/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.java.proxies;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jruby.AbstractRubyMethod;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyMethod;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyUnboundMethod;
import org.jruby.anno.JRubyMethod;
import org.jruby.common.IRubyWarnings;
import org.jruby.java.invokers.InstanceFieldGetter;
import org.jruby.java.invokers.InstanceFieldSetter;
import org.jruby.java.invokers.InstanceMethodInvoker;
import org.jruby.java.invokers.MethodInvoker;
import org.jruby.java.invokers.StaticFieldGetter;
import org.jruby.java.invokers.StaticFieldSetter;
import org.jruby.java.invokers.StaticMethodInvoker;
import org.jruby.java.proxies.ArrayJavaProxy;
import org.jruby.java.proxies.ArrayJavaProxyCreator;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.JavaMethod;
import org.jruby.javasupport.JavaObject;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.CodegenUtils;
import org.jruby.util.JRubyObjectInputStream;

public class JavaProxy
extends RubyObject {
    private transient JavaObject javaObject;
    Object object;
    private static final ObjectAllocator ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klazz) {
            return new JavaProxy(runtime, klazz);
        }
    };
    private static final String NONPERSISTENT_IVAR_MESSAGE = "instance vars on non-persistent Java type {0} (http://wiki.jruby.org/Persistence)";
    private static final String NONPERSISTENT_SINGLETON_MESSAGE = "singleton on non-persistent Java type {0} (http://wiki.jruby.org/Persistence)";

    public JavaProxy(Ruby runtime, RubyClass klazz) {
        super(runtime, klazz);
    }

    public JavaProxy(Ruby runtime, RubyClass klazz, Object object) {
        super(runtime, klazz);
        this.object = object;
    }

    public static RubyClass createJavaProxy(ThreadContext context) {
        Ruby runtime = context.runtime;
        RubyClass JavaProxy2 = runtime.defineClass("JavaProxy", runtime.getObject(), ALLOCATOR);
        JavaProxy2.getSingletonClass().addReadWriteAttribute(context, "java_class");
        JavaProxy2.defineAnnotatedMethods(JavaProxy.class);
        JavaProxy2.includeModule(runtime.getModule("JavaProxyMethods"));
        return JavaProxy2;
    }

    @Override
    public Object dataGetStruct() {
        return this.getJavaObject();
    }

    @Override
    public void dataWrapStruct(Object object) {
        this.javaObject = (JavaObject)object;
        this.object = this.javaObject.getValue();
    }

    public Object getObject() {
        if (this.object == null) {
            if (this.javaObject == null) {
                throw this.getRuntime().newRuntimeError("Java wrapper with no contents: " + this.getMetaClass().getName());
            }
            this.object = this.javaObject.getValue();
        }
        return this.object;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public Object unwrap() {
        return this.getObject();
    }

    private JavaObject getJavaObject() {
        if (this.javaObject == null) {
            this.javaObject = JavaObject.wrap(this.getRuntime(), this.object);
        }
        return this.javaObject;
    }

    @Override
    public Class getJavaClass() {
        return this.getObject().getClass();
    }

    static JavaClass java_class(ThreadContext context, RubyModule module) {
        return (JavaClass)Helpers.invoke(context, module, "java_class");
    }

    @JRubyMethod(meta=true, frame=true)
    public static IRubyObject inherited(ThreadContext context, IRubyObject recv2, IRubyObject subclass) {
        IRubyObject subJavaClass = Helpers.invoke(context, subclass, "java_class");
        if (subJavaClass.isNil()) {
            subJavaClass = Helpers.invoke(context, recv2, "java_class");
            Helpers.invoke(context, subclass, "java_class=", subJavaClass);
        }
        return Helpers.invokeSuper(context, recv2, subclass, Block.NULL_BLOCK);
    }

    @JRubyMethod(meta=true)
    public static RubyClass singleton_class(IRubyObject self2) {
        return ((RubyClass)self2).getSingletonClass();
    }

    @JRubyMethod(name={"[]"}, meta=true, rest=true)
    public static IRubyObject op_aref(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
        JavaClass javaClass = JavaProxy.java_class(context, (RubyModule)self2);
        if (args2.length > 0) {
            return new ArrayJavaProxyCreator(context, javaClass, args2);
        }
        return Java.get_proxy_class(javaClass, Helpers.invoke(context, javaClass, "array_class"));
    }

    @JRubyMethod(meta=true)
    public static IRubyObject new_array(ThreadContext context, IRubyObject self2, IRubyObject len) {
        JavaClass javaClass = JavaProxy.java_class(context, (RubyModule)self2);
        Class componentType = javaClass.javaClass();
        int length2 = (int)len.convertToInteger().getLongValue();
        return ArrayJavaProxy.newArray(context.runtime, componentType, length2);
    }

    @JRubyMethod(name={"__persistent__="}, meta=true)
    public static IRubyObject persistent(IRubyObject clazz, IRubyObject value2) {
        ((RubyClass)clazz).getRealClass().setCacheProxy(value2.isTrue());
        return value2;
    }

    @JRubyMethod(name={"__persistent__"}, meta=true)
    public static IRubyObject persistent(ThreadContext context, IRubyObject clazz) {
        return context.runtime.newBoolean(((RubyClass)clazz).getRealClass().getCacheProxy());
    }

    @Override
    public IRubyObject initialize_copy(IRubyObject original) {
        super.initialize_copy(original);
        this.setObject(((JavaProxy)original).getObject());
        return this;
    }

    private static Map<String, String> getFieldListFromArgs(IRubyObject[] args2) {
        final HashMap<String, String> map = new HashMap<String, String>();
        for (int i2 = 0; i2 < args2.length; ++i2) {
            IRubyObject arg2 = args2[i2];
            if (arg2 instanceof RubyHash) {
                ((RubyHash)arg2).visitAll(new RubyHash.Visitor(){

                    @Override
                    public void visit(IRubyObject key2, IRubyObject value2) {
                        map.put(key2.asString().toString(), value2.asString().toString());
                    }
                });
                continue;
            }
            String value2 = arg2.asString().toString();
            map.put(value2, value2);
        }
        return map;
    }

    private static void installField(ThreadContext context, Map<String, String> fieldMap, Field field2, RubyModule module, boolean asReader, boolean asWriter) {
        String fieldName = field2.getName();
        Iterator<Map.Entry<String, String>> iter = fieldMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, String> entry = iter.next();
            if (!entry.getKey().equals(fieldName)) continue;
            if (Ruby.isSecurityRestricted() && !Modifier.isPublic(field2.getModifiers())) {
                throw context.runtime.newSecurityError("Cannot change accessibility on fields in a restricted mode: field '" + fieldName + "'");
            }
            String asName = entry.getValue();
            if (Modifier.isStatic(field2.getModifiers())) {
                if (asReader) {
                    module.getSingletonClass().addMethod(asName, new StaticFieldGetter(fieldName, module, field2));
                }
                if (asWriter) {
                    if (Modifier.isFinal(field2.getModifiers())) {
                        throw context.runtime.newSecurityError("Cannot change final field '" + fieldName + "'");
                    }
                    module.getSingletonClass().addMethod(asName + '=', new StaticFieldSetter(fieldName, module, field2));
                }
            } else {
                if (asReader) {
                    module.addMethod(asName, new InstanceFieldGetter(fieldName, module, field2));
                }
                if (asWriter) {
                    if (Modifier.isFinal(field2.getModifiers())) {
                        throw context.runtime.newSecurityError("Cannot change final field '" + fieldName + "'");
                    }
                    module.addMethod(asName + '=', new InstanceFieldSetter(fieldName, module, field2));
                }
            }
            iter.remove();
            break;
        }
    }

    private static void findFields(ThreadContext context, RubyModule topModule, IRubyObject[] args2, boolean asReader, boolean asWriter) {
        Map<String, String> fieldMap = JavaProxy.getFieldListFromArgs(args2);
        for (RubyModule module = topModule; module != null; module = module.getSuperClass()) {
            Class<?> javaClass = JavaClass.getJavaClassIfProxy(context, module);
            if (javaClass == null) continue;
            Field[] fields2 = JavaClass.getDeclaredFields(javaClass);
            for (int j = 0; j < fields2.length; ++j) {
                JavaProxy.installField(context, fieldMap, fields2[j], module, asReader, asWriter);
            }
        }
        if (!fieldMap.isEmpty()) {
            throw JavaClass.undefinedFieldError(context.runtime, topModule.getName(), fieldMap.keySet().iterator().next());
        }
    }

    @JRubyMethod(meta=true, rest=true)
    public static IRubyObject field_accessor(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
        JavaProxy.findFields(context, (RubyModule)self2, args2, true, true);
        return context.nil;
    }

    @JRubyMethod(meta=true, rest=true)
    public static IRubyObject field_reader(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
        JavaProxy.findFields(context, (RubyModule)self2, args2, true, false);
        return context.nil;
    }

    @JRubyMethod(meta=true, rest=true)
    public static IRubyObject field_writer(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
        JavaProxy.findFields(context, (RubyModule)self2, args2, false, true);
        return context.nil;
    }

    @Override
    @JRubyMethod(name={"equal?"})
    public IRubyObject equal_p(ThreadContext context, IRubyObject other) {
        if (other instanceof JavaProxy) {
            boolean equal = this.getObject() == ((JavaProxy)other).getObject();
            return context.runtime.newBoolean(equal);
        }
        return context.runtime.getFalse();
    }

    @JRubyMethod
    public IRubyObject java_send(ThreadContext context, IRubyObject rubyName) {
        String name2 = rubyName.asJavaString();
        Ruby runtime = context.runtime;
        JavaMethod method2 = new JavaMethod(runtime, this.getMethod(name2, new Class[0]));
        return method2.invokeDirect(this.getObject());
    }

    @JRubyMethod
    public IRubyObject java_send(ThreadContext context, IRubyObject rubyName, IRubyObject argTypes) {
        String name2 = rubyName.asJavaString();
        RubyArray argTypesAry = argTypes.convertToArray();
        Ruby runtime = context.runtime;
        JavaProxy.checkArgSizeMismatch(runtime, 0, argTypesAry);
        JavaMethod method2 = new JavaMethod(runtime, this.getMethod(name2, new Class[0]));
        return method2.invokeDirect(this.getObject());
    }

    @JRubyMethod
    public IRubyObject java_send(ThreadContext context, IRubyObject rubyName, IRubyObject argTypes, IRubyObject arg0) {
        String name2 = rubyName.asJavaString();
        RubyArray argTypesAry = argTypes.convertToArray();
        Ruby runtime = context.runtime;
        JavaProxy.checkArgSizeMismatch(runtime, 1, argTypesAry);
        Class argTypeClass = (Class)argTypesAry.eltInternal(0).toJava(Class.class);
        JavaMethod method2 = new JavaMethod(runtime, this.getMethod(name2, argTypeClass));
        return method2.invokeDirect(this.getObject(), arg0.toJava(argTypeClass));
    }

    @JRubyMethod(required=4, rest=true)
    public IRubyObject java_send(ThreadContext context, IRubyObject[] args2) {
        Ruby runtime = context.runtime;
        String name2 = args2[0].asJavaString();
        RubyArray argTypesAry = args2[1].convertToArray();
        int argsLen = args2.length - 2;
        JavaProxy.checkArgSizeMismatch(runtime, argsLen, argTypesAry);
        Class[] argTypesClasses = (Class[])argTypesAry.toArray(new Class[argsLen]);
        Object[] javaArgs = new Object[argsLen];
        for (int i2 = 0; i2 < argsLen; ++i2) {
            javaArgs[i2] = args2[i2 + 2].toJava(argTypesClasses[i2]);
        }
        JavaMethod method2 = new JavaMethod(runtime, this.getMethod(name2, argTypesClasses));
        return method2.invokeDirect(this.getObject(), javaArgs);
    }

    private static void checkArgSizeMismatch(Ruby runtime, int expected, RubyArray argTypes) {
        if (argTypes.size() != expected) {
            Class[] argTypesClasses = (Class[])argTypes.toArray(new Class[argTypes.size()]);
            throw JavaMethod.newArgSizeMismatchError(runtime, argTypesClasses);
        }
    }

    @JRubyMethod
    public IRubyObject java_method(ThreadContext context, IRubyObject rubyName) {
        String name2 = rubyName.asJavaString();
        return this.getRubyMethod(name2, new Class[0]);
    }

    @JRubyMethod
    public IRubyObject java_method(ThreadContext context, IRubyObject rubyName, IRubyObject argTypes) {
        String name2 = rubyName.asJavaString();
        RubyArray argTypesAry = argTypes.convertToArray();
        Class[] argTypesClasses = (Class[])argTypesAry.toArray(new Class[argTypesAry.size()]);
        return this.getRubyMethod(name2, argTypesClasses);
    }

    @JRubyMethod
    public IRubyObject marshal_dump() {
        if (!Serializable.class.isAssignableFrom(this.object.getClass())) {
            throw this.getRuntime().newTypeError("Java type is not serializable, cannot be marshaled " + this.getJavaClass());
        }
        try {
            ByteArrayOutputStream bytes2 = new ByteArrayOutputStream();
            new ObjectOutputStream(bytes2).writeObject(this.object);
            return this.getRuntime().newString(new ByteList(bytes2.toByteArray(), false));
        }
        catch (IOException ex) {
            throw this.getRuntime().newTypeError("Java type is not serializable: " + ex.getMessage());
        }
    }

    @JRubyMethod
    public IRubyObject marshal_load(ThreadContext context, IRubyObject str) {
        try {
            ByteList byteList = str.convertToString().getByteList();
            ByteArrayInputStream bytes2 = new ByteArrayInputStream(byteList.getUnsafeBytes(), byteList.getBegin(), byteList.getRealSize());
            this.object = new JRubyObjectInputStream(context.runtime, bytes2).readObject();
            return this;
        }
        catch (IOException ex) {
            throw context.runtime.newIOErrorFromException(ex);
        }
        catch (ClassNotFoundException ex) {
            throw context.runtime.newTypeError("Class not found unmarshaling Java type: " + ex.getLocalizedMessage());
        }
    }

    @Override
    protected int inspectHashCode() {
        return System.identityHashCode(this.object);
    }

    private Method getMethod(String name2, Class ... argTypes) {
        try {
            return this.getObject().getClass().getMethod(name2, argTypes);
        }
        catch (NoSuchMethodException nsme) {
            throw JavaMethod.newMethodNotFoundError(this.getRuntime(), this.getObject().getClass(), name2 + CodegenUtils.prettyParams(argTypes), name2);
        }
    }

    private MethodInvoker getMethodInvoker(Method method2) {
        if (Modifier.isStatic(method2.getModifiers())) {
            return new StaticMethodInvoker(this.metaClass.getMetaClass(), method2);
        }
        return new InstanceMethodInvoker((RubyModule)this.metaClass, method2);
    }

    private RubyMethod getRubyMethod(String name2, Class ... argTypes) {
        Method jmethod = this.getMethod(name2, argTypes);
        if (Modifier.isStatic(jmethod.getModifiers())) {
            return RubyMethod.newMethod(this.metaClass.getSingletonClass(), CodegenUtils.prettyParams(argTypes).toString(), this.metaClass.getSingletonClass(), name2, this.getMethodInvoker(jmethod), this.getMetaClass());
        }
        return RubyMethod.newMethod(this.metaClass, CodegenUtils.prettyParams(argTypes).toString(), this.metaClass, name2, this.getMethodInvoker(jmethod), this);
    }

    @Override
    public Object toJava(Class type2) {
        Object object = this.getObject();
        Class<?> clazz = object.getClass();
        if (type2.isAssignableFrom(clazz)) {
            return object;
        }
        throw this.getRuntime().newTypeError("failed to coerce " + clazz.getName() + " to " + type2.getName());
    }

    @Override
    public Object getVariable(int index2) {
        this.confirmCachedProxy(NONPERSISTENT_IVAR_MESSAGE);
        return super.getVariable(index2);
    }

    @Override
    public void setVariable(int index2, Object value2) {
        this.confirmCachedProxy(NONPERSISTENT_IVAR_MESSAGE);
        super.setVariable(index2, value2);
    }

    @Override
    public RubyClass getSingletonClass() {
        this.confirmCachedProxy(NONPERSISTENT_SINGLETON_MESSAGE);
        return super.getSingletonClass();
    }

    private void confirmCachedProxy(String message2) {
        RubyClass realClass = this.metaClass.getRealClass();
        if (!realClass.getCacheProxy()) {
            Ruby runtime = this.getRuntime();
            if (Java.OBJECT_PROXY_CACHE) {
                runtime.getWarnings().warnOnce(IRubyWarnings.ID.NON_PERSISTENT_JAVA_PROXY, MessageFormat.format(message2, realClass));
            } else {
                runtime.getWarnings().warn(MessageFormat.format(message2, realClass));
                realClass.setCacheProxy(true);
                runtime.getJavaSupport().getObjectProxyCache().put(this.getObject(), this);
            }
        }
    }

    public static class ClassMethods {
        @JRubyMethod(meta=true)
        public static IRubyObject java_method(ThreadContext context, IRubyObject proxyClass, IRubyObject rubyName) {
            String name2 = rubyName.asJavaString();
            return ClassMethods.getRubyMethod(context, proxyClass, name2, new Class[0]);
        }

        @JRubyMethod(meta=true)
        public static IRubyObject java_method(ThreadContext context, IRubyObject proxyClass, IRubyObject rubyName, IRubyObject argTypes) {
            String name2 = rubyName.asJavaString();
            RubyArray argTypesAry = argTypes.convertToArray();
            Class[] argTypesClasses = (Class[])argTypesAry.toArray(new Class[argTypesAry.size()]);
            return ClassMethods.getRubyMethod(context, proxyClass, name2, argTypesClasses);
        }

        @JRubyMethod(meta=true)
        public static IRubyObject java_send(ThreadContext context, IRubyObject recv2, IRubyObject rubyName) {
            String name2 = rubyName.asJavaString();
            Ruby runtime = context.runtime;
            JavaMethod method2 = new JavaMethod(runtime, ClassMethods.getMethodFromClass(context, recv2, name2, new Class[0]));
            return method2.invokeStaticDirect();
        }

        @JRubyMethod(meta=true)
        public static IRubyObject java_send(ThreadContext context, IRubyObject recv2, IRubyObject rubyName, IRubyObject argTypes) {
            String name2 = rubyName.asJavaString();
            RubyArray argTypesAry = argTypes.convertToArray();
            Ruby runtime = context.runtime;
            JavaProxy.checkArgSizeMismatch(runtime, 0, argTypesAry);
            JavaMethod method2 = new JavaMethod(runtime, ClassMethods.getMethodFromClass(context, recv2, name2, new Class[0]));
            return method2.invokeStaticDirect();
        }

        @JRubyMethod(meta=true)
        public static IRubyObject java_send(ThreadContext context, IRubyObject recv2, IRubyObject rubyName, IRubyObject argTypes, IRubyObject arg0) {
            String name2 = rubyName.asJavaString();
            RubyArray argTypesAry = argTypes.convertToArray();
            Ruby runtime = context.runtime;
            JavaProxy.checkArgSizeMismatch(runtime, 1, argTypesAry);
            Class argTypeClass = (Class)argTypesAry.eltInternal(0).toJava(Class.class);
            JavaMethod method2 = new JavaMethod(runtime, ClassMethods.getMethodFromClass(context, recv2, name2, argTypeClass));
            return method2.invokeStaticDirect(arg0.toJava(argTypeClass));
        }

        @JRubyMethod(required=4, rest=true, meta=true)
        public static IRubyObject java_send(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
            Ruby runtime = context.runtime;
            String name2 = args2[0].asJavaString();
            RubyArray argTypesAry = args2[1].convertToArray();
            int argsLen = args2.length - 2;
            JavaProxy.checkArgSizeMismatch(runtime, argsLen, argTypesAry);
            Class[] argTypesClasses = (Class[])argTypesAry.toArray(new Class[argsLen]);
            Object[] javaArgs = new Object[argsLen];
            for (int i2 = 0; i2 < argsLen; ++i2) {
                javaArgs[i2] = args2[i2 + 2].toJava(argTypesClasses[i2]);
            }
            JavaMethod method2 = new JavaMethod(runtime, ClassMethods.getMethodFromClass(context, recv2, name2, argTypesClasses));
            return method2.invokeStaticDirect(javaArgs);
        }

        @JRubyMethod(meta=true, visibility=Visibility.PRIVATE)
        public static IRubyObject java_alias(ThreadContext context, IRubyObject clazz, IRubyObject newName, IRubyObject rubyName) {
            return ClassMethods.java_alias(context, clazz, newName, rubyName, context.runtime.newEmptyArray());
        }

        @JRubyMethod(meta=true, visibility=Visibility.PRIVATE)
        public static IRubyObject java_alias(ThreadContext context, IRubyObject clazz, IRubyObject newName, IRubyObject rubyName, IRubyObject argTypes) {
            Ruby runtime = context.runtime;
            if (!(clazz instanceof RubyClass)) {
                throw runtime.newTypeError(clazz, runtime.getModule());
            }
            RubyClass proxyClass = (RubyClass)clazz;
            String name2 = rubyName.asJavaString();
            String newNameStr = newName.asJavaString();
            RubyArray argTypesAry = argTypes.convertToArray();
            Class[] argTypesClasses = (Class[])argTypesAry.toArray(new Class[argTypesAry.size()]);
            Method method2 = ClassMethods.getMethodFromClass(context, clazz, name2, argTypesClasses);
            if (Modifier.isStatic(method2.getModifiers())) {
                StaticMethodInvoker invoker = new StaticMethodInvoker(proxyClass.getMetaClass(), method2);
                proxyClass.getSingletonClass().addMethod(newNameStr, invoker);
            } else {
                InstanceMethodInvoker invoker = new InstanceMethodInvoker((RubyModule)proxyClass, method2);
                proxyClass.addMethod(newNameStr, invoker);
            }
            return context.nil;
        }

        private static AbstractRubyMethod getRubyMethod(ThreadContext context, IRubyObject clazz, String name2, Class ... argTypesClasses) {
            Ruby runtime = context.runtime;
            if (!(clazz instanceof RubyModule)) {
                throw runtime.newTypeError(clazz, runtime.getModule());
            }
            RubyModule proxyClass = (RubyModule)clazz;
            Method method2 = ClassMethods.getMethodFromClass(context, clazz, name2, argTypesClasses);
            String prettyName = name2 + CodegenUtils.prettyParams(argTypesClasses);
            if (Modifier.isStatic(method2.getModifiers())) {
                StaticMethodInvoker invoker = new StaticMethodInvoker(proxyClass, method2);
                return RubyMethod.newMethod(proxyClass, prettyName, proxyClass, name2, invoker, clazz);
            }
            InstanceMethodInvoker invoker = new InstanceMethodInvoker(proxyClass, method2);
            return RubyUnboundMethod.newUnboundMethod(proxyClass, prettyName, proxyClass, name2, invoker);
        }

        private static Method getMethodFromClass(ThreadContext context, IRubyObject proxyClass, String name2, Class ... argTypes) {
            Class<?> clazz = JavaClass.getJavaClass(context, (RubyModule)proxyClass);
            try {
                return clazz.getMethod(name2, argTypes);
            }
            catch (NoSuchMethodException nsme) {
                String prettyName = name2 + CodegenUtils.prettyParams(argTypes);
                String errorName = clazz.getName() + '.' + prettyName;
                throw context.runtime.newNameError("Java method not found: " + errorName, name2);
            }
        }
    }
}

