/*
 * Decompiled with CFR 0.152.
 */
package com.orbus.mahalo;

import com.orbus.mahalo.ServiceState;
import com.orbus.mahalo.dns.DNSRecord;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class ServiceInfo {
    private static final Charset s_Charset = Charset.forName("UTF-8");
    private String _sServiceType;
    private String _sName;
    private int _iPort;
    private int _iWeight;
    private int _iPriority;
    private byte[] _Text;
    private ServiceState _eState = ServiceState.PROBING_1;

    public ServiceInfo(String asType, String asName, int aiPort, String asText) throws IllegalArgumentException {
        this(asType, asName, aiPort, 0, 0, asText);
    }

    public ServiceInfo(String asType, String asName, int aiPort, int aiWeight, int aiPriority, String asText) throws IllegalArgumentException {
        this(asType, asName, aiPort, aiWeight, aiPriority, (byte[])null);
        this._Text = s_Charset.encode(asText).array();
    }

    public ServiceInfo(String asType, String asName, int aiPort, int aiWeight, int aiPriority, byte[] aText) throws IllegalArgumentException {
        if (asType.endsWith("\\.")) {
            throw new IllegalArgumentException("Service types must be fully qualified DNS names ending in '.': " + asType + " is invalid.");
        }
        this._sServiceType = asType;
        this._sName = asName;
        this._iPort = aiPort;
        this._iWeight = aiWeight;
        this._iPriority = aiPriority;
        this._Text = aText;
    }

    public ServiceInfo(ServiceInfo aInfo) throws IllegalArgumentException {
        this(aInfo._sServiceType, aInfo._sName, aInfo._iPort, aInfo._iWeight, aInfo._iPriority, aInfo._Text);
    }

    public ServiceInfo(DNSRecord.Service aServiceRecord) {
        String sname = aServiceRecord.getName();
        int ifirstDot = sname.indexOf(".");
        this._sServiceType = sname.substring(ifirstDot + 1);
        this._sName = sname.substring(0, ifirstDot);
        this._iPort = aServiceRecord.getPort();
        this._iWeight = aServiceRecord.getWeight();
        this._iPriority = aServiceRecord.getPriority();
        this._Text = null;
    }

    public synchronized void advanceState() {
        this._eState = this._eState.advance();
    }

    public ServiceState getState() {
        return this._eState;
    }

    public String getType() {
        return this._sServiceType;
    }

    public String getName() {
        return this._sName;
    }

    public String getQualifiedName() {
        return this._sName + "." + this._sServiceType;
    }

    public int getPort() {
        return this._iPort;
    }

    public int getPriority() {
        return this._iPriority;
    }

    public int getWeight() {
        return this._iWeight;
    }

    public byte[] getTextBytes() {
        return this._Text;
    }

    public String getTextString() {
        if (this._Text != null) {
            return s_Charset.decode(ByteBuffer.wrap(this._Text)).toString();
        }
        return null;
    }

    public void setTextBytes(byte[] aBytes) {
        this._Text = aBytes;
    }

    public void setTextString(String asText) {
        this._Text = s_Charset.encode(asText).array();
    }

    public int hashCode() {
        return this.getQualifiedName().hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof ServiceInfo && this.getQualifiedName().equals(((ServiceInfo)obj).getQualifiedName());
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("service[");
        buf.append(this.getQualifiedName());
        buf.append(",Port:");
        buf.append(this._iPort);
        buf.append(',');
        buf.append(this.getTextString());
        buf.append(',');
        buf.append((Object)this._eState);
        buf.append(']');
        return buf.toString();
    }
}

