/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import net.sourceforge.schemaspy.model.ForeignKeyConstraint;
import net.sourceforge.schemaspy.model.ImpliedForeignKeyConstraint;
import net.sourceforge.schemaspy.model.RailsForeignKeyConstraint;
import net.sourceforge.schemaspy.model.Table;
import net.sourceforge.schemaspy.model.TableColumn;
import net.sourceforge.schemaspy.model.TableIndex;
import net.sourceforge.schemaspy.util.Inflection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbAnalyzer {
    public static List<ImpliedForeignKeyConstraint> getImpliedConstraints(Collection<Table> collection) {
        ArrayList<TableColumn> arrayList = new ArrayList<TableColumn>();
        TreeMap<TableColumn, Table> treeMap = new TreeMap<TableColumn, Table>(new Comparator<TableColumn>(){

            @Override
            public int compare(TableColumn tableColumn, TableColumn tableColumn2) {
                int n = tableColumn.getName().compareToIgnoreCase(tableColumn2.getName());
                if (n == 0) {
                    n = tableColumn.getType().compareToIgnoreCase(tableColumn2.getType());
                }
                if (n == 0) {
                    n = tableColumn.getLength() - tableColumn2.getLength();
                }
                return n;
            }
        });
        int n = 0;
        for (Table object2 : collection) {
            List<TableColumn> list = object2.getPrimaryColumns();
            if (list.size() == 1) {
                for (TableColumn tableColumn2 : list) {
                    if (!tableColumn2.allowsImpliedChildren() || treeMap.put(tableColumn2, object2) == null) continue;
                    ++n;
                }
            }
            for (TableColumn tableColumn2 : object2.getColumns()) {
                if (tableColumn2.isForeignKey() || !tableColumn2.allowsImpliedParents()) continue;
                arrayList.add(tableColumn2);
            }
        }
        if (n > treeMap.size()) {
            return new ArrayList<ImpliedForeignKeyConstraint>();
        }
        DbAnalyzer.sortColumnsByTable(arrayList);
        ArrayList arrayList2 = new ArrayList();
        for (TableColumn tableColumn : arrayList) {
            TableColumn tableColumn2;
            Table table = (Table)treeMap.get(tableColumn);
            if (table == null || table == tableColumn.getTable() || (tableColumn2 = table.getColumn(tableColumn.getName())).getParentConstraint(tableColumn) != null) continue;
            arrayList2.add(new ImpliedForeignKeyConstraint(tableColumn2, tableColumn));
        }
        return arrayList2;
    }

    public static List<RailsForeignKeyConstraint> getRailsConstraints(Map<String, Table> map) {
        ArrayList<RailsForeignKeyConstraint> arrayList = new ArrayList<RailsForeignKeyConstraint>(map.size());
        for (Table table : map.values()) {
            for (TableColumn tableColumn : table.getColumns()) {
                TableColumn tableColumn2;
                String string;
                String string2;
                Table table2;
                String string3 = tableColumn.getName().toLowerCase();
                if (tableColumn.isForeignKey() || !tableColumn.allowsImpliedParents() || !string3.endsWith("_id") || (table2 = map.get(string2 = Inflection.pluralize(string = string3.substring(0, string3.length() - 3)))) == null || (tableColumn2 = table2.getColumn("ID")) == null) continue;
                arrayList.add(new RailsForeignKeyConstraint(tableColumn2, tableColumn));
            }
        }
        return arrayList;
    }

    public static List<ForeignKeyConstraint> getForeignKeyConstraints(Collection<Table> collection) {
        ArrayList<ForeignKeyConstraint> arrayList = new ArrayList<ForeignKeyConstraint>();
        for (Table table : collection) {
            arrayList.addAll(table.getForeignKeys());
        }
        return arrayList;
    }

    public static List<Table> getOrphans(Collection<Table> collection) {
        ArrayList<Table> arrayList = new ArrayList<Table>();
        for (Table table : collection) {
            if (!table.isOrphan(false)) continue;
            arrayList.add(table);
        }
        return DbAnalyzer.sortTablesByName(arrayList);
    }

    public static List<TableColumn> getMustBeUniqueNullableColumns(Collection<Table> collection) {
        ArrayList<TableColumn> arrayList = new ArrayList<TableColumn>();
        for (Table table : collection) {
            for (TableIndex tableIndex : table.getIndexes()) {
                if (!tableIndex.isUniqueNullable()) continue;
                arrayList.addAll(tableIndex.getColumns());
            }
        }
        return DbAnalyzer.sortColumnsByTable(arrayList);
    }

    public static List<Table> getTablesWithoutIndexes(Collection<Table> collection) {
        ArrayList<Table> arrayList = new ArrayList<Table>();
        for (Table table : collection) {
            if (table.isView() || table.getIndexes().size() != 0) continue;
            arrayList.add(table);
        }
        return DbAnalyzer.sortTablesByName(arrayList);
    }

    public static List<Table> getTablesWithIncrementingColumnNames(Collection<Table> collection) {
        ArrayList<Table> arrayList = new ArrayList<Table>();
        block0: for (Table table : collection) {
            HashMap<String, Long> hashMap = new HashMap<String, Long>();
            for (TableColumn tableColumn : table.getColumns()) {
                String string = tableColumn.getName();
                String string2 = null;
                for (int i = string.length() - 1; i > 0 && Character.isDigit(string.charAt(i)); --i) {
                    string2 = String.valueOf(string.charAt(i)) + (string2 == null ? "" : string2);
                }
                if (string2 == null) {
                    string2 = "1";
                    string = string + string2;
                }
                String string3 = string.substring(0, string.length() - string2.length());
                long l = Long.parseLong(string2);
                Long l2 = (Long)hashMap.get(string3);
                if (l2 != null && Math.abs(l2 - l) == 1L) {
                    arrayList.add(table);
                    continue block0;
                }
                hashMap.put(string3, new Long(l));
            }
        }
        return DbAnalyzer.sortTablesByName(arrayList);
    }

    public static List<Table> getTablesWithOneColumn(Collection<Table> collection) {
        ArrayList<Table> arrayList = new ArrayList<Table>();
        for (Table table : collection) {
            if (table.getColumns().size() != 1) continue;
            arrayList.add(table);
        }
        return DbAnalyzer.sortTablesByName(arrayList);
    }

    public static List<Table> sortTablesByName(List<Table> list) {
        Collections.sort(list, new Comparator<Table>(){

            @Override
            public int compare(Table table, Table table2) {
                return table.compareTo(table2);
            }
        });
        return list;
    }

    public static List<TableColumn> sortColumnsByTable(List<TableColumn> list) {
        Collections.sort(list, new Comparator<TableColumn>(){

            @Override
            public int compare(TableColumn tableColumn, TableColumn tableColumn2) {
                int n = tableColumn.getTable().compareTo(tableColumn2.getTable());
                if (n == 0) {
                    n = tableColumn.getName().compareToIgnoreCase(tableColumn2.getName());
                }
                return n;
            }
        });
        return list;
    }

    public static List<TableColumn> getDefaultNullStringColumns(Collection<Table> collection) {
        ArrayList<TableColumn> arrayList = new ArrayList<TableColumn>();
        for (Table table : collection) {
            for (TableColumn tableColumn : table.getColumns()) {
                String string;
                Object object = tableColumn.getDefaultValue();
                if (object == null || !(object instanceof String) || !(string = object.toString()).trim().equalsIgnoreCase("null")) continue;
                arrayList.add(tableColumn);
            }
        }
        return DbAnalyzer.sortColumnsByTable(arrayList);
    }

    public static List<String> getSchemas(DatabaseMetaData databaseMetaData) throws SQLException {
        ArrayList<String> arrayList = new ArrayList<String>();
        ResultSet resultSet = databaseMetaData.getSchemas();
        while (resultSet.next()) {
            arrayList.add(resultSet.getString("TABLE_SCHEM"));
        }
        resultSet.close();
        return arrayList;
    }

    public static List<String> getPopulatedSchemas(DatabaseMetaData databaseMetaData) throws SQLException {
        return DbAnalyzer.getPopulatedSchemas(databaseMetaData, ".*");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getPopulatedSchemas(DatabaseMetaData databaseMetaData, String string) throws SQLException {
        TreeSet<String> treeSet = new TreeSet<String>();
        Pattern pattern = Pattern.compile(string);
        Logger logger = Logger.getLogger(DbAnalyzer.class.getName());
        boolean bl = logger.isLoggable(Level.FINE);
        Iterator<String> iterator = DbAnalyzer.getSchemas(databaseMetaData).iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next().toString();
            if (pattern.matcher(string2).matches()) {
                ResultSet resultSet = null;
                try {
                    resultSet = databaseMetaData.getTables(null, string2, "%", null);
                    if (resultSet.next()) {
                        if (bl) {
                            logger.fine("Including schema " + string2 + ": matches + \"" + pattern + "\" and contains tables");
                        }
                        treeSet.add(string2);
                        continue;
                    }
                    if (!bl) continue;
                    logger.fine("Excluding schema " + string2 + ": matches \"" + pattern + "\" but contains no tables");
                }
                catch (SQLException sQLException) {}
                continue;
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    continue;
                }
            }
            if (!bl) continue;
            logger.fine("Excluding schema " + string2 + ": doesn't match \"" + pattern + '\"');
        }
        return new ArrayList<String>(treeSet);
    }

    public static void dumpResultSetRow(ResultSet resultSet, String string) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        System.out.println(n + " columns of " + string + ":");
        for (int i = 1; i <= n; ++i) {
            System.out.print(resultSetMetaData.getColumnLabel(i));
            System.out.print(": ");
            System.out.print(String.valueOf(resultSet.getString(i)));
            System.out.print("\t");
        }
        System.out.println();
    }
}

