/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.ui;

import com.jbidwatcher.scripting.Scripting;
import com.jbidwatcher.util.queue.MQFactory;
import com.jbidwatcher.util.queue.MessageQueue;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.JTextComponent;
import org.jruby.Ruby;
import org.jruby.RubyInstanceConfig;
import org.jruby.demo.readline.TextAreaReadline;

public class ScriptManager
implements MessageQueue.Listener {
    private JFrame mFrame = null;
    private Thread t2;
    private static final String EXECUTE = "EXECUTE ";

    public void show() {
        this.mFrame.setVisible(true);
        try {
            this.t2.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public ScriptManager() {
        MQFactory.getConcrete("scripting").registerListener(this);
    }

    public JFrame getNewScriptManager() {
        final JFrame console = new JFrame("JBidwatcher Scripting Console");
        console.getContentPane().setLayout(new BorderLayout());
        console.setSize(700, 600);
        JTextPane text = new JTextPane();
        text.setMargin(new Insets(8, 8, 8, 8));
        text.setCaretColor(new Color(164, 0, 0));
        text.setBackground(new Color(242, 242, 242));
        text.setForeground(new Color(164, 0, 0));
        Font font = this.findFont("Monospaced", 0, 14, new String[]{"Monaco", "Andale Mono"});
        text.setFont(font);
        JScrollPane pane = new JScrollPane();
        pane.setViewportView(text);
        pane.setBorder(BorderFactory.createLineBorder(Color.darkGray));
        console.getContentPane().add(pane);
        console.validate();
        TextAreaReadline tar = new TextAreaReadline((JTextComponent)text, " Welcome to the JBidwatcher IRB Scripting Console \n\n");
        final Ruby runtime = Scripting.getRuntime();
        RubyInstanceConfig config = runtime.getInstanceConfig();
        config.setObjectSpaceEnabled(true);
        Scripting.setOutput(tar.getOutputStream());
        Scripting.setInput(tar.getInputStream());
        tar.hookIntoRuntime(runtime);
        this.t2 = new Thread(){

            @Override
            public void run() {
                console.setVisible(true);
                runtime.evalScriptlet("require 'irb'; require 'irb/completion'; IRB.start");
            }
        };
        this.t2.start();
        return console;
    }

    private Font findFont(String otherwise, int style, int size, String[] families) {
        Object[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        Arrays.sort(fonts);
        Font font = null;
        for (String family : families) {
            if (Arrays.binarySearch(fonts, family) < 0) continue;
            font = new Font(family, style, size);
            break;
        }
        if (font == null) {
            font = new Font(otherwise, style, size);
        }
        return font;
    }

    private void prepFrame() {
        if (this.mFrame == null) {
            this.mFrame = this.getNewScriptManager();
        }
    }

    @Override
    public void messageAction(Object deQ) {
        String msg = (String)deQ;
        if (msg.equals("SHOW")) {
            this.prepFrame();
            this.mFrame.setVisible(true);
        } else if (msg.equals("HIDE")) {
            this.prepFrame();
            this.mFrame.setVisible(false);
        } else if (msg.startsWith(EXECUTE)) {
            int firstSpace = msg.indexOf(32, EXECUTE.length());
            if (firstSpace == -1) {
                firstSpace = msg.length();
            }
            String method = msg.substring(EXECUTE.length(), firstSpace);
            String body = "";
            if (firstSpace != msg.length()) {
                body = msg.substring(firstSpace + 1);
            }
            Scripting.rubyMethod(method, body);
        }
    }
}

