/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.ui.config;

import com.cyberfox.util.config.JConfig;
import com.jbidwatcher.ui.config.JConfigTab;
import com.jbidwatcher.ui.util.JBEditorPane;
import com.jbidwatcher.ui.util.JPasteListener;
import com.jbidwatcher.ui.util.OptionUI;
import com.jbidwatcher.util.config.JConfig;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class JConfigSnipeTab
extends JConfigTab {
    private JComboBox gixenMode;
    private JCheckBox autoSubtractShippingBox;
    private JTextField snipeTime;
    private JBEditorPane gixenDisabledWarning;
    private static final String HTML_PREFIX = "<html><body><div style=\"font-size: 0.96em;\"><i>";
    private static final String HTML_SUFFIX = "</div></body></html>";
    private static final String GIXEN_DISABLED = "Gixen support is disabled until an eBay username and password are set.";
    private static final String GIXEN_AVAILABLE = "If you change to a new Gixen mode, JBidwatcher will submit your eBay username and password to Gixen to verify that you have a Gixen Mirror account.";
    private final String DISABLED_HTML = "<html><body><div style=\"font-size: 0.96em;\"><i>Gixen support is disabled until an eBay username and password are set.</div></body></html>";
    private final String AVAILABLE_HTML = "<html><body><div style=\"font-size: 0.96em;\"><i>If you change to a new Gixen mode, JBidwatcher will submit your eBay username and password to Gixen to verify that you have a Gixen Mirror account.</div></body></html>";

    @Override
    public String getTabName() {
        return "Sniping";
    }

    @Override
    public void cancel() {
    }

    @Override
    public void apply() {
        long newSnipeAt = Long.parseLong(this.snipeTime.getText()) * 1000L;
        JConfig.setConfiguration("snipemilliseconds", Long.toString(newSnipeAt));
        JConfig.setConfiguration("snipe.subtract_shipping", this.autoSubtractShippingBox.isSelected() ? "true" : "false");
        JConfig.setConfiguration("snipe.gixen", ((Enum)this.gixenMode.getSelectedItem()).name());
    }

    @Override
    public void updateValues() {
        String snipeAtCfg = JConfig.queryConfiguration("snipemilliseconds", "30000");
        String autoSubtractShipping = JConfig.queryConfiguration("snipe.subtract_shipping", "false");
        long snipeAt = Long.parseLong(snipeAtCfg);
        this.snipeTime.setText(Long.toString(snipeAt / 1000L));
        this.autoSubtractShippingBox.setSelected(autoSubtractShipping.equals("true"));
        this.gixenMode.setSelectedItem((Object)GixenModes.valueOf(JConfig.queryConfiguration("snipe.gixen", "NO")));
    }

    private JPanel buildSnipeSettings(JPasteListener pasteListener) {
        JPanel tp = new JPanel();
        JLabel jl = new JLabel("How close to snipe (in seconds):");
        tp.setBorder(BorderFactory.createTitledBorder("Snipe Timing"));
        tp.setLayout(new BorderLayout());
        this.snipeTime = new JTextField();
        this.snipeTime.addMouseListener(pasteListener);
        this.snipeTime.setToolTipText("Number of seconds prior to auction end to fire a snipe.");
        this.snipeTime.setEditable(true);
        this.snipeTime.getAccessibleContext().setAccessibleName("Default number of seconds prior to auction end to fire a snipe.");
        tp.add((Component)jl, "North");
        tp.add((Component)this.snipeTime, "South");
        return tp;
    }

    private JPanel buildExtraSettings() {
        JPanel tp = new JPanel();
        tp.setBorder(BorderFactory.createTitledBorder("Snipe Settings"));
        tp.setLayout(new BoxLayout(tp, 1));
        this.autoSubtractShippingBox = new JCheckBox("Subtract shipping/insurance from bid amounts by default");
        this.autoSubtractShippingBox.setToolTipText("Determines the default behaviour of deducting shipping/insurance from bid amounts. This behaviour can be overridden on a per-bid basis.");
        Box shippingBox = Box.createHorizontalBox();
        shippingBox.add(this.autoSubtractShippingBox);
        shippingBox.add(Box.createHorizontalGlue());
        tp.add(shippingBox);
        return tp;
    }

    private JPanel buildGixenSettings() {
        JPanel tp = new JPanel();
        tp.setBorder(BorderFactory.createTitledBorder("Gixen Settings (optional)"));
        tp.setLayout(new BoxLayout(tp, 1));
        Box label = Box.createHorizontalBox();
        label.add(new JLabel("Submit snipes to the Gixen web service"));
        label.add(Box.createHorizontalGlue());
        tp.add(label);
        this.gixenMode = new JComboBox<GixenModes>(GixenModes.values());
        Box gixenBox = Box.createHorizontalBox();
        gixenBox.add(this.gixenMode);
        gixenBox.add(Box.createHorizontalGlue());
        tp.add(gixenBox);
        return tp;
    }

    private void checkGixenEligibility() {
        String user = JConfig.queryConfiguration("ebay.user");
        if (user == null || user.equals("default")) {
            this.gixenMode.setEnabled(false);
            this.gixenDisabledWarning.setText("<html><body><div style=\"font-size: 0.96em;\"><i>Gixen support is disabled until an eBay username and password are set.</div></body></html>");
            this.gixenDisabledWarning.setVisible(true);
        } else {
            this.gixenMode.setEnabled(true);
            this.gixenDisabledWarning.setText("<html><body><div style=\"font-size: 0.96em;\"><i>If you change to a new Gixen mode, JBidwatcher will submit your eBay username and password to Gixen to verify that you have a Gixen Mirror account.</div></body></html>");
        }
        this.repaint();
    }

    public JConfigSnipeTab(JPasteListener pasteListener) {
        this.setLayout(new BorderLayout());
        JPanel jp = new JPanel();
        jp.setLayout(new BoxLayout(jp, 1));
        jp.add(this.buildSnipeSettings(pasteListener));
        jp.add(this.buildExtraSettings());
        Box spareBox = Box.createHorizontalBox();
        spareBox.add(new JLabel(""));
        jp.add(spareBox);
        jp.add(this.buildGixenSettings());
        this.add((Component)JConfigSnipeTab.panelPack(jp), "Center");
        this.gixenDisabledWarning = OptionUI.getHTMLLabel("<html><body><div style=\"font-size: 0.96em;\"><i>Gixen support is disabled until an eBay username and password are set.</div></body></html>");
        this.checkGixenEligibility();
        this.add((Component)this.gixenDisabledWarning, "South");
        JConfig.registerListener(new JConfig.ConfigListener(){

            @Override
            public void updateConfiguration() {
                JConfigSnipeTab.this.checkGixenEligibility();
            }
        });
        this.updateValues();
    }

    private static enum GixenModes {
        NO("Not at all"),
        ONLY("Exclusively"),
        ADDITIONAL("In addition to JBidwatcher");

        private final String plainText;

        private GixenModes(String subtitle) {
            this.plainText = subtitle;
        }

        public final String toString() {
            return this.plainText;
        }
    }
}

