/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.ui.table;

import com.jbidwatcher.auction.AuctionEntry;
import com.jbidwatcher.auction.AuctionList;
import com.jbidwatcher.auction.MultiSnipe;
import com.jbidwatcher.auction.MultiSnipeManager;
import com.jbidwatcher.auction.NullEntry;
import com.jbidwatcher.auction.Seller;
import com.jbidwatcher.ui.table.AuctionSortable;
import com.jbidwatcher.ui.table.TableColumnController;
import com.jbidwatcher.util.Comparison;
import com.jbidwatcher.util.Constants;
import com.jbidwatcher.util.Currency;
import com.jbidwatcher.util.IconFactory;
import com.jbidwatcher.util.config.JConfig;
import com.jbidwatcher.util.xml.XMLElement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.table.AbstractTableModel;
import org.jetbrains.annotations.NotNull;

public class auctionTableModel
extends AbstractTableModel {
    private static final String neverBid = "--";
    private static final AuctionEntry nullEntry = new NullEntry();
    private final MultiSnipeManager multiManager;
    private AuctionList dispList;
    private Date futureForever = new Date(Long.MAX_VALUE);
    private static final ImageIcon dummyIcon = new ImageIcon(JConfig.getResource("/icons/white_ball.gif"));
    private static final ImageIcon greenIcon = new ImageIcon(JConfig.getResource("/icons/green_ball.gif"));
    private static final ImageIcon binIcon = new ImageIcon(JConfig.getResource("/icons/bin_item.gif"));
    private static final ImageIcon resIcon = new ImageIcon(JConfig.getResource("/icons/unmet_reserve.gif"));
    private static final ImageIcon resMetIcon = new ImageIcon(JConfig.getResource("/icons/met_reserve.gif"));
    private static final ImageIcon imageIcon = new ImageIcon(JConfig.getResource("/icons/camera.gif"));
    private static final ImageIcon commentIcon = new ImageIcon(JConfig.getResource("/icons/note3.gif"));
    private static final ImageIcon winningIcon = new ImageIcon(JConfig.getResource("/icons/winning.gif"));
    private static final ImageIcon invalidIcon = new ImageIcon(JConfig.getResource("/icons/invalid.png"));
    private static final ImageIcon deletedIcon = new ImageIcon(JConfig.getResource("/icons/deleted.png"));
    private static final ImageIcon paypalIcon = new ImageIcon(JConfig.getResource("/icons/paypal16x16.gif"));
    static Map<String, ImageIcon> iconCache = new HashMap<String, ImageIcon>();
    private static Map<String, Seller> sellers = new HashMap<String, Seller>();
    private final AuctionSortable featherweightSortBy = new AuctionSortable();

    public auctionTableModel(MultiSnipeManager multiManager, AuctionList inList) {
        this.multiManager = multiManager;
        this.dispList = inList;
    }

    @NotNull
    private Object getDummyValueAtColumn(int j) {
        switch (j) {
            case -1: {
                return nullEntry;
            }
            case 1: 
            case 2: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 18: 
            case 19: {
                return Currency.NoValue();
            }
            case 3: 
            case 12: {
                return this.futureForever;
            }
            case 5: 
            case 21: {
                return dummyIcon;
            }
        }
        return "";
    }

    private int buildEntryFlags(AuctionEntry ae) {
        if (ae == null) {
            return 1;
        }
        return ae.getFlags();
    }

    private ImageIcon getEntryIcon(AuctionEntry ae) {
        ImageIcon ret_icon = null;
        if (ae.isFixed()) {
            ret_icon = null;
        }
        if (ae.getHighBidder() != null) {
            if (ae.isHighBidder()) {
                ret_icon = winningIcon;
            } else if (ae.isSeller() && ae.getNumBidders() > 0 && (!ae.isReserve() || ae.isReserveMet())) {
                ret_icon = greenIcon;
            }
        }
        if (!ae.getBuyNow().isNull()) {
            ret_icon = IconFactory.getCombination(ret_icon, binIcon);
        }
        if (ae.isReserve()) {
            ret_icon = ae.isReserveMet() ? IconFactory.getCombination(ret_icon, resMetIcon) : IconFactory.getCombination(ret_icon, resIcon);
        }
        if (ae.getThumbnail() != null) {
            ret_icon = IconFactory.getCombination(ret_icon, imageIcon);
        }
        if (ae.getComment() != null) {
            ret_icon = IconFactory.getCombination(ret_icon, commentIcon);
        }
        if (ae.isInvalid()) {
            ret_icon = IconFactory.getCombination(ret_icon, invalidIcon);
        }
        if (ae.isDeleted()) {
            ret_icon = IconFactory.getCombination(ret_icon, deletedIcon);
        }
        if (ae.hasPaypal()) {
            ret_icon = IconFactory.getCombination(ret_icon, paypalIcon);
        }
        return ret_icon;
    }

    private String formatSnipeAndBid(AuctionEntry aEntry) {
        String errorNote = "";
        if (aEntry.getErrorPage() != null) {
            errorNote = "*";
        }
        if (aEntry.isSniped()) {
            return this.formatSnipe(aEntry, errorNote);
        }
        if (aEntry.isBidOn()) {
            return this.formatBid(aEntry, errorNote);
        }
        if (aEntry.snipeCancelled() && aEntry.isComplete()) {
            return errorNote + '(' + aEntry.getCancelledSnipe() + ')';
        }
        return neverBid;
    }

    private String formatBid(AuctionEntry aEntry, String errorNote) {
        String bidCount = "";
        return errorNote + aEntry.getBid().toString() + bidCount;
    }

    private String formatSnipe(AuctionEntry aEntry, String errorNote) {
        String snipeCount = "";
        MultiSnipe ms = this.multiManager.getForAuctionIdentifier(aEntry.getIdentifier());
        if (ms != null) {
            if (aEntry.isSnipeValid()) {
                return errorNote + "Multi: " + aEntry.getSnipeAmount() + snipeCount;
            }
            return errorNote + "Multi: (" + aEntry.getSnipeAmount() + snipeCount + ')';
        }
        if (aEntry.isSnipeValid()) {
            return errorNote + aEntry.getSnipeAmount().toString() + snipeCount;
        }
        return errorNote + '(' + aEntry.getSnipeAmount() + snipeCount + ')';
    }

    private String formatTotalSnipe(AuctionEntry aEntry, String errorNote) {
        Currency totalSnipe;
        if (!aEntry.isSniped()) {
            return neverBid;
        }
        Currency shipping = aEntry.getShippingWithInsurance();
        if (shipping.getCurrencyType() == 0 || aEntry.getSnipeAmount().getCurrencyType() == 0) {
            return neverBid;
        }
        try {
            totalSnipe = aEntry.getSnipeAmount().add(shipping);
        }
        catch (Currency.CurrencyTypeException e) {
            JConfig.log().handleException("Currency addition threw a bad currency exception, which should be very difficult to cause to happen.", e);
            return neverBid;
        }
        MultiSnipe ms = this.multiManager.getForAuctionIdentifier(aEntry.getIdentifier());
        if (ms != null) {
            if (aEntry.isSnipeValid()) {
                return errorNote + "Multi: " + totalSnipe;
            }
            return errorNote + "Multi: (" + totalSnipe + ')';
        }
        if (aEntry.isSnipeValid()) {
            return errorNote + totalSnipe.toString();
        }
        return errorNote + '(' + totalSnipe + ')';
    }

    private Seller getSeller(String sellerId) {
        Seller seller;
        if (sellers.containsKey(sellerId)) {
            seller = sellers.get(sellerId);
        } else {
            seller = Seller.findFirstBy("id", sellerId);
            sellers.put(sellerId, seller);
        }
        return seller;
    }

    private Object priceWithShippingColumn(AuctionEntry aEntry) {
        Currency shipping = aEntry.getShippingWithInsurance();
        if (shipping.getCurrencyType() == 0) {
            return neverBid;
        }
        try {
            return aEntry.getCurrentPrice().add(shipping);
        }
        catch (Currency.CurrencyTypeException e) {
            JConfig.log().handleException("Currency addition threw a bad currency exception, which is odd...", e);
            return neverBid;
        }
    }

    private Object thumbnailColumn(AuctionEntry aEntry) {
        String thumb = aEntry.getThumbnail();
        if (thumb != null) {
            if (iconCache.containsKey(thumb)) {
                return iconCache.get(thumb);
            }
            thumb = thumb.replaceAll("file:", "");
            ImageIcon base = new ImageIcon(thumb);
            int h = base.getIconHeight();
            int w = base.getIconWidth();
            if (h <= 64 && w <= 64) {
                h = -1;
                w = -1;
            }
            if (h != -1 && w != -1) {
                if (h > w) {
                    h = 64;
                    w = -1;
                } else if (w > h) {
                    w = 64;
                    h = -1;
                } else if (h == w) {
                    h = 64;
                    w = -1;
                }
            }
            ImageIcon thumbIcon = new ImageIcon(base.getImage().getScaledInstance(w, h, 4));
            iconCache.put(thumb, thumbIcon);
            return thumbIcon;
        }
        return dummyIcon;
    }

    private Object endDateColumn(AuctionEntry aEntry) {
        if (aEntry.getEndDate() == null || aEntry.getEndDate().equals(Constants.FAR_FUTURE)) {
            return "N/A";
        }
        SimpleDateFormat fmt = new SimpleDateFormat("dd-MMM-yy HH:mm:ss zzz");
        return fmt.format(aEntry.getEndDate());
    }

    private Object timeLeftColumn(AuctionEntry aEntry) {
        if (aEntry.getEndDate() == null || aEntry.getEndDate().equals(Constants.FAR_FUTURE)) {
            return "N/A";
        }
        String endTime = aEntry.getTimeLeft();
        if (endTime.equals("Auction ended.")) {
            SimpleDateFormat fmt = new SimpleDateFormat("dd-MMM-yy HH:mm:ss zzz");
            endTime = fmt.format(aEntry.getEndDate());
            if (!aEntry.isComplete()) {
                endTime = "<html><body color=\"red\">" + endTime + "</body></html>";
            }
        }
        return endTime;
    }

    private Object snipeColumn(AuctionEntry aEntry, String errorNote) {
        if (aEntry.isSniped()) {
            return this.formatSnipe(aEntry, errorNote);
        }
        if (aEntry.snipeCancelled() && aEntry.isComplete()) {
            return errorNote + '(' + aEntry.getCancelledSnipe() + ')';
        }
        return neverBid;
    }

    private Object currentBid(AuctionEntry aEntry) {
        Currency curPrice = aEntry.getCurrentPrice();
        if (aEntry.isFixed()) {
            return curPrice + " (FP" + (aEntry.getQuantity() > 1 ? " x " + aEntry.getQuantity() + ")" : ")");
        }
        return curPrice + " (" + Integer.toString(aEntry.getNumBidders()) + ')';
    }

    @Override
    public int getRowCount() {
        return this.dispList.size();
    }

    @Override
    public int getColumnCount() {
        return TableColumnController.columnCount();
    }

    @Override
    public String getColumnName(int aColumn) {
        return TableColumnController.getInstance().getColumnName(aColumn);
    }

    public Class getColumnClass(int aColumn) {
        if (aColumn != 5) {
            return String.class;
        }
        return Icon.class;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        try {
            AuctionEntry aEntry = this.dispList.get(rowIndex);
            if (columnIndex == -1) {
                return aEntry;
            }
            if (aEntry == null) {
                this.dispList.remove(rowIndex);
                return "*";
            }
            String errorNote = aEntry.getErrorPage() == null ? "" : "*";
            Seller seller = this.getSeller(aEntry.getSellerId());
            switch (columnIndex) {
                case 0: {
                    return aEntry.getIdentifier();
                }
                case 1: {
                    return this.currentBid(aEntry);
                }
                case 2: {
                    return this.formatSnipeAndBid(aEntry);
                }
                case 9: {
                    return aEntry.isBidOn() ? this.formatBid(aEntry, errorNote) : neverBid;
                }
                case 10: {
                    return this.snipeColumn(aEntry, errorNote);
                }
                case 3: {
                    return this.timeLeftColumn(aEntry);
                }
                case 12: {
                    return this.endDateColumn(aEntry);
                }
                case 4: {
                    return XMLElement.decodeString(aEntry.getTitle());
                }
                case 5: {
                    return this.getEntryIcon(aEntry);
                }
                case 21: {
                    return this.thumbnailColumn(aEntry);
                }
                case 6: {
                    return aEntry.getSellerName();
                }
                case 11: {
                    String comment = aEntry.getComment();
                    return comment == null ? "" : comment;
                }
                case 8: {
                    String bidder = aEntry.getHighBidder();
                    if (bidder != null && bidder.length() != 0) {
                        return bidder;
                    }
                    return neverBid;
                }
                case 13: {
                    Currency bin = aEntry.getBuyNow();
                    if (bin.isNull()) {
                        return neverBid;
                    }
                    return bin;
                }
                case 7: {
                    Currency ship = aEntry.getShippingWithInsurance();
                    if (ship.isNull()) {
                        return neverBid;
                    }
                    return ship;
                }
                case 16: {
                    return aEntry.getItemLocation();
                }
                case 17: {
                    if (aEntry.getNumBidders() < 0) {
                        return "(FP)";
                    }
                    return Integer.toString(aEntry.getNumBidders());
                }
                case 18: {
                    return aEntry.getCurrentPrice();
                }
                case 14: {
                    return seller.getFeedback();
                }
                case 15: {
                    String fbp = seller.getPositivePercentage();
                    return fbp == null || fbp.length() == 0 ? neverBid : fbp;
                }
                case 19: {
                    return this.priceWithShippingColumn(aEntry);
                }
                case 20: {
                    return this.formatTotalSnipe(aEntry, errorNote);
                }
            }
            if (columnIndex > 21 && columnIndex < TableColumnController.columnCount()) {
                return TableColumnController.getInstance().customColumn(columnIndex, aEntry);
            }
            return "";
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            return this.getDummyValueAtColumn(columnIndex);
        }
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    public void delete(int row) {
        this.dispList.remove(row);
        this.fireTableRowsDeleted(row, row);
    }

    public synchronized int findRow(Comparison c) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!c.match(this.getValueAt(i, -1))) continue;
            return i;
        }
        return -1;
    }

    public synchronized int findRow(Object o) {
        int i;
        ArrayList<Object> cache = new ArrayList<Object>();
        for (i = 0; i < this.getRowCount(); ++i) {
            Object curStep = this.getValueAt(i, -1);
            if (curStep == o) {
                return i;
            }
            cache.add(curStep);
        }
        for (i = 0; i < cache.size(); ++i) {
            if (!cache.get(i).equals(o)) continue;
            return i;
        }
        return -1;
    }

    public boolean delete(Object o) {
        int row = this.findRow(o);
        if (row != -1) {
            this.delete(row);
        }
        return row != -1;
    }

    public int insert(Object o) {
        this.dispList.add((AuctionEntry)o);
        int row = this.findRow(o);
        this.fireTableRowsInserted(row, row);
        return this.dispList.size() - 1;
    }

    public Class getSortByColumnClass(int i) {
        if (i == 5 || i == 21 || i == 14 || i == 17 || i == 15) {
            return Integer.class;
        }
        if (i == -1 || i > 21) {
            return String.class;
        }
        Object o = this.getDummyValueAtColumn(i);
        return o.getClass();
    }

    public Object getSortByValueAt(int i, int j) {
        try {
            AuctionEntry entry = this.dispList.get(i);
            this.featherweightSortBy.setEntry(entry);
            AuctionSortable sortBy = this.featherweightSortBy;
            switch (j) {
                case -1: {
                    return entry;
                }
                case 0: {
                    return sortBy.getId();
                }
                case 1: {
                    return sortBy.getCurrentBid();
                }
                case 2: {
                    return sortBy.getSnipeOrMax();
                }
                case 3: {
                    return entry.getEndDate();
                }
                case 4: {
                    return entry.getTitle();
                }
                case 5: {
                    return this.buildEntryFlags(entry);
                }
                case 21: {
                    return 0;
                }
                case 6: {
                    return entry.getSellerName();
                }
                case 13: {
                    return sortBy.getFixedPrice();
                }
                case 7: {
                    return sortBy.getShippingInsurance();
                }
                case 8: {
                    return entry.getHighBidder();
                }
                case 9: {
                    return sortBy.getMax();
                }
                case 10: {
                    return sortBy.getSnipe();
                }
                case 11: {
                    return sortBy.getComment();
                }
                case 12: {
                    return entry.getEndDate();
                }
                case 14: {
                    return sortBy.getSellerFeedback();
                }
                case 16: {
                    return entry.getItemLocation();
                }
                case 17: {
                    return entry.getNumBidders();
                }
                case 18: {
                    return entry.getUSCurBid();
                }
                case 15: {
                    return sortBy.getSellerPositiveFeedback();
                }
                case 19: {
                    return sortBy.getCurrentTotal();
                }
                case 20: {
                    return sortBy.getSnipeTotal();
                }
            }
            if (j > 21 && j < TableColumnController.columnCount()) {
                return TableColumnController.getInstance().customColumn(j, entry);
            }
            return "";
        }
        catch (ArrayIndexOutOfBoundsException ignored) {
            return this.getDummyValueAtColumn(j);
        }
    }
}

