/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.txtmark;

import com.github.rjeschke.txtmark.Block;
import com.github.rjeschke.txtmark.Decorator;
import com.github.rjeschke.txtmark.HTML;
import com.github.rjeschke.txtmark.Line;
import com.github.rjeschke.txtmark.LinkRef;
import com.github.rjeschke.txtmark.MarkToken;
import com.github.rjeschke.txtmark.Utils;
import java.util.HashMap;

class Emitter {
    private final HashMap<String, LinkRef> linkRefs = new HashMap();
    private Decorator decorator;
    public boolean useExtensions = false;
    private final boolean safeMode;

    public Emitter(Decorator decorator, boolean bl) {
        this.decorator = decorator;
        this.safeMode = bl;
    }

    public void addLinkRef(String string, LinkRef linkRef) {
        this.linkRefs.put(string.toLowerCase(), linkRef);
    }

    public void emit(StringBuilder stringBuilder, Block block) {
        block.removeSurroundingEmptyLines();
        switch (block.type) {
            case RULER: {
                this.decorator.horizontalRuler(stringBuilder);
                return;
            }
            case NONE: 
            case XML: {
                break;
            }
            case HEADLINE: {
                this.decorator.openHeadline(stringBuilder, block.hlDepth);
                if (this.useExtensions && block.id != null) {
                    stringBuilder.append(" id=\"");
                    Utils.appendCode(stringBuilder, block.id, 0, block.id.length());
                    stringBuilder.append('\"');
                }
                stringBuilder.append('>');
                break;
            }
            case PARAGRAPH: {
                this.decorator.openParagraph(stringBuilder);
                break;
            }
            case CODE: {
                this.decorator.openCodeBlock(stringBuilder);
                break;
            }
            case BLOCKQUOTE: {
                this.decorator.openBlockquote(stringBuilder);
                break;
            }
            case UNORDERED_LIST: {
                this.decorator.openUnorderedList(stringBuilder);
                break;
            }
            case ORDERED_LIST: {
                this.decorator.openOrderedList(stringBuilder);
                break;
            }
            case LIST_ITEM: {
                this.decorator.openListItem(stringBuilder);
                if (this.useExtensions && block.id != null) {
                    stringBuilder.append(" id=\"");
                    Utils.appendCode(stringBuilder, block.id, 0, block.id.length());
                    stringBuilder.append('\"');
                }
                stringBuilder.append('>');
            }
        }
        if (block.hasLines()) {
            this.emitLines(stringBuilder, block);
        } else {
            Block block2 = block.blocks;
            while (block2 != null) {
                this.emit(stringBuilder, block2);
                block2 = block2.next;
            }
        }
        switch (block.type) {
            case RULER: 
            case NONE: 
            case XML: {
                break;
            }
            case HEADLINE: {
                this.decorator.closeHeadline(stringBuilder, block.hlDepth);
                break;
            }
            case PARAGRAPH: {
                this.decorator.closeParagraph(stringBuilder);
                break;
            }
            case CODE: {
                this.decorator.closeCodeBlock(stringBuilder);
                break;
            }
            case BLOCKQUOTE: {
                this.decorator.closeBlockquote(stringBuilder);
                break;
            }
            case UNORDERED_LIST: {
                this.decorator.closeUnorderedList(stringBuilder);
                break;
            }
            case ORDERED_LIST: {
                this.decorator.closeOrderedList(stringBuilder);
                break;
            }
            case LIST_ITEM: {
                this.decorator.closeListItem(stringBuilder);
            }
        }
    }

    private void emitLines(StringBuilder stringBuilder, Block block) {
        switch (block.type) {
            case CODE: {
                this.emitCodeLines(stringBuilder, block.lines);
                break;
            }
            case XML: {
                this.emitRawLines(stringBuilder, block.lines);
                break;
            }
            default: {
                this.emitMarkedLines(stringBuilder, block.lines);
            }
        }
    }

    private int findToken(String string, int n, MarkToken markToken) {
        for (int i = n; i < string.length(); ++i) {
            if (this.getToken(string, i) != markToken) continue;
            return i;
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int checkLink(StringBuilder stringBuilder, String string, int n, MarkToken markToken) {
        boolean bl = false;
        int n2 = n + (markToken == MarkToken.LINK ? 1 : 2);
        StringBuilder stringBuilder2 = new StringBuilder();
        stringBuilder2.setLength(0);
        n2 = Utils.readMdLinkId(stringBuilder2, string, n2);
        if (n2 < n) {
            return -1;
        }
        String string2 = stringBuilder2.toString();
        String string3 = null;
        String string4 = null;
        int n3 = n2++;
        if ((n2 = Utils.skipSpaces(string, n2)) < n) {
            LinkRef linkRef = this.linkRefs.get(string2.toLowerCase());
            if (linkRef == null) return -1;
            bl = linkRef.isAbbrev;
            string3 = linkRef.link;
            string4 = linkRef.title;
            n2 = n3;
        } else if (string.charAt(n2) == '(') {
            ++n2;
            if ((n2 = Utils.skipSpaces(string, n2)) < n) {
                return -1;
            }
            stringBuilder2.setLength(0);
            boolean bl2 = string.charAt(n2) == '<';
            int n4 = n2 = bl2 ? Utils.readUntil(stringBuilder2, string, n2 + 1, '>') : Utils.readMdLink(stringBuilder2, string, n2);
            if (n2 < n) {
                return -1;
            }
            if (bl2) {
                ++n2;
            }
            string3 = stringBuilder2.toString();
            if (string.charAt(n2) == ' ' && (n2 = Utils.skipSpaces(string, n2)) > n && string.charAt(n2) == '\"') {
                ++n2;
                stringBuilder2.setLength(0);
                n2 = Utils.readUntil(stringBuilder2, string, n2, '\"');
                if (n2 < n) {
                    return -1;
                }
                string4 = stringBuilder2.toString();
                ++n2;
                if ((n2 = Utils.skipSpaces(string, n2)) == -1) {
                    return -1;
                }
            }
            if (string.charAt(n2) != ')') {
                return -1;
            }
        } else if (string.charAt(n2) == '[') {
            ++n2;
            stringBuilder2.setLength(0);
            n2 = Utils.readRawUntil(stringBuilder2, string, n2, ']');
            if (n2 < n) {
                return -1;
            }
            String string5 = stringBuilder2.length() > 0 ? stringBuilder2.toString() : string2;
            LinkRef linkRef = this.linkRefs.get(string5.toLowerCase());
            if (linkRef != null) {
                string3 = linkRef.link;
                string4 = linkRef.title;
            }
        } else {
            LinkRef linkRef = this.linkRefs.get(string2.toLowerCase());
            if (linkRef == null) return -1;
            bl = linkRef.isAbbrev;
            string3 = linkRef.link;
            string4 = linkRef.title;
            n2 = n3;
        }
        if (string3 == null) {
            return -1;
        }
        if (markToken == MarkToken.LINK) {
            if (bl && string4 != null) {
                if (!this.useExtensions) {
                    return -1;
                }
                stringBuilder.append("<abbr title=\"");
                Utils.appendValue(stringBuilder, string4, 0, string4.length());
                stringBuilder.append("\">");
                this.recursiveEmitLine(stringBuilder, string2, 0, MarkToken.NONE);
                stringBuilder.append("</abbr>");
                return n2;
            } else {
                this.decorator.openLink(stringBuilder);
                stringBuilder.append(" href=\"");
                Utils.appendValue(stringBuilder, string3, 0, string3.length());
                stringBuilder.append('\"');
                if (string4 != null) {
                    stringBuilder.append(" title=\"");
                    Utils.appendValue(stringBuilder, string4, 0, string4.length());
                    stringBuilder.append('\"');
                }
                stringBuilder.append('>');
                this.recursiveEmitLine(stringBuilder, string2, 0, MarkToken.NONE);
                stringBuilder.append("</a>");
            }
            return n2;
        } else {
            this.decorator.openImage(stringBuilder);
            stringBuilder.append(" src=\"");
            Utils.appendValue(stringBuilder, string3, 0, string3.length());
            stringBuilder.append("\" alt=\"");
            Utils.appendValue(stringBuilder, string2, 0, string2.length());
            stringBuilder.append('\"');
            if (string4 != null) {
                stringBuilder.append(" title=\"");
                Utils.appendValue(stringBuilder, string4, 0, string4.length());
                stringBuilder.append('\"');
            }
            stringBuilder.append(" />");
        }
        return n2;
    }

    private int checkHtml(StringBuilder stringBuilder, String string, int n) {
        StringBuilder stringBuilder2 = new StringBuilder();
        stringBuilder2.setLength(0);
        int n2 = Utils.readUntil(stringBuilder2, string, n + 1, ':', ' ', '>', '\n');
        if (n2 != -1 && string.charAt(n2) == ':' && HTML.isLinkPrefix(stringBuilder2.toString()) && (n2 = Utils.readUntil(stringBuilder2, string, n2, '>')) != -1) {
            String string2 = stringBuilder2.toString();
            this.decorator.openLink(stringBuilder);
            stringBuilder.append(" href=\"");
            Utils.appendValue(stringBuilder, string2, 0, string2.length());
            stringBuilder.append("\">");
            Utils.appendValue(stringBuilder, string2, 0, string2.length());
            stringBuilder.append("</a>");
            return n2;
        }
        stringBuilder2.setLength(0);
        n2 = Utils.readUntil(stringBuilder2, string, n + 1, '@', ' ', '>', '\n');
        if (n2 != -1 && string.charAt(n2) == '@' && (n2 = Utils.readUntil(stringBuilder2, string, n2, '>')) != -1) {
            String string3 = stringBuilder2.toString();
            this.decorator.openLink(stringBuilder);
            stringBuilder.append(" href=\"");
            Utils.appendMailto(stringBuilder, "mailto:", 0, 7);
            Utils.appendMailto(stringBuilder, string3, 0, string3.length());
            stringBuilder.append("\">");
            Utils.appendMailto(stringBuilder, string3, 0, string3.length());
            stringBuilder.append("</a>");
            return n2;
        }
        if (n + 2 < string.length()) {
            stringBuilder2.setLength(0);
            return Utils.readXML(stringBuilder, string, n, this.safeMode);
        }
        return -1;
    }

    private int checkEntity(StringBuilder stringBuilder, String string, int n) {
        int n2 = Utils.readUntil(stringBuilder, string, n, ';');
        if (n2 < 0 || stringBuilder.length() < 3) {
            return -1;
        }
        if (stringBuilder.charAt(1) == '#') {
            if (stringBuilder.charAt(2) == 'x' || stringBuilder.charAt(2) == 'X') {
                if (stringBuilder.length() < 4) {
                    return -1;
                }
                for (int i = 3; i < stringBuilder.length(); ++i) {
                    char c = stringBuilder.charAt(i);
                    if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F') continue;
                    return -1;
                }
            } else {
                for (int i = 2; i < stringBuilder.length(); ++i) {
                    char c = stringBuilder.charAt(i);
                    if (c >= '0' && c <= '9') continue;
                    return -1;
                }
            }
        } else {
            for (int i = 1; i < stringBuilder.length(); ++i) {
                char c = stringBuilder.charAt(i);
                if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') continue;
                return -1;
            }
            stringBuilder.append(';');
            return HTML.isEntity(stringBuilder.toString()) ? n2 : -1;
        }
        stringBuilder.append(';');
        return n2;
    }

    private int recursiveEmitLine(StringBuilder stringBuilder, String string, int n, MarkToken markToken) {
        StringBuilder stringBuilder2 = new StringBuilder();
        block20: for (int i = n; i < string.length(); ++i) {
            MarkToken markToken2 = this.getToken(string, i);
            if (markToken != MarkToken.NONE && (markToken2 == markToken || markToken == MarkToken.EM_STAR && markToken2 == MarkToken.STRONG_STAR || markToken == MarkToken.EM_UNDERSCORE && markToken2 == MarkToken.STRONG_UNDERSCORE)) {
                return i;
            }
            switch (markToken2) {
                case IMAGE: 
                case LINK: {
                    stringBuilder2.setLength(0);
                    int n2 = this.checkLink(stringBuilder2, string, i, markToken2);
                    if (n2 > 0) {
                        stringBuilder.append((CharSequence)stringBuilder2);
                        i = n2;
                        continue block20;
                    }
                    stringBuilder.append(string.charAt(i));
                    continue block20;
                }
                case EM_STAR: 
                case EM_UNDERSCORE: {
                    stringBuilder2.setLength(0);
                    int n2 = this.recursiveEmitLine(stringBuilder2, string, i + 1, markToken2);
                    if (n2 > 0) {
                        this.decorator.openEmphasis(stringBuilder);
                        stringBuilder.append((CharSequence)stringBuilder2);
                        this.decorator.closeEmphasis(stringBuilder);
                        i = n2;
                        continue block20;
                    }
                    stringBuilder.append(string.charAt(i));
                    continue block20;
                }
                case STRONG_STAR: 
                case STRONG_UNDERSCORE: {
                    stringBuilder2.setLength(0);
                    int n2 = this.recursiveEmitLine(stringBuilder2, string, i + 2, markToken2);
                    if (n2 > 0) {
                        this.decorator.openStrong(stringBuilder);
                        stringBuilder.append((CharSequence)stringBuilder2);
                        this.decorator.closeStrong(stringBuilder);
                        i = n2 + 1;
                        continue block20;
                    }
                    stringBuilder.append(string.charAt(i));
                    continue block20;
                }
                case SUPER: {
                    stringBuilder2.setLength(0);
                    int n2 = this.recursiveEmitLine(stringBuilder2, string, i + 1, markToken2);
                    if (n2 > 0) {
                        this.decorator.openSuper(stringBuilder);
                        stringBuilder.append((CharSequence)stringBuilder2);
                        this.decorator.closeSuper(stringBuilder);
                        i = n2;
                        continue block20;
                    }
                    stringBuilder.append(string.charAt(i));
                    continue block20;
                }
                case CODE_SINGLE: 
                case CODE_DOUBLE: {
                    int n3 = i + (markToken2 == MarkToken.CODE_DOUBLE ? 2 : 1);
                    int n2 = this.findToken(string, n3, markToken2);
                    if (n2 > 0) {
                        i = n2 + (markToken2 == MarkToken.CODE_DOUBLE ? 1 : 0);
                        while (n3 < n2 && string.charAt(n3) == ' ') {
                            ++n3;
                        }
                        if (n3 >= n2) continue block20;
                        while (string.charAt(n2 - 1) == ' ') {
                            --n2;
                        }
                        this.decorator.openCodeSpan(stringBuilder);
                        Utils.appendCode(stringBuilder, string, n3, n2);
                        this.decorator.closeCodeSpan(stringBuilder);
                        continue block20;
                    }
                    stringBuilder.append(string.charAt(i));
                    continue block20;
                }
                case HTML: {
                    stringBuilder2.setLength(0);
                    int n2 = this.checkHtml(stringBuilder2, string, i);
                    if (n2 > 0) {
                        stringBuilder.append((CharSequence)stringBuilder2);
                        i = n2;
                        continue block20;
                    }
                    stringBuilder.append("&lt;");
                    continue block20;
                }
                case ENTITY: {
                    stringBuilder2.setLength(0);
                    int n2 = this.checkEntity(stringBuilder2, string, i);
                    if (n2 > 0) {
                        stringBuilder.append((CharSequence)stringBuilder2);
                        i = n2;
                        continue block20;
                    }
                    stringBuilder.append("&amp;");
                    continue block20;
                }
                case X_COPY: {
                    stringBuilder.append("&copy;");
                    i += 2;
                    continue block20;
                }
                case X_REG: {
                    stringBuilder.append("&reg;");
                    i += 2;
                    continue block20;
                }
                case X_TRADE: {
                    stringBuilder.append("&trade;");
                    i += 3;
                    continue block20;
                }
                case X_NDASH: {
                    stringBuilder.append("&ndash;");
                    ++i;
                    continue block20;
                }
                case X_MDASH: {
                    stringBuilder.append("&mdash;");
                    i += 2;
                    continue block20;
                }
                case X_HELLIP: {
                    stringBuilder.append("&hellip;");
                    i += 2;
                    continue block20;
                }
                case X_LAQUO: {
                    stringBuilder.append("&laquo;");
                    ++i;
                    continue block20;
                }
                case X_RAQUO: {
                    stringBuilder.append("&raquo;");
                    ++i;
                    continue block20;
                }
                case X_RDQUO: {
                    stringBuilder.append("&rdquo;");
                    continue block20;
                }
                case X_LDQUO: {
                    stringBuilder.append("&ldquo;");
                    continue block20;
                }
                case ESCAPE: {
                    ++i;
                }
                default: {
                    stringBuilder.append(string.charAt(i));
                }
            }
        }
        return -1;
    }

    private MarkToken getToken(String string, int n) {
        char c = n > 0 ? (char)string.charAt(n - 1) : (char)' ';
        char c2 = string.charAt(n);
        char c3 = n + 1 < string.length() ? (char)string.charAt(n + 1) : (char)' ';
        int n2 = n + 2 < string.length() ? (int)string.charAt(n + 2) : 32;
        int n3 = n + 3 < string.length() ? (int)string.charAt(n + 3) : 32;
        switch (c2) {
            case '*': {
                if (c3 == '*') {
                    return c != ' ' || n2 != 32 ? MarkToken.STRONG_STAR : MarkToken.EM_STAR;
                }
                return c != ' ' || c3 != ' ' ? MarkToken.EM_STAR : MarkToken.NONE;
            }
            case '_': {
                if (c3 == '_') {
                    return c != ' ' || n2 != 32 ? MarkToken.STRONG_UNDERSCORE : MarkToken.EM_UNDERSCORE;
                }
                if (this.useExtensions) {
                    return c != ' ' && c != '_' && c3 != ' ' ? MarkToken.NONE : MarkToken.EM_UNDERSCORE;
                }
                return c != ' ' || c3 != ' ' ? MarkToken.EM_UNDERSCORE : MarkToken.NONE;
            }
            case '!': {
                if (c3 == '[') {
                    return MarkToken.IMAGE;
                }
                return MarkToken.NONE;
            }
            case '[': {
                return MarkToken.LINK;
            }
            case '`': {
                return c3 == '`' ? MarkToken.CODE_DOUBLE : MarkToken.CODE_SINGLE;
            }
            case '\\': {
                switch (c3) {
                    case '!': 
                    case '\"': 
                    case '#': 
                    case '\'': 
                    case '(': 
                    case ')': 
                    case '*': 
                    case '+': 
                    case '-': 
                    case '.': 
                    case '<': 
                    case '>': 
                    case '[': 
                    case '\\': 
                    case ']': 
                    case '^': 
                    case '_': 
                    case '`': 
                    case '{': 
                    case '}': {
                        return MarkToken.ESCAPE;
                    }
                }
                return MarkToken.NONE;
            }
            case '<': {
                if (this.useExtensions && c3 == '<') {
                    return MarkToken.X_LAQUO;
                }
                return MarkToken.HTML;
            }
            case '&': {
                return MarkToken.ENTITY;
            }
        }
        if (this.useExtensions) {
            switch (c2) {
                case '-': {
                    if (c3 != 45) break;
                    return n2 == 45 ? MarkToken.X_MDASH : MarkToken.X_NDASH;
                }
                case '^': {
                    return c == '^' || c3 == '^' ? MarkToken.NONE : MarkToken.SUPER;
                }
                case '>': {
                    if (c3 != 62) break;
                    return MarkToken.X_RAQUO;
                }
                case '.': {
                    if (c3 != 46 || n2 != 46) break;
                    return MarkToken.X_HELLIP;
                }
                case '(': {
                    if (c3 == 'C' && n2 == 41) {
                        return MarkToken.X_COPY;
                    }
                    if (c3 == 'R' && n2 == 41) {
                        return MarkToken.X_REG;
                    }
                    if (!(c3 == 'T' & n2 == 77 & n3 == 41)) break;
                    return MarkToken.X_TRADE;
                }
                case '\"': {
                    if (!Character.isLetterOrDigit(c) && c3 != ' ') {
                        return MarkToken.X_LDQUO;
                    }
                    if (c == 32 || Character.isLetterOrDigit(c3)) break;
                    return MarkToken.X_RDQUO;
                }
            }
        }
        return MarkToken.NONE;
    }

    private void emitMarkedLines(StringBuilder stringBuilder, Line line) {
        StringBuilder stringBuilder2 = new StringBuilder();
        Line line2 = line;
        while (line2 != null) {
            if (!line2.isEmpty) {
                stringBuilder2.append(line2.value.substring(line2.leading, line2.value.length() - line2.trailing));
                if (line2.trailing >= 2) {
                    stringBuilder2.append("<br />");
                }
            }
            if (line2.next != null) {
                stringBuilder2.append('\n');
            }
            line2 = line2.next;
        }
        this.recursiveEmitLine(stringBuilder, stringBuilder2.toString(), 0, MarkToken.NONE);
    }

    private void emitRawLines(StringBuilder stringBuilder, Line line) {
        Line line2 = line;
        if (this.safeMode) {
            StringBuilder stringBuilder2 = new StringBuilder();
            while (line2 != null) {
                if (!line2.isEmpty) {
                    stringBuilder2.append(line2.value);
                }
                stringBuilder2.append('\n');
                line2 = line2.next;
            }
            String string = stringBuilder2.toString();
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '<') {
                    stringBuilder2.setLength(0);
                    int n = Utils.readXML(stringBuilder2, string, i, this.safeMode);
                    if (n != -1) {
                        stringBuilder.append((CharSequence)stringBuilder2);
                        i = n;
                        continue;
                    }
                    stringBuilder.append(string.charAt(i));
                    continue;
                }
                stringBuilder.append(string.charAt(i));
            }
        } else {
            while (line2 != null) {
                if (!line2.isEmpty) {
                    stringBuilder.append(line2.value);
                }
                stringBuilder.append('\n');
                line2 = line2.next;
            }
        }
    }

    private void emitCodeLines(StringBuilder stringBuilder, Line line) {
        Line line2 = line;
        while (line2 != null) {
            if (!line2.isEmpty) {
                block6: for (int i = 4; i < line2.value.length(); ++i) {
                    char c = line2.value.charAt(i);
                    switch (c) {
                        case '&': {
                            stringBuilder.append("&amp;");
                            continue block6;
                        }
                        case '<': {
                            stringBuilder.append("&lt;");
                            continue block6;
                        }
                        case '>': {
                            stringBuilder.append("&gt;");
                            continue block6;
                        }
                        default: {
                            stringBuilder.append(c);
                        }
                    }
                }
            }
            stringBuilder.append('\n');
            line2 = line2.next;
        }
    }
}

