/*
 * Decompiled with CFR 0.152.
 */
package com.cyberfox.util.config;

import com.cyberfox.util.config.Base64;
import com.cyberfox.util.config.LoggerInterface;
import com.cyberfox.util.config.NullLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class JConfig {
    private static String sVersion = null;
    protected static Properties soleProperty = new Properties();
    protected static Properties displayProperty = null;
    protected static Properties mAuxProps = null;
    protected static Properties mTempProps = null;
    protected static String _configFileName = null;
    protected static String baseName = null;
    public static int screenx;
    public static int screeny;
    public static int height;
    public static int width;
    public static volatile boolean debugging;
    private static List<ConfigListener> _listeners;
    private static boolean _anyUpdates;
    private static boolean mScripting;
    private static LoggerInterface mLogger;
    private static String sHomeDirectory;
    private static Set sTimers;

    public static void load(InputStream inConfigFile) {
        try {
            if (inConfigFile != null) {
                soleProperty.load(inConfigFile);
                inConfigFile.close();
            }
        }
        catch (IOException e) {
            JConfig.log().handleException("Fatal error loading config file.", e);
            System.exit(1);
        }
        JConfig.handleConfigLoading();
    }

    public static void enableScripting() {
        mScripting = true;
    }

    public static void disableScripting() {
        mScripting = false;
    }

    public static boolean scriptingEnabled() {
        return mScripting;
    }

    public static boolean debugging() {
        return debugging;
    }

    public static void registerListener(ConfigListener jcl) {
        _listeners.add(jcl);
    }

    public static void killAll(String prefix) {
        Set<Object> ks = soleProperty.keySet();
        Iterator<Object> it = ks.iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (!key.startsWith(prefix)) continue;
            it.remove();
        }
    }

    public static void kill(String key) {
        Set<Object> ks;
        if (key.startsWith("temp.")) {
            if (mTempProps == null) {
                return;
            }
            ks = mTempProps.keySet();
        } else {
            ks = soleProperty.keySet();
        }
        Iterator<Object> it = ks.iterator();
        while (it.hasNext()) {
            String stepKey = (String)it.next();
            if (!stepKey.equals(key)) continue;
            it.remove();
        }
    }

    public static String getOS() {
        String rawOSName = System.getProperty("os.name");
        int spaceIndex = rawOSName.indexOf(32);
        String osName = spaceIndex == -1 ? rawOSName : rawOSName.substring(0, spaceIndex);
        return osName;
    }

    public static void updateComplete() {
        JConfig.setDebugging(JConfig.queryConfiguration("debugging", "false").equals("true"));
        if (_anyUpdates) {
            for (ConfigListener jcl : _listeners) {
                jcl.updateConfiguration();
            }
        }
        _anyUpdates = false;
    }

    private static void handleConfigLoading() {
        JConfig.passwordUnfixup_b64(soleProperty);
        if (soleProperty.containsKey("debugging")) {
            String debugFlag = soleProperty.getProperty("debugging");
            if (debugFlag.equalsIgnoreCase("true")) {
                JConfig.setDebugging(true);
            } else if (debugFlag.equalsIgnoreCase("false")) {
                JConfig.setDebugging(false);
            } else {
                JConfig.log().logMessage("debugging flag is bad, only 'true' or 'false' allowed.  Presuming true.");
                JConfig.setDebugging(true);
            }
        }
    }

    public static void load(String configFile) {
        _configFileName = configFile;
        if (configFile != null) {
            try {
                FileInputStream fis = new FileInputStream(configFile);
                JConfig.load(fis);
                fis.close();
            }
            catch (FileNotFoundException e) {
                JConfig.log().handleException("Property file " + configFile + " not found.  Retaining default settings!\n", e);
            }
            catch (IOException e) {
                JConfig.log().handleException("Failed to close property file!\n", e);
            }
        }
    }

    public static void saveArbitrary(String cfgName, Properties arbProps) {
        try {
            FileOutputStream fos = new FileOutputStream(cfgName);
            arbProps.store(fos, "Configuration information.  Do not modify while running.");
            fos.close();
        }
        catch (IOException e) {
            JConfig.log().handleException("Failed to write configuration: " + cfgName, e);
        }
    }

    public static Properties loadArbitrary(InputStream inCfgStream) {
        Properties slopsProps;
        try {
            slopsProps = new Properties();
            slopsProps.load(inCfgStream);
            inCfgStream.close();
        }
        catch (IOException e) {
            JConfig.log().handleException("Failed to load arbitrary stream configuration.", e);
            slopsProps = null;
        }
        return slopsProps;
    }

    public static Properties loadArbitrary(String cfgName) {
        File checkExistence = new File(cfgName);
        if (checkExistence.exists()) {
            try {
                FileInputStream fis = new FileInputStream(cfgName);
                return JConfig.loadArbitrary(fis);
            }
            catch (IOException e) {
                JConfig.log().handleException("Failed to load configuration " + cfgName, e);
            }
        }
        return null;
    }

    public static void saveDisplayConfig(String dispFile, Properties displayProps, Properties auxProps) {
        try {
            File fd = new File(dispFile);
            if (fd.canWrite() || !fd.exists()) {
                FileOutputStream fos = new FileOutputStream(fd);
                displayProps.store(fos, "Display information.  Do not modify while running.");
                if (auxProps != null) {
                    auxProps.store(fos, "Column header information.  Do not modify while running.");
                }
                if (mAuxProps != null) {
                    mAuxProps.store(fos, "Search display information.  Do not modify while running.");
                }
                fos.close();
            } else {
                JConfig.log().logMessage("Failed to write to the display configuration; no write permissions to " + dispFile);
            }
        }
        catch (IOException e) {
            JConfig.log().handleException("Failed to write display configuration.", e);
        }
    }

    private static void passwordFixup(Properties _inProps) {
        Properties encoded = new Properties();
        ArrayList<String> removedKeys = new ArrayList<String>();
        for (Object o : _inProps.keySet()) {
            String key = o.toString();
            String lcKey = key.toLowerCase();
            if (lcKey.indexOf("password") == -1 || lcKey.indexOf("_b64") != -1) continue;
            String val = _inProps.getProperty(key);
            removedKeys.add(key);
            encoded.setProperty(key + "_b64", Base64.encodeString(val, false));
        }
        for (String key : removedKeys) {
            _inProps.remove(key);
        }
        _inProps.putAll((Map<?, ?>)encoded);
    }

    private static void passwordUnfixup_b64(Properties _inProps) {
        Properties decoded = new Properties();
        ArrayList<String> removedKeys = new ArrayList<String>();
        for (Object o : _inProps.keySet()) {
            String key = o.toString();
            String lcKey = key.toLowerCase();
            if (lcKey.indexOf("_b64") == -1) continue;
            int b64_start = lcKey.indexOf("_b64");
            String val = _inProps.getProperty(key);
            removedKeys.add(key);
            key = key.substring(0, b64_start) + key.substring(b64_start + 4);
            try {
                decoded.setProperty(key, Base64.decodeToString(val));
            }
            catch (Exception e) {
                JConfig.log().handleException("Couldn't decode the password!", e);
            }
        }
        for (String key : removedKeys) {
            _inProps.remove(key);
        }
        _inProps.putAll((Map<?, ?>)decoded);
    }

    public static void setConfigurationFile(String cfgFile) {
        _configFileName = cfgFile;
    }

    public static void saveConfiguration() {
        JConfig.saveConfiguration(_configFileName);
    }

    public static void setBaseName(String newBaseName) {
        baseName = newBaseName;
    }

    public static void saveConfiguration(String outFile) {
        _configFileName = outFile;
        JConfig.passwordFixup(soleProperty);
        if (_configFileName != null) {
            JConfig.saveArbitrary(_configFileName, soleProperty);
            JConfig.log().logDebug("Saving to: " + _configFileName);
        } else {
            JConfig.saveArbitrary(baseName, soleProperty);
            JConfig.log().logDebug("Just saving to: " + baseName + "!");
        }
        JConfig.passwordUnfixup_b64(soleProperty);
    }

    public static InputStream bestSource(ClassLoader urlCL, String inConfig) {
        File realConfig = new File(inConfig);
        InputStream configStream = null;
        if (realConfig.exists()) {
            try {
                configStream = new FileInputStream(inConfig);
            }
            catch (FileNotFoundException ignore) {
                JConfig.log().logMessage(inConfig + " deleted between existence check and loading!");
            }
        } else {
            configStream = urlCL.getResourceAsStream(realConfig.getName());
        }
        return configStream;
    }

    public static void loadDisplayConfig(String dispFile, ClassLoader urlCL, int screenwidth, int screenheight) {
        Properties displayProps = new Properties();
        InputStream dispIS = JConfig.getExternalWithFallback(urlCL, dispFile);
        height = 0;
        width = 0;
        boolean setOwnProps = false;
        if (dispIS != null) {
            try {
                displayProps.load(dispIS);
                screenx = Integer.parseInt(displayProps.getProperty("screenx", "0"));
                screeny = Integer.parseInt(displayProps.getProperty("screeny", "0"));
                if (screenx < 0 || screeny < 0 || screenx > screenwidth || screeny > screenheight) {
                    setOwnProps = true;
                }
                height = Integer.parseInt(displayProps.getProperty("height", "0"));
                width = Integer.parseInt(displayProps.getProperty("width", "0"));
                if (height <= 0 || width <= 0) {
                    height = 0;
                    width = 0;
                    setOwnProps = true;
                }
            }
            catch (IOException e) {
                JConfig.log().handleException("Error loading display properties.", e);
                setOwnProps = true;
            }
        } else {
            setOwnProps = true;
        }
        if (setOwnProps) {
            if (height == 0 || width == 0) {
                height = screenheight / 2;
                width = screenwidth < 1010 ? screenwidth / 2 : 1010;
            }
            screenx = (screenwidth - width) / 2;
            screeny = (screenheight - height) / 2;
            displayProps.setProperty("screenx", Integer.toString(screenx));
            displayProps.setProperty("screeny", Integer.toString(screeny));
            displayProps.setProperty("height", Integer.toString(height));
            displayProps.setProperty("width", Integer.toString(width));
        }
        displayProperty = displayProps;
    }

    private static InputStream getExternalWithFallback(ClassLoader urlCL, String dispFile) {
        boolean fileLoadFailed = false;
        File checkExistence = new File(dispFile);
        InputStream dispIS = null;
        if (checkExistence.exists()) {
            try {
                dispIS = new FileInputStream(dispFile);
            }
            catch (FileNotFoundException e) {
                JConfig.log().handleException(dispFile + " deleted between existence check and loading!", e);
                fileLoadFailed = true;
            }
        } else {
            fileLoadFailed = true;
        }
        if (fileLoadFailed) {
            dispIS = urlCL.getResourceAsStream("/resources/display.cfg");
        }
        return dispIS;
    }

    private static boolean validResource(URL path) {
        if (path == null) {
            return false;
        }
        InputStream is = JConfig.class.getClassLoader().getResourceAsStream(path.toString());
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    public static URL getResource(String path) {
        URL rval = JConfig.class.getClassLoader().getResource(path);
        if (!(rval != null && JConfig.validResource(rval) || path.charAt(0) != '/')) {
            rval = JConfig.class.getClassLoader().getResource(path.substring(1));
        }
        return rval;
    }

    public static void setVersion(String version) {
        sVersion = version;
    }

    public static void setDebugging(boolean doDebug) {
        debugging = sVersion != null && sVersion.matches(".*(pre|alpha|beta).*") || doDebug;
    }

    public static void setDisplayConfiguration(String key, String value) {
        displayProperty.setProperty(key, value);
    }

    public static void setAuxConfiguration(String key, String value) {
        if (mAuxProps == null) {
            mAuxProps = new Properties();
        }
        mAuxProps.setProperty(key, value);
    }

    public static String queryAuxConfiguration(String key, String inDefault) {
        if (mAuxProps == null) {
            return inDefault;
        }
        return mAuxProps.getProperty(key, inDefault);
    }

    public static String queryDisplayProperty(String query) {
        return displayProperty.getProperty(query, null);
    }

    public static Properties multiMatchDisplay(String query) {
        Properties p = new Properties();
        for (Object key : displayProperty.keySet()) {
            if (!((String)key).startsWith(query)) continue;
            p.setProperty((String)key, displayProperty.getProperty((String)key));
        }
        return p;
    }

    public static String queryDisplayProperty(String query, String inDefault) {
        String retVal = JConfig.queryDisplayProperty(query);
        if (retVal == null) {
            return inDefault;
        }
        return retVal;
    }

    public static void setConfiguration(String key, String value) {
        if (key.startsWith("temp.")) {
            if (mTempProps == null) {
                mTempProps = new Properties();
            }
            mTempProps.setProperty(key, value);
        } else {
            _anyUpdates = true;
            soleProperty.setProperty(key, value);
        }
    }

    public static String queryConfiguration(String query, String inDefault) {
        String retVal = JConfig.queryConfiguration(query);
        if (retVal == null) {
            return inDefault;
        }
        return retVal;
    }

    public static String queryConfiguration(String query) {
        if (soleProperty.getProperty("config.logging", "false").equals("true")) {
            System.out.println("Query: " + query);
        }
        if (query.startsWith("temp.")) {
            if (mTempProps == null) {
                return null;
            }
            return mTempProps.getProperty(query, null);
        }
        return soleProperty.getProperty(query, null);
    }

    public static List<String> getAllKeys() {
        ArrayList<String> keyList = new ArrayList<String>();
        for (Object name : soleProperty.keySet()) {
            keyList.add(name.toString());
        }
        Collections.sort(keyList);
        return keyList;
    }

    public static List<String> getMatching(String prefix) {
        Set<Object> keySet = soleProperty.keySet();
        ArrayList<String> results = null;
        int prefixLen = prefix.length();
        for (Object aKeySet : keySet) {
            String s = (String)aKeySet;
            if (!s.startsWith(prefix)) continue;
            if (results == null) {
                results = new ArrayList<String>();
            }
            results.add(s.substring(prefixLen));
        }
        return results;
    }

    public static void killDisplay(String key) {
        displayProperty.remove(key);
    }

    public static void addAllToDisplay(Properties replace) {
        displayProperty.putAll((Map<?, ?>)replace);
    }

    public static void setLogger(LoggerInterface logger) {
        mLogger = logger;
    }

    public static LoggerInterface log() {
        return mLogger;
    }

    public static void increment(String key) {
        long count;
        try {
            count = Integer.parseInt(JConfig.queryConfiguration(key, "0"));
        }
        catch (NumberFormatException e) {
            count = 0L;
        }
        JConfig.setConfiguration(key, Long.toString(++count));
    }

    public static void setHomeDirectory(String homeDirectory) {
        sHomeDirectory = homeDirectory;
    }

    public static String getHomeDirectory() {
        return sHomeDirectory;
    }

    public static void registerTimer(Object o) {
        sTimers.add(o);
    }

    public static Set getTimers() {
        return sTimers;
    }

    public static URL getURL(String url) throws MalformedURLException {
        JConfig.log().logDebug("Parsing URL " + url);
        return new URL(url);
    }

    static {
        debugging = true;
        _listeners = new LinkedList<ConfigListener>();
        _anyUpdates = false;
        mScripting = false;
        mLogger = new NullLogger();
        sHomeDirectory = null;
        sTimers = new HashSet();
    }

    public static interface ConfigListener {
        public void updateConfiguration();
    }
}

