/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.auction;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.jbidwatcher.auction.AuctionEntry;
import com.jbidwatcher.auction.AuctionEntryHTMLPresenter;
import com.jbidwatcher.auction.AuctionServerInterface;
import com.jbidwatcher.auction.DeletedEntry;
import com.jbidwatcher.auction.EntryCorral;
import com.jbidwatcher.auction.EntryManager;
import com.jbidwatcher.auction.Resolver;
import com.jbidwatcher.util.Observer;
import com.jbidwatcher.util.StringTools;
import com.jbidwatcher.util.config.JConfig;
import com.jbidwatcher.util.queue.MQFactory;

@Singleton
public class EntryFactory
extends Observer<AuctionEntry> {
    private final EntryCorral entryCorral;
    private Resolver resolver = null;
    private EntryManager auctionsManager;

    @Inject
    public EntryFactory(EntryCorral corral, EntryManager entryManager) {
        this.entryCorral = corral;
        this.auctionsManager = entryManager;
    }

    public AuctionEntry constructEntry() {
        AuctionServerInterface server = this.resolver.getServer();
        AuctionEntry ae = AuctionEntry.construct(server);
        ae.setPresenter(new AuctionEntryHTMLPresenter(ae));
        return ae;
    }

    public AuctionEntry constructEntry(String auctionId) {
        AuctionServerInterface server = this.resolver.getServer();
        String strippedId = server.stripId(auctionId);
        AuctionEntry ae = null;
        if (!DeletedEntry.exists(strippedId) && EntryCorral.findByIdentifier(strippedId) == null && (ae = AuctionEntry.construct(strippedId, server)) != null) {
            ae.setPresenter(new AuctionEntryHTMLPresenter(ae));
        }
        return ae;
    }

    public AuctionEntry conditionallyAddEntry(boolean interactive, String aucId, String label) {
        AuctionEntry aeNew;
        if (interactive) {
            DeletedEntry.remove(aucId);
        }
        if ((aeNew = this.constructEntry(aucId)) != null) {
            if (label != null) {
                aeNew.setCategory(label);
            }
            this.entryCorral.put(aeNew);
            MQFactory.getConcrete("manager").enqueue(aeNew.getUnique());
            MQFactory.getConcrete("Swing").enqueue("Added [ " + aeNew.getIdentifier() + ", " + aeNew.getTitle() + " ]");
        } else if (interactive) {
            MQFactory.getConcrete("Swing").enqueue("Cannot add auction " + aucId + ", either invalid or\ncommunication error talking to server.");
        }
        return aeNew;
    }

    public static boolean isInvalid(boolean interactive, String aucId) {
        boolean invalid;
        boolean bl = invalid = !StringTools.isNumberOnly(aucId);
        if (invalid) {
            JConfig.log().logDebug("Rejecting bad identifier: " + aucId);
        } else if (interactive) {
            boolean bl2 = invalid = EntryCorral.findByIdentifier(aucId) != null;
            if (invalid) {
                MQFactory.getConcrete("Swing").enqueue("Cannot add auction " + aucId + ", it is already in your auction list.");
            }
        }
        return invalid;
    }

    public void setResolver(Resolver resolver) {
        this.resolver = resolver;
    }

    @Override
    public void afterCreate(AuctionEntry auctionEntry) {
        if (auctionEntry.getServer() == null) {
            auctionEntry.setServer(this.resolver.getServer());
        }
        if (auctionEntry.getPresenter() == null) {
            auctionEntry.setPresenter(new AuctionEntryHTMLPresenter(auctionEntry));
        }
    }

    @Override
    public void afterSave(AuctionEntry auctionEntry) {
        MQFactory.getConcrete("redraw").enqueue(auctionEntry.getIdentifier());
    }
}

