/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.auction.event;

import com.jbidwatcher.auction.event.EventStatus;
import com.jbidwatcher.util.config.JConfig;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class EventLogger {
    private String mIdentifier = null;
    private String mTitle = null;
    private Integer mEntryId = null;
    private List<EventStatus> mAllEvents;
    private final EventStatus mNullEvent = new EventStatus("Nothing has happened.", new Date());

    public EventLogger(String identifier, Integer entryId, String title) {
        this.mIdentifier = identifier;
        this.mEntryId = entryId;
        this.mTitle = title;
        this.mNullEvent.setEntryId(this.mEntryId);
        this.mNullEvent.setAuctionIdentifier(this.mIdentifier);
        this.mNullEvent.setTitle(this.mTitle);
        this.mAllEvents = EventStatus.findAllByEntry(this.mEntryId, this.mIdentifier);
        if (this.mAllEvents == null) {
            this.mAllEvents = new ArrayList<EventStatus>();
        }
    }

    public void setLastStatus(String inStatus) {
        if (inStatus != null) {
            EventStatus lastStatus = this.mAllEvents.isEmpty() ? this.mNullEvent : this.mAllEvents.get(this.mAllEvents.size() - 1);
            if (inStatus.equals(lastStatus.getMessage())) {
                lastStatus.setRepeatCount(lastStatus.getRepeatCount() + 1);
                lastStatus.saveDB();
            } else {
                EventStatus whatHappened = new EventStatus(inStatus, new Date(), this.mEntryId, this.mIdentifier, this.mTitle);
                whatHappened.saveDB();
                this.mAllEvents.add(whatHappened);
                JConfig.log().logMessage(whatHappened.toString());
            }
        }
    }

    public int getStatusCount() {
        return this.mAllEvents.size();
    }

    public String getLastStatus() {
        if (this.mAllEvents.isEmpty()) {
            return this.mNullEvent.toString();
        }
        return this.mAllEvents.get(this.mAllEvents.size() - 1).toString();
    }

    public String getAllStatuses() {
        if (this.mAllEvents.isEmpty()) {
            return this.mNullEvent.toBulkString() + "<br>";
        }
        StringBuilder sb = new StringBuilder();
        for (EventStatus lastStatus : this.mAllEvents) {
            sb.append(lastStatus.toBulkString());
            sb.append("<br>");
        }
        return sb.toString();
    }

    public void save() {
        for (EventStatus step : this.mAllEvents) {
            step.saveDB();
        }
    }
}

