/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.util.db;

import com.jbidwatcher.util.config.JConfig;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;

public class Database {
    private static boolean sFirst = true;
    private String framework = JConfig.queryConfiguration("db.framework", "embedded");
    private String driver = JConfig.queryConfiguration("db.driver", "org.apache.derby.jdbc.EmbeddedDriver");
    private String protocol = JConfig.queryConfiguration("db.protocol", "jdbc:derby:");
    private Connection mConn;
    private boolean mNew;
    private boolean mysql = this.driver.toLowerCase().contains("mysql");

    public boolean executeCanonicalizedSQL(Statement mS, String statement) throws SQLException {
        if (this.isMySQL()) {
            statement = statement.replace("timestamp", "datetime");
            statement = statement.replace("generated by default as identity (START WITH 1, INCREMENT BY 1)", "auto_increment");
            statement = statement.replace(" clob,", " text,");
        }
        System.err.println("statement == " + statement);
        return mS.execute(statement);
    }

    public boolean isMySQL() {
        return this.mysql;
    }

    public static void main(String[] args) {
        try {
            Database db = new Database("/Users/mrs/.jbidwatcher");
            db.shutdown();
        }
        catch (Exception e) {
            Database.handleSQLException(e);
        }
    }

    public Database(String base) throws ClassNotFoundException, IllegalAccessException, InstantiationException, SQLException {
        if (base == null) {
            base = JConfig.getHomeDirectory();
        }
        if (!this.mysql) {
            System.setProperty("derby.system.home", base);
            System.setProperty("derby.storage.pageCacheSize", "500");
            if (JConfig.debugging) {
                // empty if block
            }
        }
        this.setup();
    }

    private void setup() throws ClassNotFoundException, IllegalAccessException, InstantiationException, SQLException {
        Class.forName(this.driver).newInstance();
        if (sFirst) {
            JConfig.log().logDebug("Loaded the appropriate driver.");
        }
        Properties props = new Properties();
        props.setProperty("user", JConfig.queryConfiguration("db.user", "user1"));
        props.setProperty("password", JConfig.queryConfiguration("db.pass", "user1"));
        try {
            this.mConn = this.isMySQL() ? DriverManager.getConnection(this.protocol + JConfig.queryConfiguration("db.mysql.database", "jbidwatcher"), props) : DriverManager.getConnection(this.protocol + "jbdb", props);
            this.mNew = false;
        }
        catch (SQLException se) {
            if (this.isMySQL()) {
                this.mConn = DriverManager.getConnection(this.protocol, props);
                Statement s = this.mConn.createStatement();
                s.executeUpdate("CREATE DATABASE " + JConfig.queryConfiguration("db.mysql.database", "jbidwatcher"));
                this.mConn.close();
                this.mConn = DriverManager.getConnection(this.protocol + JConfig.queryConfiguration("db.mysql.database", "jbidwatcher"), props);
            } else {
                this.mConn = DriverManager.getConnection(this.protocol + "jbdb;create=true", props);
            }
            this.mNew = true;
        }
        if (sFirst) {
            JConfig.log().logDebug("Connected to " + (this.mNew ? "and created " : "") + "database " + (this.isMySQL() ? JConfig.queryConfiguration("db.mysql.database", "jbidwatcher") : "jbdb") + " (JBidwatcher DataBase)");
        }
        this.mConn.setTransactionIsolation(8);
        boolean autoCommit = JConfig.queryConfiguration("db.autocommit", "true").equals("true");
        this.mConn.setAutoCommit(autoCommit);
        sFirst = false;
    }

    public Statement getStatement() {
        Statement rval = null;
        try {
            if (this.mConn != null) {
                rval = this.mConn.createStatement();
            }
        }
        catch (SQLException squee) {
            Database.handleSQLException(squee);
        }
        return rval;
    }

    public void commit() {
        if (this.isMySQL()) {
            return;
        }
        try {
            this.mConn.commit();
        }
        catch (SQLException squee) {
            Database.handleSQLException(squee);
        }
    }

    public void shutdown() {
        block6: {
            try {
                this.mConn.close();
                JConfig.log().logDebug("Closed connection");
                if (!this.framework.equals("embedded")) break block6;
                boolean gotSQLExc = false;
                try {
                    DriverManager.getConnection("jdbc:derby:;shutdown=true");
                }
                catch (SQLException se) {
                    gotSQLExc = true;
                }
                if (!gotSQLExc) {
                    JConfig.log().logMessage("Database did not shut down normally");
                } else {
                    JConfig.log().logDebug("Database shut down normally");
                }
            }
            catch (Throwable e) {
                Database.handleSQLException(e);
            }
        }
        sFirst = true;
    }

    private static void handleSQLException(Throwable e) {
        JConfig.log().logDebug("exception thrown:");
        if (e instanceof SQLException) {
            Database.printSQLError((SQLException)e);
        } else {
            e.printStackTrace();
        }
    }

    static void printSQLError(SQLException e) {
        while (e != null) {
            JConfig.log().logDebug(e.toString());
            e = e.getNextException();
        }
    }

    public PreparedStatement prepare(String statement) throws SQLException {
        try {
            return this.mConn.prepareStatement(statement, 1);
        }
        catch (SQLException sqe) {
            if (this.mConn.isClosed() || sqe.getMessage().equals("No current connection.")) {
                try {
                    this.setup();
                    return this.mConn.prepareStatement(statement, 1);
                }
                catch (Exception e) {
                    SQLException error = new SQLException("Failed to reconnect due to: " + e.getMessage());
                    error.initCause(e);
                    throw error;
                }
            }
            throw sqe;
        }
    }

    public Connection getConnection() {
        return this.mConn;
    }

    public static boolean saveDBConfig() {
        if (JConfig.queryConfiguration("temp.db.protocol") != null) {
            String[] keys;
            for (String key : keys = new String[]{"db.framework", "db.protocol", "db.driver", "db.user", "db.pass"}) {
                JConfig.setConfiguration(key, JConfig.queryConfiguration("temp." + key));
            }
            JConfig.kill("jbidwatcher.created_db");
            return true;
        }
        if (JConfig.queryConfiguration("temp.db.switch2derby", "false").equals("true")) {
            JConfig.kill("db.protocol");
            JConfig.kill("db.driver");
            JConfig.kill("db.user");
            JConfig.kill("db.pass");
        }
        return false;
    }
}

