/*
 * Decompiled with CFR 0.152.
 */
package com.orbus.mahalo;

import com.orbus.mahalo.MahaloSocketListener;
import com.orbus.mahalo.dns.DNSPacket;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;

public class MahaloSocket {
    private static final int MDNS_PORT = 5353;
    private NetworkInterface _NetInterface;
    private InetAddress _BoundAddress;
    private InetAddress _MulticastGroup;
    private MulticastSocket _MulticastSocket;
    private boolean _bContinueRunning = false;
    private Thread _ListeningThread;
    private List<MahaloSocketListener> _Listeners = new LinkedList<MahaloSocketListener>();

    public MahaloSocket(InetAddress aAddress) throws IOException {
        this._BoundAddress = aAddress;
        this._NetInterface = NetworkInterface.getByInetAddress(aAddress);
        if (this._NetInterface == null) {
            throw new SocketException("Could not find network interface associated with requested address: " + aAddress);
        }
        this.openMulticastSocket();
    }

    public InetAddress getBoundAddress() {
        return this._BoundAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(MahaloSocketListener aListener) {
        List<MahaloSocketListener> list = this._Listeners;
        synchronized (list) {
            if (!this._Listeners.contains(aListener)) {
                this._Listeners.add(aListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(MahaloSocketListener aListener) {
        List<MahaloSocketListener> list = this._Listeners;
        synchronized (list) {
            this._Listeners.remove(aListener);
        }
    }

    public void send(DNSPacket aMessage) {
        this.send(aMessage, null, null);
    }

    public void send(DNSPacket aMessage, InetAddress aAddress, Integer iPort) {
        if (aAddress == null) {
            aAddress = this._MulticastGroup;
        }
        if (iPort == null) {
            iPort = 5353;
        }
        try {
            ByteBuffer[] buffers;
            for (ByteBuffer buffer : buffers = aMessage.write()) {
                buffer.flip();
                byte[] data = new byte[buffer.remaining()];
                buffer.get(data);
                DatagramPacket packet = new DatagramPacket(data, buffer.position(), aAddress, iPort);
                this._MulticastSocket.send(packet);
            }
        }
        catch (IOException e) {
            try {
                this.recover();
            }
            catch (IOException ioException) {
                // empty catch block
            }
        }
    }

    public synchronized void startListening() {
        if (this._ListeningThread == null) {
            this._bContinueRunning = true;
            this._ListeningThread = new Thread(new SocketListener());
            this._ListeningThread.start();
        }
    }

    public synchronized void close() {
        if (this._bContinueRunning) {
            this._bContinueRunning = false;
            try {
                this._ListeningThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this._ListeningThread = null;
            this.closeMulticastSocket();
        }
    }

    private void recover() throws IOException {
        this.closeMulticastSocket();
        this.openMulticastSocket();
    }

    private synchronized void closeMulticastSocket() {
        if (this._MulticastSocket != null) {
            try {
                this._MulticastSocket.leaveGroup(this._MulticastGroup);
                this._MulticastSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this._MulticastSocket = null;
        this._MulticastGroup = null;
    }

    private synchronized void openMulticastSocket() throws IOException {
        if (this._MulticastSocket != null) {
            this.closeMulticastSocket();
        }
        try {
            this._MulticastGroup = InetAddress.getByName("224.0.0.251");
            this._MulticastSocket = new MulticastSocket(5353);
            this._MulticastSocket.setNetworkInterface(this._NetInterface);
            this._MulticastSocket.setSoTimeout(1000);
            this._MulticastSocket.setTimeToLive(255);
            this._MulticastSocket.joinGroup(this._MulticastGroup);
            this._bContinueRunning = true;
        }
        catch (IOException e) {
            this.closeMulticastSocket();
            throw e;
        }
    }

    private boolean shouldIgnorePacket(DatagramPacket packet) {
        boolean result = false;
        InetAddress from = packet.getAddress();
        if (from != null) {
            if (from.isLinkLocalAddress() && !this._BoundAddress.isLinkLocalAddress()) {
                result = true;
            }
            if (from.isLoopbackAddress() && !this._BoundAddress.isLoopbackAddress()) {
                result = true;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onQuery(DNSPacket aPacket, InetAddress aAddress, int aiPort) {
        List<MahaloSocketListener> list = this._Listeners;
        synchronized (list) {
            for (MahaloSocketListener listener : this._Listeners) {
                listener.handleQuery(aPacket, aAddress, aiPort);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onResponse(DNSPacket aPacket) {
        List<MahaloSocketListener> list = this._Listeners;
        synchronized (list) {
            for (MahaloSocketListener listener : this._Listeners) {
                listener.handleResponse(aPacket);
            }
        }
    }

    private class SocketListener
    implements Runnable {
        private SocketListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            byte[] buf = new byte[8972];
            DatagramPacket packet = new DatagramPacket(buf, buf.length);
            packet.setLength(buf.length);
            while (MahaloSocket.this._bContinueRunning) {
                try {
                    SocketListener socketListener = this;
                    synchronized (socketListener) {
                        MahaloSocket.this._MulticastSocket.receive(packet);
                    }
                    if (MahaloSocket.this.shouldIgnorePacket(packet)) continue;
                    ByteBuffer buffer = ByteBuffer.wrap(packet.getData(), packet.getOffset(), packet.getLength());
                    DNSPacket dnsMessage = DNSPacket.Parse(buffer);
                    if (dnsMessage.isQuery()) {
                        MahaloSocket.this.onQuery(dnsMessage, packet.getAddress(), packet.getPort());
                        continue;
                    }
                    MahaloSocket.this.onResponse(dnsMessage);
                }
                catch (SocketTimeoutException e) {
                }
                catch (IOException e) {
                    try {
                        MahaloSocket.this.recover();
                    }
                    catch (IOException ioException) {
                        System.err.println("Error on mDNS recovery: " + ioException.getLocalizedMessage());
                        break;
                    }
                }
                catch (BufferUnderflowException bue) {
                    System.err.println("Received an badly formatted mDNS packet, ignoring the rest.");
                }
                catch (IllegalArgumentException iae) {
                    System.err.println("Received an oddly formatted mDNS packet, ignoring the rest.");
                }
            }
            MahaloSocket.this._bContinueRunning = false;
            MahaloSocket.this._ListeningThread = null;
        }
    }
}

