/*
 * Decompiled with CFR 0.152.
 */
package com.github.rjeschke.txtmark;

import com.github.rjeschke.txtmark.HTML;

class Utils {
    private static int RND = (int)System.nanoTime();

    Utils() {
    }

    public static int rnd() {
        RND = RND * 1664525 + 1013904223;
        return RND >>> 22;
    }

    public static int skipSpaces(String string, int n) {
        int n2;
        for (n2 = n; n2 < string.length() && (string.charAt(n2) == ' ' || string.charAt(n2) == '\n'); ++n2) {
        }
        return n2 < string.length() ? n2 : -1;
    }

    public static int escape(StringBuilder stringBuilder, char c, int n) {
        switch (c) {
            case '!': 
            case '\"': 
            case '#': 
            case '\'': 
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case '-': 
            case '.': 
            case '<': 
            case '>': 
            case '[': 
            case '\\': 
            case ']': 
            case '^': 
            case '_': 
            case '`': 
            case '{': 
            case '}': {
                stringBuilder.append(c);
                return n + 1;
            }
        }
        stringBuilder.append('\\');
        return n;
    }

    public static int readUntil(StringBuilder stringBuilder, String string, int n, char ... cArray) {
        int n2;
        for (n2 = n; n2 < string.length(); ++n2) {
            char c = string.charAt(n2);
            if (c == '\\' && n2 + 1 < string.length()) {
                n2 = Utils.escape(stringBuilder, string.charAt(n2 + 1), n2);
                continue;
            }
            boolean bl = false;
            for (int i = 0; i < cArray.length; ++i) {
                if (c != cArray[i]) continue;
                bl = true;
                break;
            }
            if (bl) break;
            stringBuilder.append(c);
        }
        return n2 == string.length() ? -1 : n2;
    }

    public static int readUntil(StringBuilder stringBuilder, String string, int n, char c) {
        int n2;
        for (n2 = n; n2 < string.length(); ++n2) {
            char c2 = string.charAt(n2);
            if (c2 == '\\' && n2 + 1 < string.length()) {
                n2 = Utils.escape(stringBuilder, string.charAt(n2 + 1), n2);
                continue;
            }
            if (c2 == c) break;
            stringBuilder.append(c2);
        }
        return n2 == string.length() ? -1 : n2;
    }

    public static int readMdLink(StringBuilder stringBuilder, String string, int n) {
        int n2;
        int n3 = 1;
        for (n2 = n; n2 < string.length(); ++n2) {
            char c = string.charAt(n2);
            if (c == '\\' && n2 + 1 < string.length()) {
                n2 = Utils.escape(stringBuilder, string.charAt(n2 + 1), n2);
                continue;
            }
            boolean bl = false;
            switch (c) {
                case '(': {
                    ++n3;
                    break;
                }
                case ' ': {
                    if (n3 != 1) break;
                    bl = true;
                    break;
                }
                case ')': {
                    if (--n3 != 0) break;
                    bl = true;
                }
            }
            if (bl) break;
            stringBuilder.append(c);
        }
        return n2 == string.length() ? -1 : n2;
    }

    public static int readMdLinkId(StringBuilder stringBuilder, String string, int n) {
        int n2;
        int n3 = 1;
        for (n2 = n; n2 < string.length(); ++n2) {
            char c = string.charAt(n2);
            boolean bl = false;
            switch (c) {
                case '\n': {
                    stringBuilder.append(' ');
                    break;
                }
                case '[': {
                    ++n3;
                    stringBuilder.append(c);
                    break;
                }
                case ']': {
                    if (--n3 == 0) {
                        bl = true;
                        break;
                    }
                    stringBuilder.append(c);
                    break;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
            if (bl) break;
        }
        return n2 == string.length() ? -1 : n2;
    }

    public static int readRawUntil(StringBuilder stringBuilder, String string, int n, char ... cArray) {
        int n2;
        for (n2 = n; n2 < string.length(); ++n2) {
            char c = string.charAt(n2);
            boolean bl = false;
            for (int i = 0; i < cArray.length; ++i) {
                if (c != cArray[i]) continue;
                bl = true;
                break;
            }
            if (bl) break;
            stringBuilder.append(c);
        }
        return n2 == string.length() ? -1 : n2;
    }

    public static int readRawUntil(StringBuilder stringBuilder, String string, int n, char c) {
        char c2;
        int n2;
        for (n2 = n; n2 < string.length() && (c2 = string.charAt(n2)) != c; ++n2) {
            stringBuilder.append(c2);
        }
        return n2 == string.length() ? -1 : n2;
    }

    public static void appendCode(StringBuilder stringBuilder, String string, int n, int n2) {
        block5: for (int i = n; i < n2; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '&': {
                    stringBuilder.append("&amp;");
                    continue block5;
                }
                case '<': {
                    stringBuilder.append("&lt;");
                    continue block5;
                }
                case '>': {
                    stringBuilder.append("&gt;");
                    continue block5;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
    }

    public static void appendValue(StringBuilder stringBuilder, String string, int n, int n2) {
        block7: for (int i = n; i < n2; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '&': {
                    stringBuilder.append("&amp;");
                    continue block7;
                }
                case '<': {
                    stringBuilder.append("&lt;");
                    continue block7;
                }
                case '>': {
                    stringBuilder.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    stringBuilder.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    stringBuilder.append("&apos;");
                    continue block7;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
    }

    public static void appendDecEntity(StringBuilder stringBuilder, char c) {
        stringBuilder.append("&#");
        stringBuilder.append((int)c);
        stringBuilder.append(';');
    }

    public static void appendHexEntity(StringBuilder stringBuilder, char c) {
        stringBuilder.append("&#x");
        stringBuilder.append(Integer.toHexString(c));
        stringBuilder.append(';');
    }

    public static void appendMailto(StringBuilder stringBuilder, String string, int n, int n2) {
        block3: for (int i = n; i < n2; ++i) {
            int n3 = Utils.rnd();
            char c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '&': 
                case '\'': 
                case '<': 
                case '>': 
                case '@': {
                    if (n3 < 512) {
                        Utils.appendDecEntity(stringBuilder, c);
                        continue block3;
                    }
                    Utils.appendHexEntity(stringBuilder, c);
                    continue block3;
                }
                default: {
                    if (n3 < 32) {
                        stringBuilder.append(c);
                        continue block3;
                    }
                    if (n3 < 520) {
                        Utils.appendDecEntity(stringBuilder, c);
                        continue block3;
                    }
                    Utils.appendHexEntity(stringBuilder, c);
                }
            }
        }
    }

    public static void getXMLTag(StringBuilder stringBuilder, StringBuilder stringBuilder2) {
        int n = 1;
        if (stringBuilder2.charAt(1) == '/') {
            ++n;
        }
        while (Character.isLetterOrDigit(stringBuilder2.charAt(n))) {
            stringBuilder.append(stringBuilder2.charAt(n++));
        }
    }

    public static void getXMLTag(StringBuilder stringBuilder, String string) {
        int n = 1;
        if (string.charAt(1) == '/') {
            ++n;
        }
        while (Character.isLetterOrDigit(string.charAt(n))) {
            stringBuilder.append(string.charAt(n++));
        }
    }

    public static int readXML(StringBuilder stringBuilder, String string, int n, boolean bl) {
        try {
            int n2;
            boolean bl2;
            if (string.charAt(n + 1) == '/') {
                bl2 = true;
                n2 = n + 2;
            } else {
                if (string.charAt(n + 1) == '!') {
                    stringBuilder.append("<!");
                    return n + 1;
                }
                bl2 = false;
                n2 = n + 1;
            }
            if (bl) {
                StringBuilder stringBuilder2 = new StringBuilder();
                if ((n2 = Utils.readRawUntil(stringBuilder2, string, n2, ' ', '/', '>')) == -1) {
                    return -1;
                }
                String string2 = stringBuilder2.toString().trim().toLowerCase();
                if (HTML.isUnsafeHtmlElement(string2)) {
                    stringBuilder.append("&lt;");
                    if (bl2) {
                        stringBuilder.append('/');
                    }
                    stringBuilder.append((CharSequence)stringBuilder2);
                }
            } else {
                stringBuilder.append('<');
                if (bl2) {
                    stringBuilder.append('/');
                }
                n2 = Utils.readRawUntil(stringBuilder, string, n2, ' ', '/', '>');
            }
            if (n2 == -1) {
                return -1;
            }
            if (string.charAt(n2 = Utils.readRawUntil(stringBuilder, string, n2, '/', '>')) == '/') {
                stringBuilder.append(" /");
                n2 = Utils.readRawUntil(stringBuilder, string, n2 + 1, '>');
                if (n2 == -1) {
                    return -1;
                }
            }
            if (string.charAt(n2) == '>') {
                stringBuilder.append('>');
                return n2;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            return -1;
        }
        return -1;
    }
}

