/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.MathUtils;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractConnection;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Arrows;
import net.sourceforge.plantuml.activitydiagram3.ftile.Connection;
import net.sourceforge.plantuml.activitydiagram3.ftile.ConnectionTranslatable;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileUtils;
import net.sourceforge.plantuml.activitydiagram3.ftile.Snake;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDiamond;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDiamondFoo1;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDiamondInside;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.svek.ConditionStyle;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UEmpty;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FtileWhile2
extends AbstractFtile {
    private final Ftile whileBlock;
    private final Ftile diamond1;
    private final TextBlock supplementarySouthText;

    @Override
    public Set<Swimlane> getSwimlanes() {
        HashSet<Swimlane> hashSet = new HashSet<Swimlane>(this.whileBlock.getSwimlanes());
        hashSet.add(this.getSwimlaneIn());
        return hashSet;
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.diamond1.getSwimlaneIn();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.getSwimlaneIn();
    }

    private FtileWhile2(Ftile ftile, Ftile ftile2, TextBlock textBlock) {
        super(ftile.shadowing());
        this.whileBlock = ftile;
        this.diamond1 = ftile2;
        this.supplementarySouthText = textBlock;
    }

    private static TextBlock createLabel1(Display display, Display display2, UFont uFont, ISkinSimple iSkinSimple) {
        FontConfiguration fontConfiguration = new FontConfiguration(uFont, HtmlColorUtils.BLACK);
        TextBlock textBlock = TextBlockUtils.create(display2, fontConfiguration, HorizontalAlignment.LEFT, iSkinSimple);
        if (display == null) {
            return textBlock;
        }
        return TextBlockUtils.mergeTB(TextBlockUtils.create(display, fontConfiguration, HorizontalAlignment.LEFT, iSkinSimple), textBlock, HorizontalAlignment.CENTER);
    }

    public static Ftile create(Swimlane swimlane, Ftile ftile, Display display, HtmlColor htmlColor, HtmlColor htmlColor2, HtmlColor htmlColor3, Display display2, Display display3, UFont uFont, HtmlColor htmlColor4, LinkRendering linkRendering, FtileFactory ftileFactory, ConditionStyle conditionStyle, UFont uFont2) {
        Ftile ftile2;
        TextBlock textBlock;
        FontConfiguration fontConfiguration = new FontConfiguration(uFont, HtmlColorUtils.BLACK);
        FontConfiguration fontConfiguration2 = new FontConfiguration(uFont2, HtmlColorUtils.BLACK);
        TextBlock textBlock2 = TextBlockUtils.create(display2, fontConfiguration, HorizontalAlignment.LEFT, ftileFactory);
        TextBlock textBlock3 = TextBlockUtils.create(display, fontConfiguration2, HorizontalAlignment.LEFT, ftileFactory);
        TextBlock textBlock4 = TextBlockUtils.create(display3, fontConfiguration, HorizontalAlignment.LEFT, ftileFactory);
        if (conditionStyle == ConditionStyle.INSIDE) {
            textBlock = TextBlockUtils.empty(0.0, 0.0);
            ftile2 = new FtileDiamondInside(ftile.shadowing(), htmlColor2, htmlColor, swimlane, textBlock3).withNorth(textBlock2).withWest(textBlock4);
        } else if (conditionStyle == ConditionStyle.FOO1) {
            textBlock = TextBlockUtils.empty(0.0, 0.0);
            ftile2 = new FtileDiamondFoo1(ftile.shadowing(), htmlColor2, htmlColor, swimlane, textBlock3).withNorth(textBlock2).withWest(textBlock4);
        } else if (conditionStyle == ConditionStyle.DIAMOND) {
            textBlock = FtileWhile2.createLabel1(display, display2, uFont, ftileFactory);
            ftile2 = new FtileDiamond(ftile.shadowing(), htmlColor2, htmlColor, swimlane).withWest(textBlock4).withSouth(textBlock);
        } else {
            throw new IllegalStateException();
        }
        FtileWhile2 ftileWhile2 = new FtileWhile2(ftile, ftile2, textBlock);
        HtmlColor htmlColor5 = htmlColor3;
        if (linkRendering != null && linkRendering.getColor() != null) {
            htmlColor5 = linkRendering.getColor();
        }
        ArrayList<Connection> arrayList = new ArrayList<Connection>();
        FtileWhile2 ftileWhile22 = ftileWhile2;
        ftileWhile22.getClass();
        arrayList.add(ftileWhile22.new ConnectionIn(LinkRendering.getColor(ftile.getInLinkRendering(), htmlColor3)));
        FtileWhile2 ftileWhile23 = ftileWhile2;
        ftileWhile23.getClass();
        arrayList.add(ftileWhile23.new ConnectionBack(htmlColor4));
        FtileWhile2 ftileWhile24 = ftileWhile2;
        ftileWhile24.getClass();
        arrayList.add(ftileWhile24.new ConnectionOut(htmlColor5));
        return FtileUtils.addConnection((Ftile)ftileWhile2, arrayList);
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        uGraphic.apply(this.getTranslateForWhile(stringBounder)).draw(this.whileBlock);
        uGraphic.apply(this.getTranslateDiamond1(stringBounder)).draw(this.diamond1);
    }

    @Override
    public FtileGeometry calculateDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = this.calculateDimensionInternal(stringBounder);
        return new FtileGeometry(dimension2D, dimension2D.getWidth() / 2.0, 0.0, dimension2D.getHeight());
    }

    private Dimension2D calculateDimensionInternal(StringBounder stringBounder) {
        FtileGeometry ftileGeometry = this.diamond1.calculateDimension(stringBounder);
        Dimension2D dimension2D = this.supplementarySouthText.calculateDimension(stringBounder);
        FtileGeometry ftileGeometry2 = this.whileBlock.calculateDimension(stringBounder);
        double d = ((Dimension2D)ftileGeometry).getHeight() + ((Dimension2D)ftileGeometry2).getHeight();
        double d2 = MathUtils.max(((Dimension2D)ftileGeometry).getWidth(), ((Dimension2D)ftileGeometry2).getWidth());
        Dimension2D dimension2D2 = new Dimension2DDouble(d2, d);
        dimension2D2 = Dimension2DDouble.max(dimension2D2, dimension2D);
        return Dimension2DDouble.delta(dimension2D2, 48.0, 96.0);
    }

    @Override
    public UTranslate getTranslateFor(Ftile ftile, StringBounder stringBounder) {
        if (ftile == this.whileBlock) {
            return this.getTranslateForWhile(stringBounder);
        }
        if (ftile == this.diamond1) {
            return this.getTranslateDiamond1(stringBounder);
        }
        throw new UnsupportedOperationException();
    }

    private UTranslate getTranslateForWhile(StringBounder stringBounder) {
        FtileGeometry ftileGeometry = this.diamond1.calculateDimension(stringBounder);
        Dimension2D dimension2D = this.calculateDimensionInternal(stringBounder);
        FtileGeometry ftileGeometry2 = this.whileBlock.calculateDimension(stringBounder);
        double d = ((Dimension2D)ftileGeometry).getHeight() + (dimension2D.getHeight() - ((Dimension2D)ftileGeometry).getHeight() - ((Dimension2D)ftileGeometry2).getHeight()) / 2.0;
        double d2 = (dimension2D.getWidth() - ((Dimension2D)ftileGeometry2).getWidth()) / 2.0;
        return new UTranslate(d2, d);
    }

    private UTranslate getTranslateDiamond1(StringBounder stringBounder) {
        Dimension2D dimension2D = this.calculateDimensionInternal(stringBounder);
        FtileGeometry ftileGeometry = this.diamond1.calculateDimension(stringBounder);
        double d = (dimension2D.getWidth() - ((Dimension2D)ftileGeometry).getWidth()) / 2.0;
        return new UTranslate(d, 0.0);
    }

    @Override
    public boolean isKilled() {
        return false;
    }

    class ConnectionOut
    extends AbstractConnection {
        private final HtmlColor afterEndwhileColor;

        public ConnectionOut(HtmlColor htmlColor) {
            super(FtileWhile2.this.diamond1, null);
            this.afterEndwhileColor = htmlColor;
        }

        private Point2D getP1(StringBounder stringBounder) {
            return FtileWhile2.this.getTranslateDiamond1(stringBounder).getTranslated(new Point2D.Double(0.0, 0.0));
        }

        private Point2D getP2(StringBounder stringBounder) {
            Dimension2D dimension2D = FtileWhile2.this.calculateDimensionInternal(stringBounder);
            return new Point2D.Double(dimension2D.getWidth() / 2.0, dimension2D.getHeight());
        }

        public void drawU(UGraphic uGraphic) {
            StringBounder stringBounder = uGraphic.getStringBounder();
            Snake snake = new Snake(this.afterEndwhileColor);
            FtileGeometry ftileGeometry = FtileWhile2.this.diamond1.calculateDimension(stringBounder);
            Point2D point2D = this.getP1(stringBounder);
            Point2D point2D2 = this.getP2(stringBounder);
            double d = point2D.getX();
            double d2 = point2D.getY() + ((Dimension2D)ftileGeometry).getHeight() / 2.0;
            double d3 = point2D2.getX();
            double d4 = point2D2.getY();
            snake.addPoint(d, d2);
            snake.addPoint(12.0, d2);
            snake.addPoint(12.0, d4);
            uGraphic.draw(snake);
            uGraphic = uGraphic.apply(new UChangeColor(this.afterEndwhileColor)).apply(new UChangeBackColor(this.afterEndwhileColor));
            uGraphic.apply(new UTranslate(12.0, (d2 + d4) / 2.0)).draw(Arrows.asToDown());
            Snake snake2 = new Snake(this.afterEndwhileColor, true);
            snake2.addPoint(12.0, d4);
            snake2.addPoint(d3, d4);
            uGraphic.draw(snake2);
        }
    }

    class ConnectionBack
    extends AbstractConnection
    implements ConnectionTranslatable {
        private final HtmlColor endInlinkColor;

        public ConnectionBack(HtmlColor htmlColor) {
            super(FtileWhile2.this.whileBlock, FtileWhile2.this.diamond1);
            this.endInlinkColor = htmlColor;
        }

        private Point2D getP1(StringBounder stringBounder) {
            FtileGeometry ftileGeometry = FtileWhile2.this.whileBlock.calculateDimension(stringBounder);
            if (!ftileGeometry.hasPointOut()) {
                return null;
            }
            return FtileWhile2.this.getTranslateForWhile(stringBounder).getTranslated(ftileGeometry.getPointOut());
        }

        private Point2D getP2(StringBounder stringBounder) {
            return FtileWhile2.this.getTranslateDiamond1(stringBounder).getTranslated(new Point2D.Double(0.0, 0.0));
        }

        public void drawU(UGraphic uGraphic) {
            StringBounder stringBounder = uGraphic.getStringBounder();
            Snake snake = new Snake(this.endInlinkColor, Arrows.asToLeft());
            Dimension2D dimension2D = FtileWhile2.this.calculateDimensionInternal(stringBounder);
            Point2D point2D = this.getP1(stringBounder);
            if (point2D == null) {
                return;
            }
            Point2D point2D2 = this.getP2(stringBounder);
            FtileGeometry ftileGeometry = FtileWhile2.this.diamond1.calculateDimension(stringBounder);
            double d = point2D.getX();
            double d2 = point2D.getY();
            double d3 = point2D2.getX() + ((Dimension2D)ftileGeometry).getWidth();
            double d4 = point2D2.getY() + ((Dimension2D)ftileGeometry).getHeight() / 2.0;
            snake.addPoint(d, d2);
            snake.addPoint(d, d2 + 12.0);
            double d5 = dimension2D.getWidth() - 12.0;
            snake.addPoint(d5, d2 + 12.0);
            snake.addPoint(d5, d4);
            snake.addPoint(d3, d4);
            uGraphic.draw(snake);
            uGraphic.apply(new UTranslate(d, d2 + 12.0)).draw(new UEmpty(5.0, 12.0));
            uGraphic = uGraphic.apply(new UChangeColor(this.endInlinkColor)).apply(new UChangeBackColor(this.endInlinkColor));
            uGraphic.apply(new UTranslate(d5, (d2 + d4) / 2.0)).draw(Arrows.asToUp());
        }

        public void drawTranslate(UGraphic uGraphic, UTranslate uTranslate, UTranslate uTranslate2) {
            StringBounder stringBounder = uGraphic.getStringBounder();
            Snake snake = new Snake(this.endInlinkColor, Arrows.asToLeft());
            Dimension2D dimension2D = FtileWhile2.this.calculateDimensionInternal(stringBounder);
            Point2D point2D = this.getP1(stringBounder);
            Point2D point2D2 = this.getP2(stringBounder);
            Point2D point2D3 = uTranslate.getTranslated(point2D);
            Point2D point2D4 = uTranslate2.getTranslated(point2D2);
            FtileGeometry ftileGeometry = FtileWhile2.this.diamond1.calculateDimension(stringBounder);
            double d = point2D3.getX();
            double d2 = point2D3.getY();
            double d3 = point2D4.getX() + ((Dimension2D)ftileGeometry).getWidth();
            double d4 = point2D4.getY() + ((Dimension2D)ftileGeometry).getHeight() / 2.0;
            snake.addPoint(d, d2);
            snake.addPoint(d, d2 + 12.0);
            double d5 = Math.max(uTranslate.getDx(), uTranslate2.getDx()) + dimension2D.getWidth() - 12.0;
            snake.addPoint(d5, d2 + 12.0);
            snake.addPoint(d5, d4);
            snake.addPoint(d3, d4);
            uGraphic.draw(snake);
            uGraphic.apply(new UTranslate(d, d2 + 12.0)).draw(new UEmpty(5.0, 12.0));
            uGraphic = uGraphic.apply(new UChangeColor(this.endInlinkColor)).apply(new UChangeBackColor(this.endInlinkColor));
            uGraphic.apply(new UTranslate(d5, (d2 + d4) / 2.0)).draw(Arrows.asToUp());
        }
    }

    class ConnectionIn
    extends AbstractConnection
    implements ConnectionTranslatable {
        private final HtmlColor arrowColor;

        public ConnectionIn(HtmlColor htmlColor) {
            super(FtileWhile2.this.diamond1, FtileWhile2.this.whileBlock);
            this.arrowColor = htmlColor;
        }

        private Point2D getP1(StringBounder stringBounder) {
            return FtileWhile2.this.getTranslateDiamond1(stringBounder).getTranslated(this.getFtile1().calculateDimension(stringBounder).getPointOut());
        }

        private Point2D getP2(StringBounder stringBounder) {
            return FtileWhile2.this.getTranslateForWhile(stringBounder).getTranslated(this.getFtile2().calculateDimension(stringBounder).getPointIn());
        }

        public void drawU(UGraphic uGraphic) {
            StringBounder stringBounder = uGraphic.getStringBounder();
            Snake snake = new Snake(this.arrowColor, Arrows.asToDown());
            snake.addPoint(this.getP1(stringBounder));
            snake.addPoint(this.getP2(stringBounder));
            uGraphic.draw(snake);
        }

        public void drawTranslate(UGraphic uGraphic, UTranslate uTranslate, UTranslate uTranslate2) {
            StringBounder stringBounder = uGraphic.getStringBounder();
            Point2D point2D = this.getP1(stringBounder);
            Point2D point2D2 = this.getP2(stringBounder);
            Snake snake = new Snake(this.arrowColor, Arrows.asToDown());
            Point2D point2D3 = uTranslate.getTranslated(point2D);
            Point2D point2D4 = uTranslate2.getTranslated(point2D2);
            double d = (point2D3.getY() + point2D4.getY()) / 2.0;
            snake.addPoint(point2D3);
            snake.addPoint(point2D3.getX(), d);
            snake.addPoint(point2D4.getX(), d);
            snake.addPoint(point2D4);
            uGraphic.draw(snake);
        }
    }
}

