/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import net.sourceforge.schemaspy.Config;
import net.sourceforge.schemaspy.model.Database;
import net.sourceforge.schemaspy.model.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteTable
extends Table {
    private final String baseSchema;

    public RemoteTable(Database database, String string, String string2, String string3, Properties properties, Pattern pattern, Pattern pattern2) throws SQLException {
        super(database, string, string2, null, properties, pattern, pattern2);
        this.baseSchema = string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectForeignKeys(Map<String, Table> map, Pattern pattern, Pattern pattern2) throws SQLException {
        ResultSet resultSet = null;
        try {
            resultSet = this.db.getMetaData().getImportedKeys(null, this.getSchema(), this.getName());
            while (resultSet.next()) {
                String string = resultSet.getString("PKTABLE_SCHEM");
                if (string == null || !string.equals(this.baseSchema)) continue;
                this.addForeignKey(resultSet.getString("FK_NAME"), resultSet.getString("FKCOLUMN_NAME"), resultSet.getString("PKTABLE_SCHEM"), resultSet.getString("PKTABLE_NAME"), resultSet.getString("PKCOLUMN_NAME"), resultSet.getInt("UPDATE_RULE"), resultSet.getInt("DELETE_RULE"), map, pattern, pattern2);
            }
        }
        catch (SQLException sQLException) {
            if (Config.getInstance().isOneOfMultipleSchemas()) {
                throw sQLException;
            }
            System.err.println("Couldn't resolve foreign keys for remote table " + this.getSchema() + "." + this.getName() + ": " + sQLException);
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
        }
    }

    @Override
    public boolean isRemote() {
        return true;
    }
}

