/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy.view;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.schemaspy.model.Database;
import net.sourceforge.schemaspy.model.TableColumn;
import net.sourceforge.schemaspy.util.Dot;
import net.sourceforge.schemaspy.util.LineWriter;
import net.sourceforge.schemaspy.view.HtmlDiagramFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlRelationshipsPage
extends HtmlDiagramFormatter {
    private static final HtmlRelationshipsPage instance = new HtmlRelationshipsPage();
    private static final boolean fineEnabled = Logger.getLogger(HtmlRelationshipsPage.class.getName()).isLoggable(Level.FINE);

    private HtmlRelationshipsPage() {
    }

    public static HtmlRelationshipsPage getInstance() {
        return instance;
    }

    public boolean write(Database database, File file, String string, boolean bl, boolean bl2, boolean bl3, Set<TableColumn> set, LineWriter lineWriter) {
        File file2 = new File(file, string + ".real.compact.dot");
        File file3 = new File(file, string + ".real.compact.png");
        File file4 = new File(file, string + ".real.large.dot");
        File file5 = new File(file, string + ".real.large.png");
        File file6 = new File(file, string + ".implied.compact.dot");
        File file7 = new File(file, string + ".implied.compact.png");
        File file8 = new File(file, string + ".implied.large.dot");
        File file9 = new File(file, string + ".implied.large.png");
        try {
            Dot dot = this.getDot();
            if (dot == null) {
                this.writeHeader(database, null, "All Relationships", bl, lineWriter);
                lineWriter.writeln("<div class='content'>");
                this.writeInvalidGraphvizInstallation(lineWriter);
                lineWriter.writeln("</div>");
                this.writeFooter(lineWriter);
                return false;
            }
            this.writeHeader(database, "All Relationships", bl, bl2, bl3, lineWriter);
            lineWriter.writeln("<table width=\"100%\"><tr><td class=\"container\">");
            if (bl2) {
                if (!fineEnabled) {
                    System.out.print(".");
                }
                lineWriter.writeln(dot.generateDiagram(file2, file3));
                lineWriter.writeln("  <a name='diagram'><img id='realCompactImg' src='diagrams/summary/" + file3.getName() + "' usemap='#compactRelationshipsDiagram' class='diagram' border='0' alt=''></a>");
                try {
                    if (!fineEnabled) {
                        System.out.print(".");
                    }
                    lineWriter.writeln(dot.generateDiagram(file4, file5));
                    lineWriter.writeln("  <a name='diagram'><img id='realLargeImg' src='diagrams/summary/" + file5.getName() + "' usemap='#largeRelationshipsDiagram' class='diagram' border='0' alt=''></a>");
                }
                catch (Dot.DotFailure dotFailure) {
                    System.err.println("dot failed to generate all of the relationships diagrams:");
                    System.err.println(dotFailure);
                    System.err.println("...but the relationships page may still be usable.");
                }
            }
            try {
                if (bl3) {
                    if (!fineEnabled) {
                        System.out.print(".");
                    }
                    lineWriter.writeln(dot.generateDiagram(file6, file7));
                    lineWriter.writeln("  <a name='diagram'><img id='impliedCompactImg' src='diagrams/summary/" + file7.getName() + "' usemap='#compactImpliedRelationshipsDiagram' class='diagram' border='0' alt=''></a>");
                    if (!fineEnabled) {
                        System.out.print(".");
                    }
                    lineWriter.writeln(dot.generateDiagram(file8, file9));
                    lineWriter.writeln("  <a name='diagram'><img id='impliedLargeImg' src='diagrams/summary/" + file9.getName() + "' usemap='#largeImpliedRelationshipsDiagram' class='diagram' border='0' alt=''></a>");
                }
            }
            catch (Dot.DotFailure dotFailure) {
                System.err.println("dot failed to generate all of the relationships diagrams:");
                System.err.println(dotFailure);
                System.err.println("...but the relationships page may still be usable.");
            }
            if (!fineEnabled) {
                System.out.print(".");
            }
            lineWriter.writeln("</td></tr></table>");
            this.writeExcludedColumns(set, null, lineWriter);
            this.writeFooter(lineWriter);
            return true;
        }
        catch (Dot.DotFailure dotFailure) {
            System.err.println(dotFailure);
            return false;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    private void writeHeader(Database database, String string, boolean bl, boolean bl2, boolean bl3, LineWriter lineWriter) throws IOException {
        this.writeHeader(database, null, string, bl, lineWriter);
        lineWriter.writeln("<table class='container' width='100%'>");
        lineWriter.writeln("<tr><td class='container'>");
        this.writeGeneratedBy(database.getConnectTime(), lineWriter);
        lineWriter.writeln("</td>");
        lineWriter.writeln("<td class='container' align='right' valign='top' rowspan='2'>");
        this.writeLegend(false, lineWriter);
        lineWriter.writeln("</td></tr>");
        if (!bl2) {
            lineWriter.writeln("<tr><td class='container' align='left' valign='top'>");
            if (bl3) {
                lineWriter.writeln("No 'real' Foreign Key relationships were detected in the schema.<br>");
                lineWriter.writeln("Displayed relationships are implied by a column's name/type/size matching another table's primary key.<p>");
            } else {
                lineWriter.writeln("No relationships were detected in the schema.");
            }
            lineWriter.writeln("</td></tr>");
        }
        lineWriter.writeln("<tr><td class='container' align='left' valign='top'>");
        lineWriter.writeln("<form name='options' action=''>");
        if (bl3) {
            lineWriter.write("  <span ");
            if (!bl2) {
                lineWriter.write("style=\"display:none\" ");
            }
            lineWriter.writeln("title=\"Show relationships implied by column name/type/size matching another table's primary key\">");
            lineWriter.write("    <label for='implied'><input type='checkbox' id='implied'" + (bl2 ? "" : " checked") + '>');
            lineWriter.writeln("Implied relationships</label>");
            lineWriter.writeln("  </span>");
        }
        if (bl2 || bl3) {
            lineWriter.writeln("  <span title=\"By default only columns that are primary keys, foreign keys or indexes are shown\">");
            lineWriter.write("    <label for='showNonKeys'><input type='checkbox' id='showNonKeys'>");
            lineWriter.writeln("All columns</label>");
            lineWriter.writeln("  </span>");
        }
        lineWriter.writeln("</form>");
        lineWriter.writeln("</td></tr></table>");
    }

    @Override
    protected boolean isRelationshipsPage() {
        return true;
    }
}

