/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy.model;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.schemaspy.Config;
import net.sourceforge.schemaspy.model.ExplicitRemoteTable;
import net.sourceforge.schemaspy.model.InvalidConfigurationException;
import net.sourceforge.schemaspy.model.RemoteTable;
import net.sourceforge.schemaspy.model.Table;
import net.sourceforge.schemaspy.model.TableColumn;
import net.sourceforge.schemaspy.model.TableIndex;
import net.sourceforge.schemaspy.model.View;
import net.sourceforge.schemaspy.model.xml.SchemaMeta;
import net.sourceforge.schemaspy.model.xml.TableMeta;
import net.sourceforge.schemaspy.util.CaseInsensitiveMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Database {
    private final String databaseName;
    private final String schema;
    private String description;
    private final Map<String, Table> tables = new CaseInsensitiveMap<Table>();
    private final Map<String, View> views = new CaseInsensitiveMap<View>();
    private final Map<String, Table> remoteTables = new CaseInsensitiveMap<Table>();
    private final DatabaseMetaData meta;
    private final Connection connection;
    private final String connectTime = new SimpleDateFormat("EEE MMM dd HH:mm z yyyy").format(new Date());
    private Set<String> sqlKeywords;
    private Pattern invalidIdentifierPattern;
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final boolean fineEnabled = this.logger.isLoggable(Level.FINE);

    public Database(Config config, Connection connection, DatabaseMetaData databaseMetaData, String string, String string2, Properties properties, SchemaMeta schemaMeta) throws SQLException, MissingResourceException {
        this.connection = connection;
        this.meta = databaseMetaData;
        this.databaseName = string;
        this.schema = string2;
        this.description = config.getDescription();
        this.initTables(databaseMetaData, properties, config);
        if (config.isViewsEnabled()) {
            this.initViews(databaseMetaData, properties, config);
        }
        this.initCheckConstraints(properties);
        this.initTableIds(properties);
        this.initIndexIds(properties);
        this.initTableComments(properties);
        this.initTableColumnComments(properties);
        this.initViewComments(properties);
        this.initViewColumnComments(properties);
        this.connectTables();
        this.updateFromXmlMetadata(schemaMeta);
    }

    public String getName() {
        return this.databaseName;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getDescription() {
        return this.description;
    }

    public Collection<Table> getTables() {
        return this.tables.values();
    }

    public Map<String, Table> getTablesByName() {
        return this.tables;
    }

    public Collection<View> getViews() {
        return this.views.values();
    }

    public Collection<Table> getRemoteTables() {
        return this.remoteTables.values();
    }

    public Connection getConnection() {
        return this.connection;
    }

    public DatabaseMetaData getMetaData() {
        return this.meta;
    }

    public String getConnectTime() {
        return this.connectTime;
    }

    public String getDatabaseProduct() {
        try {
            return this.meta.getDatabaseProductName() + " - " + this.meta.getDatabaseProductVersion();
        }
        catch (SQLException sQLException) {
            return "";
        }
    }

    private void initTables(DatabaseMetaData databaseMetaData, Properties properties, Config config) throws SQLException {
        TableCreator tableCreator;
        Pattern pattern = config.getTableInclusions();
        Pattern pattern2 = config.getTableExclusions();
        int n = config.getMaxDbThreads();
        String[] stringArray = this.getTypes("tableTypes", "TABLE", properties);
        NameValidator nameValidator = new NameValidator("table", pattern, pattern2, stringArray);
        List<BasicTableMeta> list = this.getBasicTableMeta(databaseMetaData, true, properties, stringArray);
        if (n == 1) {
            tableCreator = new TableCreator();
        } else {
            tableCreator = new ThreadedTableCreator(n);
            while (!list.isEmpty()) {
                BasicTableMeta basicTableMeta = list.remove(0);
                if (!nameValidator.isValid(basicTableMeta.name, basicTableMeta.type)) continue;
                new TableCreator().create(basicTableMeta, properties);
                break;
            }
        }
        for (BasicTableMeta basicTableMeta : list) {
            if (!nameValidator.isValid(basicTableMeta.name, basicTableMeta.type)) continue;
            tableCreator.create(basicTableMeta, properties);
        }
        tableCreator.join();
    }

    private void initViews(DatabaseMetaData databaseMetaData, Properties properties, Config config) throws SQLException {
        Pattern pattern = config.getTableInclusions();
        Pattern pattern2 = config.getTableExclusions();
        Pattern pattern3 = config.getColumnExclusions();
        Pattern pattern4 = config.getIndirectColumnExclusions();
        String[] stringArray = this.getTypes("viewTypes", "VIEW", properties);
        NameValidator nameValidator = new NameValidator("view", pattern, pattern2, stringArray);
        for (BasicTableMeta basicTableMeta : this.getBasicTableMeta(databaseMetaData, false, properties, stringArray)) {
            if (!nameValidator.isValid(basicTableMeta.name, basicTableMeta.type)) continue;
            View view = new View(this, basicTableMeta.schema, basicTableMeta.name, basicTableMeta.remarks, basicTableMeta.viewSql, properties, pattern4, pattern3);
            this.views.put(view.getName(), view);
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Found details of view " + view.getName());
                continue;
            }
            System.out.print('.');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<BasicTableMeta> getBasicTableMeta(DatabaseMetaData databaseMetaData, boolean bl, Properties properties, String ... stringArray) throws SQLException {
        String string;
        String string2;
        Object object;
        String string3;
        String string4 = bl ? "selectTablesSql" : "selectViewsSql";
        String string5 = properties.getProperty(string4);
        ArrayList<BasicTableMeta> arrayList = new ArrayList<BasicTableMeta>();
        ResultSet resultSet = null;
        if (string5 != null) {
            string3 = bl ? "table" : "view";
            object = null;
            try {
                object = this.prepareStatement(string5, null);
                resultSet = object.executeQuery();
                while (resultSet.next()) {
                    string2 = resultSet.getString(string3 + "_name");
                    string = this.getOptionalString(resultSet, string3 + "_schema");
                    if (string == null) {
                        string = this.schema;
                    }
                    String string6 = this.getOptionalString(resultSet, string3 + "_comment");
                    String string7 = bl ? null : this.getOptionalString(resultSet, "view_definition");
                    String string8 = bl ? this.getOptionalString(resultSet, "table_rows") : null;
                    int n = string8 == null ? -1 : Integer.parseInt(string8);
                    arrayList.add(new BasicTableMeta(string, string2, string3, string6, string7, n));
                }
            }
            catch (SQLException sQLException) {
                System.out.flush();
                System.err.println();
                System.err.println("Failed to retrieve " + string3 + " names with custom SQL: " + sQLException);
                System.err.println(string5);
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (object != null) {
                    object.close();
                }
            }
        }
        if (arrayList.isEmpty()) {
            resultSet = databaseMetaData.getTables(null, this.schema, "%", stringArray);
            try {
                while (resultSet.next()) {
                    string3 = resultSet.getString("TABLE_NAME");
                    object = resultSet.getString("TABLE_TYPE");
                    string2 = resultSet.getString("TABLE_SCHEM");
                    string = this.getOptionalString(resultSet, "REMARKS");
                    arrayList.add(new BasicTableMeta(string2, string3, (String)object, string, null, -1));
                }
            }
            catch (SQLException sQLException) {
                if (bl) {
                    throw sQLException;
                }
                System.out.flush();
                System.err.println();
                System.err.println("Ignoring view " + resultSet.getString("TABLE_NAME") + " due to exception:");
                sQLException.printStackTrace();
                System.err.println("Continuing analysis.");
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
        return arrayList;
    }

    private String[] getTypes(String string, String string2, Properties properties) {
        String string3 = properties.getProperty(string, string2);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string4 : string3.split(",")) {
            if ((string4 = string4.trim()).length() <= 0) continue;
            arrayList.add(string4);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String getOptionalString(ResultSet resultSet, String string) {
        try {
            return resultSet.getString(string);
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initCheckConstraints(Properties properties) throws SQLException {
        String string = properties.getProperty("selectCheckConstraintsSql");
        if (string != null) {
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            try {
                preparedStatement = this.prepareStatement(string, null);
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    String string2 = resultSet.getString("table_name");
                    Table table = this.tables.get(string2);
                    if (table == null) continue;
                    table.addCheckConstraint(resultSet.getString("constraint_name"), resultSet.getString("text"));
                }
            }
            catch (SQLException sQLException) {
                System.err.println();
                System.err.println("Failed to retrieve check constraints: " + sQLException);
                System.err.println(string);
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
        }
    }

    private void initTableIds(Properties properties) throws SQLException {
        String string = properties.getProperty("selectTableIdsSql");
        if (string != null) {
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            try {
                preparedStatement = this.prepareStatement(string, null);
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    String string2 = resultSet.getString("table_name");
                    Table table = this.tables.get(string2);
                    if (table == null) continue;
                    table.setId(resultSet.getObject("table_id"));
                }
            }
            catch (SQLException sQLException) {
                System.err.println();
                System.err.println(string);
                throw sQLException;
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
        }
    }

    private void initIndexIds(Properties properties) throws SQLException {
        String string = properties.getProperty("selectIndexIdsSql");
        if (string != null) {
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            try {
                preparedStatement = this.prepareStatement(string, null);
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    TableIndex tableIndex;
                    String string2 = resultSet.getString("table_name");
                    Table table = this.tables.get(string2);
                    if (table == null || (tableIndex = table.getIndex(resultSet.getString("index_name"))) == null) continue;
                    tableIndex.setId(resultSet.getObject("index_id"));
                }
            }
            catch (SQLException sQLException) {
                System.err.println();
                System.err.println(string);
                throw sQLException;
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initTableComments(Properties properties) throws SQLException {
        String string = properties.getProperty("selectTableCommentsSql");
        if (string != null) {
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            try {
                preparedStatement = this.prepareStatement(string, null);
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    String string2 = resultSet.getString("table_name");
                    Table table = this.tables.get(string2);
                    if (table == null) {
                        table = this.views.get(string2);
                    }
                    if (table == null) continue;
                    table.setComments(resultSet.getString("comments"));
                }
            }
            catch (SQLException sQLException) {
                System.err.println();
                System.err.println("Failed to retrieve table/view comments: " + sQLException);
                System.err.println(string);
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initViewComments(Properties properties) throws SQLException {
        String string = properties.getProperty("selectViewCommentsSql");
        if (string != null) {
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            try {
                preparedStatement = this.prepareStatement(string, null);
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    Table table;
                    String string2 = resultSet.getString("view_name");
                    if (string2 == null) {
                        string2 = resultSet.getString("table_name");
                    }
                    if ((table = (Table)this.views.get(string2)) == null) continue;
                    table.setComments(resultSet.getString("comments"));
                }
            }
            catch (SQLException sQLException) {
                System.err.println();
                System.err.println("Failed to retrieve table/view comments: " + sQLException);
                System.err.println(string);
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initTableColumnComments(Properties properties) throws SQLException {
        String string = properties.getProperty("selectColumnCommentsSql");
        if (string != null) {
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            try {
                preparedStatement = this.prepareStatement(string, null);
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    TableColumn tableColumn;
                    String string2 = resultSet.getString("table_name");
                    Table table = this.tables.get(string2);
                    if (table == null) {
                        table = this.views.get(string2);
                    }
                    if (table == null || (tableColumn = table.getColumn(resultSet.getString("column_name"))) == null) continue;
                    tableColumn.setComments(resultSet.getString("comments"));
                }
            }
            catch (SQLException sQLException) {
                System.err.println();
                System.err.println("Failed to retrieve column comments: " + sQLException);
                System.err.println(string);
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initViewColumnComments(Properties properties) throws SQLException {
        String string = properties.getProperty("selectViewColumnCommentsSql");
        if (string != null) {
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            try {
                preparedStatement = this.prepareStatement(string, null);
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    TableColumn tableColumn;
                    Table table;
                    String string2 = resultSet.getString("view_name");
                    if (string2 == null) {
                        string2 = resultSet.getString("table_name");
                    }
                    if ((table = (Table)this.views.get(string2)) == null || (tableColumn = table.getColumn(resultSet.getString("column_name"))) == null) continue;
                    tableColumn.setComments(resultSet.getString("comments"));
                }
            }
            catch (SQLException sQLException) {
                System.err.println();
                System.err.println("Failed to retrieve view column comments: " + sQLException);
                System.err.println(string);
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
        }
    }

    public PreparedStatement prepareStatement(String string, String string2) throws SQLException {
        StringBuilder stringBuilder = new StringBuilder(string);
        List<String> list = this.getSqlParams(stringBuilder, string2);
        PreparedStatement preparedStatement = this.getConnection().prepareStatement(stringBuilder.toString());
        try {
            for (int i = 0; i < list.size(); ++i) {
                preparedStatement.setString(i + 1, list.get(i).toString());
            }
        }
        catch (SQLException sQLException) {
            preparedStatement.close();
            throw sQLException;
        }
        return preparedStatement;
    }

    public Table addRemoteTable(String string, String string2, String string3, Properties properties, Pattern pattern, Pattern pattern2) throws SQLException {
        String string4 = string + "." + string2;
        Table table = this.remoteTables.get(string4);
        if (table == null) {
            table = properties != null ? new RemoteTable(this, string, string2, string3, properties, pattern, pattern2) : new ExplicitRemoteTable(this, string, string2, string3);
            this.logger.fine("Adding remote table " + string4);
            table.connectForeignKeys(this.tables, pattern, pattern2);
            this.remoteTables.put(string4, table);
        }
        return table;
    }

    public Set<String> getSqlKeywords() throws SQLException {
        if (this.sqlKeywords == null) {
            String[] stringArray = "ADA| C | CATALOG_NAME | CHARACTER_SET_CATALOG | CHARACTER_SET_NAME| CHARACTER_SET_SCHEMA | CLASS_ORIGIN | COBOL | COLLATION_CATALOG| COLLATION_NAME | COLLATION_SCHEMA | COLUMN_NAME | COMMAND_FUNCTION | COMMITTED| CONDITION_NUMBER | CONNECTION_NAME | CONSTRAINT_CATALOG | CONSTRAINT_NAME| CONSTRAINT_SCHEMA | CURSOR_NAME| DATA | DATETIME_INTERVAL_CODE | DATETIME_INTERVAL_PRECISION | DYNAMIC_FUNCTION| FORTRAN| LENGTH| MESSAGE_LENGTH | MESSAGE_OCTET_LENGTH | MESSAGE_TEXT | MORE | MUMPS| NAME | NULLABLE | NUMBER| PASCAL | PLI| REPEATABLE | RETURNED_LENGTH | RETURNED_OCTET_LENGTH | RETURNED_SQLSTATE| ROW_COUNT| SCALE | SCHEMA_NAME | SERIALIZABLE | SERVER_NAME | SUBCLASS_ORIGIN| TABLE_NAME | TYPE| UNCOMMITTED | UNNAMED| ABSOLUTE | ACTION | ADD | ALL | ALLOCATE | ALTER | AND| ANY | ARE | AS | ASC| ASSERTION | AT | AUTHORIZATION | AVG| BEGIN | BETWEEN | BIT | BIT_LENGTH | BOTH | BY| CASCADE | CASCADED | CASE | CAST | CATALOG | CHAR | CHARACTER | CHAR_LENGTH| CHARACTER_LENGTH | CHECK | CLOSE | COALESCE | COLLATE | COLLATION| COLUMN | COMMIT | CONNECT | CONNECTION | CONSTRAINT| CONSTRAINTS | CONTINUE| CONVERT | CORRESPONDING | COUNT | CREATE | CROSS | CURRENT| CURRENT_DATE | CURRENT_TIME | CURRENT_TIMESTAMP | CURRENT_USER | CURSOR| DATE | DAY | DEALLOCATE | DEC | DECIMAL | DECLARE | DEFAULT | DEFERRABLE| DEFERRED | DELETE | DESC | DESCRIBE | DESCRIPTOR | DIAGNOSTICS| DISCONNECT | DISTINCT | DOMAIN | DOUBLE | DROP| ELSE | END | END-EXEC | ESCAPE | EXCEPT | EXCEPTION| EXEC | EXECUTE | EXISTS| EXTERNAL | EXTRACT| FALSE | FETCH | FIRST | FLOAT | FOR | FOREIGN | FOUND | FROM | FULL| GET | GLOBAL | GO | GOTO | GRANT | GROUP| HAVING | HOUR| IDENTITY | IMMEDIATE | IN | INDICATOR | INITIALLY | INNER | INPUT| INSENSITIVE | INSERT | INT | INTEGER | INTERSECT | INTERVAL | INTO | IS| ISOLATION| JOIN| KEY| LANGUAGE | LAST | LEADING | LEFT | LEVEL | LIKE | LOCAL | LOWER| MATCH | MAX | MIN | MINUTE | MODULE | MONTH| NAMES | NATIONAL | NATURAL | NCHAR | NEXT | NO | NOT | NULL| NULLIF | NUMERIC| OCTET_LENGTH | OF | ON | ONLY | OPEN | OPTION | OR| ORDER | OUTER| OUTPUT | OVERLAPS| PAD | PARTIAL | POSITION | PRECISION | PREPARE | PRESERVE | PRIMARY| PRIOR | PRIVILEGES | PROCEDURE | PUBLIC| READ | REAL | REFERENCES | RELATIVE | RESTRICT | REVOKE | RIGHT| ROLLBACK | ROWS| SCHEMA | SCROLL | SECOND | SECTION | SELECT | SESSION | SESSION_USER | SET| SIZE | SMALLINT | SOME | SPACE | SQL | SQLCODE | SQLERROR | SQLSTATE| SUBSTRING | SUM | SYSTEM_USER| TABLE | TEMPORARY | THEN | TIME | TIMESTAMP | TIMEZONE_HOUR | TIMEZONE_MINUTE| TO | TRAILING | TRANSACTION | TRANSLATE | TRANSLATION | TRIM | TRUE| UNION | UNIQUE | UNKNOWN | UPDATE | UPPER | USAGE | USER | USING| VALUE | VALUES | VARCHAR | VARYING | VIEW| WHEN | WHENEVER | WHERE | WITH | WORK | WRITE| YEAR| ZONE".split("|,\\s*");
            String[] stringArray2 = this.getMetaData().getSQLKeywords().toUpperCase().split(",\\s*");
            this.sqlKeywords = new HashSet<String>();
            this.sqlKeywords.addAll(Arrays.asList(stringArray));
            this.sqlKeywords.addAll(Arrays.asList(stringArray2));
        }
        return this.sqlKeywords;
    }

    public String getQuotedIdentifier(String string) throws SQLException {
        boolean bl;
        Matcher matcher = this.getInvalidIdentifierPattern().matcher(string);
        boolean bl2 = bl = matcher.find() || this.getSqlKeywords().contains(string.toUpperCase());
        if (bl) {
            String string2 = this.getMetaData().getIdentifierQuoteString().trim();
            return string2 + string + string2;
        }
        return string;
    }

    private Pattern getInvalidIdentifierPattern() throws SQLException {
        if (this.invalidIdentifierPattern == null) {
            String string = "a-zA-Z0-9_";
            String string2 = "-&^";
            String string3 = this.getMetaData().getExtraNameCharacters();
            for (int i = 0; i < string3.length(); ++i) {
                char c = string3.charAt(i);
                if (string2.indexOf(c) >= 0) {
                    string = string + "\\";
                }
                string = string + c;
            }
            this.invalidIdentifierPattern = Pattern.compile("[^" + string + "]");
        }
        return this.invalidIdentifierPattern;
    }

    private List<String> getSqlParams(StringBuilder stringBuilder, String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string2 = this.getSchema();
        if (string2 == null) {
            string2 = this.getName();
        }
        hashMap.put(":schema", string2);
        hashMap.put(":owner", string2);
        if (string != null) {
            hashMap.put(":table", string);
            hashMap.put(":view", string);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = stringBuilder.indexOf(":");
        while (n != -1) {
            String string3 = new StringTokenizer(stringBuilder.substring(n), " ,\"')").nextToken();
            String string4 = (String)hashMap.get(string3);
            if (string4 == null) {
                throw new InvalidConfigurationException("Unexpected named parameter '" + string3 + "' found in SQL '" + stringBuilder + "'");
            }
            arrayList.add(string4);
            stringBuilder.replace(n, n + string3.length(), "?");
            n = stringBuilder.indexOf(":", n);
        }
        return arrayList;
    }

    private void updateFromXmlMetadata(SchemaMeta schemaMeta) throws SQLException {
        if (schemaMeta != null) {
            Table table;
            Pattern pattern = Pattern.compile("[^.]");
            Properties properties = new Properties();
            this.description = schemaMeta.getComments();
            for (TableMeta tableMeta : schemaMeta.getTables()) {
                if (tableMeta.getRemoteSchema() != null) {
                    table = this.remoteTables.get(tableMeta.getRemoteSchema() + '.' + tableMeta.getName());
                    if (table == null) {
                        table = this.addRemoteTable(tableMeta.getRemoteSchema(), tableMeta.getName(), this.getSchema(), null, pattern, pattern);
                    }
                } else {
                    table = this.tables.get(tableMeta.getName());
                    if (table == null) {
                        table = this.views.get(tableMeta.getName());
                    }
                    if (table == null) {
                        table = new Table(this, this.getSchema(), tableMeta.getName(), null, properties, pattern, pattern);
                        this.tables.put(table.getName(), table);
                    }
                }
                table.update(tableMeta);
            }
            for (TableMeta tableMeta : schemaMeta.getTables()) {
                if (tableMeta.getRemoteSchema() != null) {
                    table = this.remoteTables.get(tableMeta.getRemoteSchema() + '.' + tableMeta.getName());
                } else {
                    table = this.tables.get(tableMeta.getName());
                    if (table == null) {
                        table = this.views.get(tableMeta.getName());
                    }
                }
                table.connect(tableMeta, this.tables, this.remoteTables);
            }
        }
    }

    private void connectTables() throws SQLException {
        Pattern pattern = Config.getInstance().getColumnExclusions();
        Pattern pattern2 = Config.getInstance().getIndirectColumnExclusions();
        for (Table table : this.tables.values()) {
            table.connectForeignKeys(this.tables, pattern2, pattern);
        }
    }

    private class ThreadedTableCreator
    extends TableCreator {
        private final Set<Thread> threads;
        private final int maxThreads;

        ThreadedTableCreator(int n) {
            this.threads = new HashSet<Thread>();
            this.maxThreads = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void create(final BasicTableMeta basicTableMeta, final Properties properties) throws SQLException {
            Thread thread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        ThreadedTableCreator.this.createImpl(basicTableMeta, properties);
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                    }
                    finally {
                        Set set = ThreadedTableCreator.this.threads;
                        synchronized (set) {
                            ThreadedTableCreator.this.threads.remove(this);
                            ThreadedTableCreator.this.threads.notify();
                        }
                    }
                }
            };
            Set<Thread> set = this.threads;
            synchronized (set) {
                while (this.threads.size() >= this.maxThreads) {
                    try {
                        this.threads.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.threads.add(thread);
            }
            thread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void join() {
            while (true) {
                Thread thread;
                Set<Thread> set = this.threads;
                synchronized (set) {
                    Iterator<Thread> iterator = this.threads.iterator();
                    if (!iterator.hasNext()) {
                        break;
                    }
                    thread = iterator.next();
                }
                try {
                    thread.join();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private class TableCreator {
        private final Pattern excludeColumns = Config.getInstance().getColumnExclusions();
        private final Pattern excludeIndirectColumns = Config.getInstance().getIndirectColumnExclusions();

        private TableCreator() {
        }

        void create(BasicTableMeta basicTableMeta, Properties properties) throws SQLException {
            this.createImpl(basicTableMeta, properties);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void createImpl(BasicTableMeta basicTableMeta, Properties properties) throws SQLException {
            Table table = new Table(Database.this, basicTableMeta.schema, basicTableMeta.name, basicTableMeta.remarks, properties, this.excludeIndirectColumns, this.excludeColumns);
            if (basicTableMeta.numRows != -1) {
                table.setNumRows(basicTableMeta.numRows);
            }
            Map map = Database.this.tables;
            synchronized (map) {
                Database.this.tables.put(table.getName(), table);
            }
            if (Database.this.logger.isLoggable(Level.FINE)) {
                Database.this.logger.fine("Found details of table " + table.getName());
            } else {
                System.out.print('.');
            }
        }

        void join() {
        }
    }

    private class BasicTableMeta {
        final String schema;
        final String name;
        final String type;
        final String remarks;
        final String viewSql;
        final int numRows;

        BasicTableMeta(String string, String string2, String string3, String string4, String string5, int n) {
            this.schema = string;
            this.name = string2;
            this.type = string3;
            this.remarks = string4;
            this.viewSql = string5;
            this.numRows = n;
        }
    }

    class NameValidator {
        private final String clazz;
        private final Pattern include;
        private final Pattern exclude;
        private final Set<String> validTypes;

        NameValidator(String string, Pattern pattern, Pattern pattern2, String[] stringArray) {
            this.clazz = string;
            this.include = pattern;
            this.exclude = pattern2;
            this.validTypes = new HashSet<String>();
            for (String string2 : stringArray) {
                this.validTypes.add(string2.toUpperCase());
            }
        }

        boolean isValid(String string, String string2) {
            if (!this.validTypes.contains(string2.toUpperCase())) {
                return false;
            }
            if (string.indexOf("$") != -1) {
                if (Database.this.fineEnabled) {
                    Database.this.logger.fine("Excluding " + this.clazz + " " + string + ": embedded $ implies illegal name");
                }
                return false;
            }
            if (this.exclude.matcher(string).matches()) {
                if (Database.this.fineEnabled) {
                    Database.this.logger.fine("Excluding " + this.clazz + " " + string + ": matches exclusion pattern \"" + this.exclude + '\"');
                }
                return false;
            }
            boolean bl = this.include.matcher(string).matches();
            if (Database.this.fineEnabled) {
                if (bl) {
                    Database.this.logger.fine("Including " + this.clazz + " " + string + ": matches inclusion pattern \"" + this.include + '\"');
                } else {
                    Database.this.logger.fine("Excluding " + this.clazz + " " + string + ": doesn't match inclusion pattern \"" + this.include + '\"');
                }
            }
            return bl;
        }
    }
}

