/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy.view;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import net.sourceforge.schemaspy.model.Database;
import net.sourceforge.schemaspy.model.Table;
import net.sourceforge.schemaspy.model.TableColumn;
import net.sourceforge.schemaspy.model.TableIndex;
import net.sourceforge.schemaspy.util.LineWriter;
import net.sourceforge.schemaspy.view.HtmlFormatter;
import net.sourceforge.schemaspy.view.HtmlTablePage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlColumnsPage
extends HtmlFormatter {
    private static HtmlColumnsPage instance = new HtmlColumnsPage();

    private HtmlColumnsPage() {
    }

    public static HtmlColumnsPage getInstance() {
        return instance;
    }

    public List<ColumnInfo> getColumnInfos() {
        ArrayList<ColumnInfo> arrayList = new ArrayList<ColumnInfo>();
        arrayList.add(new ColumnInfo("Table", new ByTableComparator()));
        arrayList.add(new ColumnInfo("Column", new ByColumnComparator()));
        arrayList.add(new ColumnInfo("Type", new ByTypeComparator()));
        arrayList.add(new ColumnInfo("Size", new BySizeComparator()));
        arrayList.add(new ColumnInfo("Nulls", new ByNullableComparator()));
        arrayList.add(new ColumnInfo("Auto", new ByAutoUpdateComparator()));
        arrayList.add(new ColumnInfo("Default", new ByDefaultValueComparator()));
        return arrayList;
    }

    public void write(Database database, Collection<Table> collection, ColumnInfo columnInfo, boolean bl, LineWriter lineWriter) throws IOException {
        TreeSet<TableColumn> treeSet = new TreeSet<TableColumn>(columnInfo.getComparator());
        HashSet<TableColumn> hashSet = new HashSet<TableColumn>();
        HashSet<TableColumn> hashSet2 = new HashSet<TableColumn>();
        for (Table object : collection) {
            treeSet.addAll(object.getColumns());
            hashSet.addAll(object.getPrimaryColumns());
            for (TableIndex tableIndex : object.getIndexes()) {
                hashSet2.addAll(tableIndex.getColumns());
            }
        }
        this.writeHeader(database, treeSet.size(), bl, columnInfo, lineWriter);
        HtmlTablePage htmlTablePage = HtmlTablePage.getInstance();
        for (TableColumn tableColumn : treeSet) {
            htmlTablePage.writeColumn(tableColumn, tableColumn.getTable().getName(), hashSet, hashSet2, true, false, lineWriter);
        }
        this.writeFooter(lineWriter);
    }

    private void writeHeader(Database database, int n, boolean bl, ColumnInfo columnInfo, LineWriter lineWriter) throws IOException {
        this.writeHeader(database, null, "Columns", bl, lineWriter);
        lineWriter.writeln("<table width='100%' border='0'>");
        lineWriter.writeln("<tr><td class='container'>");
        this.writeGeneratedBy(database.getConnectTime(), lineWriter);
        lineWriter.writeln("</td><td class='container' rowspan='2' align='right' valign='top'>");
        this.writeLegend(false, false, lineWriter);
        lineWriter.writeln("</td></tr>");
        lineWriter.writeln("<tr valign='top'><td class='container' align='left' valign='top'>");
        lineWriter.writeln("<p>");
        lineWriter.writeln("<form name='options' action=''>");
        lineWriter.writeln(" <label for='showComments'><input type=checkbox id='showComments'>Comments</label>");
        lineWriter.writeln(" <label for='showLegend'><input type=checkbox checked id='showLegend'>Legend</label>");
        lineWriter.writeln("</form>");
        lineWriter.writeln("</table>");
        lineWriter.writeln("<div class='indent'>");
        lineWriter.write("<b>");
        lineWriter.write(database.getName());
        if (database.getSchema() != null) {
            lineWriter.write(46);
            lineWriter.write(database.getSchema());
        }
        lineWriter.write(" contains ");
        lineWriter.write(String.valueOf(n));
        lineWriter.write(" columns</b> - click on heading to sort:");
        Collection<Table> collection = database.getTables();
        boolean bl2 = collection.size() > 0 && collection.iterator().next().getId() != null;
        this.writeMainTableHeader(bl2, columnInfo, lineWriter);
        lineWriter.writeln("<tbody valign='top'>");
    }

    public void writeMainTableHeader(boolean bl, ColumnInfo columnInfo, LineWriter lineWriter) throws IOException {
        boolean bl2 = columnInfo != null;
        lineWriter.writeln("<a name='columns'></a>");
        lineWriter.writeln("<table id='columns' class='dataTable' border='1' rules='groups'>");
        int n = 6;
        if (bl && !bl2) {
            ++n;
        }
        n = bl2 ? ++n : (n += 2);
        for (int i = 0; i < n; ++i) {
            lineWriter.writeln("<colgroup>");
        }
        lineWriter.writeln("<colgroup class='comment'>");
        lineWriter.writeln("<thead align='left'>");
        lineWriter.writeln("<tr>");
        if (bl && !bl2) {
            lineWriter.writeln(this.getTH(columnInfo, "ID", null, "right"));
        }
        if (bl2) {
            lineWriter.writeln(this.getTH(columnInfo, "Table", null, null));
        }
        lineWriter.writeln(this.getTH(columnInfo, "Column", null, null));
        lineWriter.writeln(this.getTH(columnInfo, "Type", null, null));
        lineWriter.writeln(this.getTH(columnInfo, "Size", null, null));
        lineWriter.writeln(this.getTH(columnInfo, "Nulls", "Are nulls allowed?", null));
        lineWriter.writeln(this.getTH(columnInfo, "Auto", "Is column automatically updated?", null));
        lineWriter.writeln(this.getTH(columnInfo, "Default", "Default value", null));
        if (!bl2) {
            lineWriter.write("  <th title='Columns in tables that reference this column'>");
            lineWriter.writeln("<span class='notSortedByColumn'>Children</span></th>");
            lineWriter.write("  <th title='Columns in tables that are referenced by this column'>");
            lineWriter.writeln("<span class='notSortedByColumn'>Parents</span></th>");
        }
        lineWriter.writeln("  <th title='Comments' class='comment'><span class='notSortedByColumn'>Comments</span></th>");
        lineWriter.writeln("</tr>");
        lineWriter.writeln("</thead>");
    }

    private String getTH(ColumnInfo columnInfo, String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder("  <th");
        if (string3 != null) {
            stringBuilder.append(" align='");
            stringBuilder.append(string3);
            stringBuilder.append("'");
        }
        if (string2 != null) {
            stringBuilder.append(" title='");
            stringBuilder.append(string2);
            stringBuilder.append("'");
        }
        if (columnInfo != null) {
            if (columnInfo.getColumnName().equals(string)) {
                stringBuilder.append(" class='sortedByColumn'>");
                stringBuilder.append(string);
            } else {
                stringBuilder.append(" class='notSortedByColumn'>");
                stringBuilder.append("<a href='");
                stringBuilder.append(columnInfo.getLocation(string));
                stringBuilder.append("#columns'><span class='notSortedByColumn'>");
                stringBuilder.append(string);
                stringBuilder.append("</span></a>");
            }
        } else {
            stringBuilder.append('>');
            stringBuilder.append(string);
        }
        stringBuilder.append("</th>");
        return stringBuilder.toString();
    }

    @Override
    protected void writeFooter(LineWriter lineWriter) throws IOException {
        lineWriter.writeln("</table>");
        lineWriter.writeln("</div>");
        super.writeFooter(lineWriter);
    }

    @Override
    protected boolean isColumnsPage() {
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ByDefaultValueComparator
    implements Comparator<TableColumn> {
        private final Comparator<TableColumn> byColumn;

        private ByDefaultValueComparator() {
            this.byColumn = new ByColumnComparator();
        }

        @Override
        public int compare(TableColumn tableColumn, TableColumn tableColumn2) {
            int n = String.valueOf(tableColumn.getDefaultValue()).compareToIgnoreCase(String.valueOf(tableColumn2.getDefaultValue()));
            if (n == 0) {
                n = this.byColumn.compare(tableColumn, tableColumn2);
            }
            return n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ByAutoUpdateComparator
    implements Comparator<TableColumn> {
        private final Comparator<TableColumn> byColumn;

        private ByAutoUpdateComparator() {
            this.byColumn = new ByColumnComparator();
        }

        @Override
        public int compare(TableColumn tableColumn, TableColumn tableColumn2) {
            int n;
            int n2 = tableColumn.isAutoUpdated() == tableColumn2.isAutoUpdated() ? 0 : (n = tableColumn.isAutoUpdated() ? -1 : 1);
            if (n == 0) {
                n = this.byColumn.compare(tableColumn, tableColumn2);
            }
            return n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ByNullableComparator
    implements Comparator<TableColumn> {
        private final Comparator<TableColumn> byColumn;

        private ByNullableComparator() {
            this.byColumn = new ByColumnComparator();
        }

        @Override
        public int compare(TableColumn tableColumn, TableColumn tableColumn2) {
            int n;
            int n2 = tableColumn.isNullable() == tableColumn2.isNullable() ? 0 : (n = tableColumn.isNullable() ? -1 : 1);
            if (n == 0) {
                n = this.byColumn.compare(tableColumn, tableColumn2);
            }
            return n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BySizeComparator
    implements Comparator<TableColumn> {
        private final Comparator<TableColumn> byColumn;

        private BySizeComparator() {
            this.byColumn = new ByColumnComparator();
        }

        @Override
        public int compare(TableColumn tableColumn, TableColumn tableColumn2) {
            int n = tableColumn.getLength() - tableColumn2.getLength();
            if (n == 0 && (n = tableColumn.getDecimalDigits() - tableColumn2.getDecimalDigits()) == 0) {
                n = this.byColumn.compare(tableColumn, tableColumn2);
            }
            return n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ByTypeComparator
    implements Comparator<TableColumn> {
        private final Comparator<TableColumn> bySize;

        private ByTypeComparator() {
            this.bySize = new BySizeComparator();
        }

        @Override
        public int compare(TableColumn tableColumn, TableColumn tableColumn2) {
            int n = tableColumn.getType().compareToIgnoreCase(tableColumn2.getType());
            if (n == 0) {
                n = this.bySize.compare(tableColumn, tableColumn2);
            }
            return n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ByTableComparator
    implements Comparator<TableColumn> {
        private ByTableComparator() {
        }

        @Override
        public int compare(TableColumn tableColumn, TableColumn tableColumn2) {
            int n = tableColumn.getTable().compareTo(tableColumn2.getTable());
            if (n == 0) {
                n = tableColumn.getName().compareToIgnoreCase(tableColumn2.getName());
            }
            return n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ByColumnComparator
    implements Comparator<TableColumn> {
        private ByColumnComparator() {
        }

        @Override
        public int compare(TableColumn tableColumn, TableColumn tableColumn2) {
            int n = tableColumn.getName().compareToIgnoreCase(tableColumn2.getName());
            if (n == 0) {
                n = tableColumn.getTable().compareTo(tableColumn2.getTable());
            }
            return n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ColumnInfo {
        private final String columnName;
        private final Comparator<TableColumn> comparator;

        private ColumnInfo(String string, Comparator<TableColumn> comparator) {
            this.columnName = string;
            this.comparator = comparator;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public String getLocation() {
            return this.getLocation(this.columnName);
        }

        public String getLocation(String string) {
            return "columns.by" + string + ".html";
        }

        private Comparator<TableColumn> getComparator() {
            return this.comparator;
        }

        public String toString() {
            return this.getLocation();
        }
    }
}

