/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.context;

import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Stack;
import org.apache.derby.iapi.error.ShutdownException;
import org.apache.derby.iapi.services.context.Context;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.SystemContext;
import org.apache.derby.iapi.services.info.JVMInfo;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.stream.HeaderPrintWriter;

public final class ContextService {
    private static ContextService factory;
    private HeaderPrintWriter errorStream;
    private ThreadLocal threadContextList = new ThreadLocal();
    private HashSet allContexts;

    public ContextService() {
        this.errorStream = Monitor.getStream();
        factory = this;
        this.allContexts = new HashSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stop() {
        ContextService contextService = factory;
        if (contextService != null) {
            ContextService contextService2 = contextService;
            synchronized (contextService2) {
                contextService.allContexts = null;
                contextService.threadContextList = null;
                factory = null;
            }
        }
    }

    public static ContextService getFactory() {
        ContextService contextService = factory;
        if (contextService == null) {
            throw new ShutdownException();
        }
        return contextService;
    }

    public static Context getContext(String string) {
        ContextManager contextManager = ContextService.getFactory().getCurrentContextManager();
        if (contextManager == null) {
            return null;
        }
        return contextManager.getContext(string);
    }

    public static Context getContextOrNull(String string) {
        ContextService contextService = factory;
        if (contextService == null) {
            return null;
        }
        ContextManager contextManager = contextService.getCurrentContextManager();
        if (contextManager == null) {
            return null;
        }
        return contextManager.getContext(string);
    }

    public ContextManager getCurrentContextManager() {
        ThreadLocal threadLocal = this.threadContextList;
        if (threadLocal == null) {
            return null;
        }
        Object t = threadLocal.get();
        if (t instanceof ContextManager) {
            Thread thread = Thread.currentThread();
            ContextManager contextManager = (ContextManager)t;
            if (contextManager.activeThread == thread) {
                return contextManager;
            }
            return null;
        }
        if (t == null) {
            return null;
        }
        Stack stack = (Stack)t;
        return (ContextManager)stack.peek();
    }

    public void resetCurrentContextManager(ContextManager contextManager) {
        ThreadLocal threadLocal = this.threadContextList;
        if (threadLocal == null) {
            return;
        }
        if (contextManager.activeCount != -1) {
            if (--contextManager.activeCount == 0) {
                contextManager.activeThread = null;
                if (contextManager.isEmpty()) {
                    threadLocal.set(null);
                }
            }
            return;
        }
        Stack stack = (Stack)threadLocal.get();
        Object e = stack.pop();
        ContextManager contextManager2 = (ContextManager)stack.peek();
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < stack.size(); ++i) {
            Object e2 = stack.elementAt(i);
            if (e2 != contextManager2) {
                bl = true;
            }
            if (e2 != contextManager) continue;
            bl2 = true;
        }
        if (!bl2) {
            contextManager.activeThread = null;
            contextManager.activeCount = 0;
        }
        if (!bl) {
            contextManager2.activeCount = stack.size();
            threadLocal.set(contextManager2);
        }
    }

    private boolean addToThreadList(Thread thread, ContextManager contextManager) {
        Stack<ContextManager> stack;
        ThreadLocal threadLocal = this.threadContextList;
        if (threadLocal == null) {
            return false;
        }
        Object t = threadLocal.get();
        if (contextManager == t) {
            return true;
        }
        if (t == null) {
            threadLocal.set(contextManager);
            return true;
        }
        if (t instanceof ContextManager) {
            ContextManager contextManager2 = (ContextManager)t;
            if (thread == null) {
                thread = Thread.currentThread();
            }
            if (contextManager2.activeThread != thread) {
                threadLocal.set(contextManager);
                return true;
            }
            stack = new Stack<ContextManager>();
            threadLocal.set(stack);
            for (int i = 0; i < contextManager2.activeCount; ++i) {
                stack.push(contextManager2);
            }
            contextManager2.activeCount = -1;
        } else {
            stack = (Stack<ContextManager>)t;
        }
        stack.push(contextManager);
        contextManager.activeCount = -1;
        return false;
    }

    public void setCurrentContextManager(ContextManager contextManager) {
        Thread thread = null;
        if (contextManager.activeThread == null) {
            contextManager.activeThread = thread = Thread.currentThread();
        }
        if (this.addToThreadList(thread, contextManager)) {
            ++contextManager.activeCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextManager newContextManager() {
        ContextManager contextManager = new ContextManager(this, this.errorStream);
        new SystemContext(contextManager);
        ContextService contextService = this;
        synchronized (contextService) {
            this.allContexts.add(contextManager);
        }
        return contextManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyAllActiveThreads(Context context) {
        Thread thread = Thread.currentThread();
        ContextService contextService = this;
        synchronized (contextService) {
            Iterator iterator = this.allContexts.iterator();
            while (iterator.hasNext()) {
                ContextManager contextManager = (ContextManager)iterator.next();
                Thread thread2 = contextManager.activeThread;
                if (thread2 == thread || thread2 == null) continue;
                final Thread thread3 = thread2;
                if (!contextManager.setInterrupted(context)) continue;
                try {
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            thread3.interrupt();
                            return null;
                        }
                    });
                }
                catch (AccessControlException accessControlException) {
                    if (JVMInfo.isIBMJVM()) {
                        JVMInfo.javaDump();
                    }
                    throw accessControlException;
                }
            }
        }
    }

    synchronized void removeContext(ContextManager contextManager) {
        if (this.allContexts != null) {
            this.allContexts.remove(contextManager);
        }
    }
}

