/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.auction.server.ebay;

import com.cyberfox.util.config.JConfig;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import com.jbidwatcher.auction.AuctionAction;
import com.jbidwatcher.auction.AuctionEntry;
import com.jbidwatcher.auction.AuctionInfo;
import com.jbidwatcher.auction.BadBidException;
import com.jbidwatcher.auction.Bidder;
import com.jbidwatcher.auction.EntryCorral;
import com.jbidwatcher.auction.ItemParser;
import com.jbidwatcher.auction.MultiSnipeManager;
import com.jbidwatcher.auction.Snipe;
import com.jbidwatcher.auction.SpecificAuction;
import com.jbidwatcher.auction.server.AuctionServer;
import com.jbidwatcher.auction.server.AuctionServerManager;
import com.jbidwatcher.auction.server.ServerMenu;
import com.jbidwatcher.auction.server.ebay.ebayAuction2;
import com.jbidwatcher.auction.server.ebay.ebayBidder;
import com.jbidwatcher.auction.server.ebay.ebayCleaner;
import com.jbidwatcher.auction.server.ebay.ebayCurrencyTables;
import com.jbidwatcher.auction.server.ebay.ebayItemParser;
import com.jbidwatcher.auction.server.ebay.ebayLoginManager;
import com.jbidwatcher.auction.server.ebay.ebaySearches;
import com.jbidwatcher.auction.server.ebay.ebayServerMenu;
import com.jbidwatcher.search.SearchManager;
import com.jbidwatcher.search.SearchManagerInterface;
import com.jbidwatcher.search.Searcher;
import com.jbidwatcher.util.Constants;
import com.jbidwatcher.util.Currency;
import com.jbidwatcher.util.Externalized;
import com.jbidwatcher.util.Record;
import com.jbidwatcher.util.StringTools;
import com.jbidwatcher.util.TT;
import com.jbidwatcher.util.UpdateBlocker;
import com.jbidwatcher.util.ZoneDate;
import com.jbidwatcher.util.config.JConfig;
import com.jbidwatcher.util.html.JHTML;
import com.jbidwatcher.util.http.CookieJar;
import com.jbidwatcher.util.queue.AuctionQObject;
import com.jbidwatcher.util.queue.MQFactory;
import com.jbidwatcher.util.queue.MessageQueue;
import com.jbidwatcher.util.queue.TimeQueueManager;
import com.jbidwatcher.util.queue.TimerHandler;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public final class ebayServer
extends AuctionServer
implements MessageQueue.Listener,
JConfig.ConfigListener {
    private static final ebayCurrencyTables sCurrencies = new ebayCurrencyTables();
    private TT T;
    private eBayTimeQueueManager _etqm;
    private Searcher mSellerSearch;
    private ebaySearches mSearcher;
    private ebayLoginManager mLogin;
    private SnipeListener mSnipeQueue;
    private TimerHandler eQueue;
    private long mPageRequestTime;
    private long mOfficialServerTimeDelta;
    private TimeZone mOfficialServerTimeZone;
    private Date mNow = new Date();
    private GregorianCalendar mCal;
    private ebayCleaner mCleaner;
    private Bidder mBidder;
    private MultiSnipeManager multiSnipeManager;
    private static final int THIRTY_SECONDS = 30000;
    private static final long TWO_MINUTES = 120000L;
    private static final long FIVE_MINUTES = 300000L;

    @Override
    public Currency getMinimumBidIncrement(Currency currentBid, int bidCount) {
        return sCurrencies.getMinimumBidIncrement(currentBid, bidCount);
    }

    @Override
    public void updateConfiguration() {
        boolean isUpdated = this.mLogin.updateLogin(this.getName());
        if (!this.mLogin.isDefault()) {
            Searcher s;
            if (isUpdated) {
                this.forceLogin();
            }
            if ((s = this.searcher.getSearchByName("My Selling Items")) == null) {
                this.mSellerSearch = this.searcher.buildSearch(System.currentTimeMillis(), "Seller", "My Selling Items", this.mLogin.getUserId(), this.getName(), null, 1);
                this.mSellerSearch.setCategory("selling");
                this.searcher.addSearch(this.mSellerSearch);
            } else {
                s.setSearch(this.mLogin.getUserId());
            }
        }
    }

    @Override
    public ServerMenu establishMenu() {
        ebayServerMenu esm = new ebayServerMenu(this.getFriendlyName(), "eBay", 'b');
        ((ServerMenu)esm).initialize();
        return esm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateHighBid(String auctionId) {
        JHTML htmlDocument;
        String bidHistory = Externalized.getString("ebayServer.protocol") + this.T.s("ebayServer.bidHost") + Externalized.getString("ebayServer.V3file") + Externalized.getString("ebayServer.viewBidsCGI") + auctionId;
        CookieJar cj = this.mLogin.getNecessaryCookie(false);
        String userCookie = null;
        if (cj != null) {
            userCookie = cj.toString();
        }
        if ((htmlDocument = new JHTML(bidHistory, userCookie, this.mCleaner)).isLoaded()) {
            List<JHTML.Table> bidderTables = htmlDocument.extractTables();
            for (JHTML.Table t : bidderTables) {
                if (!t.rowCellMatches(0, "^(Bidder|User ID).*")) continue;
                int bidCount = t.getRowCount() - 1;
                AuctionEntry ae = (AuctionEntry)this.entryCorral.takeForWrite(auctionId);
                try {
                    String newCurrency;
                    if (t.rowCellMatches(bidCount, "Starting Price")) {
                        --bidCount;
                    }
                    if (t.rowCellMatches(bidCount, "(No purchases have been made.|No bids have been placed.)")) {
                        ae.setNumBids(0);
                        return;
                    }
                    if (ae.getNumBidders() == 0) {
                        ae.setNumBids(bidCount);
                    }
                    int myMostRecentRow = -1;
                    for (int i = 1; i < bidCount + 1; ++i) {
                        if (!t.getCell(0, i).equals(this.mLogin.getUserId())) continue;
                        myMostRecentRow = i;
                        break;
                    }
                    if (myMostRecentRow != -1 && (newCurrency = t.getCell(1, myMostRecentRow)) != null) {
                        Currency highBid = Currency.getCurrency(newCurrency);
                        try {
                            if (!ae.isBidOn() || ae.getBid().less(highBid)) {
                                ae.setBid(highBid);
                                ae.setBidQuantity(bidCount);
                                ae.saveDB();
                            }
                        }
                        catch (Currency.CurrencyTypeException currencyTypeException) {
                            // empty catch block
                        }
                    }
                    if (bidCount <= 0) continue;
                    AuctionInfo ai = ae.getAuction();
                    String highBidder = t.getCell(0, 1);
                    int feedbackStart = highBidder.indexOf(" (");
                    if (feedbackStart != -1) {
                        highBidder = highBidder.substring(0, feedbackStart);
                    }
                    if (highBidder.startsWith("private listing")) {
                        ai.setPrivate(true);
                        ai.setHighBidder("(private)");
                    } else {
                        Pattern p = Pattern.compile("Member Id: (.*)");
                        Matcher m = p.matcher(highBidder);
                        if (m.matches()) {
                            highBidder = m.group(1);
                        }
                        ai.setHighBidder(highBidder);
                    }
                    ai.saveDB();
                    return;
                }
                finally {
                    this.entryCorral.release(auctionId);
                }
            }
        }
    }

    @Override
    public void messageAction(Object deQ) {
        AuctionQObject ac = (AuctionQObject)deQ;
        String failString = null;
        switch (ac.getCommand()) {
            case 0: {
                this.mSearcher.loadAllFromURLString(this.searcher.getSearchById((Long)ac.getData()), ac.getLabel());
                return;
            }
            case 1: {
                this.mSearcher.loadSearchString(this.searcher.getSearchById((Long)ac.getData()), ac.getLabel(), false);
                return;
            }
            case 6: {
                this.mSearcher.loadSearchString(this.searcher.getSearchById((Long)ac.getData()), ac.getLabel(), true);
                return;
            }
            case 2: {
                this.doGetSelling(this.searcher.getSearchById((Long)ac.getData()), ac.getLabel());
                return;
            }
            case 3: {
                if (this.mLogin.isDefault()) {
                    failString = Externalized.getString("ebayServer.cantLoadWithoutUsername1") + " " + this.getName() + Externalized.getString("ebayServer.cantLoadWithoutUsername2");
                    break;
                }
                this.doMyEbaySynchronize(ac.getLabel());
                return;
            }
            case 5: {
                this.bidMsg(ac);
                return;
            }
        }
        if (ac.getData() != null) {
            if (ac.getData().equals("Get My eBay Items")) {
                if (this.mLogin.isDefault()) {
                    failString = Externalized.getString("ebayServer.cantLoadWithoutUsername1") + " " + this.getName() + Externalized.getString("ebayServer.cantLoadWithoutUsername2");
                } else {
                    this.searcher.getSearchByName("My eBay").execute();
                    return;
                }
            }
            if (ac.getData().equals("Get Selling Items")) {
                if (this.mLogin.isDefault()) {
                    failString = Externalized.getString("ebayServer.cantLoadSellerWithoutUser1") + " " + this.getName() + Externalized.getString("ebayServer.cantLoadWithoutUsername2");
                } else {
                    if (this.mSellerSearch == null) {
                        this.updateConfiguration();
                    }
                    if (this.mSellerSearch != null) {
                        this.mSellerSearch.execute();
                    }
                    return;
                }
            }
            if (ac.getData().equals("Update login cookie")) {
                if (this.mLogin.isDefault()) {
                    failString = Externalized.getString("ebayServer.cantUpdateCookieWithoutUser1") + " " + this.getName() + Externalized.getString("ebayServer.cantLoadWithoutUsername2");
                } else {
                    this.forceLogin();
                    return;
                }
            }
            if (ac.getData().equals("Dump eBay Activity Queue")) {
                this._etqm.dumpQueue(this.T.getBundle());
                return;
            }
        }
        if (failString != null && failString.length() != 0 && this.mLogin.isDefault()) {
            MQFactory.getConcrete("Swing").enqueue("NOACCOUNT " + failString);
        } else if (ac.getData() instanceof String) {
            String acData = (String)ac.getData();
            JConfig.log().logMessage("Dequeue'd unexpected command or fell through: " + ac.getCommand() + ':' + acData);
        } else {
            JConfig.log().logMessage("Can't recognize ebay-queued data: " + ac.getData());
        }
    }

    public void forceLogin() {
        this.mLogin.resetCookie();
        this.mLogin.getNecessaryCookie(true);
    }

    private void bidMsg(AuctionQObject ac) {
        AuctionAction ab = (AuctionAction)ac.getData();
        String bidResultString = ab.activate(this.entryCorral);
        String configBidMsg = ab.isSuccessful() ? "prompt.hide_bidalert" : "prompt.hide_bidfailalert";
        MQFactory.getConcrete("Swing").enqueue("IGNORE " + configBidMsg + ' ' + bidResultString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSnipe(String auctionId) {
        AuctionEntry ae = (AuctionEntry)this.entryCorral.takeForWrite(auctionId);
        try {
            Date endDate = ae.getEndDate();
            long snipeDelta = ae.getSnipeTime();
            this._etqm.erase(auctionId);
            this.mSnipeQueue.delSnipe(auctionId);
            JConfig.log().logDebug("Establishing a snipe on " + auctionId + " for " + ae.getSnipeAmount());
            if (endDate != null && endDate != Constants.FAR_FUTURE) {
                ae.setLastStatus("Establishing a snipe for " + ae.getSnipeAmount());
                this._etqm.add("TIMECHECK", "auction_manager", endDate.getTime() - snipeDelta - 300000L);
                this._etqm.add(auctionId, this.mSnipeQueue.getQueueName(), endDate.getTime() - snipeDelta - 120000L);
                this._etqm.add(auctionId, this.mSnipeQueue.getQueueName(), endDate.getTime() - snipeDelta);
                this._etqm.add(auctionId, "drop", endDate.getTime() + 30000L);
            } else {
                JConfig.log().logMessage("Failing to set snipe for " + auctionId + ", endDate is null or in the far future (" + endDate + ")");
            }
            MQFactory.getConcrete("my").enqueue("SNIPE " + auctionId);
        }
        finally {
            this.entryCorral.release(auctionId);
        }
    }

    @Override
    public void cancelSnipe(String identifier) {
        this._etqm.erase(identifier);
        this.mSnipeQueue.delSnipe(identifier);
        MQFactory.getConcrete("my").enqueue("CANCEL " + identifier);
    }

    @Inject
    private ebayServer(EntryCorral corral, SearchManager searchManager, AuctionServerManager asm, MultiSnipeManager multiSnipeManager, @Nullable @Assisted(value="site") String site, @Nullable @Assisted(value="username") String username, @Nullable @Assisted(value="password") String password) {
        if (site == null) {
            site = JConfig.queryConfiguration(this.getName() + ".browse.site");
        }
        if (site == null) {
            site = "0";
        }
        if (username == null) {
            username = JConfig.queryConfiguration(this.getName() + ".user", "default");
        }
        if (password == null) {
            password = JConfig.queryConfiguration(this.getName() + ".password", "default");
        }
        this.constructServer(corral, searchManager, asm, multiSnipeManager, site, username, password);
    }

    private void constructServer(EntryCorral corral, SearchManager searchManager, AuctionServerManager asm, MultiSnipeManager multiSnipeManager, String site, String username, String password) {
        this.entryCorral = corral;
        this.searcher = searchManager;
        this.multiSnipeManager = multiSnipeManager;
        this.T = site == null ? new TT("ebay.com") : (StringTools.isNumberOnly(site) ? new TT("ebay.com") : new TT(site));
        this.mCleaner = new ebayCleaner();
        this.mLogin = new ebayLoginManager(this.T, "ebay", password, username);
        this.mSearcher = new ebaySearches(this.entryCorral, asm, this.mCleaner, this.mLogin);
        this.mBidder = JConfig.queryConfiguration("ebay.mock_bidding", "false").equals("true") ? new Bidder(){

            @Override
            public int buy(AuctionEntry ae, int quantity) {
                return 16;
            }

            @Override
            public int bid(AuctionEntry inEntry, Currency inBid, int inQuantity) {
                return 3;
            }

            @Override
            public JHTML.Form getBidForm(CookieJar cj, AuctionEntry inEntry, Currency inCurr) throws BadBidException {
                return new JHTML.Form("<form action=\"http://example.com\">");
            }

            @Override
            public int placeFinalBid(CookieJar cj, JHTML.Form bidForm, AuctionEntry inEntry, Currency inBid, int inQuantity) {
                return 3;
            }
        } : new ebayBidder(this.T, this.mLogin);
        this._etqm = new eBayTimeQueueManager();
        this.eQueue = new TimerHandler(this._etqm);
        this.eQueue.setName("eBay SuperQueue");
        this.eQueue.start();
        this.mSnipeQueue = new SnipeListener(this.getFriendlyName());
        MQFactory.getConcrete(this.mSnipeQueue.getQueueName()).registerListener(this.mSnipeQueue);
        MQFactory.getConcrete(this.getFriendlyName()).registerListener(this);
        JConfig.registerListener(this);
    }

    @Override
    protected ItemParser getItemParser(StringBuffer itemContents, AuctionEntry ae, String item_id) {
        Record updateRecord = new Record();
        Record highBidderInfo = new Record();
        return new ebayItemParser(this.T, itemContents, updateRecord, highBidderInfo);
    }

    @Override
    public String extractIdentifierFromURLString(String urlStyle) {
        int index;
        String lastPart;
        String itemNum;
        Pattern url = Pattern.compile(Externalized.getString("ebayServer.itemNumberMatch"));
        Matcher urlMatch = url.matcher(urlStyle);
        if (urlMatch.find() && StringTools.isNumberOnly(itemNum = urlMatch.group(2))) {
            return itemNum;
        }
        URL siteAddr = StringTools.getURLFromString(urlStyle);
        if (siteAddr != null && (lastPart = siteAddr.toString()).contains(Externalized.getString("ebayServer.viewCmd")) && (index = lastPart.indexOf(Externalized.getString("ebayServer.viewCGI"))) != -1) {
            String aucId = lastPart.substring(index + Externalized.getString("ebayServer.viewCGI").length());
            if (aucId.contains("&")) {
                aucId = aucId.substring(0, aucId.indexOf("&"));
            }
            if (aucId.contains("#")) {
                aucId = aucId.substring(0, aucId.indexOf("#"));
            }
            return aucId;
        }
        try {
            URL pieces = new URL(urlStyle);
            String path = pieces.getPath();
            String digits = path.substring(path.lastIndexOf(47) + 1);
            if (StringTools.isNumberOnly(digits)) {
                return digits;
            }
        }
        catch (Exception e) {
            JConfig.log().logDebug("Failed to parse " + urlStyle + " as a URL");
        }
        JConfig.log().logDebug("extractIdentifierFromURLString failed.");
        return null;
    }

    @Override
    public String getStringURLFromItem(String itemID) {
        return Externalized.getString("ebayServer.protocol") + this.T.s("ebayServer.viewHost") + Externalized.getString("ebayServer.file") + '?' + Externalized.getString("ebayServer.viewCmd") + Externalized.getString("ebayServer.viewCGI") + itemID;
    }

    @Override
    public String getBrowsableURLFromItem(String itemID) {
        int browse_site = Integer.parseInt(JConfig.queryConfiguration(this.getName() + ".browse.site", "0"));
        return Externalized.getString("ebayServer.protocol") + Externalized.getString("ebayServer.browseHost") + Constants.SITE_CHOICES[browse_site] + Externalized.getString("ebayServer.file") + '?' + Externalized.getString("ebayServer.viewCmd") + Externalized.getString("ebayServer.viewCGI") + itemID;
    }

    @Override
    public SpecificAuction getNewSpecificAuction() {
        return new ebayAuction2(this.T);
    }

    @Override
    public StringBuffer getAuction(String id) throws FileNotFoundException {
        long pre = System.currentTimeMillis();
        StringBuffer sb = this.getAuction(this.getURLFromItem(id));
        long post = System.currentTimeMillis();
        if (JConfig.queryConfiguration("timesync.enabled", "true").equals("true")) {
            this.mPageRequestTime = post - pre;
        }
        return sb;
    }

    @Override
    public long getPageRequestTime() {
        return this.mPageRequestTime;
    }

    @Override
    public synchronized CookieJar getNecessaryCookie(boolean force) {
        return this.mLogin.getNecessaryCookie(force);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int bid(String auctionId, Currency inBid, int inQuantity) {
        AuctionEntry inEntry = (AuctionEntry)this.entryCorral.takeForWrite(auctionId);
        try {
            if (inEntry == null) {
                JConfig.log().logMessage("Auction " + auctionId + " disappeared before the bid.");
                int n = 14;
                return n;
            }
            int n = this.mBidder.bid(inEntry, inBid, inQuantity);
            return n;
        }
        finally {
            this.entryCorral.release(auctionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int buy(String auctionId, int quantity) {
        AuctionEntry ae = (AuctionEntry)this.entryCorral.takeForWrite(auctionId);
        try {
            int n = this.mBidder.buy(ae, quantity);
            return n;
        }
        finally {
            this.entryCorral.release(auctionId);
        }
    }

    @Override
    public boolean isDefaultUser() {
        return this.mLogin.isDefault();
    }

    @Override
    public String getUserId() {
        return this.mLogin.getUserId();
    }

    @Override
    public void cancelSearches() {
        MQFactory.getConcrete(this.getFriendlyName()).clear();
    }

    @Override
    public void addSearches(SearchManagerInterface searchManager) {
        Searcher s = searchManager.getSearchByName("My eBay");
        if (s == null) {
            searchManager.addSearch("My Items", "My eBay", "", "ebay", -1, 1L);
        }
    }

    private void doMyEbaySynchronize(String label) {
        MQFactory.getConcrete("Swing").enqueue("Synchronizing with My eBay...");
        this.mSearcher.getMyEbayItems(this.mLogin.getUserId(), label);
        MQFactory.getConcrete("Swing").enqueue("Done synchronizing with My eBay...");
    }

    private void doGetSelling(Object searcher, String label) {
        String userId = ((Searcher)searcher).getSearch();
        MQFactory.getConcrete("Swing").enqueue("Getting Selling Items for " + userId);
        this.mSearcher.getSellingItems(userId, this.mLogin.getUserId(), label);
        MQFactory.getConcrete("Swing").enqueue("Done Getting Selling Items for " + userId);
    }

    @Override
    public String getTime() {
        TimeZone serverTZ = this.getOfficialServerTimeZone();
        if (serverTZ != null) {
            if (this.mCal == null) {
                this.mCal = new GregorianCalendar(serverTZ);
                if (JConfig.queryConfiguration("display.ebayTime", "false").equals("true")) {
                    Constants.remoteClockFormat.setCalendar(this.mCal);
                }
            }
            if (JConfig.queryConfiguration("timesync.enabled", "true").equals("true")) {
                this.mNow.setTime(System.currentTimeMillis() + this.getServerTimeDelta() + this.getPageRequestTime());
            } else {
                this.mNow.setTime(System.currentTimeMillis());
            }
            this.mCal.setTime(this.mNow);
            this.mNow.setTime(this.mCal.getTimeInMillis());
            return this.mLogin.getUserId() + '@' + this.getName() + ": " + Constants.remoteClockFormat.format(this.mNow);
        }
        this.mNow.setTime(System.currentTimeMillis());
        return this.mLogin.getUserId() + '@' + this.getName() + ": " + Constants.localClockFormat.format(this.mNow);
    }

    @Override
    public long getAdjustedTime() {
        return System.currentTimeMillis() + this.getServerTimeDelta() + this.getPageRequestTime();
    }

    @Override
    public long getServerTimeDelta() {
        return this.mOfficialServerTimeDelta;
    }

    @Override
    public TimeZone getOfficialServerTimeZone() {
        return this.mOfficialServerTimeZone;
    }

    @Override
    public String getName() {
        return "ebay";
    }

    @Override
    public String getFriendlyName() {
        return this.T.getCountrySiteName();
    }

    @Override
    public boolean validate(String username, String password) {
        return this.mLogin.validate(username, password);
    }

    @Override
    protected Date getOfficialTime() {
        UpdateBlocker.startBlocking();
        String timeRequest = Externalized.getString("ebayServer.timeURL");
        JHTML htmlDocument = new JHTML(timeRequest, null, this.mCleaner);
        long localDateAfterPage = System.currentTimeMillis();
        ZoneDate result = null;
        String pageStep = htmlDocument.getNextContent();
        while (result == null && pageStep != null) {
            if (pageStep.equals(this.T.s("ebayServer.timePrequel1")) || pageStep.equals(this.T.s("ebayServer.timePrequel2"))) {
                result = StringTools.figureDate(htmlDocument.getNextContent(), Externalized.getString("ebayServer.officialTimeFormat"), false, false);
            }
            pageStep = htmlDocument.getNextContent();
        }
        UpdateBlocker.endBlocking();
        if (result == null || result.getDate() == null) {
            this.mPageRequestTime = 0L;
            JConfig.log().logMessage(this.getName() + ": Error, can't accurately set delta to server's official time.");
            this.mOfficialServerTimeDelta = 1L;
            return null;
        }
        this.mOfficialServerTimeDelta = result.getDate().getTime() - localDateAfterPage;
        if (this.mOfficialServerTimeDelta == 0L) {
            this.mOfficialServerTimeDelta = 1L;
        }
        if (result.getZone() != null) {
            this.mOfficialServerTimeZone = result.getZone();
        }
        if (Math.abs(this.mOfficialServerTimeDelta) > 604800000L) {
            MQFactory.getConcrete("Swing").enqueue("NOTIFY Your system time is off from eBay's by more than a week.");
        }
        return result.getDate();
    }

    private class SnipeListener
    implements MessageQueue.Listener {
        private String queueName = "sniper";
        private Map<String, Snipe> mSnipeMap = new HashMap<String, Snipe>();

        private SnipeListener(String suffix) {
            this.queueName = suffix + " sniper";
        }

        public String getQueueName() {
            return this.queueName;
        }

        public void delSnipe(String identifier) {
            this.mSnipeMap.remove(identifier);
        }

        private Snipe getSnipe(String identifier) {
            Snipe snipe;
            AuctionEntry ae = (AuctionEntry)ebayServer.this.entryCorral.takeForRead(identifier);
            if (ae == null || !ae.isSniped()) {
                return null;
            }
            if (this.mSnipeMap.containsKey(identifier)) {
                snipe = this.mSnipeMap.get(identifier);
            } else {
                snipe = new Snipe(ebayServer.this.multiSnipeManager, ebayServer.this.mLogin, ebayServer.this.mBidder, ae);
                this.mSnipeMap.put(identifier, snipe);
            }
            return snipe;
        }

        private boolean resnipe(String identifier, Snipe snipe, boolean force) {
            long snipeTime;
            long timeLeft = snipe.getItem().getEndDate().getTime() - ebayServer.this._etqm.getCurrentTime();
            if (timeLeft > (snipeTime = snipe.getItem().getSnipeTime())) {
                ebayServer.this._etqm.add(identifier, this.getQueueName(), ebayServer.this._etqm.getCurrentTime() + (timeLeft - snipeTime));
            } else {
                if (timeLeft > 3000L) {
                    long retry_wait = timeLeft / 10L * 2L;
                    if (retry_wait < 3000L) {
                        retry_wait = 3000L;
                    }
                    ebayServer.this._etqm.add(identifier, this.getQueueName(), ebayServer.this._etqm.getCurrentTime() + retry_wait);
                    return true;
                }
                if (force) {
                    MQFactory.getConcrete(this.getQueueName()).enqueue(identifier);
                }
            }
            return false;
        }

        @Override
        public void messageAction(Object deQ) {
            final String identifier = (String)deQ;
            Snipe snipe = this.getSnipe(identifier);
            if (snipe == null) {
                return;
            }
            int snipeResult = snipe.fire();
            switch (snipeResult) {
                case 1: {
                    if (this.resnipe(identifier, snipe, false)) break;
                    JConfig.log().logDebug("Resnipes failed, and less than 3 seconds away.  Giving up.");
                }
                case 2: {
                    ebayServer.this._etqm.erase(identifier);
                    JConfig.log().logDebug("Snipe appears to have failed; cancelling.");
                    snipe.getItem().snipeFailed();
                }
                case 3: {
                    this.mSnipeMap.remove(identifier);
                    break;
                }
                case 0: {
                    if (ebayServer.this._etqm.contains(new TimeQueueManager.Matcher(){

                        @Override
                        public boolean match(Object payload, Object queue, long when) {
                            return payload.equals(identifier) && queue == ebayServer.this.mSnipeQueue;
                        }
                    })) break;
                    this.resnipe(identifier, snipe, true);
                }
            }
        }
    }

    private class eBayTimeQueueManager
    extends TimeQueueManager {
        private eBayTimeQueueManager() {
        }

        @Override
        public boolean check() {
            return (JConfig.queryConfiguration("timesync.enabled", "true").equals("false") || ebayServer.this.getServerTimeDelta() != 0L) && super.check();
        }

        @Override
        public long getCurrentTime() {
            return super.getCurrentTime() + ebayServer.this.getServerTimeDelta();
        }
    }
}

