/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.ui;

import com.cyberfox.util.platform.Platform;
import com.jbidwatcher.auction.AuctionEntry;
import com.jbidwatcher.auction.Auctions;
import com.jbidwatcher.auction.DeletedEntry;
import com.jbidwatcher.auction.EntryInterface;
import com.jbidwatcher.auction.MultiSnipeManager;
import com.jbidwatcher.ui.ImageDropResolver;
import com.jbidwatcher.ui.JDropListener;
import com.jbidwatcher.ui.JPrintable;
import com.jbidwatcher.ui.TabStatusPanel;
import com.jbidwatcher.ui.TargetDrop;
import com.jbidwatcher.ui.myTableCellRenderer;
import com.jbidwatcher.ui.table.AuctionTable;
import com.jbidwatcher.ui.table.CSVExporter;
import com.jbidwatcher.ui.table.TableColumnController;
import com.jbidwatcher.ui.table.auctionTableModel;
import com.jbidwatcher.ui.util.JContext;
import com.jbidwatcher.util.Currency;
import com.jbidwatcher.util.config.JConfig;
import com.jbidwatcher.util.queue.MQFactory;
import com.jbidwatcher.util.queue.PlainMessageQueue;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.jetbrains.annotations.Nullable;

public class AuctionsUIModel {
    private Auctions _dataModel;
    private JTable _table;
    private JScrollPane _scroller;
    private DropTarget[] _targets;
    private Color _bgColor;
    private JPrintable _print;
    private CSVExporter _export;
    private JPanel mPanel;
    private final myTableCellRenderer _myRenderer;
    private auctionTableModel model;
    private final TableRowSorter<TableModel> sorter;

    public AuctionsUIModel(Auctions newAuctionList, myTableCellRenderer cellRenderer, MultiSnipeManager multiManager, JContext tableContextMenu, final JContext frameContextMenu, ActionListener cornerButtonListener) {
        this._myRenderer = cellRenderer;
        this._dataModel = newAuctionList;
        this._targets = new DropTarget[2];
        this.model = new auctionTableModel(multiManager, this._dataModel.getList());
        this._table = new AuctionTable(this._dataModel.getName(), this.model);
        if (newAuctionList.isCompleted() && this._table.convertColumnIndexToView(12) == -1) {
            this._table.addColumn(new TableColumn(12, 75, this._myRenderer, null));
        }
        if (JConfig.queryConfiguration("show_shipping", "false").equals("true")) {
            if (this._table.convertColumnIndexToView(7) == -1) {
                this._table.addColumn(new TableColumn(7));
            }
            JConfig.killAll("show_shipping");
        }
        this.adjustRowHeight();
        DelegatedTableModel sortedModel = new DelegatedTableModel(this.model);
        this.sorter = new TableRowSorter<DelegatedTableModel>(sortedModel);
        this._table.setRowSorter(this.sorter);
        this._table.addMouseListener(tableContextMenu);
        this._scroller = Platform.isMac() || JConfig.queryConfiguration("ui.useCornerButton", "true").equals("true") ? new JScrollPane(this._table, 22, 31) : new JScrollPane(this._table, 20, 31);
        if (JConfig.queryConfiguration("ui.useCornerButton", "true").equals("true")) {
            JButton cornerButton = new JButton("*");
            cornerButton.addActionListener(cornerButtonListener);
            this._scroller.setCorner("UPPER_RIGHT_CORNER", cornerButton);
        }
        this._bgColor = UIManager.getColor("window");
        this._scroller.setViewport(new JViewport(){
            private Image image;
            {
                this.setBackground(AuctionsUIModel.this._bgColor);
                this.addMouseListener(frameContextMenu);
                this.setView(AuctionsUIModel.this._table);
                try {
                    this.image = ImageIO.read(JConfig.getResource("/jbidwatch.jpg"));
                }
                catch (IOException e) {
                    this.image = null;
                }
            }

            @Override
            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                if (this.image != null && AuctionsUIModel.this._table.getRowCount() == 0) {
                    int imageW = this.image.getWidth(null);
                    int imageH = this.image.getHeight(null);
                    Graphics2D g2d = (Graphics2D)g;
                    AlphaComposite comp = AlphaComposite.getInstance(3, 0.5f);
                    Composite oldComp = g2d.getComposite();
                    g2d.setComposite(comp);
                    int xloc = this.getWidth() / 2 - imageW / 2 - 2;
                    int yloc = this.getHeight() / 2 - imageH / 2 - 2;
                    g2d.drawImage(this.image, xloc, yloc, this);
                    g2d.setComposite(oldComp);
                }
            }
        });
        JDropListener _dropEar = newAuctionList.isCompleted() ? new JDropListener(new TargetDrop()) : new JDropListener(new TargetDrop(this._dataModel.getName(), new ImageDropResolver(){

            @Override
            public void handle(String imgUrl, Point location) {
                int rowPoint = AuctionsUIModel.this._table.rowAtPoint(location);
                AuctionEntry whichAuction = (AuctionEntry)AuctionsUIModel.this._table.getValueAt(rowPoint, -1);
                DeletedEntry.deleteThumbnails(whichAuction.getIdentifier());
                whichAuction.getAuction().setThumbnailURL(imgUrl);
                ((PlainMessageQueue)MQFactory.getConcrete("thumbnail")).enqueueObject(whichAuction.getAuction());
            }
        }));
        this._targets[0] = new DropTarget(this._scroller.getViewport(), _dropEar);
        this._targets[1] = new DropTarget(this._table, _dropEar);
        this._targets[0].setActive(true);
        this._targets[1].setActive(true);
        this._print = new JPrintable(this._table);
        this._export = new CSVExporter(this._table);
        this._table.setDefaultRenderer(String.class, this._myRenderer);
        this._table.setDefaultRenderer(Icon.class, this._myRenderer);
        this.mPanel = new JPanel();
        this.mPanel.setLayout(new BorderLayout());
        this.mPanel.add((Component)this._scroller, "Center");
        this.addSumMonitor(this._table);
        TabStatusPanel statusPanel = new TabStatusPanel(this._dataModel.getName());
        this.mPanel.add((Component)statusPanel, "North");
    }

    private void addSumMonitor(JTable table) {
        table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                AuctionsUIModel.this.updateSum();
            }
        });
    }

    private void updateSum() {
        int[] rowList = this._table.getSelectedRows();
        String total = this.sum(rowList);
        if (total == null) {
            MQFactory.getConcrete("Swing").enqueue("PRICE  ");
        } else {
            MQFactory.getConcrete("Swing").enqueue("PRICE " + rowList.length + " / " + total);
        }
    }

    private static Currency getBestBidValue(AuctionEntry checkEntry) {
        return checkEntry.bestValue();
    }

    private static Currency addUSD(Currency inCurr, AuctionEntry ae) {
        boolean newCurrency = inCurr == null || inCurr.isNull();
        Currency currentUSPrice = ae.getCurrentUSPrice();
        try {
            inCurr = ae.getShippingWithInsurance().isNull() ? (newCurrency ? currentUSPrice : inCurr.add(currentUSPrice)) : (newCurrency ? currentUSPrice.add(Currency.convertToUSD(currentUSPrice, ae.getCurrentPrice(), ae.getShippingWithInsurance())) : inCurr.add(currentUSPrice.add(Currency.convertToUSD(currentUSPrice, ae.getCurrentPrice(), ae.getShippingWithInsurance()))));
        }
        catch (Currency.CurrencyTypeException cte) {
            JConfig.log().handleException("This should have been cleaned up.", cte);
        }
        return inCurr;
    }

    private static Currency addNonUSD(Currency inCurr, AuctionEntry ae) {
        boolean newCurrency = inCurr == null || inCurr.isNull();
        try {
            inCurr = ae.getShippingWithInsurance().isNull() ? (newCurrency ? AuctionsUIModel.getBestBidValue(ae) : inCurr.add(AuctionsUIModel.getBestBidValue(ae))) : (newCurrency ? AuctionsUIModel.getBestBidValue(ae).add(ae.getShippingWithInsurance()) : inCurr.add(AuctionsUIModel.getBestBidValue(ae).add(ae.getShippingWithInsurance())));
        }
        catch (Currency.CurrencyTypeException cte) {
            JConfig.log().handleException("This should have been cleaned up.", cte);
        }
        return inCurr;
    }

    protected String sum(int[] rowList) {
        boolean approx = false;
        boolean i18n = true;
        Currency accum = null;
        Currency withShipping = null;
        Currency withRealShipping = null;
        Currency realAccum = null;
        String result = null;
        try {
            for (int aRowList : rowList) {
                try {
                    AuctionEntry entry = (AuctionEntry)this._table.getValueAt(aRowList, -1);
                    Currency currentUSPrice = entry.getCurrentUSPrice();
                    if (accum == null) {
                        accum = currentUSPrice;
                        realAccum = AuctionsUIModel.getBestBidValue(entry);
                        withShipping = AuctionsUIModel.addUSD(withShipping, entry);
                        withRealShipping = AuctionsUIModel.addNonUSD(withRealShipping, entry);
                    } else if (!currentUSPrice.isNull() && !accum.isNull() && currentUSPrice.getCurrencyType() != 0) {
                        accum = accum.add(currentUSPrice);
                        withShipping = AuctionsUIModel.addUSD(withShipping, entry);
                        if (i18n) {
                            try {
                                realAccum = realAccum.add(AuctionsUIModel.getBestBidValue(entry));
                                withRealShipping = AuctionsUIModel.addNonUSD(withRealShipping, entry);
                            }
                            catch (Currency.CurrencyTypeException cte) {
                                i18n = false;
                            }
                        }
                    }
                    if (entry.getCurrentPrice().getCurrencyType() == 1) continue;
                    approx = true;
                }
                catch (ClassCastException currentUSPrice) {
                }
                catch (IndexOutOfBoundsException bounds) {
                    approx = true;
                }
            }
            result = this.formatSum(approx, i18n, accum, withShipping, withRealShipping, realAccum);
        }
        catch (Currency.CurrencyTypeException e) {
            JConfig.log().handleException("Sum currency exception!", e);
        }
        catch (ArrayIndexOutOfBoundsException ignored) {
            JConfig.log().logDebug("Selection of " + rowList.length + " items changed out from under 'sum'.");
        }
        catch (NullPointerException npe) {
            JConfig.log().logDebug("sum got NPE - this is common during delete operations");
        }
        catch (Exception e) {
            JConfig.log().handleException("Sum serious exception!", e);
        }
        return result;
    }

    @Nullable
    private String formatSum(boolean approx, boolean i18n, Currency accum, Currency withShipping, Currency withRealShipping, Currency realAccum) {
        if (accum != null && !accum.isNull()) {
            String sAndH = "s/h";
            if (!Locale.getDefault().equals(Locale.US)) {
                sAndH = "p/p";
            }
            StringBuilder result = new StringBuilder();
            if (i18n && realAccum != null) {
                result.append(realAccum.toString());
                if (withRealShipping != null && !realAccum.equals(withRealShipping)) {
                    result.append(" (").append(withRealShipping).append(" with ").append(sAndH).append(')');
                }
            } else if (approx) {
                if (withShipping != null && !accum.equals(withShipping)) {
                    result.append("About ");
                    this.formatAmountAndShipping(accum, withShipping, sAndH, result);
                } else {
                    result.append("About ").append(accum.toString());
                }
            } else if (withShipping != null && !accum.equals(withShipping)) {
                this.formatAmountAndShipping(accum, withShipping, sAndH, result);
            } else {
                result.append(accum.toString());
            }
            return result.toString();
        }
        return null;
    }

    private void formatAmountAndShipping(Currency accum, Currency withShipping, String sAndH, StringBuilder result) {
        result.append(accum.toString()).append(" (").append(withShipping).append(" with ").append(sAndH).append(')');
    }

    public JPanel getPanel() {
        return this.mPanel;
    }

    public TableRowSorter<TableModel> getTableSorter() {
        return this.sorter;
    }

    public JTable getTable() {
        return this._table;
    }

    public void setBackground(Color bgColor) {
        this._scroller.getViewport().setBackground(bgColor);
        this._table.setBackground(bgColor);
        this._bgColor = bgColor;
    }

    public Color getBackground() {
        return this._bgColor;
    }

    public void delEntry(EntryInterface inEntry) {
        this.model.delete(inEntry);
    }

    public void addEntry(EntryInterface aeNew) {
        if (aeNew != null && this.model.insert(aeNew) == -1) {
            JConfig.log().logMessage("JBidWatch: Bad auction entry, cannot add!");
        }
    }

    public boolean toggleField(String field) {
        boolean rval;
        int modelColumn = TableColumnController.getInstance().getColumnNumber(field);
        if (this._table.convertColumnIndexToView(modelColumn) == -1) {
            TableColumn newColumn = new TableColumn(modelColumn, 75, this._myRenderer, null);
            if (modelColumn == 21) {
                newColumn.setMinWidth(75);
            }
            this._table.addColumn(newColumn);
            rval = true;
        } else {
            this._table.removeColumn(this._table.getColumn(field));
            rval = false;
        }
        this.adjustRowHeight();
        return rval;
    }

    public void adjustRowHeight() {
        int defaultHeight;
        Font def = this._myRenderer.getDefaultFont();
        Graphics g = this._table.getGraphics();
        if (def == null || g == null) {
            defaultHeight = 20;
        } else {
            FontMetrics metrics = g.getFontMetrics(def);
            defaultHeight = metrics.getMaxAscent() + metrics.getMaxDescent() + metrics.getLeading() + 4;
        }
        int thumbnailIndex = this._table.convertColumnIndexToView(21);
        if (thumbnailIndex != -1) {
            defaultHeight = Math.max(72, defaultHeight);
        }
        this._table.setRowHeight(Math.max(defaultHeight, 20));
        if (def != null) {
            this._table.getTableHeader().setFont(def);
        }
    }

    public List<String> getColumns() {
        ArrayList<String> al = new ArrayList<String>();
        for (int i = 0; i < this._table.getColumnCount(); ++i) {
            al.add(this._table.getColumnName(i));
        }
        return al;
    }

    public boolean export(String fname) {
        return this._export.export(fname);
    }

    public void print() {
        this._print.doPrint();
    }

    public void getColumnWidthsToProperties(Properties addToProps, String name) {
        for (int j = 0; j < this._table.getColumnCount(); ++j) {
            TableColumn ct;
            try {
                ct = this._table.getColumn(this._table.getColumnName(j));
            }
            catch (IllegalArgumentException iae) {
                JConfig.log().logMessage("Column can't be retrieved from the table: " + this._table.getColumnName(j));
                ct = null;
            }
            if (ct == null) continue;
            addToProps.setProperty(name + '.' + this._table.getColumnName(j), Integer.toString(j) + '.' + Integer.toString(ct.getWidth()));
        }
    }

    public void getColumnWidthsToProperties(Properties addToProps) {
        this.getColumnWidthsToProperties(addToProps, this._dataModel.getName());
    }

    public void sort() {
        this.sorter.sort();
    }

    public void redrawAll() {
        this._table.tableChanged(new TableModelEvent(this.model));
    }

    private class DelegatedTableModel
    extends AbstractTableModel {
        private final auctionTableModel delegate;

        public DelegatedTableModel(auctionTableModel model) {
            this.delegate = model;
        }

        @Override
        public int getRowCount() {
            return this.delegate.getRowCount();
        }

        @Override
        public int getColumnCount() {
            return this.delegate.getColumnCount();
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.delegate.getColumnName(columnIndex);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return this.delegate.getSortByColumnClass(columnIndex);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return this.delegate.isCellEditable(rowIndex, columnIndex);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.delegate.getSortByValueAt(rowIndex, columnIndex);
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            this.delegate.setValueAt(aValue, rowIndex, columnIndex);
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
            this.delegate.addTableModelListener(l);
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
            this.delegate.removeTableModelListener(l);
        }
    }
}

