/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.posimo;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.posimo.Block;
import net.sourceforge.plantuml.posimo.Clusterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cluster
implements Clusterable {
    private static int CPT = 1;
    private final Cluster parent;
    private final Collection<Block> blocs = new ArrayList<Block>();
    private final Collection<Cluster> children = new ArrayList<Cluster>();
    private final int uid = CPT++;
    private double x;
    private double y;
    private double width;
    private double height;
    private final double titleWidth;
    private final double titleHeight;

    public Cluster(Cluster cluster, double d, double d2) {
        this.parent = cluster;
        this.titleWidth = d;
        this.titleHeight = d2;
        if (cluster != null) {
            cluster.children.add(this);
        }
    }

    public Collection<Cluster> getSubClusters() {
        return Collections.unmodifiableCollection(this.children);
    }

    public Collection<Block> getRecursiveContents() {
        ArrayList<Block> arrayList = new ArrayList<Block>();
        this.addContentRecurse(arrayList);
        return Collections.unmodifiableCollection(arrayList);
    }

    private void addContentRecurse(Collection<Block> collection) {
        collection.addAll(this.blocs);
        for (Cluster cluster : this.children) {
            cluster.addContentRecurse(collection);
        }
    }

    public int getUid() {
        return this.uid;
    }

    public void addBloc(Block block) {
        this.blocs.add(block);
    }

    @Override
    public Cluster getParent() {
        return this.parent;
    }

    public Collection<Block> getContents() {
        return Collections.unmodifiableCollection(this.blocs);
    }

    public Block getBlock(int n) {
        for (Block clusterable : this.blocs) {
            if (clusterable.getUid() != n) continue;
            return clusterable;
        }
        for (Cluster cluster : this.children) {
            Block block = cluster.getBlock(n);
            if (block == null) continue;
            return block;
        }
        return null;
    }

    @Override
    public Point2D getPosition() {
        return new Point2D.Double(this.x, this.y);
    }

    @Override
    public Dimension2D getSize() {
        return new Dimension2DDouble(this.width, this.height);
    }

    public final void setX(double d) {
        this.x = d;
    }

    public final void setY(double d) {
        this.y = d;
    }

    public final void setWidth(double d) {
        this.width = d;
    }

    public final void setHeight(double d) {
        this.height = d;
    }

    public final double getTitleWidth() {
        return this.titleWidth;
    }

    public final double getTitleHeight() {
        return this.titleHeight;
    }

    @Override
    public void moveSvek(double d, double d2) {
        throw new UnsupportedOperationException();
    }
}

