/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project2;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.SpriteContainerEmpty;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.project2.Day;
import net.sourceforge.plantuml.project2.TimeLine;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class TimeHeaderDay
implements TextBlock {
    private final Day start;
    private final Day end;
    private final TimeLine timeline;
    private final double dayWidth;
    private final UFont font = new UFont("Serif", 0, 9);
    private final FontConfiguration fontConfig = new FontConfiguration(this.font, HtmlColorUtils.BLACK);

    public TimeHeaderDay(Day day, Day day2, TimeLine timeLine, double d) {
        this.start = day;
        this.end = day2;
        this.timeline = timeLine;
        this.dayWidth = d;
    }

    public void drawU(UGraphic uGraphic) {
        int n = 0;
        Day day = this.start;
        while (day.compareTo(this.end) <= 0) {
            String string = "" + day.getNumDay();
            TextBlock textBlock = TextBlockUtils.create(Display.create(string), this.fontConfig, HorizontalAlignment.LEFT, new SpriteContainerEmpty());
            Dimension2D dimension2D = textBlock.calculateDimension(uGraphic.getStringBounder());
            double d = this.dayWidth - dimension2D.getWidth();
            double d2 = this.getHeight() - dimension2D.getHeight();
            uGraphic = uGraphic.apply(new UChangeColor(HtmlColorUtils.BLACK));
            uGraphic = uGraphic.apply(new UChangeBackColor(HtmlColorUtils.WHITE));
            uGraphic.apply(new UTranslate((double)n * this.dayWidth, 0.0)).draw(new URectangle(this.dayWidth, this.getHeight()));
            textBlock.drawU(uGraphic.apply(new UTranslate((double)n * this.dayWidth + d / 2.0, d2 / 2.0)));
            ++n;
            day = (Day)this.timeline.next(day);
        }
    }

    private double getHeight() {
        return 20.0;
    }

    public Dimension2D calculateDimension(StringBounder stringBounder) {
        int n = 0;
        Day day = this.start;
        while (day.compareTo(this.end) <= 0) {
            ++n;
            day = (Day)this.timeline.next(day);
        }
        return new Dimension2DDouble((double)n * this.dayWidth, this.getHeight());
    }
}

