/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.schemaspy.model.TableColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableIndex
implements Comparable<TableIndex> {
    private final String name;
    private final boolean isUnique;
    private Object id;
    private boolean isPrimary;
    private final List<TableColumn> columns = new ArrayList<TableColumn>();
    private final List<Boolean> columnsAscending = new ArrayList<Boolean>();

    public TableIndex(ResultSet resultSet) throws SQLException {
        this.name = resultSet.getString("INDEX_NAME");
        this.isUnique = !resultSet.getBoolean("NON_UNIQUE");
    }

    public void setId(Object object) {
        this.id = object;
    }

    public Object getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    void addColumn(TableColumn tableColumn, String string) {
        if (tableColumn != null) {
            this.columns.add(tableColumn);
            this.columnsAscending.add(string == null || string.equals("A"));
        }
    }

    public String getType() {
        if (this.isPrimaryKey()) {
            return "Primary key";
        }
        if (this.isUnique()) {
            return "Must be unique";
        }
        return "Performance";
    }

    public boolean isPrimaryKey() {
        return this.isPrimary;
    }

    public void setIsPrimaryKey(boolean bl) {
        this.isPrimary = bl;
    }

    public boolean isUnique() {
        return this.isUnique;
    }

    public String getColumnsAsString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (TableColumn tableColumn : this.columns) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" + ");
            }
            stringBuilder.append(tableColumn);
        }
        return stringBuilder.toString();
    }

    public List<TableColumn> getColumns() {
        return Collections.unmodifiableList(this.columns);
    }

    public boolean isUniqueNullable() {
        TableColumn tableColumn;
        if (!this.isUnique()) {
            return false;
        }
        boolean bl = true;
        Iterator<TableColumn> iterator = this.getColumns().iterator();
        while (iterator.hasNext() && (bl = (tableColumn = iterator.next()) != null && tableColumn.isNullable())) {
        }
        return bl;
    }

    public boolean isAscending(TableColumn tableColumn) {
        return this.columnsAscending.get(this.columns.indexOf(tableColumn));
    }

    @Override
    public int compareTo(TableIndex tableIndex) {
        if (this.isPrimaryKey() && !tableIndex.isPrimaryKey()) {
            return -1;
        }
        if (!this.isPrimaryKey() && tableIndex.isPrimaryKey()) {
            return 1;
        }
        Object object = this.getId();
        Object object2 = tableIndex.getId();
        if (object == null || object2 == null) {
            return this.getName().compareToIgnoreCase(tableIndex.getName());
        }
        if (object instanceof Number) {
            return ((Number)object).intValue() - ((Number)object2).intValue();
        }
        return object.toString().compareToIgnoreCase(object2.toString());
    }
}

