/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.util.HashMap;
import org.armedbear.lisp.ControlTransfer;
import org.armedbear.lisp.Debug;
import org.armedbear.lisp.Function;
import org.armedbear.lisp.JavaClassLoader;
import org.armedbear.lisp.JavaObject;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispError;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Primitive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryClassLoader
extends JavaClassLoader {
    private final HashMap<String, JavaObject> hashtable = new HashMap();
    private final JavaObject boxedThis = new JavaObject(this);
    private final String internalNamePrefix;
    private static final Primitive MAKE_MEMORY_CLASS_LOADER = new pf_make_memory_class_loader();
    private static final Primitive PUT_MEMORY_FUNCTION = new pf_put_memory_function();
    private static final Primitive GET_MEMORY_FUNCTION = new pf_get_memory_function();

    public MemoryClassLoader() {
        this("org/armedbear/lisp/");
    }

    public MemoryClassLoader(String internalNamePrefix) {
        this.internalNamePrefix = internalNamePrefix;
    }

    public MemoryClassLoader(JavaClassLoader parent) {
        super(parent);
        this.internalNamePrefix = "";
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c;
        if (this.hashtable.containsKey(name)) {
            String internalName = this.internalNamePrefix + name;
            Class<?> c2 = this.findLoadedClass(internalName);
            if (c2 == null) {
                c2 = this.findClass(name);
            }
            if (c2 != null) {
                if (resolve) {
                    this.resolveClass(c2);
                }
                return c2;
            }
        }
        if (checkPreCompiledClassLoader && (c = this.findPrecompiledClassOrNull(name)) != null) {
            return c;
        }
        return super.loadClass(name, resolve);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        try {
            Class<?> c;
            if (checkPreCompiledClassLoader && (c = this.findPrecompiledClassOrNull(name)) != null) {
                return c;
            }
            byte[] b = this.getFunctionClassBytes(name);
            return this.defineLispClass(name, b, 0, b.length);
        }
        catch (Throwable e) {
            e.printStackTrace();
            if (e instanceof ControlTransfer) {
                throw (ControlTransfer)e;
            }
            throw new ClassNotFoundException("Function class not found: " + name, e);
        }
    }

    @Override
    public byte[] getFunctionClassBytes(String name) {
        if (this.hashtable.containsKey(name)) {
            return (byte[])this.hashtable.get(name).javaInstance();
        }
        return super.getFunctionClassBytes(name);
    }

    public LispObject loadFunction(String name) {
        try {
            Class<?> clz = this.loadClass(name);
            Function f = (Function)clz.newInstance();
            this.getFunctionClassBytes(f);
            return f;
        }
        catch (Throwable e) {
            if (e instanceof ControlTransfer) {
                throw (ControlTransfer)e;
            }
            Debug.trace(e);
            return Lisp.error(new LispError("Compiled function can't be loaded: " + name + " from memory"));
        }
    }

    private static final class pf_get_memory_function
    extends Primitive {
        pf_get_memory_function() {
            super("get-memory-function", Lisp.PACKAGE_SYS, false, "loader class-name");
        }

        public LispObject execute(LispObject loader, LispObject name) {
            MemoryClassLoader l = (MemoryClassLoader)loader.javaInstance(MemoryClassLoader.class);
            return l.loadFunction(name.getStringValue());
        }
    }

    private static final class pf_put_memory_function
    extends Primitive {
        pf_put_memory_function() {
            super("put-memory-function", Lisp.PACKAGE_SYS, false, "loader class-name class-bytes");
        }

        public LispObject execute(LispObject loader, LispObject className, LispObject classBytes) {
            MemoryClassLoader l = (MemoryClassLoader)loader.javaInstance(MemoryClassLoader.class);
            return l.hashtable.put(className.getStringValue(), (JavaObject)classBytes);
        }
    }

    private static final class pf_make_memory_class_loader
    extends Primitive {
        pf_make_memory_class_loader() {
            super("make-memory-class-loader", Lisp.PACKAGE_SYS, false);
        }

        public LispObject execute() {
            return new MemoryClassLoader().boxedThis;
        }
    }
}

