/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.CellError;
import org.armedbear.lisp.Keyword;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.SpecialBindingsMark;
import org.armedbear.lisp.StandardClass;
import org.armedbear.lisp.Symbol;

public final class UnboundSlot
extends CellError {
    public UnboundSlot(LispObject initArgs) {
        super(StandardClass.UNBOUND_SLOT);
        this.initialize(initArgs);
    }

    protected void initialize(LispObject initArgs) {
        super.initialize(initArgs);
        while (initArgs != Lisp.NIL) {
            LispObject first = initArgs.car();
            initArgs = initArgs.cdr();
            if (first == Keyword.INSTANCE) {
                this.setInstance(initArgs.car());
                break;
            }
            initArgs = initArgs.cdr();
        }
    }

    public LispObject getInstance() {
        return this.getInstanceSlotValue(Symbol.INSTANCE);
    }

    private void setInstance(LispObject instance) {
        this.setInstanceSlotValue(Symbol.INSTANCE, instance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMessage() {
        LispThread thread = LispThread.currentThread();
        SpecialBindingsMark mark = thread.markSpecialBindings();
        thread.bindSpecial(Symbol.PRINT_ESCAPE, Lisp.T);
        try {
            StringBuilder sb = new StringBuilder("The slot ");
            sb.append(this.getCellName().princToString());
            sb.append(" is unbound in the object ");
            sb.append(this.getInstance().princToString());
            sb.append('.');
            String string = sb.toString();
            Object var6_5 = null;
            thread.resetSpecialBindings(mark);
            return string;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            thread.resetSpecialBindings(mark);
            throw throwable;
        }
    }

    public LispObject typeOf() {
        return Symbol.UNBOUND_SLOT;
    }

    public LispObject classOf() {
        return StandardClass.UNBOUND_SLOT;
    }

    public LispObject typep(LispObject type) {
        if (type == Symbol.UNBOUND_SLOT) {
            return Lisp.T;
        }
        if (type == StandardClass.UNBOUND_SLOT) {
            return Lisp.T;
        }
        return super.typep(type);
    }
}

