/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.jcodings.specific.USASCIIEncoding;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyComplex;
import org.jruby.RubyEnumerator;
import org.jruby.RubyFloat;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyRational;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.common.IRubyWarnings;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.ByteList;
import org.jruby.util.ConvertBytes;
import org.jruby.util.Numeric;
import org.jruby.util.TypeCoercer;

@JRubyClass(name={"Fixnum"}, parent="Integer", include={"Precision"})
public class RubyFixnum
extends RubyInteger {
    private final long value;
    private static final int BIT_SIZE = 64;
    public static final long SIGN_BIT = Long.MIN_VALUE;
    public static final long MAX = Long.MAX_VALUE;
    public static final long MIN = Long.MIN_VALUE;
    public static final long MAX_MARSHAL_FIXNUM = 0x3FFFFFFFL;
    public static final long MIN_MARSHAL_FIXNUM = -1073741824L;
    public static final int CACHE_OFFSET = 256;
    private static final Map<Class, TypeCoercer> JAVA_COERCERS = new HashMap<Class, TypeCoercer>();

    public static RubyClass createFixnumClass(Ruby runtime) {
        RubyClass fixnum = runtime.defineClass("Fixnum", runtime.getInteger(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        runtime.setFixnum(fixnum);
        fixnum.index = 1;
        fixnum.setReifiedClass(RubyFixnum.class);
        fixnum.kindOf = new RubyModule.JavaClassKindOf(RubyFixnum.class);
        if (!runtime.is1_9()) {
            fixnum.includeModule(runtime.getPrecision());
        }
        fixnum.defineAnnotatedMethods(RubyFixnum.class);
        for (int i2 = 0; i2 < runtime.fixnumCache.length; ++i2) {
            runtime.fixnumCache[i2] = new RubyFixnum(fixnum, (long)(i2 - 256));
        }
        return fixnum;
    }

    private static IRubyObject fixCoerce(IRubyObject x) {
        while (!((x = x.convertToInteger()) instanceof RubyFixnum) && !(x instanceof RubyBignum)) {
        }
        return x;
    }

    private static IRubyObject bitCoerce(IRubyObject x) {
        do {
            if (!(x instanceof RubyFloat)) continue;
            throw x.getRuntime().newTypeError("can't convert Float to Integer");
        } while (!((x = x.convertToInteger("to_int")) instanceof RubyFixnum) && !(x instanceof RubyBignum));
        return x;
    }

    public RubyFixnum(Ruby runtime) {
        this(runtime, 0L);
    }

    public RubyFixnum(Ruby runtime, long value2) {
        super(runtime.getFixnum());
        this.value = value2;
    }

    private RubyFixnum(RubyClass klazz, long value2) {
        super(klazz);
        this.value = value2;
    }

    @Override
    public int getNativeTypeIndex() {
        return 1;
    }

    @Override
    public final boolean eql(IRubyObject other) {
        return other instanceof RubyFixnum && this.value == ((RubyFixnum)other).value;
    }

    @Override
    public IRubyObject equal_p(ThreadContext context, IRubyObject obj) {
        return this.equal_p19(context, obj);
    }

    @Override
    public IRubyObject equal_p19(ThreadContext context, IRubyObject obj) {
        return context.runtime.newBoolean(this == obj || this.eql(obj));
    }

    @Override
    public boolean isImmediate() {
        return true;
    }

    @Override
    public RubyClass getSingletonClass() {
        throw this.getRuntime().newTypeError("can't define singleton");
    }

    @Override
    public Class<?> getJavaClass() {
        return Long.TYPE;
    }

    @Override
    public double getDoubleValue() {
        return this.value;
    }

    @Override
    public long getLongValue() {
        return this.value;
    }

    @Override
    public BigInteger getBigIntegerValue() {
        return BigInteger.valueOf(this.value);
    }

    public static RubyFixnum newFixnum(Ruby runtime, long value2) {
        if (RubyFixnum.isInCacheRange(value2)) {
            return runtime.fixnumCache[(int)value2 + 256];
        }
        return new RubyFixnum(runtime, value2);
    }

    private static boolean isInCacheRange(long value2) {
        return value2 <= 255L && value2 >= -256L;
    }

    public RubyFixnum newFixnum(long newValue) {
        return RubyFixnum.newFixnum(this.getRuntime(), newValue);
    }

    public static RubyFixnum zero(Ruby runtime) {
        return runtime.fixnumCache[256];
    }

    public static RubyFixnum one(Ruby runtime) {
        return runtime.fixnumCache[257];
    }

    public static RubyFixnum two(Ruby runtime) {
        return runtime.fixnumCache[258];
    }

    public static RubyFixnum three(Ruby runtime) {
        return runtime.fixnumCache[259];
    }

    public static RubyFixnum four(Ruby runtime) {
        return runtime.fixnumCache[260];
    }

    public static RubyFixnum five(Ruby runtime) {
        return runtime.fixnumCache[261];
    }

    public static RubyFixnum minus_one(Ruby runtime) {
        return runtime.fixnumCache[255];
    }

    @Override
    public RubyFixnum hash() {
        return this.newFixnum(this.hashCode());
    }

    @Override
    public final int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof RubyFixnum) {
            RubyFixnum num = (RubyFixnum)other;
            if (num.value == this.value) {
                return true;
            }
        }
        return false;
    }

    @Override
    @JRubyMethod
    public IRubyObject times(ThreadContext context, Block block) {
        if (block.isGiven()) {
            Ruby runtime = context.runtime;
            long lvalue = this.value;
            boolean checkArity = block.type.checkArity;
            if (block.getBody().getArgumentType() == 0 || block.arity() == Arity.NO_ARGUMENTS) {
                if (checkArity) {
                    IRubyObject nil = runtime.getNil();
                    for (long i2 = 0L; i2 < lvalue; ++i2) {
                        block.yieldSpecific(context, nil);
                    }
                } else {
                    for (long i3 = 0L; i3 < lvalue; ++i3) {
                        block.yieldSpecific(context);
                    }
                }
            } else {
                for (long i4 = 0L; i4 < lvalue; ++i4) {
                    block.yield(context, RubyFixnum.newFixnum(runtime, i4));
                }
            }
            return this;
        }
        return RubyEnumerator.enumeratorize(context.runtime, this, "times");
    }

    public RubyString to_s(IRubyObject[] args2) {
        switch (args2.length) {
            case 0: {
                return this.to_s();
            }
            case 1: {
                return this.to_s(args2[0]);
            }
        }
        throw this.getRuntime().newArgumentError(args2.length, 1);
    }

    @Override
    @JRubyMethod
    public RubyString to_s() {
        ByteList bl = ConvertBytes.longToByteList(this.value, 10);
        RubyString str = this.getRuntime().newString(bl);
        if (this.getRuntime().is1_9()) {
            str.setEncoding(USASCIIEncoding.INSTANCE);
        }
        return str;
    }

    @JRubyMethod
    public RubyString to_s(IRubyObject arg0) {
        int base = RubyFixnum.num2int(arg0);
        if (base < 2 || base > 36) {
            throw this.getRuntime().newArgumentError("illegal radix " + base);
        }
        ByteList bl = ConvertBytes.longToByteList(this.value, base);
        if (this.getRuntime().is1_9()) {
            bl.setEncoding(USASCIIEncoding.INSTANCE);
        }
        return this.getRuntime().newString(bl);
    }

    @JRubyMethod
    public IRubyObject id2name() {
        RubySymbol symbol = RubySymbol.getSymbolLong(this.getRuntime(), this.value);
        if (symbol != null) {
            return this.getRuntime().newString(symbol.asJavaString());
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_8)
    public IRubyObject to_sym() {
        RubySymbol symbol = RubySymbol.getSymbolLong(this.getRuntime(), this.value);
        return symbol != null ? symbol : this.getRuntime().getNil();
    }

    @JRubyMethod(name={"-@"})
    public IRubyObject op_uminus() {
        if (this.value == Long.MIN_VALUE) {
            return RubyBignum.newBignum(this.getRuntime(), BigInteger.valueOf(this.value).negate());
        }
        return RubyFixnum.newFixnum(this.getRuntime(), -this.value);
    }

    @JRubyMethod(name={"+"})
    public IRubyObject op_plus(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return this.addFixnum(context, (RubyFixnum)other);
        }
        return this.addOther(context, other);
    }

    public IRubyObject op_plus(ThreadContext context, long otherValue) {
        long result2 = this.value + otherValue;
        if (RubyFixnum.additionOverflowed(this.value, otherValue, result2)) {
            return this.addAsBignum(context, otherValue);
        }
        return RubyFixnum.newFixnum(context.runtime, result2);
    }

    public IRubyObject op_plus_one(ThreadContext context) {
        long result2 = this.value + 1L;
        if (result2 == Long.MIN_VALUE) {
            return this.addAsBignum(context, 1L);
        }
        return RubyFixnum.newFixnum(context.runtime, result2);
    }

    public IRubyObject op_plus_two(ThreadContext context) {
        long result2 = this.value + 2L;
        if (result2 < this.value) {
            return this.addAsBignum(context, 2L);
        }
        return RubyFixnum.newFixnum(context.runtime, result2);
    }

    private IRubyObject addFixnum(ThreadContext context, RubyFixnum other) {
        long otherValue = other.value;
        long result2 = this.value + otherValue;
        if (RubyFixnum.additionOverflowed(this.value, otherValue, result2)) {
            return this.addAsBignum(context, other);
        }
        return RubyFixnum.newFixnum(context.runtime, result2);
    }

    private static boolean additionOverflowed(long original, long other, long result2) {
        return ((original ^ other ^ 0xFFFFFFFFFFFFFFFFL) & (original ^ result2) & Long.MIN_VALUE) != 0L;
    }

    private static boolean subtractionOverflowed(long original, long other, long result2) {
        return ((original ^ (other ^ 0xFFFFFFFFFFFFFFFFL) ^ 0xFFFFFFFFFFFFFFFFL) & (original ^ result2) & Long.MIN_VALUE) != 0L;
    }

    private IRubyObject addAsBignum(ThreadContext context, RubyFixnum other) {
        return RubyBignum.newBignum(context.runtime, this.value).op_plus(context, other);
    }

    private IRubyObject addAsBignum(ThreadContext context, long other) {
        return RubyBignum.newBignum(context.runtime, this.value).op_plus(context, other);
    }

    private IRubyObject addOther(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyBignum) {
            return ((RubyBignum)other).op_plus(context, this);
        }
        if (other instanceof RubyFloat) {
            return context.runtime.newFloat((double)this.value + ((RubyFloat)other).getDoubleValue());
        }
        return this.coerceBin(context, "+", other);
    }

    @JRubyMethod(name={"-"})
    public IRubyObject op_minus(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return this.subtractFixnum(context, (RubyFixnum)other);
        }
        return this.subtractOther(context, other);
    }

    public IRubyObject op_minus(ThreadContext context, long otherValue) {
        long result2 = this.value - otherValue;
        if (RubyFixnum.subtractionOverflowed(this.value, otherValue, result2)) {
            return this.subtractAsBignum(context, otherValue);
        }
        return RubyFixnum.newFixnum(context.runtime, result2);
    }

    public IRubyObject op_minus_one(ThreadContext context) {
        long result2 = this.value - 1L;
        if (result2 == Long.MAX_VALUE) {
            return this.subtractAsBignum(context, 1L);
        }
        return RubyFixnum.newFixnum(context.runtime, result2);
    }

    public IRubyObject op_minus_two(ThreadContext context) {
        long result2 = this.value - 2L;
        if (this.value < result2) {
            return this.subtractAsBignum(context, 2L);
        }
        return RubyFixnum.newFixnum(context.runtime, result2);
    }

    private IRubyObject subtractFixnum(ThreadContext context, RubyFixnum other) {
        long otherValue = other.value;
        long result2 = this.value - otherValue;
        if (RubyFixnum.subtractionOverflowed(this.value, otherValue, result2)) {
            return this.subtractAsBignum(context, other);
        }
        return RubyFixnum.newFixnum(context.runtime, result2);
    }

    private IRubyObject subtractAsBignum(ThreadContext context, RubyFixnum other) {
        return RubyBignum.newBignum(context.runtime, this.value).op_minus(context, other);
    }

    private IRubyObject subtractAsBignum(ThreadContext context, long other) {
        return RubyBignum.newBignum(context.runtime, this.value).op_minus(context, other);
    }

    private IRubyObject subtractOther(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyBignum) {
            return RubyBignum.newBignum(context.runtime, this.value).op_minus(context, other);
        }
        if (other instanceof RubyFloat) {
            return context.runtime.newFloat((double)this.value - ((RubyFloat)other).getDoubleValue());
        }
        return this.coerceBin(context, "-", other);
    }

    @JRubyMethod(name={"*"})
    public IRubyObject op_mul(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return this.op_mul(context, ((RubyFixnum)other).value);
        }
        return this.multiplyOther(context, other);
    }

    private IRubyObject multiplyOther(ThreadContext context, IRubyObject other) {
        Ruby runtime = context.runtime;
        if (other instanceof RubyBignum) {
            return ((RubyBignum)other).op_mul(context, this);
        }
        if (other instanceof RubyFloat) {
            return runtime.newFloat((double)this.value * ((RubyFloat)other).getDoubleValue());
        }
        return this.coerceBin(context, "*", other);
    }

    public IRubyObject op_mul(ThreadContext context, long otherValue) {
        Ruby runtime = context.runtime;
        long value2 = this.value;
        if (value2 <= 3037000499L && otherValue <= 3037000499L && value2 >= -3037000499L && otherValue >= -3037000499L) {
            return RubyFixnum.newFixnum(runtime, value2 * otherValue);
        }
        if (value2 == 0L || otherValue == 0L) {
            return RubyFixnum.zero(runtime);
        }
        if (value2 == -1L) {
            if (otherValue != Long.MIN_VALUE) {
                return RubyFixnum.newFixnum(runtime, -otherValue);
            }
        } else {
            long result2 = value2 * otherValue;
            if (result2 / value2 == otherValue) {
                return RubyFixnum.newFixnum(runtime, result2);
            }
        }
        return RubyBignum.newBignum(runtime, value2).op_mul(context, otherValue);
    }

    @JRubyMethod(name={"div"})
    public IRubyObject div_div(ThreadContext context, IRubyObject other) {
        if (context.is19) {
            this.checkZeroDivisionError(context, other);
        }
        return this.idiv(context, other, "div");
    }

    @JRubyMethod(name={"/"})
    public IRubyObject op_div(ThreadContext context, IRubyObject other) {
        return this.idiv(context, other, "/");
    }

    public IRubyObject op_div(ThreadContext context, long other) {
        return this.idiv(context, other, "/");
    }

    @Override
    @JRubyMethod(name={"odd?"}, compat=CompatVersion.RUBY1_9)
    public RubyBoolean odd_p(ThreadContext context) {
        if (this.value % 2L != 0L) {
            return context.runtime.getTrue();
        }
        return context.runtime.getFalse();
    }

    @Override
    @JRubyMethod(name={"even?"}, compat=CompatVersion.RUBY1_9)
    public RubyBoolean even_p(ThreadContext context) {
        if (this.value % 2L == 0L) {
            return context.runtime.getTrue();
        }
        return context.runtime.getFalse();
    }

    @Override
    @JRubyMethod(compat=CompatVersion.RUBY1_9)
    public IRubyObject pred(ThreadContext context) {
        return context.runtime.newFixnum(this.value - 1L);
    }

    public IRubyObject idiv(ThreadContext context, IRubyObject other, String method2) {
        if (other instanceof RubyFixnum) {
            return this.idivLong(context, this.value, ((RubyFixnum)other).value);
        }
        return this.coerceBin(context, method2, other);
    }

    public IRubyObject idiv(ThreadContext context, long y, String method2) {
        long x = this.value;
        return this.idivLong(context, x, y);
    }

    private IRubyObject idivLong(ThreadContext context, long x, long y) {
        long result2;
        Ruby runtime = context.runtime;
        if (y == 0L) {
            throw runtime.newZeroDivisionError();
        }
        if (y > 0L) {
            result2 = x >= 0L ? x / y : (x + 1L) / y - 1L;
        } else if (x > 0L) {
            result2 = (x - 1L) / y - 1L;
        } else if (y == -1L) {
            if (x == Long.MIN_VALUE) {
                return RubyBignum.newBignum(runtime, BigInteger.valueOf(x).negate());
            }
            result2 = -x;
        } else {
            result2 = x / y;
        }
        return runtime.newFixnum(result2);
    }

    @JRubyMethod(name={"%", "modulo"})
    public IRubyObject op_mod(ThreadContext context, IRubyObject other) {
        if (context.runtime.is1_9()) {
            this.checkZeroDivisionError(context, other);
        }
        if (other instanceof RubyFixnum) {
            return this.moduloFixnum(context, (RubyFixnum)other);
        }
        return this.coerceBin(context, "%", other);
    }

    public IRubyObject op_mod(ThreadContext context, long other) {
        return this.moduloFixnum(context, other);
    }

    private IRubyObject moduloFixnum(ThreadContext context, RubyFixnum other) {
        return this.moduloFixnum(context, other.value);
    }

    private IRubyObject moduloFixnum(ThreadContext context, long other) {
        long x = this.value;
        long y = other;
        if (y == 0L) {
            throw context.runtime.newZeroDivisionError();
        }
        long mod = x % y;
        if (mod < 0L && y > 0L || mod > 0L && y < 0L) {
            mod += y;
        }
        return context.runtime.newFixnum(mod);
    }

    @Override
    @JRubyMethod(name={"divmod"})
    public IRubyObject divmod(ThreadContext context, IRubyObject other) {
        if (context.runtime.is1_9()) {
            this.checkZeroDivisionError(context, other);
        }
        if (other instanceof RubyFixnum) {
            return this.divmodFixnum(context, other);
        }
        return this.coerceBin(context, "divmod", other);
    }

    private IRubyObject divmodFixnum(ThreadContext context, IRubyObject other) {
        long mod;
        RubyInteger integerDiv;
        long x = this.value;
        long y = ((RubyFixnum)other).value;
        Ruby runtime = context.runtime;
        if (y == 0L) {
            throw runtime.newZeroDivisionError();
        }
        if (y == -1L) {
            integerDiv = x == Long.MIN_VALUE ? RubyBignum.newBignum(runtime, BigInteger.valueOf(x).negate()) : RubyFixnum.newFixnum(runtime, -x);
            mod = 0L;
        } else {
            long div2 = x / y;
            mod = x - y * div2;
            if (mod < 0L && y > 0L || mod > 0L && y < 0L) {
                --div2;
                mod += y;
            }
            integerDiv = RubyFixnum.newFixnum(runtime, div2);
        }
        RubyFixnum fixMod = RubyFixnum.newFixnum(runtime, mod);
        return RubyArray.newArray(runtime, integerDiv, fixMod);
    }

    @Override
    @JRubyMethod(name={"quo"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject quo(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return RubyFloat.newFloat(context.runtime, (double)this.value / (double)((RubyFixnum)other).value);
        }
        if (other instanceof RubyBignum) {
            return RubyFloat.newFloat(context.runtime, (double)this.value / ((RubyBignum)other).getDoubleValue());
        }
        return this.coerceBin(context, "quo", other);
    }

    @JRubyMethod(name={"**"})
    public IRubyObject op_pow(ThreadContext context, IRubyObject other) {
        if (context.is19) {
            return this.op_pow_19(context, other);
        }
        if (other instanceof RubyFixnum) {
            return this.powerFixnum(context, ((RubyFixnum)other).value);
        }
        return this.powerOther(context, other);
    }

    public IRubyObject op_pow(ThreadContext context, long other) {
        if (context.is19) {
            throw context.runtime.newRuntimeError("bug: using direct op_pow(long) in 1.8 mode");
        }
        return this.powerFixnum(context, other);
    }

    private IRubyObject powerFixnum(ThreadContext context, long other) {
        Ruby runtime = context.runtime;
        if (other == 0L) {
            return RubyFixnum.one(runtime);
        }
        if (other == 1L) {
            return this;
        }
        if (other > 0L) {
            return RubyBignum.newBignum(runtime, this.value).op_pow(context, other);
        }
        return RubyFloat.newFloat(runtime, Math.pow(this.value, other));
    }

    private IRubyObject powerOther(ThreadContext context, IRubyObject other) {
        Ruby runtime = context.runtime;
        if (other instanceof RubyFloat) {
            return RubyFloat.newFloat(runtime, Math.pow(this.value, ((RubyFloat)other).getDoubleValue()));
        }
        return this.coerceBin(context, "**", other);
    }

    public IRubyObject op_pow_19(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyNumeric) {
            double d_other = ((RubyNumeric)other).getDoubleValue();
            if (this.value < 0L && d_other != (double)Math.round(d_other)) {
                return RubyComplex.newComplexRaw(this.getRuntime(), this).callMethod(context, "**", other);
            }
            if (other instanceof RubyFixnum) {
                return this.powerFixnum19(context, other);
            }
        }
        return this.powerOther19(context, other);
    }

    private IRubyObject powerOther19(ThreadContext context, IRubyObject other) {
        Ruby runtime = context.runtime;
        long a = this.value;
        if (other instanceof RubyBignum) {
            if (other.callMethod(context, "<", RubyFixnum.zero(runtime)).isTrue()) {
                return RubyRational.newRationalRaw(runtime, this).callMethod(context, "**", other);
            }
            if (a == 0L) {
                return RubyFixnum.zero(runtime);
            }
            if (a == 1L) {
                return RubyFixnum.one(runtime);
            }
            if (a == -1L) {
                return ((RubyBignum)other).even_p(context).isTrue() ? RubyFixnum.one(runtime) : RubyFixnum.minus_one(runtime);
            }
            RubyBignum.newBignum(runtime, RubyBignum.fix2big(this)).op_pow(context, other);
        } else if (other instanceof RubyFloat) {
            double b2 = ((RubyFloat)other).getValue();
            if (b2 == 0.0 || a == 1L) {
                return runtime.newFloat(1.0);
            }
            if (a == 0L) {
                return runtime.newFloat(b2 < 0.0 ? Double.POSITIVE_INFINITY : 0.0);
            }
            return RubyFloat.newFloat(runtime, Math.pow(a, b2));
        }
        return this.coerceBin(context, "**", other);
    }

    private IRubyObject powerFixnum19(ThreadContext context, IRubyObject other) {
        Ruby runtime = context.runtime;
        long a = this.value;
        long b2 = ((RubyFixnum)other).value;
        if (b2 < 0L) {
            return RubyRational.newRationalRaw(runtime, this).callMethod(context, "**", other);
        }
        if (b2 == 0L) {
            return RubyFixnum.one(runtime);
        }
        if (b2 == 1L) {
            return this;
        }
        if (a == 0L) {
            return b2 > 0L ? RubyFixnum.zero(runtime) : RubyNumeric.dbl2num(runtime, Double.POSITIVE_INFINITY);
        }
        if (a == 1L) {
            return RubyFixnum.one(runtime);
        }
        if (a == -1L) {
            return b2 % 2L == 0L ? RubyFixnum.one(runtime) : RubyFixnum.minus_one(runtime);
        }
        return Numeric.int_pow(context, a, b2);
    }

    @Override
    @JRubyMethod
    public IRubyObject abs(ThreadContext context) {
        if (this.value < 0L) {
            if (this.value == Long.MIN_VALUE) {
                return RubyBignum.newBignum(context.runtime, BigInteger.valueOf(this.value).negate());
            }
            return RubyFixnum.newFixnum(context.runtime, -this.value);
        }
        return this;
    }

    @Override
    @JRubyMethod(name={"magnitude"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject magnitude(ThreadContext context) {
        return this.abs(context);
    }

    @Override
    @JRubyMethod(name={"=="})
    public IRubyObject op_equal(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return this.op_equal(context, ((RubyFixnum)other).value);
        }
        return context.is19 ? this.op_equalOther(context, other) : super.op_num_equal(context, other);
    }

    public IRubyObject op_equal(ThreadContext context, long other) {
        return RubyBoolean.newBoolean(context.runtime, this.value == other);
    }

    public boolean op_equal_boolean(ThreadContext context, long other) {
        return this.value == other;
    }

    public boolean fastEqual(RubyFixnum other) {
        return this.value == other.value;
    }

    private IRubyObject op_equalOther(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyBignum) {
            return RubyBoolean.newBoolean(context.runtime, BigInteger.valueOf(this.value).compareTo(((RubyBignum)other).getValue()) == 0);
        }
        if (other instanceof RubyFloat) {
            return RubyBoolean.newBoolean(context.runtime, (double)this.value == ((RubyFloat)other).getDoubleValue());
        }
        return super.op_num_equal(context, other);
    }

    @Override
    public final int compareTo(IRubyObject other) {
        if (other instanceof RubyFixnum) {
            long otherValue = ((RubyFixnum)other).value;
            return this.value == otherValue ? 0 : (this.value > otherValue ? 1 : -1);
        }
        return this.compareToOther(other);
    }

    private int compareToOther(IRubyObject other) {
        if (other instanceof RubyBignum) {
            return BigInteger.valueOf(this.value).compareTo(((RubyBignum)other).getValue());
        }
        if (other instanceof RubyFloat) {
            return Double.compare(this.value, ((RubyFloat)other).getDoubleValue());
        }
        return (int)this.coerceCmp(this.getRuntime().getCurrentContext(), "<=>", other).convertToInteger().getLongValue();
    }

    @Override
    @JRubyMethod(name={"<=>"})
    public IRubyObject op_cmp(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return this.op_cmp(context, ((RubyFixnum)other).value);
        }
        return context.is19 ? this.compareOther(context, other) : this.coerceCmp(context, "<=>", other);
    }

    public IRubyObject op_cmp(ThreadContext context, long other) {
        Ruby runtime = context.runtime;
        return this.value == other ? RubyFixnum.zero(runtime) : (this.value > other ? RubyFixnum.one(runtime) : RubyFixnum.minus_one(runtime));
    }

    private IRubyObject compareOther(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyBignum) {
            return RubyFixnum.newFixnum(context.runtime, BigInteger.valueOf(this.value).compareTo(((RubyBignum)other).getValue()));
        }
        if (other instanceof RubyFloat) {
            return RubyFixnum.dbl_cmp(context.runtime, this.value, ((RubyFloat)other).getDoubleValue());
        }
        return this.coerceCmp(context, "<=>", other);
    }

    @JRubyMethod(name={">"})
    public IRubyObject op_gt(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return RubyBoolean.newBoolean(context.runtime, this.value > ((RubyFixnum)other).value);
        }
        return context.is19 ? this.op_gtOther(context, other) : this.coerceRelOp(context, ">", other);
    }

    public IRubyObject op_gt(ThreadContext context, long other) {
        return RubyBoolean.newBoolean(context.runtime, this.value > other);
    }

    public boolean op_gt_boolean(ThreadContext context, long other) {
        return this.value > other;
    }

    private IRubyObject op_gtOther(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyBignum) {
            return RubyBoolean.newBoolean(context.runtime, BigInteger.valueOf(this.value).compareTo(((RubyBignum)other).getValue()) > 0);
        }
        if (other instanceof RubyFloat) {
            return RubyBoolean.newBoolean(context.runtime, (double)this.value > ((RubyFloat)other).getDoubleValue());
        }
        return this.coerceRelOp(context, ">", other);
    }

    @JRubyMethod(name={">="})
    public IRubyObject op_ge(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return RubyBoolean.newBoolean(context.runtime, this.value >= ((RubyFixnum)other).value);
        }
        return context.is19 ? this.op_geOther(context, other) : this.coerceRelOp(context, ">=", other);
    }

    public IRubyObject op_ge(ThreadContext context, long other) {
        return RubyBoolean.newBoolean(context.runtime, this.value >= other);
    }

    public boolean op_ge_boolean(ThreadContext context, long other) {
        return this.value >= other;
    }

    private IRubyObject op_geOther(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyBignum) {
            return RubyBoolean.newBoolean(context.runtime, BigInteger.valueOf(this.value).compareTo(((RubyBignum)other).getValue()) >= 0);
        }
        if (other instanceof RubyFloat) {
            return RubyBoolean.newBoolean(context.runtime, (double)this.value >= ((RubyFloat)other).getDoubleValue());
        }
        return this.coerceRelOp(context, ">=", other);
    }

    @JRubyMethod(name={"<"})
    public IRubyObject op_lt(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return this.op_lt(context, ((RubyFixnum)other).value);
        }
        return this.op_ltOther(context, other);
    }

    public IRubyObject op_lt(ThreadContext context, long other) {
        return RubyBoolean.newBoolean(context.runtime, this.value < other);
    }

    public boolean op_lt_boolean(ThreadContext context, long other) {
        return this.value < other;
    }

    private IRubyObject op_ltOther(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyBignum) {
            return RubyBoolean.newBoolean(context.runtime, BigInteger.valueOf(this.value).compareTo(((RubyBignum)other).getValue()) < 0);
        }
        if (other instanceof RubyFloat) {
            return RubyBoolean.newBoolean(context.runtime, (double)this.value < ((RubyFloat)other).getDoubleValue());
        }
        return this.coerceRelOp(context, "<", other);
    }

    @JRubyMethod(name={"<="})
    public IRubyObject op_le(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum) {
            return RubyBoolean.newBoolean(context.runtime, this.value <= ((RubyFixnum)other).value);
        }
        return context.is19 ? this.op_leOther(context, other) : this.coerceRelOp(context, "<=", other);
    }

    public IRubyObject op_le(ThreadContext context, long other) {
        return RubyBoolean.newBoolean(context.runtime, this.value <= other);
    }

    public boolean op_le_boolean(ThreadContext context, long other) {
        return this.value <= other;
    }

    private IRubyObject op_leOther(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyBignum) {
            return RubyBoolean.newBoolean(context.runtime, BigInteger.valueOf(this.value).compareTo(((RubyBignum)other).getValue()) <= 0);
        }
        if (other instanceof RubyFloat) {
            return RubyBoolean.newBoolean(context.runtime, (double)this.value <= ((RubyFloat)other).getDoubleValue());
        }
        return this.coerceRelOp(context, "<=", other);
    }

    @JRubyMethod(name={"~"})
    public IRubyObject op_neg() {
        return this.newFixnum(this.value ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @JRubyMethod(name={"&"})
    public IRubyObject op_and(ThreadContext context, IRubyObject other) {
        if (context.is19) {
            return this.op_and19(context, other);
        }
        return this.op_and18(context, other);
    }

    private IRubyObject op_and18(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum || (other = RubyFixnum.fixCoerce(other)) instanceof RubyFixnum) {
            return RubyFixnum.newFixnum(context.runtime, this.value & ((RubyFixnum)other).value);
        }
        return ((RubyBignum)other).op_and(context, this);
    }

    public IRubyObject op_and(ThreadContext context, long other) {
        return RubyFixnum.newFixnum(context.runtime, this.value & other);
    }

    private IRubyObject op_and19(ThreadContext context, IRubyObject other) {
        if (!((other = RubyFixnum.bitCoerce(other)) instanceof RubyFixnum)) {
            return ((RubyBignum)other).op_and(context, this);
        }
        return this.op_and18(context, other);
    }

    @JRubyMethod(name={"|"})
    public IRubyObject op_or(ThreadContext context, IRubyObject other) {
        if (context.is19) {
            return this.op_or19(context, other);
        }
        return this.op_or18(context, other);
    }

    private IRubyObject op_or18(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum || (other = RubyFixnum.fixCoerce(other)) instanceof RubyFixnum) {
            return RubyFixnum.newFixnum(context.runtime, this.value | ((RubyFixnum)other).value);
        }
        return ((RubyBignum)other).op_or(context, this);
    }

    public IRubyObject op_or(ThreadContext context, long other) {
        return RubyFixnum.newFixnum(context.runtime, this.value | other);
    }

    private IRubyObject op_or19(ThreadContext context, IRubyObject other) {
        if (!((other = RubyFixnum.bitCoerce(other)) instanceof RubyFixnum)) {
            return ((RubyBignum)other).op_or(context, this);
        }
        return this.op_or18(context, other);
    }

    @JRubyMethod(name={"^"})
    public IRubyObject op_xor(ThreadContext context, IRubyObject other) {
        if (context.is19) {
            return this.op_xor19(context, other);
        }
        return this.op_xor18(context, other);
    }

    private IRubyObject op_xor18(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFixnum || (other = RubyFixnum.fixCoerce(other)) instanceof RubyFixnum) {
            return RubyFixnum.newFixnum(context.runtime, this.value ^ ((RubyFixnum)other).value);
        }
        return ((RubyBignum)other).op_xor(context, this);
    }

    public IRubyObject op_xor(ThreadContext context, long other) {
        return RubyFixnum.newFixnum(context.runtime, this.value ^ other);
    }

    private IRubyObject op_xor19(ThreadContext context, IRubyObject other) {
        if (!((other = RubyFixnum.bitCoerce(other)) instanceof RubyFixnum)) {
            return ((RubyBignum)other).op_xor(context, this);
        }
        return this.op_xor18(context, other);
    }

    @JRubyMethod(name={"[]"})
    public IRubyObject op_aref(IRubyObject other) {
        long otherValue;
        if (!(other instanceof RubyFixnum) && !((other = RubyFixnum.fixCoerce(other)) instanceof RubyFixnum)) {
            RubyBignum big = (RubyBignum)other;
            other = RubyBignum.bignorm(this.getRuntime(), big.getValue());
            if (!(other instanceof RubyFixnum)) {
                return big.getValue().signum() == 0 || this.value >= 0L ? RubyFixnum.zero(this.getRuntime()) : RubyFixnum.one(this.getRuntime());
            }
        }
        if ((otherValue = RubyFixnum.fix2long(other)) < 0L) {
            return RubyFixnum.zero(this.getRuntime());
        }
        if (63L < otherValue) {
            return this.value < 0L ? RubyFixnum.one(this.getRuntime()) : RubyFixnum.zero(this.getRuntime());
        }
        return (this.value & 1L << (int)otherValue) == 0L ? RubyFixnum.zero(this.getRuntime()) : RubyFixnum.one(this.getRuntime());
    }

    @JRubyMethod(name={"<<"})
    public IRubyObject op_lshift(IRubyObject other) {
        if (!(other instanceof RubyFixnum)) {
            return RubyBignum.newBignum(this.getRuntime(), this.value).op_lshift(other);
        }
        return this.op_lshift(((RubyFixnum)other).getLongValue());
    }

    public IRubyObject op_lshift(long width) {
        return width < 0L ? this.rshift(-width) : this.lshift(width);
    }

    private IRubyObject lshift(long width) {
        if (width > 63L || (-1L << (int)(64L - width - 1L) & this.value) != 0L) {
            return RubyBignum.newBignum(this.getRuntime(), this.value).op_lshift(RubyFixnum.newFixnum(this.getRuntime(), width));
        }
        return RubyFixnum.newFixnum(this.getRuntime(), this.value << (int)width);
    }

    @JRubyMethod(name={">>"})
    public IRubyObject op_rshift(IRubyObject other) {
        if (!(other instanceof RubyFixnum)) {
            return RubyBignum.newBignum(this.getRuntime(), this.value).op_rshift(other);
        }
        return this.op_rshift(((RubyFixnum)other).getLongValue());
    }

    public IRubyObject op_rshift(long width) {
        if (width == 0L) {
            return this;
        }
        return width < 0L ? this.lshift(-width) : this.rshift(width);
    }

    private IRubyObject rshift(long width) {
        if (width >= 63L) {
            return this.value < 0L ? RubyFixnum.minus_one(this.getRuntime()) : RubyFixnum.zero(this.getRuntime());
        }
        return RubyFixnum.newFixnum(this.getRuntime(), this.value >> (int)width);
    }

    @JRubyMethod
    public IRubyObject to_f() {
        return RubyFloat.newFloat(this.getRuntime(), this.value);
    }

    @JRubyMethod
    public IRubyObject size() {
        return this.newFixnum(8L);
    }

    @JRubyMethod(name={"zero?"})
    public IRubyObject zero_p() {
        return RubyBoolean.newBoolean(this.getRuntime(), this.value == 0L);
    }

    @Override
    @JRubyMethod
    public IRubyObject succ(ThreadContext context) {
        return this.op_plus_one(context);
    }

    @Override
    public IRubyObject id() {
        if (this.value <= 0x3FFFFFFFFFFFFFFFL && this.value >= -4611686018427387904L) {
            return this.newFixnum(2L * this.value + 1L);
        }
        return super.id();
    }

    @Override
    public IRubyObject taint(ThreadContext context) {
        return this;
    }

    @Override
    public String asJavaString() {
        Ruby runtime = this.getRuntime();
        if (runtime.is1_9()) {
            throw runtime.newTypeError(this.inspect().toString() + " is not a symbol");
        }
        runtime.getWarnings().warn(IRubyWarnings.ID.FIXNUMS_NOT_SYMBOLS, "do not use Fixnums as Symbols");
        RubySymbol symbol = RubySymbol.getSymbolLong(runtime, this.value);
        if (symbol == null) {
            throw runtime.newArgumentError("" + this.value + " is not a symbol");
        }
        return symbol.asJavaString();
    }

    public static RubyFixnum unmarshalFrom(UnmarshalStream input) throws IOException {
        return input.getRuntime().newFixnum(input.unmarshalInt());
    }

    @JRubyMethod(name={"induced_from"}, meta=true, compat=CompatVersion.RUBY1_8)
    public static IRubyObject induced_from(IRubyObject recv2, IRubyObject other) {
        return RubyNumeric.num2fix(other);
    }

    private static Object coerceToJavaType(Ruby ruby2, RubyFixnum self2, Class javaClass) {
        if (!Number.class.isAssignableFrom(javaClass)) {
            throw ruby2.newTypeError(javaClass.getCanonicalName() + " is not a numeric type");
        }
        TypeCoercer coercer = JAVA_COERCERS.get(javaClass);
        if (coercer == null) {
            throw ruby2.newTypeError("Cannot coerce Fixnum to " + javaClass.getCanonicalName());
        }
        return coercer.coerce(self2);
    }

    private void checkZeroDivisionError(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyFloat && ((RubyFloat)other).getDoubleValue() == 0.0) {
            throw context.runtime.newZeroDivisionError();
        }
    }

    @Override
    public RubyInteger convertToInteger(String method2) {
        return this;
    }

    static {
        TypeCoercer intCoercer = new TypeCoercer(){

            @Override
            public Object coerce(IRubyObject self2) {
                RubyFixnum fixnum = (RubyFixnum)self2;
                if (fixnum.value > Integer.MAX_VALUE) {
                    throw self2.getRuntime().newRangeError("Fixnum " + fixnum.value + " is too large for Java int");
                }
                return (int)fixnum.value;
            }
        };
        JAVA_COERCERS.put(Integer.TYPE, intCoercer);
        JAVA_COERCERS.put(Integer.class, intCoercer);
    }
}

