/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.zlib;

import org.jcodings.Encoding;
import org.joda.time.DateTime;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubyTime;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.zlib.JZlibRubyGzipReader;
import org.jruby.ext.zlib.JZlibRubyGzipWriter;
import org.jruby.ext.zlib.RubyZlib;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.encoding.Transcoder;
import org.jruby.util.io.EncodingUtils;
import org.jruby.util.io.IOEncodable;

@JRubyClass(name={"Zlib::GzipFile"})
public class RubyGzipFile
extends RubyObject
implements IOEncodable {
    protected static final ObjectAllocator GZIPFILE_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyGzipFile(runtime, klass);
        }
    };
    protected boolean closed = false;
    protected boolean finished = false;
    protected boolean hasBOM;
    protected byte osCode = (byte)-1;
    protected int level = -1;
    protected RubyString nullFreeOrigName;
    protected RubyString nullFreeComment;
    protected IRubyObject realIo;
    protected RubyTime mtime;
    protected Encoding enc;
    protected Encoding enc2;
    protected int ecflags;
    protected IRubyObject ecopts;
    protected Transcoder ec;
    protected boolean sync = false;
    protected Transcoder readTranscoder = null;
    protected Transcoder writeTranscoder = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static IRubyObject wrapBlock(ThreadContext context, RubyGzipFile instance, Block block) {
        if (block.isGiven()) {
            try {
                IRubyObject iRubyObject = block.yield(context, instance);
                return iRubyObject;
            }
            finally {
                if (!instance.isClosed()) {
                    instance.close();
                }
            }
        }
        return instance;
    }

    @JRubyMethod(meta=true, name={"wrap"}, compat=CompatVersion.RUBY1_8)
    public static IRubyObject wrap(ThreadContext context, IRubyObject recv2, IRubyObject io2, Block block) {
        Ruby runtime = recv2.getRuntime();
        RubyGzipFile instance = recv2 == runtime.getModule("Zlib").getClass("GzipWriter") ? JZlibRubyGzipWriter.newInstance(recv2, new IRubyObject[]{io2}, block) : JZlibRubyGzipReader.newInstance(recv2, new IRubyObject[]{io2}, block);
        return RubyGzipFile.wrapBlock(context, instance, block);
    }

    @JRubyMethod(meta=true, name={"wrap"}, required=1, optional=1, compat=CompatVersion.RUBY1_9)
    public static IRubyObject wrap19(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        Ruby runtime = recv2.getRuntime();
        RubyGzipFile instance = recv2 == runtime.getModule("Zlib").getClass("GzipWriter") ? JZlibRubyGzipWriter.newInstance(recv2, args2, block) : JZlibRubyGzipReader.newInstance(recv2, args2, block);
        return RubyGzipFile.wrapBlock(context, instance, block);
    }

    @JRubyMethod(name={"new"}, meta=true)
    public static RubyGzipFile newInstance(IRubyObject recv2, Block block) {
        RubyClass klass = (RubyClass)recv2;
        RubyGzipFile result2 = (RubyGzipFile)klass.allocate();
        result2.callInit(new IRubyObject[0], block);
        return result2;
    }

    public RubyGzipFile(Ruby runtime, RubyClass type2) {
        super(runtime, type2);
        this.mtime = RubyTime.newTime(runtime, new DateTime());
        this.enc = null;
        this.enc2 = null;
    }

    protected void ecopts(ThreadContext context, IRubyObject opts) {
        if (!opts.isNil()) {
            EncodingUtils.ioExtractEncodingOption(context, this, opts, null);
        }
        if (this.enc2 != null) {
            IRubyObject[] outOpts = new IRubyObject[]{opts};
            this.ecflags = EncodingUtils.econvPrepareOpts(context, opts, outOpts);
            this.ec = EncodingUtils.econvOpenOpts(context, this.enc.getName(), this.enc2.getName(), this.ecflags, opts);
            this.ecopts = opts;
        }
    }

    public Encoding getReadEncoding() {
        return this.enc == null ? this.getRuntime().getDefaultExternalEncoding() : this.enc;
    }

    @Override
    public Encoding getEnc() {
        return this.enc;
    }

    public Encoding getInternalEncoding() {
        return this.enc2 == null ? this.getEnc() : this.enc2;
    }

    @Override
    public Encoding getEnc2() {
        return this.enc2;
    }

    protected RubyString newStr(Ruby runtime, ByteList value2) {
        if (runtime.is1_9()) {
            if (this.enc2 == null) {
                return RubyString.newString(runtime, value2, this.getReadEncoding());
            }
            if (this.ec != null && this.enc2.isDummy()) {
                value2 = this.ec.convert(runtime.getCurrentContext(), value2, false);
                return RubyString.newString(runtime, value2, this.getEnc());
            }
            value2 = Transcoder.strConvEncOpts(runtime.getCurrentContext(), value2, this.enc2, this.enc, this.ecflags, this.ecopts);
            return RubyString.newString(runtime, value2);
        }
        return RubyString.newString(runtime, value2);
    }

    @JRubyMethod(name={"os_code"})
    public IRubyObject os_code() {
        return this.getRuntime().newFixnum(this.osCode & 0xFF);
    }

    @JRubyMethod(name={"closed?"})
    public IRubyObject closed_p() {
        return this.closed ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    protected boolean isClosed() {
        return this.closed;
    }

    @JRubyMethod(name={"orig_name"})
    public IRubyObject orig_name() {
        if (this.closed) {
            throw RubyZlib.newGzipFileError(this.getRuntime(), "closed gzip stream");
        }
        return this.nullFreeOrigName == null ? this.getRuntime().getNil() : this.nullFreeOrigName;
    }

    @JRubyMethod(name={"to_io"})
    public IRubyObject to_io() {
        return this.realIo;
    }

    @JRubyMethod(name={"comment"})
    public IRubyObject comment() {
        if (this.closed) {
            throw RubyZlib.newGzipFileError(this.getRuntime(), "closed gzip stream");
        }
        return this.nullFreeComment == null ? this.getRuntime().getNil() : this.nullFreeComment;
    }

    @JRubyMethod(name={"crc"})
    public IRubyObject crc() {
        return this.getRuntime().newFixnum(0);
    }

    @JRubyMethod(name={"mtime"})
    public IRubyObject mtime() {
        return this.mtime;
    }

    @JRubyMethod(name={"sync"})
    public IRubyObject sync() {
        return this.sync ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"finish"})
    public IRubyObject finish() {
        if (!this.finished) {
            // empty if block
        }
        this.finished = true;
        return this.realIo;
    }

    @JRubyMethod(name={"close"})
    public IRubyObject close() {
        return null;
    }

    @JRubyMethod(name={"level"})
    public IRubyObject level() {
        return this.getRuntime().newFixnum(this.level);
    }

    @JRubyMethod(name={"sync="}, required=1)
    public IRubyObject set_sync(IRubyObject arg2) {
        this.sync = ((RubyBoolean)arg2).isTrue();
        return this.sync ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @Override
    public void setEnc(Encoding readEncoding) {
        this.enc = readEncoding;
    }

    @Override
    public void setEnc2(Encoding writeEncoding) {
        this.enc2 = writeEncoding;
    }

    @Override
    public void setEcflags(int ecflags) {
        this.ecflags = ecflags;
    }

    @Override
    public int getEcflags() {
        return this.ecflags;
    }

    @Override
    public void setEcopts(IRubyObject ecopts) {
        this.ecopts = ecopts;
    }

    @Override
    public IRubyObject getEcopts() {
        return this.ecopts;
    }

    @Override
    public void setBOM(boolean bom) {
        this.hasBOM = bom;
    }

    @Override
    public boolean getBOM() {
        return this.hasBOM;
    }

    @JRubyClass(name={"Zlib::GzipFile::LengthError"}, parent="Zlib::GzipFile::Error")
    public static class LengthError
    extends Error {
    }

    @JRubyClass(name={"Zlib::GzipFile::NoFooter"}, parent="Zlib::GzipFile::Error")
    public static class NoFooter
    extends Error {
    }

    @JRubyClass(name={"Zlib::GzipFile::CRCError"}, parent="Zlib::GzipFile::Error")
    public static class CRCError
    extends Error {
    }

    @JRubyClass(name={"Zlib::GzipFile::Error"}, parent="Zlib::Error")
    public static class Error {
    }
}

