/*
 * Decompiled with CFR 0.152.
 */
package com.orbus.mahalo;

import com.orbus.mahalo.MahaloSocket;
import com.orbus.mahalo.MahaloSocketListener;
import com.orbus.mahalo.RemoteHostInfo;
import com.orbus.mahalo.ServiceEvent;
import com.orbus.mahalo.ServiceInfo;
import com.orbus.mahalo.ServiceListener;
import com.orbus.mahalo.dns.DNSCache;
import com.orbus.mahalo.dns.DNSEntry;
import com.orbus.mahalo.dns.DNSPacket;
import com.orbus.mahalo.dns.DNSQuestion;
import com.orbus.mahalo.dns.DNSRecord;
import java.io.IOException;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MahaloBrowser
implements MahaloSocketListener {
    private boolean _bOwnsSocket = false;
    private MahaloSocket _Socket;
    private Map<String, List<ServiceListener>> _ServiceListeners = new HashMap<String, List<ServiceListener>>();
    private DNSCache _Cache;

    public MahaloBrowser(InetAddress aAddress) throws IOException {
        this(new MahaloSocket(aAddress), new DNSCache(100));
        this._bOwnsSocket = true;
        this._Socket.startListening();
    }

    public MahaloBrowser(MahaloSocket aSocket, DNSCache aCache) {
        this._Socket = aSocket;
        this._Socket.addListener(this);
        this._Cache = aCache;
    }

    public void close() {
        if (this._bOwnsSocket) {
            this._Socket.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServiceListener(String asType, ServiceListener aListener) {
        asType = asType.toLowerCase();
        Map<String, List<ServiceListener>> map = this._ServiceListeners;
        synchronized (map) {
            List<ServiceListener> list = this._ServiceListeners.get(asType);
            if (list == null) {
                list = new LinkedList<ServiceListener>();
                this._ServiceListeners.put(asType, list);
            }
            if (!list.contains(aListener)) {
                list.add(aListener);
            }
        }
        List<ServiceEvent> events = this.getCachedServices(asType);
        for (ServiceEvent event : events) {
            aListener.serviceAdded(event);
        }
        DNSPacket packet = new DNSPacket(false);
        packet.addQuestion(new DNSQuestion(asType, DNSEntry.EntryType.PTR, DNSEntry.EntryClass.IN, false));
        this._Socket.send(packet);
    }

    public ServiceEvent[] performSyncServiceQuery(String asType, int aiWait) {
        final List<ServiceEvent> events = this.getCachedServices(asType);
        ServiceListener listener = new ServiceListener(){

            public void serviceAdded(ServiceEvent event) {
                events.add(event);
            }

            public void serviceRemoved(ServiceEvent event) {
            }

            public void serviceResolved(ServiceEvent event) {
            }
        };
        this.addServiceListener(asType, listener);
        DNSPacket packet = new DNSPacket(false);
        packet.addQuestion(new DNSQuestion(asType, DNSEntry.EntryType.PTR, DNSEntry.EntryClass.IN, false));
        this._Socket.send(packet);
        try {
            Thread.sleep(aiWait);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        this.removeServiceListener(asType, listener);
        ServiceEvent[] eventArray = new ServiceEvent[events.size()];
        events.toArray(eventArray);
        return eventArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServiceListener(String asType, ServiceListener aListener) {
        asType = asType.toLowerCase();
        Map<String, List<ServiceListener>> map = this._ServiceListeners;
        synchronized (map) {
            List<ServiceListener> list = this._ServiceListeners.get(asType);
            if (list != null) {
                list.remove(aListener);
                if (list.size() == 0) {
                    this._ServiceListeners.remove(asType);
                }
            }
        }
    }

    @Override
    public void handleQuery(DNSPacket aPacket, InetAddress aAddress, int aiPort) {
    }

    @Override
    public void handleResponse(DNSPacket aPacket) {
        long now = System.currentTimeMillis();
        LinkedList<DNSRecord> postProcess = new LinkedList<DNSRecord>();
        for (DNSRecord rec : aPacket.getAnswers()) {
            DNSRecord oldRecord = this._Cache.handleRecord(rec);
            boolean bisExpired = rec.isExpired(now);
            if (oldRecord != null && rec instanceof DNSRecord.Pointer && bisExpired) {
                ServiceEvent evt;
                DNSRecord.Pointer ptrRecord = (DNSRecord.Pointer)rec;
                DNSRecord.Service srvRecord = this._Cache.getAssociatedService(ptrRecord);
                if (srvRecord == null || (evt = this.getEventFromRecord(srvRecord)) == null) continue;
                this.onServiceRemoved(evt);
                continue;
            }
            if (oldRecord != null || bisExpired || !(rec instanceof DNSRecord.Pointer) && !(rec instanceof DNSRecord.Service)) continue;
            postProcess.add(rec);
        }
        for (DNSRecord record : postProcess) {
            DNSRecord.Pointer ptrRecord;
            DNSRecord.Service srvRecord;
            if (record instanceof DNSRecord.Service) {
                ServiceEvent evt = this.getEventFromRecord((DNSRecord.Service)record);
                if (evt == null) continue;
                this.onServiceAdded(evt);
                continue;
            }
            if (!(record instanceof DNSRecord.Pointer) || (srvRecord = this._Cache.getAssociatedService(ptrRecord = (DNSRecord.Pointer)record)) != null) continue;
            DNSPacket packet = new DNSPacket(false);
            packet.addQuestion(new DNSQuestion(ptrRecord.getAlias(), DNSEntry.EntryType.ANY, DNSEntry.EntryClass.IN, false));
            this._Socket.send(packet);
        }
    }

    private List<ServiceEvent> getCachedServices(String asType) {
        List<DNSRecord> ptrList = this._Cache.get(asType, DNSEntry.EntryType.PTR, DNSEntry.EntryClass.IN);
        LinkedList<ServiceEvent> events = new LinkedList<ServiceEvent>();
        if (ptrList != null) {
            for (DNSRecord rec : ptrList) {
                DNSRecord.Pointer ptrRec = (DNSRecord.Pointer)rec;
                DNSRecord.Service srvRec = this._Cache.getAssociatedService(ptrRec);
                events.add(this.getEventFromRecord(srvRec));
            }
        }
        return events;
    }

    private ServiceEvent getEventFromRecord(DNSRecord.Service aSrvRecord) {
        ServiceEvent retEvent = null;
        DNSRecord.Address addressRecord = this._Cache.getAssociatedAddress(aSrvRecord);
        DNSRecord.Text textRecord = this._Cache.getAssociatedText(aSrvRecord);
        if (addressRecord != null) {
            ServiceInfo srvInfo = new ServiceInfo(aSrvRecord);
            if (textRecord != null) {
                srvInfo.setTextBytes(textRecord.getTextBytes());
            }
            RemoteHostInfo hostInfo = new RemoteHostInfo(addressRecord);
            retEvent = new ServiceEvent(this, srvInfo, hostInfo);
        }
        return retEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onServiceAdded(ServiceEvent aEvent) {
        ServiceInfo srvInfo = aEvent.getSrvInfo();
        RemoteHostInfo hostInfo = aEvent.getHostInfo();
        Map<String, List<ServiceListener>> map = this._ServiceListeners;
        synchronized (map) {
            for (String key : this._ServiceListeners.keySet()) {
                if (!srvInfo.getQualifiedName().endsWith(key)) continue;
                List<ServiceListener> listeners = this._ServiceListeners.get(key);
                for (ServiceListener listener : listeners) {
                    listener.serviceAdded(aEvent);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onServiceRemoved(ServiceEvent aEvent) {
        ServiceInfo srvInfo = aEvent.getSrvInfo();
        Map<String, List<ServiceListener>> map = this._ServiceListeners;
        synchronized (map) {
            for (String key : this._ServiceListeners.keySet()) {
                if (!srvInfo.getQualifiedName().endsWith(key)) continue;
                List<ServiceListener> listeners = this._ServiceListeners.get(key);
                for (ServiceListener listener : listeners) {
                    listener.serviceRemoved(aEvent);
                }
            }
        }
    }
}

