/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.sourceforge.schemaspy.Config;
import net.sourceforge.schemaspy.DbAnalyzer;
import net.sourceforge.schemaspy.MultipleSchemaAnalyzer;
import net.sourceforge.schemaspy.TableOrderer;
import net.sourceforge.schemaspy.model.ConnectionFailure;
import net.sourceforge.schemaspy.model.Database;
import net.sourceforge.schemaspy.model.EmptySchemaException;
import net.sourceforge.schemaspy.model.ForeignKeyConstraint;
import net.sourceforge.schemaspy.model.ImpliedForeignKeyConstraint;
import net.sourceforge.schemaspy.model.InvalidConfigurationException;
import net.sourceforge.schemaspy.model.Table;
import net.sourceforge.schemaspy.model.TableColumn;
import net.sourceforge.schemaspy.model.xml.SchemaMeta;
import net.sourceforge.schemaspy.util.ConnectionURLBuilder;
import net.sourceforge.schemaspy.util.DOMUtil;
import net.sourceforge.schemaspy.util.DbSpecificOption;
import net.sourceforge.schemaspy.util.Dot;
import net.sourceforge.schemaspy.util.LineWriter;
import net.sourceforge.schemaspy.util.LogFormatter;
import net.sourceforge.schemaspy.util.PasswordReader;
import net.sourceforge.schemaspy.util.ResourceWriter;
import net.sourceforge.schemaspy.view.DotFormatter;
import net.sourceforge.schemaspy.view.HtmlAnomaliesPage;
import net.sourceforge.schemaspy.view.HtmlColumnsPage;
import net.sourceforge.schemaspy.view.HtmlConstraintsPage;
import net.sourceforge.schemaspy.view.HtmlMainIndexPage;
import net.sourceforge.schemaspy.view.HtmlOrphansPage;
import net.sourceforge.schemaspy.view.HtmlRelationshipsPage;
import net.sourceforge.schemaspy.view.HtmlTablePage;
import net.sourceforge.schemaspy.view.ImageWriter;
import net.sourceforge.schemaspy.view.StyleSheet;
import net.sourceforge.schemaspy.view.TextFormatter;
import net.sourceforge.schemaspy.view.WriteStats;
import net.sourceforge.schemaspy.view.XmlTableFormatter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaAnalyzer {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private boolean fineEnabled;

    public Database analyze(Config config) throws Exception {
        try {
            LineWriter lineWriter;
            Object object;
            Object object2;
            SchemaMeta schemaMeta;
            CharSequence charSequence;
            long l;
            if (config.isHelpRequired()) {
                config.dumpUsage(null, false);
                return null;
            }
            if (config.isDbHelpRequired()) {
                config.dumpUsage(null, true);
                return null;
            }
            Logger.getLogger("").setLevel(config.getLogLevel());
            for (Handler handler : Logger.getLogger("").getHandlers()) {
                if (!(handler instanceof ConsoleHandler)) continue;
                ((ConsoleHandler)handler).setFormatter(new LogFormatter());
                handler.setLevel(config.getLogLevel());
            }
            this.fineEnabled = this.logger.isLoggable(Level.FINE);
            this.logger.info("Starting schema analysis");
            long l2 = l = System.currentTimeMillis();
            long l3 = l;
            File file = config.getOutputDir();
            if (!file.isDirectory() && !file.mkdirs()) {
                throw new IOException("Failed to create directory '" + file + "'");
            }
            List<String> list = config.getSchemas();
            if (list != null) {
                List<String> list2 = config.asList();
                SchemaAnalyzer.yankParam(list2, "-o");
                SchemaAnalyzer.yankParam(list2, "-s");
                list2.remove("-all");
                list2.remove("-schemas");
                list2.remove("-schemata");
                String string = config.getDb();
                MultipleSchemaAnalyzer.getInstance().analyze(string, list, list2, config.getUser(), file, config.getCharset(), Config.getLoadedFromJar());
                return null;
            }
            Properties properties = config.getDbProperties(config.getDbType());
            ConnectionURLBuilder connectionURLBuilder = new ConnectionURLBuilder(config, properties);
            if (config.getDb() == null) {
                config.setDb(connectionURLBuilder.getConnectionURL());
            }
            if (config.getRemainingParameters().size() != 0) {
                charSequence = new StringBuilder("Unrecognized option(s):");
                for (String object32 : config.getRemainingParameters()) {
                    ((StringBuilder)charSequence).append(" " + object32);
                }
                this.logger.warning(((StringBuilder)charSequence).toString());
            }
            charSequence = properties.getProperty("driver");
            Object object4 = properties.getProperty("driverPath");
            if (object4 == null) {
                object4 = "";
            }
            if (config.getDriverPath() != null) {
                object4 = config.getDriverPath() + File.pathSeparator + (String)object4;
            }
            Connection connection = this.getConnection(config, connectionURLBuilder.getConnectionURL(), (String)charSequence, (String)object4);
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            String string = config.getDb();
            String string2 = config.getSchema();
            if (config.isEvaluateAllEnabled()) {
                List<String> list2 = config.asList();
                for (DbSpecificOption dbSpecificOption : connectionURLBuilder.getOptions()) {
                    if (list2.contains("-" + dbSpecificOption.getName())) continue;
                    list2.add("-" + dbSpecificOption.getName());
                    list2.add(dbSpecificOption.getValue().toString());
                }
                SchemaAnalyzer.yankParam(list2, "-o");
                SchemaAnalyzer.yankParam(list2, "-s");
                list2.remove("-all");
                Object object3 = config.getSchemaSpec();
                if (object3 == null) {
                    object3 = properties.getProperty("schemaSpec", ".*");
                }
                MultipleSchemaAnalyzer.getInstance().analyze(string, databaseMetaData, (String)object3, null, list2, config.getUser(), file, config.getCharset(), Config.getLoadedFromJar());
                return null;
            }
            if (string2 == null && databaseMetaData.supportsSchemasInTableDefinitions() && !config.isSchemaDisabled()) {
                string2 = config.getUser();
                if (string2 == null) {
                    throw new InvalidConfigurationException("Either a schema ('-s') or a user ('-u') must be specified");
                }
                config.setSchema(string2);
            }
            SchemaMeta schemaMeta2 = schemaMeta = config.getMeta() == null ? null : new SchemaMeta(config.getMeta(), string, string2);
            if (config.isHtmlGenerationEnabled()) {
                new File(file, "tables").mkdirs();
                new File(file, "diagrams/summary").mkdirs();
                this.logger.info("Connected to " + databaseMetaData.getDatabaseProductName() + " - " + databaseMetaData.getDatabaseProductVersion());
                if (schemaMeta != null && schemaMeta.getFile() != null) {
                    this.logger.info("Using additional metadata from " + schemaMeta.getFile());
                }
                this.logger.info("Gathering schema details");
                if (!this.fineEnabled) {
                    System.out.print("Gathering schema details...");
                }
            }
            Database database = new Database(config, connection, databaseMetaData, string, string2, properties, schemaMeta);
            schemaMeta = null;
            ArrayList<Table> arrayList = new ArrayList<Table>(database.getTables());
            arrayList.addAll(database.getViews());
            if (arrayList.isEmpty()) {
                SchemaAnalyzer.dumpNoTablesMessage(string2, config.getUser(), databaseMetaData, config.getTableInclusions() != null);
                if (!config.isOneOfMultipleSchemas()) {
                    throw new EmptySchemaException();
                }
            }
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = document.createElement("database");
            document.appendChild(element);
            DOMUtil.appendAttribute(element, "name", string);
            if (string2 != null) {
                DOMUtil.appendAttribute(element, "schema", string2);
            }
            DOMUtil.appendAttribute(element, "type", database.getDatabaseProduct());
            if (config.isHtmlGenerationEnabled()) {
                boolean bl;
                l3 = System.currentTimeMillis();
                if (!this.fineEnabled) {
                    System.out.println("(" + (l3 - l) / 1000L + "sec)");
                }
                this.logger.info("Gathered schema details in " + (l3 - l) / 1000L + " seconds");
                this.logger.info("Writing/graphing summary");
                System.err.flush();
                System.out.flush();
                if (!this.fineEnabled) {
                    System.out.print("Writing/graphing summary");
                    System.out.print(".");
                }
                ImageWriter.getInstance().writeImages(file);
                ResourceWriter.getInstance().writeResource("/jquery.js", new File(file, "/jquery.js"));
                ResourceWriter.getInstance().writeResource("/schemaSpy.js", new File(file, "/schemaSpy.js"));
                if (!this.fineEnabled) {
                    System.out.print(".");
                }
                boolean bl2 = arrayList.size() <= config.getMaxDetailedTables();
                boolean bl3 = config.isImpliedConstraintsEnabled();
                if (config.isRailsEnabled()) {
                    DbAnalyzer.getRailsConstraints(database.getTablesByName());
                }
                object2 = new File(file, "diagrams/summary");
                object = "relationships";
                lineWriter = new LineWriter(new File((File)object2, (String)object + ".real.compact.dot"), "UTF-8");
                WriteStats writeStats = new WriteStats(arrayList);
                DotFormatter.getInstance().writeRealRelationships(database, arrayList, true, bl2, writeStats, lineWriter);
                boolean bl4 = writeStats.getNumTablesWritten() > 0 || writeStats.getNumViewsWritten() > 0;
                lineWriter.close();
                if (bl4) {
                    if (!this.fineEnabled) {
                        System.out.print(".");
                    }
                    lineWriter = new LineWriter(new File((File)object2, (String)object + ".real.large.dot"), "UTF-8");
                    DotFormatter.getInstance().writeRealRelationships(database, arrayList, false, bl2, writeStats, lineWriter);
                    lineWriter.close();
                }
                List<ImpliedForeignKeyConstraint> list3 = null;
                list3 = bl3 ? DbAnalyzer.getImpliedConstraints(arrayList) : new ArrayList<ImpliedForeignKeyConstraint>();
                List<Table> list4 = DbAnalyzer.getOrphans(arrayList);
                boolean bl5 = bl = !list4.isEmpty() && Dot.getInstance().isValid();
                if (!this.fineEnabled) {
                    System.out.print(".");
                }
                File file2 = new File((File)object2, (String)object + ".implied.compact.dot");
                lineWriter = new LineWriter(file2, "UTF-8");
                boolean bl6 = DotFormatter.getInstance().writeAllRelationships(database, arrayList, true, bl2, writeStats, lineWriter);
                Set<TableColumn> set = writeStats.getExcludedColumns();
                lineWriter.close();
                if (bl6) {
                    file2 = new File((File)object2, (String)object + ".implied.large.dot");
                    lineWriter = new LineWriter(file2, "UTF-8");
                    DotFormatter.getInstance().writeAllRelationships(database, arrayList, false, bl2, writeStats, lineWriter);
                    lineWriter.close();
                } else {
                    file2.delete();
                }
                lineWriter = new LineWriter(new File(file, (String)object + ".html"), config.getCharset());
                HtmlRelationshipsPage.getInstance().write(database, (File)object2, (String)object, bl, bl4, bl6, set, lineWriter);
                lineWriter.close();
                if (!this.fineEnabled) {
                    System.out.print(".");
                }
                object = "utilities";
                lineWriter = new LineWriter(new File(file, (String)object + ".html"), config.getCharset());
                HtmlOrphansPage.getInstance().write(database, list4, (File)object2, lineWriter);
                lineWriter.close();
                if (!this.fineEnabled) {
                    System.out.print(".");
                }
                lineWriter = new LineWriter(new File(file, "index.html"), 65536, config.getCharset());
                HtmlMainIndexPage.getInstance().write(database, arrayList, bl, lineWriter);
                lineWriter.close();
                if (!this.fineEnabled) {
                    System.out.print(".");
                }
                List<ForeignKeyConstraint> list5 = DbAnalyzer.getForeignKeyConstraints(arrayList);
                lineWriter = new LineWriter(new File(file, "constraints.html"), 262144, config.getCharset());
                HtmlConstraintsPage htmlConstraintsPage = HtmlConstraintsPage.getInstance();
                htmlConstraintsPage.write(database, list5, arrayList, bl, lineWriter);
                lineWriter.close();
                if (!this.fineEnabled) {
                    System.out.print(".");
                }
                lineWriter = new LineWriter(new File(file, "anomalies.html"), 16384, config.getCharset());
                HtmlAnomaliesPage.getInstance().write(database, arrayList, list3, bl, lineWriter);
                lineWriter.close();
                if (!this.fineEnabled) {
                    System.out.print(".");
                }
                for (HtmlColumnsPage.ColumnInfo columnInfo : HtmlColumnsPage.getInstance().getColumnInfos()) {
                    lineWriter = new LineWriter(new File(file, columnInfo.getLocation()), 16384, config.getCharset());
                    HtmlColumnsPage.getInstance().write(database, arrayList, columnInfo, bl, lineWriter);
                    lineWriter.close();
                }
                l2 = System.currentTimeMillis();
                if (!this.fineEnabled) {
                    System.out.println("(" + (l2 - l3) / 1000L + "sec)");
                }
                this.logger.info("Completed summary in " + (l2 - l3) / 1000L + " seconds");
                this.logger.info("Writing/diagramming details");
                if (!this.fineEnabled) {
                    System.out.print("Writing/diagramming details");
                }
                HtmlTablePage htmlTablePage = HtmlTablePage.getInstance();
                for (Table table : arrayList) {
                    if (!this.fineEnabled) {
                        System.out.print('.');
                    } else {
                        this.logger.fine("Writing details of " + table.getName());
                    }
                    lineWriter = new LineWriter(new File(file, "tables/" + table.getName() + ".html"), 24576, config.getCharset());
                    htmlTablePage.write(database, table, bl, file, writeStats, lineWriter);
                    lineWriter.close();
                }
                lineWriter = new LineWriter(new File(file, "schemaSpy.css"), config.getCharset());
                StyleSheet.getInstance().write(lineWriter);
                lineWriter.close();
            }
            XmlTableFormatter.getInstance().appendTables(element, arrayList);
            String string3 = string;
            string3 = new File(string3).getName();
            if (string2 != null) {
                string3 = string3 + '.' + string2;
            }
            lineWriter = new LineWriter(new File(file, string3 + ".xml"), "UTF-8");
            document.getDocumentElement().normalize();
            DOMUtil.printDOM(document, lineWriter);
            lineWriter.close();
            documentBuilder = null;
            Object var14_20 = null;
            document = null;
            documentBuilderFactory = null;
            databaseMetaData = null;
            properties = null;
            element = null;
            connectionURLBuilder = null;
            ArrayList<ForeignKeyConstraint> arrayList2 = new ArrayList<ForeignKeyConstraint>();
            object2 = new TableOrderer();
            object = ((TableOrderer)object2).getTablesOrderedByRI(database.getTables(), arrayList2);
            lineWriter = new LineWriter(new File(file, "insertionOrder.txt"), 16384, "UTF-8");
            TextFormatter.getInstance().write((Collection<Table>)object, false, lineWriter);
            lineWriter.close();
            lineWriter = new LineWriter(new File(file, "deletionOrder.txt"), 16384, "UTF-8");
            Collections.reverse(object);
            TextFormatter.getInstance().write((Collection<Table>)object, false, lineWriter);
            lineWriter.close();
            if (config.isHtmlGenerationEnabled()) {
                long l4 = System.currentTimeMillis();
                if (!this.fineEnabled) {
                    System.out.println("(" + (l4 - l2) / 1000L + "sec)");
                }
                this.logger.info("Wrote table details in " + (l4 - l2) / 1000L + " seconds");
                if (this.logger.isLoggable(Level.INFO)) {
                    this.logger.info("Wrote relationship details of " + arrayList.size() + " tables/views to directory '" + config.getOutputDir() + "' in " + (l4 - l) / 1000L + " seconds.");
                    this.logger.info("View the results by opening " + new File(config.getOutputDir(), "index.html"));
                } else {
                    System.out.println("Wrote relationship details of " + arrayList.size() + " tables/views to directory '" + config.getOutputDir() + "' in " + (l4 - l) / 1000L + " seconds.");
                    System.out.println("View the results by opening " + new File(config.getOutputDir(), "index.html"));
                }
            }
            return database;
        }
        catch (Config.MissingRequiredParameterException missingRequiredParameterException) {
            config.dumpUsage(missingRequiredParameterException.getMessage(), missingRequiredParameterException.isDbTypeSpecific());
            return null;
        }
    }

    private static void dumpNoTablesMessage(String string, String string2, DatabaseMetaData databaseMetaData, boolean bl) throws SQLException {
        System.out.println();
        System.out.println();
        System.out.println("No tables or views were found in schema '" + string + "'.");
        List<String> list = DbAnalyzer.getSchemas(databaseMetaData);
        if (string == null || list.contains(string)) {
            System.out.println("The schema exists in the database, but the user you specified (" + string2 + ')');
            System.out.println("  might not have rights to read its contents.");
            if (bl) {
                System.out.println("Another possibility is that the regular expression that you specified");
                System.out.println("  for what to include (via -i) didn't match any tables.");
            }
        } else {
            System.out.println("The schema does not exist in the database.");
            System.out.println("Make sure that you specify a valid schema with the -s option and that");
            System.out.println("  the user specified (" + string2 + ") can read from the schema.");
            System.out.println("Note that schema names are usually case sensitive.");
        }
        System.out.println();
        boolean bl2 = list.size() != 1;
        System.out.println(list.size() + " schema" + (bl2 ? "s" : "") + " exist" + (bl2 ? "" : "s") + " in this database.");
        System.out.println("Some of these \"schemas\" may be users or system schemas.");
        System.out.println();
        for (String object : list) {
            System.out.print(object + " ");
        }
        System.out.println();
        List<String> list2 = DbAnalyzer.getPopulatedSchemas(databaseMetaData);
        if (list2.isEmpty()) {
            System.out.println("Unable to determine if any of the schemas contain tables/views");
        } else {
            System.out.println("These schemas contain tables/views that user '" + string2 + "' can see:");
            System.out.println();
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                System.out.print(" " + string3);
            }
        }
    }

    private Connection getConnection(Config config, String string, String string2, String string3) throws FileNotFoundException, IOException {
        Object object;
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.info("Using database properties:");
            this.logger.info("  " + config.getDbPropertiesLoadedFrom());
        } else {
            System.out.println("Using database properties:");
            System.out.println("  " + config.getDbPropertiesLoadedFrom());
        }
        ArrayList<URL> arrayList = new ArrayList<URL>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        StringTokenizer stringTokenizer = new StringTokenizer(string3, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            object = new File(stringTokenizer.nextToken());
            if (((File)object).exists()) {
                arrayList.add(((File)object).toURI().toURL());
                continue;
            }
            arrayList2.add(object);
        }
        object = new URLClassLoader(arrayList.toArray(new URL[arrayList.size()]));
        Driver driver = null;
        try {
            driver = (Driver)Class.forName(string2, true, (ClassLoader)object).newInstance();
        }
        catch (Exception exception) {
            System.err.println(exception);
            System.err.println();
            System.err.print("Failed to load driver '" + string2 + "'");
            if (arrayList.isEmpty()) {
                System.err.println();
            } else {
                System.err.println("from: " + arrayList);
            }
            if (!arrayList2.isEmpty()) {
                if (arrayList2.size() == 1) {
                    System.err.print("This entry doesn't point to a valid file/directory: ");
                } else {
                    System.err.print("These entries don't point to valid files/directories: ");
                }
                System.err.println(arrayList2);
            }
            System.err.println();
            System.err.println("Use the -dp option to specify the location of the database");
            System.err.println("drivers for your database (usually in a .jar or .zip/.Z).");
            System.err.println();
            throw new ConnectionFailure(exception);
        }
        Properties properties = config.getConnectionProperties();
        if (config.getUser() != null) {
            properties.put("user", config.getUser());
        }
        if (config.getPassword() != null) {
            properties.put("password", config.getPassword());
        } else if (config.isPromptForPasswordEnabled()) {
            properties.put("password", new String(PasswordReader.getInstance().readPassword("Password: ", new Object[0])));
        }
        Connection connection = null;
        try {
            connection = driver.connect(string, properties);
            if (connection == null) {
                System.err.println();
                System.err.println("Cannot connect to this database URL:");
                System.err.println("  " + string);
                System.err.println("with this driver:");
                System.err.println("  " + string2);
                System.err.println();
                System.err.println("Additional connection information may be available in ");
                System.err.println("  " + config.getDbPropertiesLoadedFrom());
                throw new ConnectionFailure("Cannot connect to '" + string + "' with driver '" + string2 + "'");
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println();
            System.err.println("Failed to load driver [" + string2 + "] from classpath " + arrayList);
            System.err.println();
            System.err.println("Make sure the reported library (.dll/.lib/.so) from the following line can be");
            System.err.println("found by your PATH (or LIB*PATH) environment variable");
            System.err.println();
            unsatisfiedLinkError.printStackTrace();
            throw new ConnectionFailure(unsatisfiedLinkError);
        }
        catch (Exception exception) {
            System.err.println();
            System.err.println("Failed to connect to database URL [" + string + "]");
            System.err.println();
            exception.printStackTrace();
            throw new ConnectionFailure(exception);
        }
        return connection;
    }

    private static void yankParam(List<String> list, String string) {
        int n = list.indexOf(string);
        if (n >= 0) {
            list.remove(n);
            list.remove(n);
        }
    }
}

