/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import net.sourceforge.schemaspy.Config;
import net.sourceforge.schemaspy.util.DbSpecificConfig;
import net.sourceforge.schemaspy.util.DbSpecificOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionURLBuilder {
    private final String connectionURL;
    private final List<DbSpecificOption> options;
    private final Logger logger = Logger.getLogger(this.getClass().getName());

    public ConnectionURLBuilder(Config config, Properties properties) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String object2 : config.getDbSpecificOptions().keySet()) {
            arrayList.add((object2.startsWith("-") ? "" : "-") + object2);
            arrayList.add(config.getDbSpecificOptions().get(object2));
        }
        arrayList.addAll(config.getRemainingParameters());
        DbSpecificConfig dbSpecificConfig = new DbSpecificConfig(config.getDbType());
        this.options = dbSpecificConfig.getOptions();
        this.connectionURL = this.buildUrl(arrayList, properties, config);
        List<String> list = config.getRemainingParameters();
        for (DbSpecificOption dbSpecificOption : this.options) {
            int n = list.indexOf("-" + dbSpecificOption.getName());
            if (n < 0) continue;
            list.remove(n);
            list.remove(n);
        }
        this.logger.config("connectionURL: " + this.connectionURL);
    }

    private String buildUrl(List<String> list, Properties properties, Config config) {
        String string = properties.getProperty("connectionSpec");
        for (DbSpecificOption dbSpecificOption : this.options) {
            dbSpecificOption.setValue(this.getParam(list, dbSpecificOption, config));
            string = string.replaceAll("\\<" + dbSpecificOption.getName() + "\\>", dbSpecificOption.getValue().toString());
        }
        return string;
    }

    public String getConnectionURL() {
        return this.connectionURL;
    }

    public List<DbSpecificOption> getOptions() {
        return this.options;
    }

    private String getParam(List<String> list, DbSpecificOption dbSpecificOption, Config config) {
        String string = null;
        int n = list.indexOf("-" + dbSpecificOption.getName());
        if (n < 0) {
            if (config != null) {
                string = config.getParam(dbSpecificOption.getName());
            }
            if (string == null) {
                throw new Config.MissingRequiredParameterException(dbSpecificOption.getName(), dbSpecificOption.getDescription(), true);
            }
        } else {
            list.remove(n);
            string = list.get(n).toString();
            list.remove(n);
        }
        return string;
    }
}

