/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.auction;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.jbidwatcher.auction.AuctionEntry;
import com.jbidwatcher.auction.AuctionInfo;
import com.jbidwatcher.auction.AuctionSnipe;
import com.jbidwatcher.auction.Category;
import com.jbidwatcher.auction.EntryCorralTemplate;
import com.jbidwatcher.auction.EntryTable;
import com.jbidwatcher.auction.Snipeable;
import com.jbidwatcher.auction.event.EventStatus;
import com.jbidwatcher.util.HashBacked;
import com.jbidwatcher.util.config.JConfig;
import com.jbidwatcher.util.db.ActiveRecord;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Singleton
public class EntryCorral
extends EntryCorralTemplate<AuctionEntry> {
    static final String snipeFinder = "(snipe_id IS NOT NULL OR multisnipe_id IS NOT NULL) AND (entries.ended != 1 OR entries.ended IS NULL)";
    private static Date updateSince = new Date();
    private static Date endingSoon = new Date();
    private static Date hourAgo = new Date();
    private static SimpleDateFormat mDateFormat = new SimpleDateFormat(HashBacked.DB_DATE_FORMAT);

    public static AuctionEntry findFirstBy(String key, String value) {
        return (AuctionEntry)ActiveRecord.findFirstBy(AuctionEntry.class, key, value);
    }

    public static List<AuctionEntry> findActive() {
        String notEndedQuery = "SELECT e.* FROM entries e JOIN auctions a ON a.id = e.auction_id WHERE (e.ended != 1 OR e.ended IS NULL) ORDER BY a.ending_at ASC";
        return ActiveRecord.findAllBySQL(AuctionEntry.class, notEndedQuery);
    }

    public static List<AuctionEntry> findEnded() {
        return ActiveRecord.findAllBy(AuctionEntry.class, "ended", "1");
    }

    public static List<AuctionEntry> findAllNeedingUpdates(long since) {
        long timeRange = System.currentTimeMillis() - since;
        updateSince.setTime(timeRange);
        return ActiveRecord.findAllByPrepared(AuctionEntry.class, "SELECT e.* FROM entries e  JOIN auctions a ON a.id = e.auction_id  WHERE (e.ended != 1 OR e.ended IS NULL)    AND (e.last_updated_at IS NULL OR e.last_updated_at < ?)  ORDER BY a.ending_at ASC", mDateFormat.format(updateSince));
    }

    public static List<AuctionEntry> findEndingNeedingUpdates(long since) {
        long timeRange = System.currentTimeMillis() - since;
        updateSince.setTime(timeRange);
        endingSoon.setTime(System.currentTimeMillis() + 1500000L);
        hourAgo.setTime(System.currentTimeMillis() - 3600000L);
        return ActiveRecord.findAllByPrepared(AuctionEntry.class, "SELECT e.* FROM entries e JOIN auctions a ON a.id = e.auction_id  WHERE (e.last_updated_at IS NULL OR e.last_updated_at < ?)    AND (e.ended != 1 OR e.ended IS NULL)    AND a.ending_at < ? AND a.ending_at > ?  ORDER BY a.ending_at ASC", mDateFormat.format(updateSince), mDateFormat.format(endingSoon), mDateFormat.format(hourAgo));
    }

    public static List<AuctionEntry> findAll() {
        return ActiveRecord.findAllBySQL(AuctionEntry.class, "SELECT * FROM entries");
    }

    public static AuctionEntry nextSniped() {
        String sql = "SELECT entries.* FROM entries, auctions WHERE (snipe_id IS NOT NULL OR multisnipe_id IS NOT NULL) AND (entries.ended != 1 OR entries.ended IS NULL) AND (entries.auction_id = auctions.id) ORDER BY auctions.ending_at ASC";
        return (AuctionEntry)ActiveRecord.findFirstBySQL(AuctionEntry.class, sql);
    }

    public static AuctionEntry findByIdentifier(String identifier) {
        AuctionInfo ai;
        AuctionEntry ae = (AuctionEntry)ActiveRecord.findFirstBy(AuctionEntry.class, "identifier", identifier);
        if (ae != null && (ai = AuctionInfo.findByIdOrIdentifier(ae.getAuctionId(), identifier)) == null) {
            JConfig.log().logMessage("Error loading auction #" + identifier + ", entry found, auction missing.");
            ae = null;
        }
        if (ae == null && (ai = AuctionInfo.findByIdOrIdentifier(null, identifier)) != null && (ae = EntryCorral.findFirstBy("auction_id", ai.getString("id"))) != null) {
            ae.setAuctionInfo(ai);
        }
        return ae;
    }

    public static boolean deleteAll(List<AuctionEntry> toDelete) {
        if (toDelete.isEmpty()) {
            return true;
        }
        String entries = ActiveRecord.makeCommaList(toDelete);
        ArrayList<Integer> auctions = new ArrayList<Integer>();
        ArrayList<AuctionSnipe> snipes = new ArrayList<AuctionSnipe>();
        for (AuctionEntry entry : toDelete) {
            auctions.add(entry.getInteger("auction_id"));
            if (!entry.isSniped()) continue;
            snipes.add(entry.getSnipe());
        }
        boolean success = new EventStatus().deleteAllEntries(entries);
        if (!snipes.isEmpty()) {
            success &= AuctionSnipe.deleteAll(snipes);
        }
        success &= AuctionInfo.deleteAll(auctions);
        return success &= EntryTable.getRealDatabase().deleteBy("id IN (" + entries + ")");
    }

    public static int countByCategory(Category c) {
        if (c == null) {
            return 0;
        }
        return EntryTable.getRealDatabase().countBySQL("SELECT COUNT(*) FROM entries WHERE category_id=" + c.getId());
    }

    public static List<AuctionEntry> findManualUpdates() {
        return ActiveRecord.findAllBySQL(AuctionEntry.class, "SELECT e.* FROM entries e JOIN auctions a ON a.id = e.auction_id WHERE e.last_updated_at IS NULL ORDER BY a.ending_at ASC");
    }

    public static List<AuctionEntry> findRecentlyEnded(int itemCount) {
        return ActiveRecord.findAllBySQL(AuctionEntry.class, "SELECT e.* FROM entries e JOIN auctions a ON a.id = e.auction_id WHERE e.ended = 1 ORDER BY a.ending_at DESC", itemCount);
    }

    public static List<AuctionEntry> findEndingSoon(int itemCount) {
        return ActiveRecord.findAllBySQL(AuctionEntry.class, "SELECT e.* FROM entries e JOIN auctions a ON a.id = e.auction_id WHERE (e.ended != 1 OR e.ended IS NULL) ORDER BY a.ending_at ASC", itemCount);
    }

    public static List<AuctionEntry> findBidOrSniped(int itemCount) {
        return ActiveRecord.findAllBySQL(AuctionEntry.class, "SELECT e.* FROM entries e JOIN auctions a ON a.id = e.auction_id WHERE (e.snipe_id IS NOT NULL OR e.multisnipe_id IS NOT NULL OR e.bid_amount IS NOT NULL) ORDER BY a.ending_at ASC", itemCount);
    }

    public static void forceUpdateActive() {
        EntryTable.getRealDatabase().execute("UPDATE entries SET last_updated_at=NULL WHERE ended != 1 OR ended IS NULL");
    }

    public static void trueUpEntries() {
        EntryTable.getRealDatabase().execute("UPDATE entries SET auction_id=(SELECT max(id) FROM auctions WHERE auctions.identifier=entries.identifier)");
        EntryTable.getRealDatabase().execute("DELETE FROM entries e WHERE id != (SELECT max(id) FROM entries e2 WHERE e2.auction_id = e.auction_id)");
    }

    public static List<AuctionEntry> findAllBy(String column, String value) {
        return ActiveRecord.findAllBy(AuctionEntry.class, column, value);
    }

    public static int count() {
        return ActiveRecord.count(AuctionEntry.class);
    }

    public static int activeCount() {
        return EntryTable.getRealDatabase().countBy("(ended != 1 OR ended IS NULL)");
    }

    public static int completedCount() {
        return EntryTable.getRealDatabase().countBy("ended = 1");
    }

    public static int uniqueCount() {
        return EntryTable.getRealDatabase().countBySQL("SELECT COUNT(DISTINCT(identifier)) FROM entries WHERE identifier IS NOT NULL");
    }

    public static int snipedCount() {
        return EntryTable.getRealDatabase().countBy(snipeFinder);
    }

    @Override
    public AuctionEntry getItem(String param) {
        return EntryCorral.findByIdentifier(param);
    }

    public List<AuctionEntry> findAllSniped() {
        List<? extends ActiveRecord> sniped = ActiveRecord.findAllBySQL(AuctionEntry.class, "SELECT * FROM " + EntryTable.getTableName() + " WHERE (snipe_id IS NOT NULL OR multisnipe_id IS NOT NULL)");
        if (sniped != null) {
            ArrayList<AuctionEntry> results = new ArrayList<AuctionEntry>();
            for (AuctionEntry auctionEntry : sniped) {
                results.add(this.chooseLatest(auctionEntry, auctionEntry.getIdentifier()));
            }
            return results;
        }
        return null;
    }

    public List<Snipeable> getMultisnipedByGroup(String multisnipeIdentifier) {
        List<AuctionEntry> entries = EntryCorral.findAllBy("multisnipe_id", multisnipeIdentifier);
        ArrayList<Snipeable> rval = new ArrayList<Snipeable>(entries.size());
        for (Snipeable snipeable : entries) {
            Snipeable ae = (Snipeable)this.takeForRead(snipeable.getIdentifier());
            if (ae.isComplete()) continue;
            rval.add(ae);
        }
        return rval;
    }

    @Inject
    private EntryCorral() {
    }
}

