/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.auction.server.ebay;

import com.jbidwatcher.auction.Category;
import com.jbidwatcher.auction.EntryCorral;
import com.jbidwatcher.auction.LoginManager;
import com.jbidwatcher.auction.server.AuctionServer;
import com.jbidwatcher.auction.server.AuctionServerManager;
import com.jbidwatcher.auction.server.ebay.EbayAuctionURLPager;
import com.jbidwatcher.search.Searcher;
import com.jbidwatcher.util.Externalized;
import com.jbidwatcher.util.Pair;
import com.jbidwatcher.util.StringTools;
import com.jbidwatcher.util.config.JConfig;
import com.jbidwatcher.util.html.CleanupHandler;
import com.jbidwatcher.util.html.JHTML;
import com.jbidwatcher.util.http.CookieJar;
import com.jbidwatcher.util.queue.DropQObject;
import com.jbidwatcher.util.queue.MQFactory;
import com.jbidwatcher.util.queue.SuperQueue;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class ebaySearches {
    private static final int ITEMS_PER_PAGE = 100;
    private final EntryCorral mCorral;
    private final AuctionServerManager mServerManager;
    private CleanupHandler mCleaner;
    private LoginManager mLogin;

    public ebaySearches(EntryCorral corral, AuctionServerManager serverManager, CleanupHandler cleaner, LoginManager login) {
        this.mCleaner = cleaner;
        this.mLogin = login;
        this.mCorral = corral;
        this.mServerManager = serverManager;
    }

    private ItemResults getAllItemsOnPage(JHTML htmlDocument) {
        List<String> allURLsOnPageUnprocessed = htmlDocument.getAllURLsOnPage(true);
        ArrayList<String> allURLsOnPage = new ArrayList<String>();
        if (allURLsOnPageUnprocessed != null) {
            for (String process : allURLsOnPageUnprocessed) {
                allURLsOnPage.add(process.replaceAll("\n|\r", ""));
            }
        }
        LinkedHashMap<String, String> allItemsOnPage = new LinkedHashMap<String, String>();
        ArrayList<String> newItems = new ArrayList<String>();
        AuctionServer aucServ = this.mServerManager.getServer();
        for (String url : allURLsOnPage) {
            String hasId = aucServ.extractIdentifierFromURLString(url);
            if (hasId == null || !StringTools.isNumberOnly(hasId) || allItemsOnPage.containsKey(hasId) || this.mCorral.takeForRead(hasId) != null) continue;
            allItemsOnPage.put(hasId, url);
            newItems.add(url);
        }
        return new ItemResults(newItems, allItemsOnPage);
    }

    private ItemResults addAllItemsOnPage(JHTML htmlDocument, String category, boolean interactive) {
        ItemResults ir = this.getAllItemsOnPage(htmlDocument);
        this.addAll(((Map)ir.getLast()).values(), category, interactive);
        return ir;
    }

    private void addAll(Collection<String> urls, String category, boolean interactive) {
        if (urls.isEmpty()) {
            JConfig.log().logDebug("No items on page!");
        } else {
            for (String url : urls) {
                MQFactory.getConcrete("drop").enqueueBean(new DropQObject(url.trim(), category, interactive));
            }
        }
    }

    void loadAllFromURLString(Object searcher, String label) {
        String urlStr = ((Searcher)searcher).getSearch();
        MQFactory.getConcrete("Swing").enqueue("Loading from URL " + urlStr);
        EbayAuctionURLPager pager = new EbayAuctionURLPager(urlStr, this.mLogin);
        int results = 0;
        ListIterator li = pager.listIterator();
        while (li.hasNext()) {
            MQFactory.getConcrete("Swing").enqueue("Loading page " + li.nextIndex() + "/" + pager.size() + " from URL " + urlStr);
            JHTML htmlDocument = (JHTML)li.next();
            if (htmlDocument == null) continue;
            ItemResults rval = this.addAllItemsOnPage(htmlDocument, label, !((Searcher)searcher).shouldSkipDeleted());
            results += ((List)rval.getFirst()).size();
        }
        if (results == 0) {
            MQFactory.getConcrete("Swing").enqueue("No new items found at URL: " + urlStr);
        } else {
            MQFactory.getConcrete("Swing").enqueue("Done loading from URL: " + urlStr);
        }
    }

    void getSellingItems(String userId, String curUser, String label) {
        CookieJar cj = this.mLogin.getNecessaryCookie(false);
        String userCookie = null;
        if (cj != null) {
            userCookie = cj.toString();
        }
        if (userId == null || userId.equals("default")) {
            JConfig.log().logMessage("Cannot load selling pages without at least a userid.");
            return;
        }
        String myEBayURL = Externalized.getString("ebayServer.protocol") + Externalized.getString("ebayServer.sellingListHost") + Externalized.getString("ebayServer.V3file") + Externalized.getString("ebayServer.listedCGI") + Externalized.getString("ebayServer.sortOrderCGI") + Externalized.getString("ebayServer.userIdCGI") + userId;
        JHTML htmlDocument = new JHTML(myEBayURL, userCookie, this.mCleaner);
        if (htmlDocument.isLoaded()) {
            ItemResults rval = this.addAllItemsOnPage(htmlDocument, label, userId.equals(curUser));
            int count = ((List)rval.getFirst()).size();
            MQFactory.getConcrete("Swing").enqueue("Loaded " + count + " new items for seller " + userId);
        } else {
            JConfig.log().logMessage("getSellingItems failed!");
        }
    }

    void getMyEbayItems(String curUser, String label) {
        CookieJar cj = this.mLogin.getNecessaryCookie(false);
        String userCookie = null;
        if (cj != null) {
            userCookie = cj.toString();
        }
        if (curUser == null || curUser.equals("default")) {
            JConfig.log().logMessage("Cannot load My eBay pages without a userid and password.");
            return;
        }
        LinkedHashMap<String, String> collatedItems = new LinkedHashMap<String, String>();
        int newWatchCount = this.pullWatchingItems(curUser, userCookie, collatedItems);
        ItemResults rval = this.getAllItemsOnPage(new JHTML(Externalized.getString("ebayServer.oldWatching"), userCookie, this.mCleaner));
        collatedItems.putAll((Map)rval.getLast());
        newWatchCount += ((List)rval.getFirst()).size();
        int watchCount = collatedItems.size();
        newWatchCount = Math.min(newWatchCount, watchCount);
        rval = this.getBiddingOnItems(label);
        collatedItems.putAll((Map)rval.getLast());
        int newBidCount = ((List)rval.getFirst()).size();
        int bidCount = ((Map)rval.getLast()).size();
        newWatchCount += this.pullSellingItems(curUser, userCookie, collatedItems);
        newWatchCount = Math.min(newWatchCount, collatedItems.size());
        this.addAll(collatedItems.values(), label, true);
        this.reportMyeBayResults(label, watchCount, newWatchCount, bidCount, newBidCount);
    }

    private int pullWatchingItems(String curUser, String userCookie, Map<String, String> collatedItems) {
        return this.pullItems("ebayServer.watchingURLPaginated", curUser, userCookie, collatedItems);
    }

    private int pullSellingItems(String curUser, String userCookie, Map<String, String> collatedItems) {
        return this.pullItems("ebayServer.sellingURLPaginated", curUser, userCookie, collatedItems);
    }

    private int pullItems(String propertyKey, String curUser, String userCookie, Map<String, String> collatedItems) {
        int page = 1;
        int newWatchCount = 0;
        boolean doneWatching = false;
        while (!doneWatching) {
            String watchingURL = this.generateWatchedItemsURL(propertyKey, curUser, page);
            JHTML htmlDocument = this.getWatchedItemsPage(userCookie, watchingURL);
            String nextPage = null;
            if (htmlDocument.isLoaded()) {
                ItemResults rval = this.getAllItemsOnPage(htmlDocument);
                collatedItems.putAll((Map)rval.getLast());
                newWatchCount += ((List)rval.getFirst()).size();
                nextPage = htmlDocument.getLinkForContent("Next");
                ++page;
            }
            if (nextPage != null) continue;
            doneWatching = true;
        }
        return newWatchCount;
    }

    private ItemResults getBiddingOnItems(String userCookie) {
        String biddingURL = Externalized.getString("ebayServer.biddingURL");
        JConfig.log().logDebug("Loading page: " + biddingURL);
        JHTML htmlDocument = new JHTML(biddingURL, userCookie, this.mCleaner);
        return this.getAllItemsOnPage(htmlDocument);
    }

    private void reportMyeBayResults(String label, int watchCount, int newWatchCount, int bidCount, int newBidCount) {
        int count;
        Category c;
        String watchInfo = watchCount == 0 ? "" : " (about " + newWatchCount + " new)";
        String bidInfo = bidCount == 0 ? "" : " (" + newBidCount + " new)";
        String reportTab = "current";
        if (label != null && (c = Category.findFirstByName(label)) != null && (count = EntryCorral.countByCategory(c)) != 0) {
            reportTab = label;
        }
        reportTab = reportTab + " Tab";
        String report = "Found " + watchCount + " watched items" + watchInfo;
        if (bidCount != 0) {
            report = report + ", and " + bidCount + " items" + bidInfo + " you've apparently bid on";
        }
        report = report + '.';
        MQFactory.getConcrete(reportTab).enqueue("REPORT " + report);
        MQFactory.getConcrete(reportTab).enqueue("SHOW");
        SuperQueue.getInstance().preQueue("HIDE", reportTab, System.currentTimeMillis() + 60000L);
    }

    private String generateWatchedItemsURL(String propertyKey, String curUser, int page) {
        String watchingURL = Externalized.getString(propertyKey);
        watchingURL = watchingURL.replace("{page}", Integer.toString(page));
        JConfig.log().logDebug("Loading page " + page + " of My eBay for user " + curUser);
        JConfig.log().logDebug("URL: " + watchingURL);
        return watchingURL;
    }

    private JHTML getWatchedItemsPage(String userCookie, String watchingURL) {
        JHTML htmlDocument = new JHTML(watchingURL, userCookie, this.mCleaner);
        if (htmlDocument.isLoaded() && htmlDocument.getTitle().equals("eBay Message")) {
            JConfig.log().logDebug("eBay is presenting an interstitial 'eBay Message' page!");
            JHTML.Form f = htmlDocument.getFormWithInput("MfcISAPICommand");
            if (f != null) {
                try {
                    JConfig.log().logDebug("Navigating to the 'Continue to My eBay' page.");
                    htmlDocument = new JHTML(f.getCGI(), userCookie, this.mCleaner);
                }
                catch (UnsupportedEncodingException uee) {
                    JConfig.log().handleException("Failed to get the real My eBay page", uee);
                }
            }
        }
        return htmlDocument;
    }

    void loadSearchString(Object searcher, String label, boolean title_only) {
        String encodedSearch;
        String search = ((Searcher)searcher).getSearch();
        try {
            encodedSearch = URLEncoder.encode(search, "UTF-8");
        }
        catch (UnsupportedEncodingException ignored) {
            encodedSearch = null;
            JConfig.log().logMessage("Failed to search because of encoding transformation failure.");
        }
        int allResults = 0;
        if (encodedSearch != null) {
            boolean done;
            MQFactory.getConcrete("Swing").enqueue("Searching for: " + search);
            String sacur = "";
            String currency = ((Searcher)searcher).getCurrency();
            if (currency != null) {
                sacur = "&sacur=" + currency;
            }
            String fullSearch = title_only ? Externalized.getString("ebayServer.searchURL1") + encodedSearch + sacur + Externalized.getString("ebayServer.searchURLNoDesc") : Externalized.getString("ebayServer.searchURL1") + encodedSearch + sacur + Externalized.getString("ebayServer.searchURL2");
            String baseSearch = fullSearch;
            int skipCount = 0;
            do {
                ItemResults rval;
                int pageResults;
                JHTML htmlDocument;
                done = true;
                CookieJar cj = this.mLogin.getNecessaryCookie(false);
                String userCookie = null;
                if (cj != null) {
                    userCookie = cj.toString();
                }
                if (!(htmlDocument = new JHTML(fullSearch, userCookie, this.mCleaner)).isLoaded() || (pageResults = ((Map)(rval = this.addAllItemsOnPage(htmlDocument, label, !((Searcher)searcher).shouldSkipDeleted())).getLast()).size()) == 0) continue;
                if (pageResults >= 100) {
                    fullSearch = baseSearch + "&skip=" + (skipCount += 100);
                    done = false;
                }
                allResults += pageResults;
            } while (!done);
        }
        if (allResults == 0) {
            MQFactory.getConcrete("Swing").enqueue("No new results found for search: " + search);
        } else {
            MQFactory.getConcrete("Swing").enqueue("Done searching for: " + search);
        }
    }

    private class ItemResults
    extends Pair<List<String>, Map<String, String>> {
        public ItemResults(List<String> s, Map<String, String> c) {
            super(s, c);
        }
    }
}

