/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.search;

import com.jbidwatcher.util.xml.XMLElement;
import com.jbidwatcher.util.xml.XMLSerializeSimple;

public abstract class Searcher
extends XMLSerializeSimple {
    protected long _id;
    protected String _name = "";
    protected String _search = "";
    protected String _server = "";
    protected String _category;
    protected String _currency;
    protected int _period;
    protected long _last;
    protected boolean _enabled;
    protected boolean _skip_deleted;
    protected boolean _initialized;
    protected String[] infoTags = new String[]{"name", "search", "period", "server", "last", "enabled", "category", "currency", "finddeleted"};

    public Searcher() {
        this._id = 0L;
        this._last = 0L;
        this._initialized = false;
        this._skip_deleted = true;
    }

    public Searcher(String name, String search, String server, int period) {
        this._id = System.currentTimeMillis();
        this._name = name;
        this._search = search;
        this._period = period;
        this._server = server;
        this._enabled = period != -1;
        this._initialized = true;
        this._skip_deleted = true;
        this._last = 0L;
    }

    public boolean isInitialized() {
        return this._initialized;
    }

    public boolean shouldSkipDeleted() {
        return this._skip_deleted;
    }

    public void setSkipDeleted(boolean skip) {
        this._skip_deleted = skip;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String newName) {
        this._name = newName;
        this._initialized = true;
    }

    public String getSearch() {
        return this._search;
    }

    public void setSearch(String newSearch) {
        this._search = newSearch;
        this._initialized = true;
    }

    public boolean hasCategory() {
        return this._category != null;
    }

    public String getCategory() {
        return this._category == null ? this.getName() : this._category;
    }

    public void setCategory(String category) {
        this._category = category;
    }

    public String getServer() {
        return this._server;
    }

    public void setServer(String newServer) {
        this._server = newServer;
        this._initialized = true;
    }

    public String getCurrency() {
        return this._currency;
    }

    public void setCurrency(String currency) {
        this._currency = currency;
        this._initialized = true;
    }

    public int getPeriod() {
        return this._period;
    }

    public void setPeriod(int newPeriod) {
        this._period = newPeriod;
        this._initialized = true;
    }

    public void setId(long id) {
        this._id = id;
        this._initialized = true;
    }

    public long getId() {
        return this._id;
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public void enable() {
        this._enabled = true;
    }

    public void disable() {
        this._enabled = false;
    }

    public long getLastRun() {
        return this._last;
    }

    protected void setLastRun() {
        this._last = System.currentTimeMillis();
    }

    protected void setLastRun(long last) {
        this._last = last;
    }

    public boolean shouldExecute() {
        long curTime;
        return this._enabled && this._period != -1 && this._last + (long)(this._period * 3600000) <= (curTime = System.currentTimeMillis());
    }

    public abstract String getTypeName();

    public void execute() {
        this.setLastRun();
        this.fire();
    }

    protected abstract void fire();

    @Override
    public XMLElement toXML() {
        XMLElement search = new XMLElement("search");
        search.setProperty("type", this.getTypeName());
        search.setProperty("id", Long.toString(this.getId()));
        XMLElement xname = new XMLElement("name");
        xname.setContents(this.getName());
        search.addChild(xname);
        XMLElement xsearch = new XMLElement("search");
        xsearch.setContents(this.getSearch());
        search.addChild(xsearch);
        XMLElement xperiod = new XMLElement("period");
        xperiod.setContents(Integer.toString(this.getPeriod()));
        search.addChild(xperiod);
        XMLElement xserver = new XMLElement("server");
        xserver.setContents(this.getServer());
        search.addChild(xserver);
        XMLElement xcurrency = new XMLElement("currency");
        xcurrency.setContents(this.getCurrency());
        search.addChild(xcurrency);
        XMLElement xlast = new XMLElement("last");
        xlast.setContents(Long.toString(this.getLastRun()));
        search.addChild(xlast);
        if (this._enabled) {
            XMLElement xenabled = new XMLElement("enabled");
            xenabled.setEmpty();
            search.addChild(xenabled);
        }
        if (!this._skip_deleted) {
            XMLElement xfinddeleted = new XMLElement("finddeleted");
            xfinddeleted.setEmpty();
            search.addChild(xfinddeleted);
        }
        XMLElement xcat = new XMLElement("category");
        if (this._category == null) {
            xcat.setContents(this.getName());
        } else {
            xcat.setContents(this._category);
        }
        search.addChild(xcat);
        this._initialized = true;
        return search;
    }

    @Override
    protected String[] getTags() {
        return this.infoTags;
    }

    @Override
    protected void handleTag(int i, XMLElement curElement) {
        String contents = curElement.getContents();
        switch (i) {
            case 0: {
                this.setName(contents);
                break;
            }
            case 1: {
                this.setSearch(contents);
                break;
            }
            case 2: {
                this.setPeriod(Integer.parseInt(contents));
                break;
            }
            case 3: {
                this.setServer(contents);
                break;
            }
            case 4: {
                this.setLastRun(Long.parseLong(contents));
                break;
            }
            case 5: {
                this.enable();
                break;
            }
            case 6: {
                this.setCategory(contents);
                break;
            }
            case 7: {
                this.setCurrency(contents);
                break;
            }
            case 8: {
                this.setSkipDeleted(false);
                break;
            }
        }
    }
}

