/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.util.http;

import com.jbidwatcher.util.config.JConfig;
import com.jbidwatcher.util.http.Cookie;
import com.jbidwatcher.util.http.Http;
import java.io.IOException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class CookieJar {
    private Map<String, Cookie> mCookies = new TreeMap<String, Cookie>();
    private boolean mIgnoreRedirectCookies = false;
    private static final boolean sUberDebug = false;
    private Map<String, Integer> mRedirections;

    public Cookie getCookie(String keyName) {
        return this.mCookies.get(keyName);
    }

    public String dump() {
        StringBuffer rval = new StringBuffer();
        for (String cookieName : this.mCookies.keySet()) {
            Cookie value = this.mCookies.get(cookieName);
            rval.append(cookieName).append(": ").append(value.getValue()).append('\n');
        }
        return rval.toString();
    }

    public StringBuffer getPage(String page, String body, String referer) throws CookieException {
        URLConnection uc = this.connect(page, body, referer, body != null, null);
        if (uc == null) {
            return null;
        }
        StringBuffer sb = null;
        try {
            sb = Http.net().receivePage(uc);
        }
        catch (ConnectException ce) {
            this.logException(page, ce);
            if (ce.toString().indexOf("Connection refused") != -1) {
                throw new CookieException("Connection refused", ce);
            }
        }
        catch (IOException e) {
            this.logException(page, e);
            return null;
        }
        return sb;
    }

    private void logException(String pageName, Exception e) {
        int qLoc = pageName.indexOf(63);
        String errmsg = "Error loading page: ";
        errmsg = qLoc == -1 ? errmsg + pageName : errmsg + pageName.substring(0, qLoc);
        JConfig.log().handleException(errmsg, e);
    }

    public URLConnection connect(String page) {
        return this.connect(page, null, null, false, null);
    }

    public URLConnection connect(String page, String body, String referer, boolean post, List<String> pages) {
        this.mRedirections = new HashMap<String, Integer>();
        URLConnection rval = this.internal_connect(page, body, referer, post, pages);
        this.mRedirections = null;
        return rval;
    }

    private URLConnection internal_connect(String page, String body, String referer, boolean post, List<String> pages) {
        String redirect;
        HttpURLConnection uc;
        if (this.handleInfiniteRedirection(page)) {
            if (post) {
                post = false;
                body = null;
            } else {
                throw new CookieRedirectException("Looped redirect to " + page, null);
            }
        }
        if (pages != null) {
            pages.add(page);
        }
        if ((uc = this.initiateRequest(post, page, body, referer)) != null && (redirect = this.handleRedirect(uc, page)) != null) {
            if (JConfig.debugging()) {
                if (!page.contains("pass")) {
                    JConfig.log().logMessage("Redirecting from: " + page);
                }
                if (!page.contains("pass")) {
                    JConfig.log().logMessage("Redirecting to: " + redirect);
                }
                try {
                    if (JConfig.queryConfiguration("debug.urls", "false").equals("true")) {
                        JConfig.log().logMessage("Content: " + Http.net().receivePage(uc));
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return this.internal_connect(redirect, body, referer, post, pages);
        }
        return uc;
    }

    private boolean handleInfiniteRedirection(String page) {
        Integer pageCount = this.mRedirections.get(page);
        if (pageCount == null) {
            pageCount = 0;
        }
        if (pageCount >= 2) {
            return true;
        }
        this.mRedirections.put(page, pageCount + 1);
        return false;
    }

    private String handleRedirect(HttpURLConnection uc, String pageName) {
        String nextKey;
        int i = 1;
        String redirect = null;
        do {
            if ((nextKey = uc.getHeaderFieldKey(i)) != null) {
                if (nextKey.startsWith("Location") || nextKey.startsWith("location")) {
                    redirect = uc.getHeaderField(i);
                    if (!(redirect = this.stripQuotedAmpersands(redirect)).startsWith("http")) {
                        redirect = this.fixRelativeRedirect(pageName, redirect);
                    }
                }
                if (nextKey.startsWith("Set-Cookie") || nextKey.startsWith("Set-cookie")) {
                    Cookie newCookie = new Cookie(uc.getHeaderField(i));
                    this.mCookies.put(newCookie.getKey(), newCookie);
                }
            }
            ++i;
        } while (nextKey != null);
        return redirect;
    }

    private String fixRelativeRedirect(String pageName, String redirect) {
        String slash = "";
        int serverEnd = pageName.indexOf(".com/");
        if (!redirect.startsWith("/")) {
            slash = "/";
        }
        String prefix = serverEnd == -1 ? pageName : pageName.substring(0, serverEnd + 4);
        redirect = prefix + slash + redirect;
        return redirect;
    }

    private String stripQuotedAmpersands(String redirect) {
        int amploc = redirect.indexOf("&amp;");
        while (amploc != -1) {
            redirect = redirect.substring(0, amploc) + "&" + redirect.substring(amploc + 5);
            amploc = redirect.indexOf("&amp;");
        }
        return redirect;
    }

    private HttpURLConnection initiateRequest(boolean post, String sendRequest, String cgi, String referer) {
        String cookies = this.mCookies.isEmpty() ? null : this.toString();
        URLConnection uc = post ? Http.net().postFormPage(sendRequest, cgi, cookies, referer, this.mIgnoreRedirectCookies) : Http.net().getPage(sendRequest, cookies, referer, this.mIgnoreRedirectCookies);
        return (HttpURLConnection)uc;
    }

    public String toString() {
        boolean firstThrough = true;
        StringBuffer outBuf = null;
        for (Cookie cookie : this.mCookies.values()) {
            if (cookie.getValue().length() == 0) continue;
            if (!firstThrough) {
                outBuf.append("; ");
            } else {
                firstThrough = false;
                outBuf = new StringBuffer();
            }
            outBuf.append(cookie.getKey());
            outBuf.append("=");
            outBuf.append(cookie.getValue());
        }
        if (outBuf != null) {
            return outBuf.toString();
        }
        return null;
    }

    public static class CookieRedirectException
    extends RuntimeException {
        public CookieRedirectException(String text, Throwable trigger) {
            super(text, trigger);
        }
    }

    public static class CookieException
    extends Exception {
        public CookieException(String text, Throwable trigger) {
            super(text, trigger);
        }
    }
}

