/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.auction;

import com.jbidwatcher.auction.Thumbnail;
import com.jbidwatcher.util.Constants;
import com.jbidwatcher.util.Currency;
import com.jbidwatcher.util.db.ActiveRecord;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public abstract class AuctionCore
extends ActiveRecord {
    private static Map<String, String> mKeys;
    protected String mThumbnailPath;

    private static void setupKeys() {
        mKeys = new HashMap<String, String>();
        mKeys.put("startDate", "started_at");
        mKeys.put("start", "started_at");
        mKeys.put("endDate", "ending_at");
        mKeys.put("seller", "seller_id");
        mKeys.put("end", "ending_at");
        mKeys.put("highbidder", "high_bidder");
        mKeys.put("highBidder", "high_bidder");
        mKeys.put("highBidderEmail", "high_bidder_email");
        mKeys.put("itemLocation", "location");
        mKeys.put("numBids", "bid_count");
        mKeys.put("bidcount", "bid_count");
        mKeys.put("insurance_optional", "optional_insurance");
        mKeys.put("insuranceOptional", "optional_insurance");
        mKeys.put("noThumbnail", "no_thumbnail");
        mKeys.put("reserveMet", "reserve_met");
        mKeys.put("isReserve", "reserve");
        mKeys.put("fixed", "fixed_price");
        mKeys.put("fixedPrice", "fixed_price");
        mKeys.put("isDutch", "dutch");
        mKeys.put("currently", "current_bid");
        mKeys.put("curBid", "current_bid");
        mKeys.put("minimum", "minimum_bid");
        mKeys.put("minBid", "minimum_bid");
        mKeys.put("usprice", "usd_current");
        mKeys.put("us_cur", "usd_current");
        mKeys.put("buy_now_us", "usd_buy_now");
        mKeys.put("buynow", "buy_now");
    }

    public AuctionCore() {
        this.setTranslationTable(mKeys);
    }

    public String getIdentifier() {
        return this.getString("identifier");
    }

    public String getTitle() {
        return this.getString("title");
    }

    public String getHighBidder() {
        return this.getString("highBidder");
    }

    public String getItemLocation() {
        return this.getString("itemLocation", "");
    }

    public boolean isComplete() {
        return this.getBoolean("ended");
    }

    public Currency getBestPrice() {
        Currency currentPrice = this.getCurBid();
        if (currentPrice == null || currentPrice.isNull()) {
            currentPrice = this.getBuyNow();
        }
        return currentPrice;
    }

    public Currency getCurBid() {
        return this.getMonetary("curBid");
    }

    public Currency getUSCurBid() {
        if (this.getCurBid().getCurrencyType() == 1) {
            return this.getCurBid();
        }
        return this.getMonetary("us_cur", 1);
    }

    public Currency getMinBid() {
        return this.getMonetary("minBid", this.getCurBid());
    }

    public Currency getShipping() {
        return this.getMonetary("shipping");
    }

    public Currency getInsurance() {
        return this.getMonetary("insurance");
    }

    public Currency getBuyNow() {
        return this.getMonetary("buy_now");
    }

    public int getQuantity() {
        return this.getInteger("quantity", 1);
    }

    public int getNumBidders() {
        return this.getInteger("numBids", 0);
    }

    public int getNumBids() {
        return this.getNumBidders();
    }

    public Date getStartDate() {
        return this.getDate("start");
    }

    public Date getEndDate() {
        Date end = this.getEnd();
        if (end == null) {
            end = Constants.FAR_FUTURE;
        }
        return end;
    }

    public boolean isReserve() {
        return this.getBoolean("isReserve");
    }

    public boolean isPrivate() {
        return this.getBoolean("isPrivate");
    }

    public boolean isFixed() {
        return this.getBoolean("fixed_price");
    }

    public boolean isReserveMet() {
        return this.getBoolean("reserve_met");
    }

    public boolean hasPaypal() {
        return this.getBoolean("paypal");
    }

    boolean isInsuranceOptional() {
        return this.getBoolean("insurance_optional", true);
    }

    protected boolean hasNoThumbnail() {
        return this.getBoolean("noThumbnail");
    }

    public Currency getUSCur() {
        return this.getMonetary("us_cur", 1);
    }

    public Currency getBuyNowUS() {
        return this.getMonetary("buy_now_us", 1);
    }

    public Date getStart() {
        return this.getDate("start");
    }

    public Date getEnd() {
        return this.getDate("end");
    }

    public String getSellerId() {
        return this.get("seller_id");
    }

    private boolean hasThumb() {
        return this.getBoolean("has_thumbnail");
    }

    private void setHasThumb(boolean hasThumb) {
        this.setBoolean("has_thumbnail", hasThumb);
    }

    protected boolean hasThumbnail() {
        String imgPath = this.mThumbnailPath;
        if (imgPath == null && (imgPath = Thumbnail.getValidImagePath(this.getIdentifier())) == null) {
            return false;
        }
        File tester = new File(imgPath);
        boolean rval = tester.exists();
        if (rval && this.mThumbnailPath == null) {
            this.mThumbnailPath = imgPath;
        }
        return rval;
    }

    public String getThumbnail() {
        if (!(this.hasThumb() && this.mThumbnailPath != null || this.hasThumbnail())) {
            return null;
        }
        this.setHasThumb(true);
        return "file:" + this.mThumbnailPath;
    }

    static {
        AuctionCore.setupKeys();
    }
}

