/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.auction.server.ebay;

import com.jbidwatcher.auction.AuctionEntry;
import com.jbidwatcher.auction.BadBidException;
import com.jbidwatcher.auction.Bidder;
import com.jbidwatcher.auction.LoginManager;
import com.jbidwatcher.util.Currency;
import com.jbidwatcher.util.Externalized;
import com.jbidwatcher.util.StringTools;
import com.jbidwatcher.util.TT;
import com.jbidwatcher.util.UpdateBlocker;
import com.jbidwatcher.util.config.JConfig;
import com.jbidwatcher.util.html.JHTML;
import com.jbidwatcher.util.http.CookieJar;
import com.jbidwatcher.util.http.Http;
import com.jbidwatcher.util.queue.MQFactory;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ebayBidder
implements Bidder {
    private LoginManager mLogin;
    private HashMap<String, Integer> mResultHash = null;
    private String mBidResultRegex = null;
    private Pattern mFindBidResult;
    private TT T;

    public ebayBidder(TT countryProperties, LoginManager login) {
        this.T = countryProperties;
        this.mLogin = login;
        if (this.mResultHash == null) {
            this.mResultHash = new HashMap();
            this.mResultHash.put("you('re| are) not permitted to bid on their listings.", 10);
            this.mResultHash.put("the item is no longer available because the auction has ended.", 9);
            this.mResultHash.put("bidding has ended (for|on) this item", 9);
            this.mResultHash.put("this listing has ended.", 9);
            this.mResultHash.put("cannot proceed", 1);
            this.mResultHash.put("problem with bid amount", 2);
            this.mResultHash.put("your bid must be at least ", 8);
            this.mResultHash.put("you('ve| have) been outbid by another bidder", 3);
            this.mResultHash.put("you('ve| have) just been outbid", 3);
            this.mResultHash.put("you('re| are) the current high bidder", 4);
            this.mResultHash.put("you('re| are) the high bidder and the reserve price has been met", 4);
            this.mResultHash.put("you('re| are) the first bidder", 4);
            this.mResultHash.put("you('re| are) the high bidder and currently in the lead", 4);
            this.mResultHash.put("you('re| are) currently the highest bidder", 4);
            this.mResultHash.put("you purchased the item", 4);
            this.mResultHash.put("you('re| are) currently the high bidder, but the reserve hasn.t been met", 11);
            this.mResultHash.put("the reserve price has not been met", 11);
            this.mResultHash.put("the reserve (price )?has(n.t| not) been met", 11);
            this.mResultHash.put("your new total must be higher than your current total", 13);
            this.mResultHash.put("this exceeds or is equal to your current bid", 13);
            this.mResultHash.put("you (just )?bought this item", 16);
            this.mResultHash.put("You('ve| have) purchased more than one of these items", 16);
            this.mResultHash.put("you committed to buy", 16);
            this.mResultHash.put("congratulations! you won!", 16);
            this.mResultHash.put("account suspended", 17);
            this.mResultHash.put("to enter a higher maximum bid, please enter", 13);
            this.mResultHash.put("you are registered in a country to which the seller doesn.t ship.", 19);
            this.mResultHash.put("this seller has set buyer requirements for this item and only sells to buyers who meet those requirements.", 20);
            this.mResultHash.put("sellers are not permitted to purchase their own items", 21);
            this.mResultHash.put("this item is not available for purchase", 22);
        }
        StringBuffer superRegex = null;
        for (String key : this.mResultHash.keySet()) {
            if (superRegex == null) {
                superRegex = new StringBuffer(".*(");
            } else {
                superRegex.append('|');
            }
            superRegex.append(key);
        }
        if (superRegex != null) {
            superRegex.append(").*");
        }
        this.mBidResultRegex = "(?msi)" + superRegex;
        this.mBidResultRegex = this.mBidResultRegex.replace(" ", "\\s+");
        this.mFindBidResult = Pattern.compile(this.mBidResultRegex);
        this.mResultHash.put("sign in", 18);
    }

    @Override
    public JHTML.Form getBidForm(CookieJar cj, AuctionEntry inEntry, Currency inCurr) throws BadBidException {
        String bidRequest = Externalized.getString("ebayServer.protocol") + this.T.s("ebayServer.bidHost") + Externalized.getString("ebayServer.V3file");
        String bidInfo = this.getBidInfoURL(inEntry, inCurr);
        BidFormReturn rval = null;
        try {
            String value;
            String pageName = bidRequest + '?' + bidInfo;
            if (JConfig.debugging) {
                inEntry.setLastStatus("Loading bid request...");
            }
            if (!(rval = this.getBidFormInternal(pageName, inEntry, cj)).isSuccess() && (cj = this.checkSignin(inEntry, rval.getDocument())) != null) {
                rval = this.getBidFormInternal(pageName, inEntry, cj);
            }
            if (!rval.isSuccess() && (pageName = this.checkForWarning(inEntry, rval.getDocument())) != null) {
                rval = this.getBidFormInternal(pageName, inEntry, cj);
            }
            if ((value = rval.getDocument().grep(".*The following must be corrected before continuing.*")) != null) {
                JHTML.SequenceResult foo = rval.getDocument().findSequence(".*Enter.*", ".*or more.*");
                JConfig.log().dump2File("error-8.html", rval.getBuffer());
                throw new BadBidException((String)foo.get(0) + " " + (String)foo.get(1), 8);
            }
            JHTML.SequenceResult quickBidError = rval.getDocument().findSequence("error", "Enter.(.*).or more");
            if (quickBidError != null) {
                JConfig.log().dump2File("error-8.html", rval.getBuffer());
                throw new BadBidException((String)quickBidError.get(1), 8);
            }
            String maxbid = rval.getForm().getInputValue("maxbid");
            if (maxbid == null || maxbid.length() == 0) {
                JConfig.log().logFile("Bad form response to: " + pageName, rval.getBuffer());
            }
            if (rval.isSuccess()) {
                return rval.getForm();
            }
        }
        catch (IOException e) {
            JConfig.log().handleException("Failure to get the bid key!  BID FAILURE!", e);
        }
        if (rval == null) {
            return null;
        }
        if (rval.getDocument() != null) {
            this.checkSignOn(rval.getDocument());
            this.checkBidErrors(rval);
        }
        if (JConfig.debugging) {
            inEntry.setLastStatus("Failed to bid. 'Show Last Error' from context menu to see the failure page from the bid attempt.");
        }
        JConfig.log().dump2File("unknown-" + inEntry.getIdentifier() + ".html", rval.getBuffer());
        inEntry.setErrorPage(rval.getBuffer());
        JConfig.log().logFile(bidInfo, rval.getBuffer());
        return null;
    }

    private String checkForWarning(AuctionEntry inEntry, JHTML htmlDocument) throws UnsupportedEncodingException {
        JHTML.Form continueForm;
        String pageName = null;
        if (htmlDocument.grep(this.T.s("ebayServer.warningPage")) != null && (continueForm = htmlDocument.getFormWithInput("firedFilterId")) != null) {
            inEntry.setLastStatus("Trying to 'continue' for the actual bid.");
            pageName = continueForm.getCGI();
            pageName = pageName.replaceFirst("%[A-F][A-F0-9]%A0", "%A0");
        }
        return pageName;
    }

    private String getBidInfoURL(AuctionEntry inEntry, Currency inCurr) {
        String bidInfo = Externalized.getString("ebayServer.bidCmd") + "&co_partnerid=" + Externalized.getString("ebayServer.itemCGI") + inEntry.getIdentifier() + "&fb=2";
        bidInfo = bidInfo + Externalized.getString("ebayServer.bidCGI") + inCurr.getValue();
        return bidInfo;
    }

    private CookieJar checkSignin(AuctionEntry inEntry, JHTML htmlDocument) {
        String signOn = htmlDocument.getTitle();
        if (signOn != null) {
            JConfig.log().logDebug("Checking sign in as bid key load failed!");
            if (StringTools.startsWithIgnoreCase(signOn, "sign in")) {
                JConfig.log().logDebug("Being prompted again for sign in, retrying.");
                if (JConfig.debugging) {
                    inEntry.setLastStatus("Not done loading bid request, got re-login request...");
                }
                CookieJar cj = this.mLogin.getSignInCookie(null);
                if (JConfig.debugging) {
                    inEntry.setLastStatus("Done re-logging in, retrying load bid request.");
                }
                return cj;
            }
        }
        return null;
    }

    private BidFormReturn getBidFormInternal(String pageName, AuctionEntry inEntry, CookieJar cj) throws IOException {
        StringBuffer loadedPage;
        URLConnection huc = cj.connect(pageName);
        if (huc == null || (loadedPage = Http.net().receivePage(huc)) == null) {
            return new BidFormReturn(true, null, null, null);
        }
        JHTML htmlDocument = new JHTML(loadedPage);
        JHTML.Form bidForm = htmlDocument.getFormWithInput("key");
        if (bidForm == null) {
            bidForm = htmlDocument.getFormWithInput("maxbid");
        }
        if (bidForm != null) {
            if (JConfig.debugging) {
                inEntry.setLastStatus("Done loading bid request, got form...");
            }
            return new BidFormReturn(true, bidForm, htmlDocument, loadedPage);
        }
        return new BidFormReturn(false, null, htmlDocument, loadedPage);
    }

    private void checkBidErrors(BidFormReturn inVal) throws BadBidException {
        String orMore;
        JHTML htmlDocument = inVal.getDocument();
        String errMsg = htmlDocument.grep(this.mBidResultRegex);
        if (errMsg != null) {
            Matcher bidMatch = this.mFindBidResult.matcher(errMsg);
            bidMatch.find();
            String matched_error = bidMatch.group().toLowerCase();
            Integer result = this.getMatchedResult(matched_error);
            JConfig.log().dump2File("error-" + result + ".html", inVal.getBuffer());
            throw new BadBidException(matched_error, result);
        }
        String amount = htmlDocument.getNextContentAfterRegex("\\s*Enter\\s*");
        if (amount != null && (orMore = htmlDocument.getNextContent()) != null && orMore.indexOf("or more") != -1) {
            JConfig.log().dump2File("error-8.html", inVal.getBuffer());
            throw new BadBidException("Enter " + amount + orMore, 8);
        }
    }

    private void checkSignOn(JHTML htmlDocument) throws BadBidException {
        String signOn = htmlDocument.getTitle();
        if (signOn != null && signOn.equalsIgnoreCase("Sign In")) {
            throw new BadBidException("sign in", 18);
        }
    }

    private Integer getMatchedResult(String matched_text) {
        for (String regex : this.mResultHash.keySet()) {
            String hacked = "(?msi).*" + regex.replace(" ", "\\s+") + ".*";
            if (!matched_text.matches(hacked)) continue;
            return this.mResultHash.get(regex);
        }
        return null;
    }

    @Override
    public int buy(AuctionEntry ae, int quantity) {
        StringBuffer sb;
        String buyRequest = this.T.s("ebayServer.buyRequest");
        buyRequest = buyRequest + "&item=" + ae.getIdentifier() + "&quantity=" + quantity;
        try {
            CookieJar cj = this.mLogin.getNecessaryCookie(false);
            sb = cj.getPage(buyRequest, null, null);
            JHTML doBuy = new JHTML(sb);
            JHTML.Form buyForm = doBuy.getFormWithInput("uiid");
            if (buyForm != null) {
                buyForm.delInput("BIN_button");
                StringBuffer loadedPage = cj.getPage(buyForm.getAction(), buyForm.getFormData(), buyRequest);
                if (loadedPage == null) {
                    return 12;
                }
                return this.handlePostBidBuyPage(cj, loadedPage, buyForm, ae);
            }
        }
        catch (CookieJar.CookieException ignored) {
            return 12;
        }
        catch (UnsupportedEncodingException uee) {
            JConfig.log().handleException("UTF-8 not supported locally, can't URLEncode buy form.", uee);
            return 12;
        }
        ae.setErrorPage(sb);
        return -1;
    }

    @Override
    public int bid(AuctionEntry inEntry, Currency inBid, int inQuantity) {
        JHTML.Form bidForm;
        UpdateBlocker.startBlocking();
        if (JConfig.queryConfiguration("sound.enable", "false").equals("true")) {
            MQFactory.getConcrete("sfx").enqueue("/audio/bid.mp3");
        }
        CookieJar cj = this.mLogin.getNecessaryCookie(false);
        try {
            bidForm = this.getBidForm(cj, inEntry, inBid);
        }
        catch (BadBidException bbe) {
            UpdateBlocker.endBlocking();
            return bbe.getResult();
        }
        if (bidForm != null) {
            int rval = this.placeFinalBid(cj, bidForm, inEntry, inBid, inQuantity);
            UpdateBlocker.endBlocking();
            return rval;
        }
        JConfig.log().logMessage("Bad/nonexistent key read in bid, or connection failure!");
        UpdateBlocker.endBlocking();
        return -1;
    }

    @Override
    public int placeFinalBid(CookieJar cj, JHTML.Form bidForm, AuctionEntry inEntry, Currency inBid, int inQuantity) {
        String bidRequest = Externalized.getString("ebayServer.protocol") + this.T.s("ebayServer.bidHost") + Externalized.getString("ebayServer.V3file");
        String bidInfo = Externalized.getString("ebayServer.bidCmd") + Externalized.getString("ebayServer.itemCGI") + inEntry.getIdentifier() + Externalized.getString("ebayServer.quantCGI") + inQuantity + Externalized.getString("ebayServer.bidCGI") + inBid.getValue();
        String bidURL = bidRequest + '?' + bidInfo;
        bidForm.delInput("BIN_button");
        StringBuffer loadedPage = null;
        try {
            if (JConfig.debugging) {
                inEntry.setLastStatus("Submitting bid form.");
            }
            loadedPage = cj.getPage(bidForm.getAction(), bidForm.getFormData(), bidURL);
            if (JConfig.debugging) {
                inEntry.setLastStatus("Done submitting bid form.");
            }
        }
        catch (UnsupportedEncodingException uee) {
            JConfig.log().handleException("UTF-8 not supported locally, can't URLEncode bid form.", uee);
        }
        catch (CookieJar.CookieException ignored) {
            return 12;
        }
        if (loadedPage == null) {
            return 12;
        }
        return this.handlePostBidBuyPage(cj, loadedPage, bidForm, inEntry);
    }

    private int handlePostBidBuyPage(CookieJar cj, StringBuffer loadedPage, JHTML.Form bidForm, AuctionEntry inEntry) {
        String errMsg;
        JHTML htmlDocument;
        JHTML.Form continueForm;
        if (JConfig.debugging) {
            inEntry.setLastStatus("Loading post-bid data.");
        }
        if ((continueForm = (htmlDocument = new JHTML(loadedPage)).getFormWithInput("firedFilterId")) != null) {
            try {
                inEntry.setLastStatus("Trying to 'continue' to the bid result page.");
                String cgi = continueForm.getFormData();
                cgi = cgi.replaceFirst("%[A-F][A-F0-9]%A0", "%A0");
                URLConnection huc = cj.connect(continueForm.getAction(), cgi, null, true, null);
                if (huc == null) {
                    return 12;
                }
                loadedPage = Http.net().receivePage(huc);
                if (loadedPage == null) {
                    return 12;
                }
                htmlDocument = new JHTML(loadedPage);
            }
            catch (Exception ignored) {
                return 12;
            }
        }
        if ((errMsg = htmlDocument.grep(this.mBidResultRegex)) != null) {
            Matcher bidMatch = this.mFindBidResult.matcher(errMsg);
            bidMatch.find();
            String matched_error = bidMatch.group().toLowerCase();
            Integer bidResult = this.getMatchedResult(matched_error);
            JConfig.log().dump2File("error-" + bidResult + ".html", loadedPage);
            int result = 0;
            if (bidResult != null) {
                result = bidResult;
                if (result == 10 || result == 19 || result == 20) {
                    inEntry.setErrorPage(loadedPage);
                }
            } else {
                String orMore;
                String amount = htmlDocument.getNextContentAfterRegex("Enter");
                if (amount != null && (orMore = htmlDocument.getNextContent()) != null && orMore.indexOf("or more") != -1) {
                    result = 8;
                }
            }
            if (JConfig.debugging) {
                inEntry.setLastStatus("Done loading post-bid data.");
            }
            if (bidResult != null) {
                return result;
            }
        }
        bidForm.setText("user", "HIDDEN");
        bidForm.setText("pass", "HIDDEN");
        String safeBidInfo = "";
        try {
            safeBidInfo = bidForm.getCGI();
        }
        catch (UnsupportedEncodingException uee) {
            JConfig.log().handleException("UTF-8 not supported locally, can't URLEncode CGI for debugging.", uee);
        }
        if (JConfig.debugging) {
            inEntry.setLastStatus("Failed to load post-bid data. 'Show Last Error' from context menu to see the failure page from the post-bid page.");
        }
        JConfig.log().dump2File("unknown-" + inEntry.getIdentifier() + ".html", loadedPage);
        inEntry.setErrorPage(loadedPage);
        JConfig.log().logFile(safeBidInfo, loadedPage);
        return -1;
    }

    private class BidFormReturn {
        private boolean mSuccess;
        private JHTML.Form mForm;
        private JHTML mDocument;
        private StringBuffer mBuffer;

        public boolean isSuccess() {
            return this.mSuccess;
        }

        public JHTML.Form getForm() {
            return this.mForm;
        }

        public JHTML getDocument() {
            return this.mDocument;
        }

        public StringBuffer getBuffer() {
            return this.mBuffer;
        }

        private BidFormReturn(boolean success, JHTML.Form form, JHTML document, StringBuffer buffer) {
            this.mSuccess = success;
            this.mForm = form;
            this.mDocument = document;
            this.mBuffer = buffer;
        }
    }
}

