/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.ui;

import com.cyberfox.util.config.JConfig;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.jbidwatcher.auction.AuctionEntry;
import com.jbidwatcher.auction.AuctionInfo;
import com.jbidwatcher.auction.DeletedEntry;
import com.jbidwatcher.auction.EntryCorral;
import com.jbidwatcher.auction.EntryManager;
import com.jbidwatcher.auction.server.AuctionServer;
import com.jbidwatcher.auction.server.AuctionServerManager;
import com.jbidwatcher.auction.server.AuctionStats;
import com.jbidwatcher.ui.FilterManager;
import com.jbidwatcher.util.PauseManager;
import com.jbidwatcher.util.Record;
import com.jbidwatcher.util.config.JConfig;
import com.jbidwatcher.util.queue.MQFactory;
import com.jbidwatcher.util.queue.MessageQueue;
import com.jbidwatcher.util.queue.TimerHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.json.simple.JSONObject;

@Singleton
public class AuctionsManager
implements TimerHandler.WakeupProcess,
EntryManager,
JConfig.ConfigListener,
MessageQueue.Listener {
    private FilterManager mFilter;
    private final PauseManager mPauseManager;
    private final EntryCorral entryCorral;
    private final Provider<AuctionServerManager> serverManagerProvider;
    private long mCheckpointFrequency = 600000L;
    private long mLastCheckpointed = System.currentTimeMillis();
    private static TimerHandler sTimer = null;

    @Inject
    private AuctionsManager(FilterManager filterManager, PauseManager pauseManager, EntryCorral corral, Provider<AuctionServerManager> serverManagerProvider) {
        this.mPauseManager = pauseManager;
        this.mFilter = filterManager;
        this.entryCorral = corral;
        this.serverManagerProvider = serverManagerProvider;
        MQFactory.getConcrete("manager").registerListener(this);
    }

    @Override
    public void messageAction(Object deQ) {
        String identifier = (String)deQ;
        AuctionEntry ae = (AuctionEntry)this.entryCorral.takeForRead(identifier);
        this.addEntry(ae);
    }

    public FilterManager getFilters() {
        return this.mFilter;
    }

    private void checkSnapshot() {
        if (this.mLastCheckpointed + this.mCheckpointFrequency < System.currentTimeMillis()) {
            this.mLastCheckpointed = System.currentTimeMillis();
            System.gc();
        }
    }

    private List<AuctionEntry> normalizeEntries(List<AuctionEntry> entries) {
        ArrayList<AuctionEntry> output = new ArrayList<AuctionEntry>();
        for (AuctionEntry ae : entries) {
            output.add((AuctionEntry)this.entryCorral.takeForRead(ae.getIdentifier()));
        }
        return output;
    }

    @Override
    public boolean check() throws InterruptedException {
        List<AuctionEntry> needUpdate;
        boolean neededUpdate = false;
        if (!this.mPauseManager.isPaused()) {
            needUpdate = this.normalizeEntries(EntryCorral.findAllNeedingUpdates(4140000L));
            this.updateList(needUpdate);
            neededUpdate = !needUpdate.isEmpty();
            needUpdate = this.normalizeEntries(EntryCorral.findEndingNeedingUpdates(60000L));
            this.updateList(needUpdate);
            neededUpdate |= !needUpdate.isEmpty();
        }
        needUpdate = this.normalizeEntries(EntryCorral.findManualUpdates());
        this.updateList(needUpdate);
        boolean bl = !needUpdate.isEmpty();
        this.checkSnapshot();
        return neededUpdate |= bl;
    }

    public void doUpdate(AuctionEntry ae) {
        String titleWithComment = ae.getTitleAndComment();
        if (!ae.isComplete() || ae.isUpdateRequired()) {
            MQFactory.getConcrete("Swing").enqueue("Updating " + titleWithComment);
            MQFactory.getConcrete("redraw").enqueue(ae.getIdentifier());
            Thread.yield();
            Record before = ae.getBacking();
            ae.update();
            Record after = ae.getBacking();
            boolean same = JSONObject.toJSONString((Map)after).equals(JSONObject.toJSONString((Map)before));
            MQFactory.getConcrete("my").enqueue("UPDATE " + ae.getIdentifier() + "," + Boolean.toString(!same));
            if (!same) {
                String category = ae.getCategory();
                MQFactory.getConcrete("redraw").enqueue(category);
            }
            ae = (AuctionEntry)this.entryCorral.takeForWrite(ae.getIdentifier());
            this.entryCorral.erase(ae.getIdentifier());
            MQFactory.getConcrete("redraw").enqueue(ae.getIdentifier());
            MQFactory.getConcrete("Swing").enqueue("Done updating " + ae.getTitleAndComment());
        }
    }

    private void updateList(List<AuctionEntry> needUpdate) throws InterruptedException {
        for (AuctionEntry ae : needUpdate) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (this.mPauseManager.isPaused()) continue;
            boolean forced = ae.isUpdateRequired();
            MQFactory.getConcrete("update " + ae.getCategory()).enqueue("start " + ae.getIdentifier());
            this.doUpdate(ae);
            this.entryCorral.putWeakly(ae);
            MQFactory.getConcrete("update " + ae.getCategory()).enqueue("stop " + ae.getIdentifier());
            if (!forced) continue;
            MQFactory.getConcrete("redraw").enqueue(ae.getCategory());
        }
    }

    @Override
    public void addEntry(AuctionEntry ae) {
        this.mFilter.addAuction(ae);
    }

    public void delEntry(AuctionEntry ae) {
        String id = ae.getIdentifier();
        DeletedEntry.create(id);
        ae.cancelSnipe(false);
        this.mFilter.deleteAuction(ae);
        ae.delete();
    }

    public int loadAuctionsFromDatabase() {
        int totalCount = AuctionInfo.count();
        int activeCount = EntryCorral.activeCount();
        MQFactory.getConcrete("splash").enqueue("WIDTH " + activeCount);
        MQFactory.getConcrete("splash").enqueue("SET 0");
        AuctionServer newServer = ((AuctionServerManager)this.serverManagerProvider.get()).getServer();
        if (totalCount == 0) {
            if (JConfig.queryConfiguration("stats.auctions") == null) {
                JConfig.setConfiguration("stats.auctions", "0");
            }
            return 0;
        }
        ((AuctionServerManager)this.serverManagerProvider.get()).loadAuctionsFromDB(newServer);
        AuctionStats as = ((AuctionServerManager)this.serverManagerProvider.get()).getStats();
        int savedCount = Integer.parseInt(JConfig.queryConfiguration("last.auctioncount", "-1"));
        if (as != null && savedCount != -1 && as.getCount() != savedCount) {
            MQFactory.getConcrete("Swing").enqueue("NOTIFY Failed to load all auctions from database.");
        }
        return activeCount;
    }

    public int clearDeleted() {
        int rval = DeletedEntry.clear();
        System.gc();
        return rval;
    }

    public void start() {
        if (sTimer == null) {
            sTimer = new TimerHandler(this);
            sTimer.setName("Updates");
            sTimer.start();
        }
        JConfig.registerListener(this);
    }

    @Override
    public void updateConfiguration() {
        String newSnipeTime = JConfig.queryConfiguration("snipemilliseconds");
        if (newSnipeTime != null) {
            AuctionEntry.setDefaultSnipeTime(Long.parseLong(newSnipeTime));
        }
    }
}

