/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.ui;

import com.jbidwatcher.ui.config.JConfigTab;
import com.jbidwatcher.ui.util.BasicDialog;
import com.jbidwatcher.ui.util.JMouseAdapter;
import com.jbidwatcher.ui.util.SpringUtilities;
import com.jbidwatcher.util.config.JConfig;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;

public class SnipeDialog
extends BasicDialog {
    private JTextField snipeAmount;
    private JCheckBox subtractShipping;
    private JLabel auctionInfo;
    String mInitialValue = "";

    public SnipeDialog(String initial) {
        super((Frame)null, "Sniping", true, JMouseAdapter.getCurrentGraphicsConfiguration());
        if (initial != null && initial.length() != 0) {
            this.mInitialValue = initial;
        }
        this.construct();
    }

    public SnipeDialog() {
        super((Frame)null, "Sniping", true, JMouseAdapter.getCurrentGraphicsConfiguration());
        this.construct();
    }

    private void construct() {
        this.setBasicContentPane(new JPanel(new SpringLayout()));
        this.addBehavior();
        this.setupUI();
    }

    @Override
    protected void onOK() {
        this.dispose();
    }

    @Override
    protected void onCancel() {
        this.setVisible(false);
    }

    public String getAmount() {
        return this.snipeAmount.getText().replace(',', '.');
    }

    public boolean subtractShipping() {
        return this.subtractShipping.isSelected();
    }

    public void setPrompt(String prompt) {
        this.auctionInfo.setText(prompt);
        this.auctionInfo.setVisible(true);
        this.auctionInfo.invalidate();
        this.getBasicContentPane().validate();
        this.validate();
    }

    public void clear() {
        this.getRootPane().setDefaultButton(this.getButtonOK());
        this.snipeAmount.setText(this.mInitialValue);
    }

    private void setupUI() {
        this.auctionInfo = new JLabel();
        this.auctionInfo.setText("Auction Information");
        this.getBasicContentPane().add(this.auctionInfo);
        JPanel inputPane = new JPanel();
        inputPane.setLayout(new BoxLayout(inputPane, 1));
        this.snipeAmount = new JTextField(10);
        this.snipeAmount.setText(this.mInitialValue);
        this.subtractShipping = new JCheckBox();
        this.subtractShipping.setSelected(JConfig.queryConfiguration("snipe.subtract_shipping", "false").equals("true"));
        this.subtractShipping.setText("Auto-subtract shipping and insurance (p/p)");
        JPanel promptPane = new JPanel(new SpringLayout());
        JLabel snipeLabel = new JLabel("How much do you wish to snipe?", 11);
        promptPane.add(snipeLabel);
        snipeLabel.setLabelFor(this.snipeAmount);
        promptPane.add(this.snipeAmount);
        SpringUtilities.makeCompactGrid(promptPane, 1, 2, 6, 6, 6, 3);
        this.getBasicContentPane().add(promptPane);
        this.getBasicContentPane().add(this.subtractShipping);
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BorderLayout());
        bottomPanel.add((Component)JConfigTab.makeLine(this.getButtonOK(), this.getButtonCancel()), "East");
        this.getBasicContentPane().add(bottomPanel);
        SpringUtilities.makeCompactGrid(this.getBasicContentPane(), 4, 1, 6, 6, 6, 6);
    }
}

