/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.ui.config;

import com.jbidwatcher.platform.Browser;
import com.jbidwatcher.ui.config.JConfigTab;
import com.jbidwatcher.ui.util.JBEditorPane;
import com.jbidwatcher.ui.util.JPasteListener;
import com.jbidwatcher.ui.util.OptionUI;
import com.jbidwatcher.util.config.JConfig;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class JConfigBrowserTab
extends JConfigTab {
    JTextField linuxBrowserLaunchCommand;
    JTextField windowsBrowserLaunchCommand;
    JCheckBox overrideDefault;

    @Override
    public String getTabName() {
        return "Browser";
    }

    @Override
    public void cancel() {
    }

    @Override
    public void apply() {
        JConfig.setConfiguration("browser.launch.Linux", this.linuxBrowserLaunchCommand.getText());
        JConfig.setConfiguration("browser.launch.Windows", this.windowsBrowserLaunchCommand.getText());
        JConfig.setConfiguration("browser.override", this.overrideDefault.isSelected() ? "true" : "false");
    }

    @Override
    public void updateValues() {
        String overrideOn = JConfig.queryConfiguration("browser.override", "false");
        this.linuxBrowserLaunchCommand.setText(JConfig.queryConfiguration("browser.launch.Linux", "firefox"));
        this.windowsBrowserLaunchCommand.setText(JConfig.queryConfiguration("browser.launch.Windows", "start netscape"));
        this.overrideDefault.setSelected(overrideOn.equals("true"));
    }

    private JPanel buildLinuxBrowserLaunch(JPasteListener pasteListener) {
        JPanel tp = new JPanel();
        tp.setBorder(BorderFactory.createTitledBorder("Browser Command"));
        tp.setLayout(new BoxLayout(tp, 1));
        this.linuxBrowserLaunchCommand = new JTextField();
        this.linuxBrowserLaunchCommand.addMouseListener(pasteListener);
        this.linuxBrowserLaunchCommand.setText(JConfig.queryConfiguration("browser.launch.Linux"));
        this.linuxBrowserLaunchCommand.setEditable(true);
        this.linuxBrowserLaunchCommand.getAccessibleContext().setAccessibleName("Command to use to launch the web browser under Linux");
        this.windowsBrowserLaunchCommand = new JTextField();
        this.windowsBrowserLaunchCommand.addMouseListener(pasteListener);
        this.windowsBrowserLaunchCommand.setText(JConfig.queryConfiguration("browser.launch.Windows"));
        this.windowsBrowserLaunchCommand.setEditable(true);
        this.windowsBrowserLaunchCommand.getAccessibleContext().setAccessibleName("Command to use to launch the web browser under Windows");
        tp.add(new JLabel("Linux command:"));
        tp.add(this.linuxBrowserLaunchCommand);
        tp.add(new JLabel("Windows command:"));
        tp.add(this.windowsBrowserLaunchCommand);
        if (!JConfig.getOS().equals("Linux") && !JConfig.getOS().equals("Windows")) {
            String otherPlatformNotice = "<html><body><div style=\"margin-left: 10px; font-size: 0.96em;\"><i>To set the browser for other platforms, go to the Advanced tab, and set<br>a key of: </i><code>browser.launch." + JConfig.getOS() + "</code><i> to a value of whatever the path to your browser is.</i></div></body></html>";
            JBEditorPane jep = OptionUI.getHTMLLabel(otherPlatformNotice);
            tp.add(jep);
        }
        return tp;
    }

    private JPanel buildOverridePreference() {
        JPanel tp = new JPanel();
        tp.setBorder(BorderFactory.createTitledBorder("Browser Command"));
        tp.setLayout(new GridLayout(2, 2));
        JPanel buttonPanel = new JPanel();
        JButton detectButton = new JButton("Detect Browser");
        String overrideOn = JConfig.queryConfiguration("browser.override", "false");
        buttonPanel.setLayout(new BorderLayout());
        this.overrideDefault = new JCheckBox("Override 'detected' browser");
        this.overrideDefault.setSelected(overrideOn.equals("true"));
        detectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (ae.getActionCommand().equals("Detect Browser")) {
                    if (JConfig.getOS().equalsIgnoreCase("windows")) {
                        String browser = Browser.getBrowserCommand();
                        if (browser != null) {
                            JConfigBrowserTab.this.windowsBrowserLaunchCommand.setText(browser);
                        } else {
                            JOptionPane.showMessageDialog(null, "This Java Virtual Machine cannot detect the default browser type.\nUpgrading to a post-1.4 version of Java might help.", "Cannot detect browser", 1);
                        }
                    } else {
                        JConfigBrowserTab.this.linuxBrowserLaunchCommand.setText(Browser.getBrowserCommand());
                    }
                }
            }
        });
        tp.add((Component)buttonPanel, "West");
        buttonPanel.add((Component)detectButton, "West");
        buttonPanel.add((Component)this.buildTestButton(), "East");
        tp.add((Component)this.overrideDefault, "South");
        return tp;
    }

    private JButton buildTestButton() {
        JButton testButton = new JButton("Test Browser");
        testButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (ae.getActionCommand().equals("Test Browser")) {
                    JConfigBrowserTab.this.apply();
                    if (!Browser.launchBrowser("http://www.jbidwatcher.com")) {
                        JOptionPane.showMessageDialog(null, "<html><body>Failed to launch browser.  The error log contains more details,<br>but some common problems are:<ul><li>Your path does not include the binary to launch.</li><li>The executable is misnamed.</li><li>The executable path contains spaces, but is not quoted.</li></ul>You should be able to copy the browser line, and execute it\nat the command line, followed by a URL, and it should go to\nthat page.", "Failed to launch browser", 1);
                    }
                }
            }
        });
        return testButton;
    }

    public JConfigBrowserTab(JPasteListener pasteListener) {
        this.setLayout(new BorderLayout());
        this.add((Component)JConfigBrowserTab.panelPack(this.buildLinuxBrowserLaunch(pasteListener)), "North");
        this.add((Component)JConfigBrowserTab.panelPack(this.buildOverridePreference()), "Center");
    }
}

