/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.ui.config;

import com.cyberfox.util.platform.Platform;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.jbidwatcher.auction.server.AuctionServerManager;
import com.jbidwatcher.my.MyJBidwatcher;
import com.jbidwatcher.ui.config.JConfigAdvancedTab;
import com.jbidwatcher.ui.config.JConfigBrowserTab;
import com.jbidwatcher.ui.config.JConfigDatabaseTab;
import com.jbidwatcher.ui.config.JConfigEbayTab;
import com.jbidwatcher.ui.config.JConfigFirewallTab;
import com.jbidwatcher.ui.config.JConfigGeneralTab;
import com.jbidwatcher.ui.config.JConfigMyJBidwatcherTab;
import com.jbidwatcher.ui.config.JConfigSnipeTab;
import com.jbidwatcher.ui.config.JConfigStubTab;
import com.jbidwatcher.ui.config.JConfigTab;
import com.jbidwatcher.ui.util.JBidFrame;
import com.jbidwatcher.ui.util.JPasteListener;
import com.jbidwatcher.ui.util.OptionUI;
import com.jbidwatcher.util.config.JConfig;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

@Singleton
public class JConfigFrame
implements ActionListener {
    private JFrame mainFrame;
    private boolean buttonPressed = false;
    private List<JConfigTab> allTabs;
    private static int cfgCount = 1;
    private static JButton advancedToggleButton;
    private JConfigTab quickTab;
    private JPanel cards;
    private static String QUICK_CARD;
    private static String ADVANCED_CARD;

    public void spinWait() {
        while (!this.buttonPressed) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Inject
    public JConfigFrame(MyJBidwatcher myJBidwatcher, AuctionServerManager serverManager, JPasteListener pasteListener) {
        String friendlyName = serverManager.getServer().getFriendlyName();
        this.mainFrame = this.createConfigFrame(myJBidwatcher, pasteListener, friendlyName);
        Rectangle rec = OptionUI.findCenterBounds(this.mainFrame.getPreferredSize());
        this.mainFrame.setLocation(rec.x, rec.y);
        this.show();
    }

    public final void show() {
        for (JConfigTab jct : this.allTabs) {
            jct.updateValues();
        }
        this.mainFrame.setState(0);
        this.mainFrame.setVisible(true);
    }

    private void applyAll() {
        for (JConfigTab jct : this.allTabs) {
            jct.apply();
        }
    }

    private void cancelAll() {
        for (JConfigTab jct : this.allTabs) {
            jct.cancel();
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String actionString = ae.getActionCommand();
        if (actionString.equals("Save")) {
            this.applyAll();
            JConfig.updateComplete();
            JConfig.saveConfiguration();
        } else if (actionString.equals("Cancel")) {
            this.cancelAll();
        } else {
            if (actionString.equals("Advanced")) {
                this.quickTab.apply();
                JConfig.updateComplete();
                CardLayout swap = (CardLayout)this.cards.getLayout();
                advancedToggleButton.setText("Quick");
                advancedToggleButton.setActionCommand("Quick");
                JConfig.setConfiguration("config.level", "advanced");
                for (JConfigTab jct : this.allTabs) {
                    jct.updateValues();
                }
                swap.show(this.cards, ADVANCED_CARD);
                return;
            }
            if (actionString.equals("Quick")) {
                this.applyAll();
                JConfig.updateComplete();
                CardLayout swap = (CardLayout)this.cards.getLayout();
                advancedToggleButton.setText("Advanced");
                advancedToggleButton.setActionCommand("Advanced");
                JConfig.setConfiguration("config.level", "quick");
                this.quickTab.updateValues();
                swap.show(this.cards, QUICK_CARD);
                return;
            }
        }
        this.mainFrame.setVisible(false);
        this.buttonPressed = true;
    }

    public static JPanel buildButtonPane(ActionListener al) {
        JPanel tp = new JPanel();
        JButton cancelButton = new JButton("Cancel");
        cancelButton.setToolTipText("Cancel any changes made.");
        JButton saveButton = new JButton("Save");
        saveButton.setToolTipText("Apply changes and save settings.");
        boolean isInQuickMode = JConfig.queryConfiguration("config.level", "quick").equals("quick");
        advancedToggleButton = new JButton(isInQuickMode ? "Advanced" : "Quick");
        advancedToggleButton.setToolTipText("Switch between advanced and quick configuration");
        tp.add((Component)advancedToggleButton, "West");
        tp.add((Component)cancelButton, "Center");
        tp.add((Component)saveButton, "East");
        advancedToggleButton.addActionListener(al);
        cancelButton.addActionListener(al);
        saveButton.addActionListener(al);
        return tp;
    }

    private static void anotherConfig() {
        ++cfgCount;
    }

    private JFrame createConfigFrame(MyJBidwatcher myJBidwatcher, JPasteListener pasteListener, String friendlyName) {
        JBidFrame w;
        JTabbedPane jtpAllTabs = new JTabbedPane();
        if (cfgCount == 2) {
            w = new JBidFrame("Configuration Manager (2)");
        } else {
            JConfigFrame.anotherConfig();
            w = new JBidFrame("Configuration Manager");
        }
        Container contentPane = w.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.establishCards(jtpAllTabs, contentPane, pasteListener, friendlyName);
        this.allTabs = new ArrayList<JConfigTab>();
        this.allTabs.add(new JConfigGeneralTab());
        this.allTabs.add(new JConfigEbayTab(false, pasteListener, friendlyName));
        this.allTabs.add(this.quickTab);
        if (Platform.isMac()) {
            this.allTabs.add(new JConfigMacBrowserTab());
        } else {
            this.allTabs.add(new JConfigBrowserTab(pasteListener));
        }
        this.allTabs.add(new JConfigFirewallTab(pasteListener));
        this.allTabs.add(new JConfigSnipeTab(pasteListener));
        this.allTabs.add(new JConfigMyJBidwatcherTab(myJBidwatcher, pasteListener));
        this.allTabs.add(new JConfigDatabaseTab(pasteListener));
        this.allTabs.add(new JConfigSecurityTab());
        this.allTabs.add(new JConfigAdvancedTab(pasteListener));
        for (JConfigTab allTab : this.allTabs) {
            if (allTab == this.quickTab) continue;
            allTab.setOpaque(true);
            jtpAllTabs.addTab(allTab.getTabName(), allTab);
        }
        jtpAllTabs.setSelectedIndex(0);
        contentPane.add((Component)JConfigFrame.buildButtonPane(this), "South");
        w.addWindowListener(new IconifyingWindowAdapter(w));
        w.pack();
        w.setResizable(false);
        return w;
    }

    private void establishCards(JTabbedPane jtpAllTabs, Container contentPane, JPasteListener pasteListener, String friendlyName) {
        CardLayout swapper = new CardLayout();
        this.cards = new JPanel(swapper);
        contentPane.add((Component)this.cards, "Center");
        this.quickTab = new JConfigEbayTab(true, pasteListener, friendlyName);
        JPanel quickPanel = new JPanel(new BorderLayout());
        quickPanel.setBorder(BorderFactory.createTitledBorder(null, "Quick Start Configuration", 2, 1));
        quickPanel.add((Component)this.quickTab, "Center");
        this.cards.add((Component)quickPanel, QUICK_CARD);
        this.cards.add((Component)jtpAllTabs, ADVANCED_CARD);
        if (JConfig.queryConfiguration("config.level", "quick").equals("advanced")) {
            swapper.show(this.cards, ADVANCED_CARD);
        }
    }

    static {
        QUICK_CARD = "Quick Configuration";
        ADVANCED_CARD = "Advanced Configuration";
    }

    public static class IconifyingWindowAdapter
    extends WindowAdapter {
        private final JFrame _window;

        public IconifyingWindowAdapter(JFrame window) {
            this._window = window;
        }

        @Override
        public void windowIconified(WindowEvent we) {
            super.windowIconified(we);
            if (Platform.supportsTray() && Platform.isTrayEnabled() && JConfig.queryConfiguration("windows.tray", "true").equals("true") && JConfig.queryConfiguration("windows.minimize", "true").equals("true")) {
                this._window.setVisible(false);
            }
        }

        @Override
        public void windowDeiconified(WindowEvent we) {
            super.windowDeiconified(we);
            if (Platform.supportsTray() && Platform.isTrayEnabled() && JConfig.queryConfiguration("windows.tray", "true").equals("true") && JConfig.queryConfiguration("windows.minimize", "true").equals("true")) {
                this._window.setState(0);
                this._window.setVisible(true);
            }
        }
    }

    private final class JConfigMacBrowserTab
    extends JConfigStubTab {
        @Override
        public String getTabName() {
            return "Browser";
        }

        JConfigMacBrowserTab() {
            JLabel newLabel = new JLabel("Under MacOSX, the browser does not need to be configured.");
            this.setLayout(new BorderLayout());
            this.add((Component)newLabel, "Center");
        }
    }

    private class JConfigSecurityTab
    extends JConfigStubTab {
        private JConfigSecurityTab() {
        }

        @Override
        public String getTabName() {
            return "Security";
        }
    }
}

