/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.ui;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.jbidwatcher.auction.AuctionEntry;
import com.jbidwatcher.auction.MultiSnipe;
import com.jbidwatcher.auction.MultiSnipeManager;
import com.jbidwatcher.util.config.JConfig;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;

@Singleton
public class myTableCellRenderer
extends DefaultTableCellRenderer {
    private static Font boldFont = null;
    private static Font fixedFont = null;
    @Inject
    private MultiSnipeManager multiManager;
    private static final Color darkGreen = new Color(0, 127, 0);
    private static final Color darkRed = new Color(127, 0, 0);
    private static final Color medBlue = new Color(0, 0, 191);
    private int mRow = 0;
    private boolean mThumbnail = false;
    private boolean mSelected;
    private Map<Integer, GradientPaint> gradientCache = new HashMap<Integer, GradientPaint>();
    private Color mLastColor = null;
    private static final String evenList = "List.evenRowBackgroundPainter";
    private static final String oddList = "List.oddRowBackgroundPainter";
    private static final Color evenDefault = new Color(241, 246, 254);
    private static final Color oddDefault = new Color(255, 255, 255);
    private static Font sDefaultFont = null;

    public static void resetBehavior() {
        boldFont = null;
        fixedFont = null;
    }

    @Override
    public void setValue(Object o) {
        if (o instanceof Icon) {
            super.setIcon((Icon)o);
            super.setValue(null);
        } else {
            super.setIcon(null);
            super.setValue(o);
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        column = table.convertColumnIndexToModel(column);
        if (value instanceof Icon) {
            this.setHorizontalAlignment(0);
            this.setVerticalAlignment(0);
        } else {
            this.setHorizontalAlignment(2);
        }
        JComponent returnComponent = (JComponent)super.getTableCellRendererComponent(table, value, isSelected, false, row, column);
        returnComponent.setOpaque(false);
        Object rowData = table.getValueAt(row, -1);
        if (rowData instanceof String) {
            return returnComponent;
        }
        AuctionEntry ae = (AuctionEntry)rowData;
        if (ae == null) {
            return returnComponent;
        }
        Color foreground = this.chooseForeground(ae, column, table.getForeground());
        this.mRow = row;
        boolean bl = this.mThumbnail = column == 21;
        if (ae.isSniped() && (column == 2 || column == 20 || column == 10)) {
            returnComponent.setBackground(this.snipeBidBackground(ae));
            returnComponent.setOpaque(true);
        }
        this.mSelected = isSelected;
        Font foo = this.chooseFont(returnComponent.getFont(), ae, column);
        returnComponent.setFont(foo);
        returnComponent.setForeground(foreground);
        return returnComponent;
    }

    private Color lighten(Color background) {
        int r = background.getRed();
        int g = background.getGreen();
        int b = background.getBlue();
        r = Math.min(255, r + 20);
        g = Math.min(255, g + 20);
        b = Math.min(255, b + 20);
        return new Color(r, g, b);
    }

    @Override
    public void paintComponent(Graphics g) {
        if (g != null) {
            boolean painted = false;
            if (this.mSelected) {
                Color selected = UIManager.getColor("Table.selectionBackground");
                String userColor = JConfig.queryConfiguration("selection.color");
                if (userColor != null) {
                    selected = MultiSnipe.reverseColor(userColor);
                }
                this.renderGradient(g, selected);
            } else {
                painted = this.drawCustomBackground(g);
            }
            if (this.mThumbnail) {
                this.drawThumbnailBox(g);
            }
            if (!painted) {
                super.paintComponent(g);
            }
        }
    }

    private boolean drawCustomBackground(Graphics g) {
        boolean painted;
        Border bgPaint = UIManager.getBorder(this.mRow % 2 == 0 ? evenList : oddList);
        if (bgPaint != null) {
            bgPaint.paintBorder(this, g, 0, 0, this.getWidth(), this.getHeight());
            super.paintComponent(g);
            painted = true;
        } else {
            this.renderColor(g, this.mRow % 2 == 0 ? evenDefault : oddDefault);
            super.paintComponent(g);
            painted = true;
        }
        Graphics2D g2d = (Graphics2D)g;
        float alpha = 0.1f;
        Composite saved = g2d.getComposite();
        g2d.setComposite(AlphaComposite.getInstance(3, alpha));
        g.setColor(Color.BLACK);
        g.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
        g2d.setComposite(saved);
        return painted;
    }

    private void drawThumbnailBox(Graphics g) {
        int top = this.getHeight() / 2 - 32;
        int left = this.getWidth() / 2 - 32;
        float alpha = 0.1f;
        Graphics2D g2d = (Graphics2D)g;
        Color oldColor = g2d.getColor();
        Stroke oldStroke = g2d.getStroke();
        Composite oldComp = g2d.getComposite();
        g2d.setComposite(AlphaComposite.getInstance(3, alpha));
        g2d.setColor(Color.BLACK);
        g2d.setStroke(new BasicStroke(2.0f, 1, 1, 0.0f, new float[]{4.0f}, 0.0f));
        g2d.drawRoundRect(left, top, 64, 64, 4, 4);
        g2d.setStroke(oldStroke);
        g2d.setColor(oldColor);
        g2d.setComposite(oldComp);
    }

    private void renderGradient(Graphics g, Color selected) {
        if (this.mLastColor != null && !this.mLastColor.equals(selected)) {
            this.gradientCache.clear();
        }
        this.mLastColor = selected;
        GradientPaint paint = this.gradientCache.get(this.cacheMapper());
        if (paint == null) {
            paint = new GradientPaint(0.0f, 0.0f, this.lighten(selected), 0.0f, this.getHeight(), selected, false);
            this.gradientCache.put(this.cacheMapper(), paint);
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.setPaint(paint);
        Rectangle bounds = g2d.getClipBounds();
        g2d.fillRect((int)bounds.getX(), (int)bounds.getY(), (int)bounds.getWidth(), (int)bounds.getHeight());
    }

    private void renderColor(Graphics g, Color color) {
        g.setColor(color);
        Rectangle bounds = g.getClipBounds();
        g.fillRect((int)bounds.getX(), (int)bounds.getY(), (int)bounds.getWidth(), (int)bounds.getHeight());
    }

    private int cacheMapper() {
        return 10000 * (this.mRow % 2) + this.getHeight();
    }

    private Color chooseForeground(AuctionEntry ae, int col, Color foreground) {
        switch (col) {
            case 0: {
                return this.chooseIDColor(ae);
            }
            case 2: 
            case 20: {
                return this.snipeBidColor(ae);
            }
            case 4: {
                return this.titleColor(ae);
            }
        }
        return foreground == null ? Color.BLACK : foreground;
    }

    public Font getDefaultFont() {
        String cfgDefault;
        if (sDefaultFont == null && (cfgDefault = JConfig.queryConfiguration("default.font")) != null) {
            sDefaultFont = Font.decode(cfgDefault);
        }
        return sDefaultFont;
    }

    private static String getStyleName(int style) {
        switch (style) {
            case 1: {
                return "bold";
            }
            case 2: {
                return "italic";
            }
            case 3: {
                return "bolditalic";
            }
        }
        return "plain";
    }

    public static void setDefaultFont(Font defaultFont) {
        String formattedFontName = defaultFont.getFamily() + "-" + myTableCellRenderer.getStyleName(defaultFont.getStyle()) + "-" + defaultFont.getSize();
        JConfig.setConfiguration("default.font", formattedFontName);
        sDefaultFont = defaultFont;
        fixedFont = null;
        boldFont = null;
    }

    private Font chooseFont(Font base, AuctionEntry ae, int col) {
        boolean hasComment;
        boolean bl = hasComment = ae.getComment() != null;
        if (sDefaultFont != null) {
            base = sDefaultFont;
        } else {
            sDefaultFont = base;
        }
        if (fixedFont == null) {
            fixedFont = new Font("Monospaced", base.getStyle(), base.getSize());
        }
        if (boldFont == null) {
            boldFont = base.deriveFont(1);
        }
        if (col == 3) {
            return fixedFont;
        }
        if (hasComment && col == 0) {
            return boldFont;
        }
        if (ae.isShippingOverridden() && col == 7) {
            return boldFont;
        }
        return base;
    }

    private Color snipeBidBackground(AuctionEntry ae) {
        MultiSnipe ms = this.multiManager.getForAuctionIdentifier(ae.getIdentifier());
        if (ms != null) {
            return ms.getColor();
        }
        return null;
    }

    private Color titleColor(AuctionEntry ae) {
        if (ae != null && ae.getHighBidder() != null) {
            if (ae.isHighBidder()) {
                if (!ae.isReserve() || ae.isReserveMet()) {
                    return medBlue;
                }
                return darkRed;
            }
            if (ae.getNumBidders() > 0 && (!ae.isReserve() || ae.isReserveMet())) {
                if (!ae.isSeller()) {
                    return darkRed;
                }
                return darkGreen;
            }
        }
        return Color.BLACK;
    }

    private Color snipeBidColor(AuctionEntry ae) {
        if (ae != null) {
            if (ae.isSniped()) {
                MultiSnipe ms = this.multiManager.getForAuctionIdentifier(ae.getIdentifier());
                if (ms == null) {
                    return ae.isSnipeValid() ? darkGreen : darkRed;
                }
                if (ae.snipeCancelled()) {
                    return darkRed;
                }
            } else {
                if (ae.isBidOn()) {
                    if (ae.isHighBidder()) {
                        return medBlue;
                    }
                    return darkRed;
                }
                if (ae.snipeCancelled()) {
                    return darkRed;
                }
            }
        }
        return Color.BLACK;
    }

    private Color chooseIDColor(AuctionEntry ae) {
        return ae != null && ae.isJustAdded() ? darkGreen : Color.BLACK;
    }
}

