/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.ui.table;

import com.jbidwatcher.auction.AuctionEntry;
import com.jbidwatcher.ui.table.FauxEditor;
import com.jbidwatcher.ui.table.TableColumnController;
import com.jbidwatcher.ui.table.auctionTableModel;
import com.jbidwatcher.util.Comparison;
import com.jbidwatcher.util.Pair;
import com.jbidwatcher.util.config.JConfig;
import com.jbidwatcher.util.queue.MQFactory;
import com.jbidwatcher.util.queue.MessageQueue;
import com.jbidwatcher.util.queue.SuperQueue;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class AuctionTable
extends JTable
implements MessageQueue.Listener {
    private static TableCellEditor FAUX = new FauxEditor();
    private Integer currentRow;
    private static final String METAL_MOUSE_LISTENER = "javax.swing.plaf.basic.BasicTableUI$MouseInputHandler";
    private static final String AQUA_MOUSE_LISTENER = "apple.laf.AquaTableUI$MouseInputHandler";
    private MouseListenerSelectProxy proxyMouseListener;
    private static final String[][] DEFAULT_COLUMNS = new String[][]{{"Thumbnail", "100"}, {"Current", "89"}, {"Max", "62"}, {"Description", "297"}, {"Time left", "127"}, {"Status", "67"}, {"Seller", "147"}};
    private static int notify_delay = 0;

    @Override
    public TableCellEditor getCellEditor() {
        return FAUX;
    }

    public AuctionTable(String name, TableModel atm) {
        MQFactory.getConcrete("update " + name).addListener(this);
        this.createDefaultRenderers();
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        this.setDoubleBuffered(true);
        this.setAutoCreateColumnsFromModel(false);
        this.setModel(atm);
        this.loadColumnSettings(name, atm);
        this.doLayout();
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        Point point = new Point(event.getX(), event.getY());
        int rowPoint = this.rowAtPoint(point);
        String result = null;
        int colPoint = this.columnAtPoint(point);
        if (rowPoint != -1) {
            AuctionEntry ae = (AuctionEntry)this.getValueAt(rowPoint, -1);
            boolean showThumbnail = true;
            if (this.getRowHeight() == 72) {
                showThumbnail = this.getColumnName(colPoint).equals("Thumbnail");
            }
            result = ae.getPresenter().buildComment(showThumbnail);
        }
        return result == null ? super.getToolTipText(event) : result;
    }

    @Override
    public void messageAction(Object deQ) {
        int activeRow;
        int start = ((String)deQ).lastIndexOf(32);
        final String identifier = ((String)deQ).substring(start + 1);
        String command = ((String)deQ).substring(0, start);
        int n = activeRow = this.currentRow == null ? 0 : this.currentRow;
        if (command.equals("start")) {
            this.currentRow = ((auctionTableModel)this.getModel()).findRow(new Comparison(){

                @Override
                public boolean match(Object o) {
                    String foundIdentifier = null;
                    if (o != null) {
                        foundIdentifier = ((AuctionEntry)o).getIdentifier();
                    }
                    return foundIdentifier != null && foundIdentifier.equals(identifier);
                }
            });
            if (this.currentRow == -1) {
                this.currentRow = null;
            }
        } else {
            this.currentRow = null;
        }
        activeRow = this.currentRow == null ? activeRow : this.currentRow;
        this.tableChanged(new TableModelEvent(this.getModel(), activeRow, activeRow, -1, 0));
    }

    @Override
    public synchronized void addMouseListener(MouseListener ml) {
        String mlClass = ml.getClass().getName();
        if (this.proxyMouseListener == null && (mlClass.equals(METAL_MOUSE_LISTENER) || mlClass.equals(AQUA_MOUSE_LISTENER))) {
            this.proxyMouseListener = new MouseListenerSelectProxy(ml);
            super.addMouseListener(this.proxyMouseListener);
        } else {
            super.addMouseListener(ml);
        }
    }

    @Override
    public synchronized void removeMouseListener(MouseListener ml) {
        if (this.proxyMouseListener != null && ml == this.proxyMouseListener.getPeer()) {
            super.removeMouseListener(this.proxyMouseListener);
            this.proxyMouseListener = null;
        } else {
            super.removeMouseListener(ml);
        }
    }

    private void loadColumnSettings(String prefix, TableModel atm) {
        String curColumnName = "";
        int columnCount = 0;
        LinkedList<ColumnIndex> initialToSaved = new LinkedList<ColumnIndex>();
        try {
            for (int i = 0; i < atm.getColumnCount(); ++i) {
                curColumnName = atm.getColumnName(i);
                String colWidth = JConfig.queryDisplayProperty(prefix + '.' + curColumnName);
                if (colWidth == null) {
                    colWidth = JConfig.queryDisplayProperty(curColumnName);
                }
                if (colWidth == null) continue;
                int dotIndex = colWidth.indexOf(46);
                if (dotIndex != -1) {
                    String colIndex = colWidth.substring(0, dotIndex);
                    colWidth = colWidth.substring(dotIndex + 1);
                    initialToSaved.add(new ColumnIndex(curColumnName, Integer.parseInt(colIndex)));
                }
                ++columnCount;
                this.makeNewColumn(curColumnName, colWidth);
            }
        }
        catch (Exception e) {
            JConfig.log().handleException("In display configuration for table " + prefix + ", column \"" + curColumnName + "\" has an invalid property.", e);
            JConfig.log().logDebug("No longer loading column widths from configuration.");
        }
        if (columnCount < 2) {
            SuperQueue.getInstance().preQueue("NOTIFY Column data for '" + prefix + "' was corrupted; resetting to defaults", "Swing", System.currentTimeMillis() + 12000L + (long)notify_delay);
            JConfig.log().logMessage("Column data for '" + prefix + "' was corrupted; resetting to defaults");
            notify_delay += 2000;
            for (String[] column : DEFAULT_COLUMNS) {
                String column_name = column[0];
                String column_width = column[1];
                if (column_name.equals("Time left") && prefix.equals("complete")) continue;
                this.makeNewColumn(column_name, column_width);
            }
        }
        if (!initialToSaved.isEmpty()) {
            Collections.sort(initialToSaved, new Comparator<ColumnIndex>(){

                @Override
                public int compare(ColumnIndex o1, ColumnIndex o2) {
                    if ((Integer)o1.getLast() < (Integer)o2.getLast()) {
                        return -1;
                    }
                    if ((Integer)o1.getLast() > (Integer)o2.getLast()) {
                        return 1;
                    }
                    return 0;
                }
            });
            for (ColumnIndex pair : initialToSaved) {
                int colFrom = this.getColumnModel().getColumnIndex(pair.getFirst());
                int colTo = (Integer)pair.getLast();
                try {
                    this.moveColumn(colFrom, colTo);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
    }

    private void makeNewColumn(String curColumnName, String colWidth) {
        TableColumn tc = new TableColumn(TableColumnController.getInstance().getColumnNumber(curColumnName));
        tc.setHeaderValue(curColumnName);
        tc.setIdentifier(curColumnName);
        if ("Thumbnail".equals(curColumnName)) {
            tc.setMinWidth(75);
        }
        this.addColumn(tc);
        this.getColumn(curColumnName).setPreferredWidth(Integer.parseInt(colWidth));
        this.getColumn(curColumnName).setWidth(Integer.parseInt(colWidth));
    }

    private boolean isCurrentRow(int i) {
        return this.currentRow != null && this.currentRow == i;
    }

    @Override
    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        Component c = super.prepareRenderer(renderer, row, column);
        if (this.isCurrentRow(row)) {
            JComponent jc = (JComponent)c;
            int left = column == 0 ? 1 : 0;
            int right = column == this.getColumnCount() - 1 ? 1 : 0;
            jc.setBorder(BorderFactory.createMatteBorder(1, left, 1, right, Color.RED));
        }
        return c;
    }

    private class ColumnIndex
    extends Pair<String, Integer> {
        public ColumnIndex(String s, Integer i) {
            super(s, i);
        }
    }

    static class MouseListenerSelectProxy
    implements MouseListener {
        private MouseListener m_peer;

        MouseListenerSelectProxy(MouseListener ml) {
            this.m_peer = ml;
        }

        public MouseListener getPeer() {
            return this.m_peer;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (!e.isPopupTrigger()) {
                this.m_peer.mouseClicked(e);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.m_peer.mouseEntered(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.m_peer.mouseExited(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!e.isPopupTrigger()) {
                this.m_peer.mousePressed(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!e.isPopupTrigger()) {
                this.m_peer.mouseReleased(e);
            }
        }
    }
}

