/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.util.http;

import com.jbidwatcher.util.ByteBuffer;
import com.jbidwatcher.util.Parameters;
import com.jbidwatcher.util.config.JConfig;
import com.jbidwatcher.util.http.Http;
import com.jbidwatcher.util.http.HttpInterface;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;

public class HttpMock
implements HttpInterface {
    private static final String GET = "GET";
    private static final String PUT = "PUT";
    private static final String POST = "POST";
    private static final Map<String, Map<String, String>> urlRegistry = new HashMap<String, Map<String, String>>();
    private Http mReal = new Http();

    public HttpMock() {
        urlRegistry.put(GET, new HashMap());
        urlRegistry.put(PUT, new HashMap());
        urlRegistry.put(POST, new HashMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String lookup(String method, String url) {
        String rval;
        Map<String, Map<String, String>> map = urlRegistry;
        synchronized (map) {
            rval = urlRegistry.get(method).get(url);
            if (rval == null) {
                JConfig.log().logMessage("No response registered for method " + method + " to url: " + url);
            }
        }
        return rval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(String method, String url, String filename) {
        Map<String, Map<String, String>> map = urlRegistry;
        synchronized (map) {
            urlRegistry.get(method).put(url, filename);
        }
    }

    @Override
    public void setAuthInfo(String user, String pass) {
        this.mReal.setAuthInfo(user, pass);
    }

    @Override
    public URLConnection postFormPage(String url, String cgiData, String cookie, String referer, boolean followRedirects) {
        String newURL = HttpMock.lookup(POST, url);
        if (newURL == null) {
            return this.mReal.postFormPage(url, cgiData, cookie, referer, followRedirects);
        }
        throw new UnimplementedException();
    }

    @Override
    public URLConnection makeRequest(URL source, String cookie) throws IOException {
        String newURL = HttpMock.lookup(GET, source.toString());
        if (newURL == null) {
            return this.mReal.makeRequest(source, cookie);
        }
        throw new UnimplementedException();
    }

    @Override
    public URLConnection getPage(String url) {
        String newURL = HttpMock.lookup(GET, url);
        if (newURL == null) {
            return this.mReal.getPage(url);
        }
        throw new UnimplementedException();
    }

    @Override
    public URLConnection getPage(String url, String cookie, String referer, boolean redirect) {
        String newURL = HttpMock.lookup(GET, url);
        if (newURL == null) {
            return this.mReal.getPage(url, cookie, referer, redirect);
        }
        throw new UnimplementedException();
    }

    @Override
    public InputStream getStream(HttpURLConnection huc) {
        return this.mReal.getStream(huc);
    }

    @Override
    public ByteBuffer getURL(URL url) {
        String newURL = HttpMock.lookup(GET, url.toString());
        if (newURL == null) {
            return this.mReal.getURL(url);
        }
        throw new UnimplementedException();
    }

    @Override
    public StringBuffer get(String url) {
        String newURL = HttpMock.lookup(GET, url);
        if (newURL == null) {
            return this.mReal.get(url);
        }
        throw new UnimplementedException();
    }

    @Override
    public StringBuffer receivePage(URLConnection uc) throws IOException {
        return this.mReal.receivePage(uc);
    }

    @Override
    public String putTo(String url, String sb) {
        String newURL = HttpMock.lookup(PUT, url);
        if (newURL == null) {
            this.mReal.putTo(url, sb);
        }
        throw new UnimplementedException();
    }

    @Override
    public String postTo(String url, Parameters params) {
        String newURL = HttpMock.lookup(POST, url);
        if (newURL == null) {
            this.mReal.postTo(url, params);
        }
        throw new UnimplementedException();
    }

    public class UnimplementedException
    extends RuntimeException {
    }
}

