/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.vietocr.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Utils {
    private static final String EOL = "\n";
    private static final Logger logger = Logger.getLogger(Utils.class.getName());

    public static File getBaseDir(Object object) {
        URL uRL = object.getClass().getResource("/" + object.getClass().getName().replaceAll("\\.", "/") + ".class");
        File file = new File(System.getProperty("user.dir"));
        try {
            if (uRL.toString().startsWith("jar:")) {
                uRL = new URL(uRL.toString().replaceFirst("^jar:", "").replaceFirst("/[^/]+.jar!.*$", ""));
                file = new File(uRL.toURI());
            }
        }
        catch (MalformedURLException | URISyntaxException exception) {
            logger.log(Level.WARNING, exception.getMessage(), exception);
        }
        return file;
    }

    public static String stripExtension(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(".");
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    public static String toHex(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (char c : string.toCharArray()) {
            stringBuilder.append("U+").append(Utils.padLeft(c, 4));
        }
        return stringBuilder.toString();
    }

    static String padLeft(int n, int n2) {
        return String.format("%1$0" + n2 + "X", n);
    }

    public static String capitalize(String string) {
        return Character.toUpperCase(string.charAt(0)) + string.substring(1).toLowerCase();
    }

    public static String join(Collection<?> collection, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<?> iterator = collection.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next());
            if (!iterator.hasNext()) break;
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static String readTextFile(File file) throws Exception {
        return new String(Files.readAllBytes(file.toPath()), "UTF8");
    }
}

