/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.schemaspy.view;

import java.io.File;
import java.io.IOException;
import net.sourceforge.schemaspy.model.Table;
import net.sourceforge.schemaspy.util.Dot;
import net.sourceforge.schemaspy.util.LineWriter;
import net.sourceforge.schemaspy.view.HtmlDiagramFormatter;

public class HtmlTableDiagrammer
extends HtmlDiagramFormatter {
    private static HtmlTableDiagrammer instance = new HtmlTableDiagrammer();

    private HtmlTableDiagrammer() {
    }

    public static HtmlTableDiagrammer getInstance() {
        return instance;
    }

    public boolean write(Table table, File file, LineWriter lineWriter) {
        File file2 = new File(file, table.getName() + ".1degree.dot");
        File file3 = new File(file, table.getName() + ".1degree.png");
        File file4 = new File(file, table.getName() + ".2degrees.dot");
        File file5 = new File(file, table.getName() + ".2degrees.png");
        File file6 = new File(file, table.getName() + ".implied2degrees.dot");
        File file7 = new File(file, table.getName() + ".implied2degrees.png");
        try {
            Dot dot = this.getDot();
            if (dot == null) {
                return false;
            }
            String string = dot.generateDiagram(file2, file3);
            lineWriter.write("<br><form action='get'><b>Close relationships");
            if (file4.exists()) {
                lineWriter.writeln("</b><span class='degrees' id='degrees' title='Detail diminishes with increased separation from " + table.getName() + "'>");
                lineWriter.write("&nbsp;within <label for='oneDegree'><input type='radio' name='degrees' id='oneDegree' checked>one</label>");
                lineWriter.write("  <label for='twoDegrees'><input type='radio' name='degrees' id='twoDegrees'>two degrees</label> of separation");
                lineWriter.write("</span><b>:</b>");
                lineWriter.writeln("</form>");
            } else {
                lineWriter.write(":</b></form>");
            }
            lineWriter.write(string);
            string = null;
            lineWriter.writeln("  <a name='diagram'><img id='oneDegreeImg' src='../diagrams/" + file3.getName() + "' usemap='#oneDegreeRelationshipsDiagram' class='diagram' border='0' alt='' align='left'></a>");
            if (file6.exists()) {
                lineWriter.writeln(dot.generateDiagram(file6, file7));
                lineWriter.writeln("  <a name='diagram'><img id='impliedTwoDegreesImg' src='../diagrams/" + file7.getName() + "' usemap='#impliedTwoDegreesRelationshipsDiagram' class='diagram' border='0' alt='' align='left'></a>");
            } else {
                file6.delete();
                file7.delete();
            }
            if (file4.exists()) {
                lineWriter.writeln(dot.generateDiagram(file4, file5));
                lineWriter.writeln("  <a name='diagram'><img id='twoDegreesImg' src='../diagrams/" + file5.getName() + "' usemap='#twoDegreesRelationshipsDiagram' class='diagram' border='0' alt='' align='left'></a>");
            } else {
                file4.delete();
                file5.delete();
            }
        }
        catch (Dot.DotFailure dotFailure) {
            System.err.println(dotFailure);
            return false;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
        return true;
    }
}

