/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.armedbear.lisp.AbstractString;
import org.armedbear.lisp.Debug;
import org.armedbear.lisp.JavaObject;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Operator;
import org.armedbear.lisp.Pathname;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.ShellCommand;
import org.armedbear.lisp.SimpleString;

public final class disassemble_class_bytes
extends Primitive {
    private static final Primitive DISASSEMBLE_CLASS_BYTES = new disassemble_class_bytes();

    private disassemble_class_bytes() {
        super("disassemble-class-bytes", Lisp.PACKAGE_SYS, true, "java-object");
    }

    public LispObject execute(LispObject arg) {
        if (arg instanceof JavaObject) {
            byte[] bytes = (byte[])((JavaObject)arg).getObject();
            try {
                File file = File.createTempFile("abcl", ".class", null);
                FileOutputStream out = new FileOutputStream(file);
                out.write(bytes);
                out.close();
                LispObject disassembler = Lisp._DISASSEMBLER_.symbolValue();
                StringBuffer command = new StringBuffer();
                if (disassembler instanceof AbstractString) {
                    command.append(disassembler.getStringValue());
                    command.append(" ");
                    command.append(file.getPath());
                } else if (disassembler instanceof Operator) {
                    Pathname p = Pathname.makePathname(file);
                    LispObject commandResult = disassembler.execute(p);
                    command.append(commandResult.getStringValue());
                } else {
                    return new SimpleString("No disassembler is available.");
                }
                ShellCommand sc = new ShellCommand(command.toString(), null, null);
                sc.run();
                file.delete();
                return new SimpleString(sc.getOutput());
            }
            catch (IOException e) {
                Debug.trace(e);
            }
        }
        return Lisp.NIL;
    }
}

