/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.WeakHashMap;

public class Finalizer {
    private static ReferenceQueue queue = null;
    private static Map<Object, FinalizingWeakReference> references = null;
    private static Map<FinalizingWeakReference, FinalizingWeakReference> anchor = null;

    private static synchronized void checkQueue() {
        if (queue == null) {
            queue = new ReferenceQueue();
            references = Collections.synchronizedMap(new WeakHashMap());
            anchor = Collections.synchronizedMap(new HashMap());
            Thread handler = new Thread(new Runnable(){

                public void run() {
                    while (true) {
                        try {
                            while (true) {
                                FinalizingWeakReference ref = (FinalizingWeakReference)queue.remove();
                                anchor.remove(ref);
                                ref.run();
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            continue;
                        }
                        break;
                    }
                }
            }, "ABCL finalizer");
            handler.setPriority(10);
            handler.setDaemon(true);
            handler.start();
        }
    }

    public static void addFinalizer(Object o, Runnable r) {
        FinalizingWeakReference ref;
        if (queue == null) {
            Finalizer.checkQueue();
        }
        if ((ref = references.get(o)) != null) {
            ref.addFinalizer(r);
        } else {
            ref = new FinalizingWeakReference(o, queue, r);
            references.put(o, ref);
            anchor.put(ref, ref);
        }
    }

    public static void clearFinalizers(Object o) {
        FinalizingWeakReference ref = references.get(o);
        if (ref != null) {
            ref.cancelFinalizers();
            anchor.remove(ref);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FinalizingWeakReference
    extends WeakReference<Object> {
        private LinkedList<Runnable> finalizers = new LinkedList();

        FinalizingWeakReference(Object o, ReferenceQueue q, Runnable finalizer) {
            super(o, q);
            this.finalizers.add(finalizer);
        }

        void addFinalizer(Runnable finalizer) {
            this.finalizers.add(finalizer);
        }

        void cancelFinalizers() {
            this.finalizers.clear();
        }

        void run() {
            Iterator iterator = this.finalizers.iterator();
            while (iterator.hasNext()) {
                ((Runnable)iterator.next()).run();
            }
        }
    }
}

