/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.ui.table;

import com.jbidwatcher.util.config.JConfig;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import javax.swing.Icon;
import javax.swing.JTable;

public class CSVExporter {
    private JTable m_table;

    public CSVExporter(JTable inTable) {
        this.m_table = inTable;
    }

    private static void addCSV(StringBuffer sb, Object value, boolean commaPrepend) {
        String canon = value.toString();
        canon = canon.replaceAll("\"", "\"\"");
        if (commaPrepend) {
            sb.append(',');
        }
        sb.append('\"');
        sb.append(canon);
        sb.append('\"');
    }

    public boolean export(String fname) {
        try {
            int i;
            StringBuffer outBuf = new StringBuffer();
            for (i = 0; i < this.m_table.getColumnModel().getColumnCount(); ++i) {
                CSVExporter.addCSV(outBuf, this.m_table.getColumnModel().getColumn(i).getHeaderValue(), i != 0);
            }
            outBuf.append('\n');
            for (i = 0; i < this.m_table.getRowCount(); ++i) {
                for (int j = 0; j < this.m_table.getColumnCount(); ++j) {
                    Object output = this.m_table.getValueAt(i, j);
                    if (output instanceof Icon) {
                        CSVExporter.addCSV(outBuf, "", j != 0);
                        continue;
                    }
                    if (output == null) continue;
                    CSVExporter.addCSV(outBuf, output, j != 0);
                }
                outBuf.append('\n');
            }
            PrintStream ps = new PrintStream(new FileOutputStream(fname));
            ps.println(outBuf);
            ps.close();
        }
        catch (IOException ioe) {
            JConfig.log().handleException("Failed to write CSV file.", ioe);
            return false;
        }
        return true;
    }
}

