/*
 * Decompiled with CFR 0.152.
 */
package com.jbidwatcher.util.http;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;

public class ClientHttpRequest {
    private URLConnection mConnection;
    private OutputStream mOutput = null;
    private Map<String, String> mCookies = new HashMap<String, String>();
    private Map<String, Object> mParameters = new LinkedHashMap<String, Object>();
    private String boundary;
    private static Random random = new Random();

    private void write(char c) throws IOException {
        this.mOutput.write(c);
    }

    private void write(String s) throws IOException {
        this.mOutput.write(s.getBytes());
    }

    private void newline() throws IOException {
        this.write("\r\n");
    }

    private void writeln(String s) throws IOException {
        this.write(s);
        this.newline();
    }

    private static String randomString() {
        return Long.toString(random.nextLong(), 36);
    }

    private void boundary() throws IOException {
        this.write("--");
        this.write(this.boundary);
    }

    public ClientHttpRequest(URLConnection connection) {
        this.mConnection = connection;
        ((HttpURLConnection)this.mConnection).setInstanceFollowRedirects(true);
        connection.setDoOutput(true);
        this.boundary = "---------------------------" + ClientHttpRequest.randomString() + ClientHttpRequest.randomString() + ClientHttpRequest.randomString();
        connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + this.boundary);
    }

    public ClientHttpRequest(URL url) throws IOException {
        this(url.openConnection());
    }

    private void postCookies() {
        StringBuffer cookieList = new StringBuffer();
        Iterator<Map.Entry<String, String>> i = this.mCookies.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<String, String> entry = i.next();
            cookieList.append(entry.getKey().toString()).append("=").append((Object)entry.getValue());
            if (!i.hasNext()) continue;
            cookieList.append("; ");
        }
        if (cookieList.length() > 0) {
            this.mConnection.setRequestProperty("Cookie", cookieList.toString());
        }
    }

    private void writeName(String name) throws IOException {
        this.newline();
        this.write("Content-Disposition: form-data; name=\"");
        this.write(name);
        this.write('\"');
    }

    public void setParameter(String name, Object value) {
        this.mParameters.put(name, value);
    }

    private void writeParameter(String name, String value) throws IOException {
        this.boundary();
        this.writeName(name);
        this.newline();
        this.newline();
        this.writeln(value);
    }

    private static void pipe(InputStream in, OutputStream out) throws IOException {
        int nread;
        byte[] buf = new byte[50000];
        while ((nread = in.read(buf, 0, buf.length)) >= 0) {
            out.write(buf, 0, nread);
        }
        out.flush();
    }

    public void writeParameter(String name, String filename, InputStream is) throws IOException {
        this.boundary();
        this.writeName(name);
        this.write("; filename=\"");
        this.write(filename);
        this.write('\"');
        this.newline();
        this.write("Content-Type: ");
        String type = URLConnection.guessContentTypeFromName(filename);
        if (type == null) {
            type = "application/octet-stream";
        }
        this.writeln(type);
        this.newline();
        ClientHttpRequest.pipe(is, this.mOutput);
        this.newline();
    }

    private void writeParameter(String name, File file) throws IOException {
        this.writeParameter(name, file.getPath(), new FileInputStream(file));
    }

    public void setParameters(Map<String, Object> parameters) {
        if (parameters == null) {
            return;
        }
        this.mParameters.putAll(parameters);
    }

    public HttpURLConnection post() throws IOException {
        if (this.mOutput == null) {
            this.mOutput = this.mConnection.getOutputStream();
        }
        this.postCookies();
        for (String key : this.mParameters.keySet()) {
            Object value = this.mParameters.get(key);
            if (value instanceof File) {
                this.writeParameter(key, (File)value);
                continue;
            }
            this.writeParameter(key, value.toString());
        }
        this.boundary();
        this.writeln("--");
        this.mOutput.close();
        return (HttpURLConnection)this.mConnection;
    }
}

